#include "main.h"

static int now_au_num;

//////////
// for AUs Editor Callback 
void editor_au_select_cb(puObject *ob)
{
	now_au_num = (int)ob->getFloatValue();
	ob->setLegend( AU_SLIDER_NAME[now_au_num] );
	au_slider_slider->setValue(m_dAUMove[now_au_num]);

	glutSwapBuffers();
	glutPostRedisplay();
}

void editor_au_slider_cb(puObject *ob)
{
	ob->setLabel( ob->getStringValue());
	m_dAUMove[now_au_num] = ob->getFloatValue();

	glutSwapBuffers();
	glutPostRedisplay();
}

void editor_au_button_cb(puObject *)
{
	m_dAUMove[now_au_num] = 0.0;
	au_slider_slider->setValue(m_dAUMove[now_au_num]);

	glutSwapBuffers();
	glutPostRedisplay();
}

void editor_au_button_reset_cb(puObject *)
{
	for( int i = 0; i < m_pAUMove->getMaxWfmNum(); i++ ) {
		m_dAUMove[i] = 0.0;
	}
	au_slider_slider->setValue(m_dAUMove[now_au_num]);

	glutSwapBuffers();
	glutPostRedisplay();
}

void editor_au_button_save_wfm_cb(puObject *)
{
	au_save_cb(NULL);
}
// for AUs Editor Callback 
//////////

//////////
// for Teeth Editor Button Action
void editor_teeth_dif_r_cb(puObject *ob)
{
	float *color = m_pDocument->GetTeethDifColor();
	color[0] = (ob->getFloatValue());
	glutSwapBuffers();
	glutPostRedisplay();
}

void editor_teeth_dif_g_cb(puObject *ob)
{
	float *color = m_pDocument->GetTeethDifColor();
	color[1] = (ob->getFloatValue());
	glutSwapBuffers();
	glutPostRedisplay();	
}

void editor_teeth_dif_b_cb(puObject *ob)
{
	float *color = m_pDocument->GetTeethDifColor();
	color[2] = (ob->getFloatValue());
	glutSwapBuffers();
	glutPostRedisplay();	
}

void editor_teeth_button_save_cb(puObject *)
{
	teeth_save_cb(NULL);
}
// for Teeth Editor Button Action
//////////

//////////
// for Eye Editor Callback
void editor_eye_sld_trans_z_r_cb(puObject *ob)
{
	double *trans;

	trans = m_pDocument->GetEyeRLocalTrans();
	trans[2] = (double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_trans_z_l_cb(puObject *ob)
{
	double *trans;

	trans = m_pDocument->GetEyeLLocalTrans();
	trans[2] = (double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_rot_x_right_cb(puObject *ob)
{
	double *rot;

	rot = m_pDocument->GetEyeRLocalRot();
	rot[0] = (double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_rot_x_left_cb(puObject *ob)
{
	double *rot;

	rot = m_pDocument->GetEyeLLocalRot();
	rot[0] =(double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_rot_y_right_cb(puObject *ob)
{
	double *rot;

	rot = m_pDocument->GetEyeRLocalRot();
	rot[1] = (double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_rot_y_left_cb(puObject *ob)
{
	double *rot;

	rot = m_pDocument->GetEyeLLocalRot();
	rot[1] = (double)(ob->getFloatValue());

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_sld_scale_cb(puObject *ob)
{
	ObjModel *obj;
	double &scale = m_pDocument->GetEyeTexScale();
	scale = (double)(ob->getFloatValue());
	obj = m_pDocument->GetEyeObject();
	obj->ReCalcTexture(scale);

	glutSwapBuffers();	
	glutPostRedisplay();
}
void editor_btn_close_editor_cb(puObject *)
{
	glutSetWindow( editor_window );
	glutHideWindow();
	glutSetWindow( main_window );
	editflag = false;

	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_btn_reset_trans_cb(puObject *)
{
	m_pDialogEdit->ResetTrans();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_btn_reset_window_cb(puObject *)
{
	glutReshapeWindow( EDITOR_WIDTH, EDITOR_HEIGHT );
	glutSwapBuffers();	
	glutPostRedisplay();
}

void editor_eye_button_save_cb(puObject *)
{
	eye_save_cb(NULL);
}
// for Eye Editor Callback
//////////

//////////
// for Button Action (open and close)
void EditorEyeButtonCloseAction(bool flag) 
{
	int i;
	if( flag == true ) {
		editor_eye_text[0]->hide();
		editor_eye_text[1]->hide();
		eye_slider_button_save->hide();
		for( i = 0; i < EDITOR_EYE_SLIDER_NUM; i++ ) editor_eye_sld[i]->hide();
	} else {
		editor_eye_text[0]->reveal();
		editor_eye_text[1]->reveal();
		eye_slider_button_save->reveal();
		for( i = 0; i < EDITOR_EYE_SLIDER_NUM; i++ ) editor_eye_sld[i]->reveal();
	}
}

void EditorResetButtonCloseAction(bool flag) 
{
	int i;
	if( flag == true ) {
		for( i = 0; i < EDITOR_BUTTON_NUM; i++ ) editor_b[i]->hide();
	} else {
		for( i = 0; i < EDITOR_BUTTON_NUM; i++ ) editor_b[i]->reveal();
	}
}

void EditorAUButtonCloseAction(bool flag) 
{
	if( flag == true ) {
		au_slider_button_reset->hide();
		au_slider_select_dial->hide();
		au_slider_slider->hide();
		au_slider_button->hide();
		au_slider_button_save_wfm->hide();
	} else {
		au_slider_button_reset->reveal();
		au_slider_select_dial->reveal();
		au_slider_slider->reveal();
		au_slider_button->reveal();
		au_slider_button_save_wfm->reveal();
	}
}

void EditorTeethButtonCloseAction(bool flag) 
{
	int i;
	if( flag == true ) {
		for( i = 0; i < EDITOR_TEETH_NUM; i++ ) teeth_slider[i]->hide();
		teeth_slider_button_save->hide();
	} else {
		for( i = 0; i < EDITOR_TEETH_NUM; i++ ) teeth_slider[i]->reveal();
		teeth_slider_button_save->reveal();
	}
}

// for Eye Editor Button Action
//////////
