#ifndef __VIEW_H__
#define __VIEW_H__

// ++ definition of region for move points bit flag ++
#define REGION_BIT_ANYPOINTS	0x00000001
#define REGION_BIT_HEAD			0x00000002
#define REGION_BIT_OUTLINE		0x00000004
#define REGION_BIT_EYES			0x00000008
#define REGION_BIT_BROWS		0x00000010
#define REGION_BIT_NOSE			0x00000020
#define REGION_BIT_MOUTH		0x00000040
#define REGION_BIT_NECK			0x00000080
#define REGION_BIT_WITHAROUND	0x00000100
// -- definition of region for move points bit flag --

// ++ define of draw region bit flag ++
#define REGION_BIT_TEXTURE		0x00000200
#define REGION_BIT_WORKWFM		0x00000400
#define REGION_BIT_WFM_EYES		0x00000800
// -- define of draw region bit flag --

#include "Trans.h"

#ifndef __CPOINT__
#define __CPOINT__

class CPoint
{
public:
	int x;
	int y;
};

#endif  __CPOINT__

class Wfm;
class TransFace;
class Document;

class View
{
	
	// user definition
public:
	// ++ object draw lest enumeration ++
	enum {
		REGION_LIST_TEXTURE			= 100,
			REGION_LIST_WORKWFM_FACE,
			REGION_LIST_WORKWFM_EYEHOLE,
			REGION_LIST_WORKWFM_RESION,
	};
	// -- object draw lest enumeration --
	
	enum {
		CHECK_REGION_GRID_ALL = 0,
			CHECK_REGION_LINK_ALL
	};
	
	
	View(Document *pDoc, int *w, int *h );
	~View();
	
	void SetEditRegion(unsigned int i) { m_unEditRegion = i; }
	void SetFittingMode(int i) { m_FittingMode = i; }
	void SetLocalTranslate(int i, double d) { m_LocalTranslate[i] = d; }
	void SetLocalRotate(int i, double d) { m_LocalTranslate[i] = d; }
	void SetLocalScale(double d) { m_LocalScale = d; }
	void SetGlobalTranslate(int i, double d) { m_GlobalTranslate[i] = d; }
	void SetGlobalRotate(int i, double d) { m_GlobalTranslate[i] = d; }
	void SetGlobalScale(double d) { m_GlobalScale = d; }
	
	void HiperColor();
	void EditUndo();
	void EditRedo();
	
	void RenewalDocument();
	
	int w() { return *m_pWidth; }
	int h() { return *m_pHeight; }

	void redraw();

	bool GetLButtonDown() { return m_bLButtonDown; }
	bool GetRButtonDown() { return m_bRButtonDown; }
	bool GetMButtonDown() { return m_bMButtonDown; }
	bool GetDrag() { return m_bDrag; }
	void GetPoint( int &x, int &y ) { x = m_point.x; y = m_point.y; }
	
	void SetLButtonDown(bool flag) { m_bLButtonDown = flag; }
	void SetRButtonDown(bool flag) { m_bRButtonDown = flag; }
	void SetMButtonDown(bool flag) { m_bMButtonDown = flag; }
	void SetDrag(bool flag) { m_bDrag = flag; }
	void SetPoint( int x, int y ) { m_point.x = x; m_point.y = y; }

		
	void LeftMousePushEvent(int x, int y, int status);
	void RightMousePushEvent(int x, int y, int status);
	void LeftMouseReleaseEvent(int x, int y, int status);
	void RightMouseReleaseEvent(int x, int y, int status);
	void MouseDragEvent(int x, int y, int status);

private:
	// private data members
	unsigned int m_unModified;				// modified info bit flags
	unsigned int m_unEditRegion;			// edit region bit flags
	
	Document *m_pDoc;
	
	// window size
	int *m_pWidth;
	int *m_pHeight;

	// position information
	double m_LocalTranslate[3], m_LocalRotate[3], m_LocalScale;		// for wire-frame
	double m_GlobalTranslate[3], m_GlobalRotate[3], m_GlobalScale;	// for all views
	
	// boolean
	bool m_bLButtonDown, m_bRButtonDown, m_bMButtonDown;	// mouse button status
	bool m_bDrag;							// mouse drag status
	bool m_bColoring;						// coloring boolean
	int m_status;
	
	// point information
	CPoint m_point;							// for mouse position information
	int	   m_PointNo;						// model's vertex number
	Point  m_PGPoint;						// picking point's coodinate information
	int	   m_AnotherPointNo[10];			// neighmorhood 10 of model's vertex number
	Point  m_PAnotherPoint[10];				// neighmorhood 10 of picking point's coodinate information
	int	   m_count;							// neighmorhood points counter
	
	// mode information
	int    m_FittingMode;					// fitting mode
	
	bool SetupViewport();
	bool SetupViewingTransform();
	bool SetupViewingFrustum(int cx, int cy);
	bool DrawOpenGL();
	
	// user definition function
	void CreateGLlist();
	void SetWireframeColor(Wfm* wfm, int linkNo);

	// transformation functions
	void ButtonPressTransAll(CPoint point);
	void ButtonPressWithAround(CPoint point);
	void ButtonPressDefault(CPoint point);	
	
	// modified information functions
	bool Modified(unsigned int un) { return (m_unModified & un) ? true : false; }
	void SetModifiedFlag(unsigned int un) { m_unModified |= un; }
	void ResetModifiedFlag(unsigned int un) { if(m_unModified & un) m_unModified ^= un; }


	
	// check region
	bool CheckRegion(int num, int i);  // num: grid num, i: 0 ... with eye
};

#endif // __VIEW_H__
