#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <GL/glu.h>
#include <GL/glut.h>

#include "View.h"
#include "Wfm.h"
#include "Trans.h"
#include "TransFace.h"
#include "Texture.h"
#include "Document.h"

View::View(Document *pDoc, int *w,int *h)
{
	m_pDoc = pDoc;
	m_pWidth = w;
	m_pHeight = h;
	
	// initialized region bit flag
	m_unModified = 0;
	SetModifiedFlag(REGION_BIT_TEXTURE);
	m_unEditRegion = REGION_BIT_ANYPOINTS;
	
	// set boolean status
	m_bLButtonDown = m_bMButtonDown = m_bRButtonDown = false;
	m_bDrag = false;
	m_bColoring = false;
	
	// GL position and scale initialize
	for(int i = 0; i < 3; i++) {
		m_LocalTranslate[i] = m_GlobalTranslate[i] = 0.0;
		m_LocalRotate[i] = m_GlobalRotate[i] = 0.0;
	}
	m_LocalScale = m_GlobalScale = 1.0;
	
	// point information initialize
	m_point.x = m_point.y = m_PointNo = 0;
	
	// default fitting mode
	m_FittingMode = TRANS_ALL;

	m_status = 0;
	
}

View::~View()
{
}


void View::redraw() 
{
	::glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	::glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
	::glClearDepth( 1.0f );
	::glDepthFunc(GL_LEQUAL);
	::glEnable( GL_DEPTH_TEST );
	::glCullFace( GL_BACK );
	::glEnable( GL_CULL_FACE );
	
	SetupViewport();
	
	SetupViewingTransform();
	
	::glPushMatrix();
	DrawOpenGL();
	::glPopMatrix();
}

bool View::SetupViewport()
{
	::glViewport(0, 0, w(), h());
	
	::glMatrixMode( GL_PROJECTION );
	::glLoadIdentity();
	
	SetupViewingFrustum(w(), h());
	
	::glMatrixMode( GL_MODELVIEW );
	::glLoadIdentity();
	
	return true;
}

bool View::SetupViewingTransform()
{
	//++ Model View Matrix --
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
	
	// Set texture environment
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	
	//++ Texture Matrix --
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
	glTranslatef(0.5f, 0.5f, 0.0f);
	glScalef(0.5f, 0.5f, 1.0f);
	
	// ++ for Model View Matrix --
	glMatrixMode(GL_MODELVIEW);
	
	return true;
}

bool View::SetupViewingFrustum(int cx, int cy)
{
	if(cx <= cy) {
		glOrtho(-(GLfloat)cx/(GLfloat)cy, (GLfloat)cx/(GLfloat)cy, 
			-1.0f, 1.0f, 0.01f, 1000.0f);
	} 
	else {
		glOrtho(-1.0f, 1.0f, 
			-(GLfloat)cy/(GLfloat)cx, (GLfloat)cy/(GLfloat)cx, 0.01f, 1000.0f);
	}
	return true;
}

bool View::DrawOpenGL()
{
	// file renewal info judgement
	if(m_pDoc->IsRenewalDoc()) RenewalDocument();
	
	// re-create GL call list
	if(m_unModified) CreateGLlist();
	
	// ++ global translate, rotate and scale ++
	glTranslated(m_GlobalTranslate[0], m_GlobalTranslate[1], m_GlobalTranslate[2]);
	glRotated(m_GlobalRotate[0], 1.0, 0.0, 0.0);
	glRotated(m_GlobalRotate[1], 0.0, 1.0, 0.0);
	glRotated(m_GlobalRotate[2], 0.0, 0.0, 1.0);
	glScaled(m_GlobalScale, m_GlobalScale, m_GlobalScale);
	// -- global translate, rotate and scale --
	
	
	
	glPushMatrix();
	// ++ local translate, rotate and scale ++
	glTranslated(m_LocalTranslate[0], m_LocalTranslate[1], m_LocalTranslate[2]);
	glRotated(m_LocalRotate[0], 1.0, 0.0, 0.0);
	glRotated(m_LocalRotate[1], 0.0, 1.0, 0.0);
	glRotated(m_LocalRotate[2], 0.0, 0.0, 1.0);
	glScaled(m_LocalScale, m_LocalScale, m_LocalScale);
	// -- local translate, rotate and scale --


	if(m_pDoc->IsModelOpened()) {
		
		// draw work wire-frame
		glCallList(REGION_LIST_WORKWFM_FACE);
		
		Wfm* work = m_pDoc->GetWorkWfm();
		
		// for ANY_POINT and WITH_AROUND
		if(m_bDrag && (m_unEditRegion == REGION_BIT_ANYPOINTS
			|| m_unEditRegion == REGION_BIT_WITHAROUND)){
			glColor4d(1.0, 1.0, 0.0, 1.0);	// yellow
			glPointSize(5.0);
			glBegin(GL_POINTS);
			glVertex3dv(work->Sgridv(m_PointNo));
			glEnd();
			glPointSize(1.0);
		}
		
		// except TRANS_ALL	
		if(m_FittingMode < TRANS_ALL) {
			TransFace* trans = m_pDoc->GetTransArray(m_FittingMode);
			glColor4d(1.0, 1.0, 0.0, 1.0);	// yellow
			glPointSize(5.0);
			glBegin(GL_POINTS);
			for(int i = 0; i < trans->numControlPoints(); i++) {
				glVertex3dv(work->Sgridv(trans->controlPointIndex(i)));
			}
			glPointSize(1.0);
			glEnd();
		}
	}
	
	if(m_pDoc->IsImageOpened())	glCallList(REGION_LIST_TEXTURE);



	glPopMatrix();
	
	// texture call list
	
	
	return true; 
}

void View::CreateGLlist()
{
	// texture
	if(Modified(REGION_BIT_TEXTURE) && m_pDoc->IsImageOpened()) {
		glNewList(REGION_LIST_TEXTURE, GL_COMPILE);
		
		glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		glMatrixMode(GL_TEXTURE);		//++ texture matrix --
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);		//++ model view matrix --
		
		int DrawCh = m_pDoc->GetTexture()->alpha() ? GL_RGBA : GL_RGB;
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		glTexImage2D(GL_TEXTURE_2D, 0, 3,
			m_pDoc->GetTexture()->GetWidth(), m_pDoc->GetTexture()->GetHeight(),
			0, DrawCh, GL_UNSIGNED_BYTE, m_pDoc->GetTexture()->GetData());
		
		glPushMatrix();
		glTranslated(0.0, 0.0, -0.1);
		glEnable(GL_TEXTURE_2D);
		glBegin(GL_POLYGON);
		glTexCoord2d(1.0, 1.0);	glVertex3d(1.0, 1.0, -5.0);
		glTexCoord2d(0.0, 1.0);	glVertex3d(-1.0, 1.0, -5.0);
		glTexCoord2d(0.0, 0.0);	glVertex3d(-1.0, -1.0, -5.0);
		glTexCoord2d(1.0, 0.0);	glVertex3d(1.0, -1.0, -5.0);
		glEnd();
		
		glPopMatrix();
		
		glMatrixMode(GL_TEXTURE);		//++ texture matrix --
		glLoadIdentity();
		glTranslatef(0.5f, 0.5f, 0.0f);
		glScalef(0.5f, 0.5f, 1.0f);
		glMatrixMode(GL_MODELVIEW);		//++ model view matrix --
		
		glEndList();
		ResetModifiedFlag(REGION_BIT_TEXTURE);
	}
	
	// work wire-frame
	if(Modified(REGION_BIT_WORKWFM) && m_pDoc->GetWorkWfm()) {
		Wfm* work = m_pDoc->GetWorkWfm();
		glNewList(REGION_LIST_WORKWFM_FACE, GL_COMPILE);
		
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		glDisable(GL_TEXTURE_2D);
		for(int i = 1; i <= work->trn(); i++) {
			if(CheckRegion( i, CHECK_REGION_LINK_ALL )) {
				SetWireframeColor(work, i);
				glBegin(GL_POLYGON);
				glVertex3dv(work->SL2G1v(i));
				glVertex3dv(work->SL2G2v(i));
				glVertex3dv(work->SL2G3v(i));
				glEnd();
			}
		}
		glEndList();
		glEnable(GL_TEXTURE_2D);
	}
}

void View::SetWireframeColor(Wfm* wfm, int linkNo)
{
	int part = wfm->S2Glinkgn(linkNo);
	
	if(part <= 3 || part == 6 || part == 7 || part == 16 || part == 17) {
		if(!m_bColoring)
			glColor4d(0.0, 0.0, 1.0, 1.0);	// blue
		
		else if(((part == 1) && (wfm->SL2G1pn(linkNo) <= 14))
			|| ((part == 1) && (wfm->SL2G1pn(linkNo) == 34))
			|| ((part == 1) && (wfm->SL2G1pn(linkNo) == 35))
			|| ((part == 1) && (wfm->SL2G1pn(linkNo) == 36))
			|| ((part == 2) && (wfm->SL2G1pn(linkNo) <= 14)) ) 
		{
			glColor4d(0.0, 1.0, 0.0, 1.0);	// green, upper lip
		}
		
		else if((((171 <= wfm->SL2G1sn(linkNo)) && (171 <= wfm->SL2G2sn(linkNo)) && (171 <= wfm->SL2G3sn(linkNo))
			&&(wfm->SL2G1sn(linkNo) <= 175))
			||((180 <= wfm->SL2G1sn(linkNo)) && (180 <= wfm->SL2G2sn(linkNo)) && (180 <= wfm->SL2G3sn(linkNo))
			&&	(wfm->SL2G1sn(linkNo) <= 183))
			||	((194 <= wfm->SL2G1sn(linkNo)) && (194 <= wfm->SL2G2sn(linkNo)) && (194 <= wfm->SL2G3sn(linkNo))
			&&	(wfm->SL2G1sn(linkNo) <= 198))
			||	((203 <= wfm->SL2G1sn(linkNo)) && (203 <= wfm->SL2G2sn(linkNo)) && (203 <= wfm->SL2G3sn(linkNo))
			&&	(wfm->SL2G1sn(linkNo) <= 206)))
			&&	(linkNo != 244) && (linkNo != 254) && (linkNo != 300) && (linkNo != 310)	)
		{
			glColor4d(0.0, 1.0, 0.0, 1.0);	// green, brows
		}
		
		else
			glColor4d(0.0, 0.0, 1.0, 1.0);	// blue
	}
	
	else if(part >= 20)
		glColor4d(1.0, 0.0, 1.0, 1.0);	// magenta, eye bolls
	
	else
		glColor4d(1.0, 1.0, 1.0, 1.0);	// white
}

void View::RenewalDocument()
{
	if(!m_pDoc->IsModelOpened()) {
		// set flags
		SetModifiedFlag(REGION_BIT_TEXTURE);
		
		// GL position and scale initialize
		for(int i = 0; i < 3; i++) {
			m_LocalTranslate[i] = m_GlobalTranslate[i] = 0.0;
			m_LocalRotate[i]	= m_GlobalRotate[i]	   = 0.0;
		}
		m_LocalScale = m_GlobalScale = 1.0;
		
		// point information initialize
		m_point.x = m_point.y = m_PointNo = 0;
		
		// create GL call list
		CreateGLlist();
	} else {
		// set flags
		SetModifiedFlag(REGION_BIT_WORKWFM);
		
		// create GL call list
		CreateGLlist();
	}
	
	m_pDoc->ResetRenewalInfo();
	
}

// transformation funcitons - translate all
void View::ButtonPressTransAll(CPoint point)
{
	Wfm *work = m_pDoc->GetWorkWfm();
	
	double Window = (h() > w()) ? ((double)h() / 2.0) : ((double)w() / 2.0);
	double movex = (point.x - m_point.x) / Window / (m_LocalScale * m_GlobalScale);
	double movey = (m_point.y - point.y) / Window / (m_LocalScale * m_GlobalScale);
	
	work->Sgridx(m_PointNo) = m_PGPoint.x() + movex * cos((m_LocalRotate[1] + m_GlobalRotate[1]));
	work->Sgridy(m_PointNo) = m_PGPoint.y() + movey * cos((m_LocalRotate[0] + m_GlobalRotate[0]));
	
	if(m_LocalRotate[0] >= 0.0) {
		work->Sgridz(m_PointNo) = m_PGPoint.z()
			+ movex * sin((m_LocalRotate[1] + m_GlobalRotate[1]))
			+ movey * (1.0 - cos((m_LocalRotate[0] + m_GlobalRotate[0])));
	}	
	else {
		work->Sgridz(m_PointNo) = m_PGPoint.z()
			+ movex * sin((m_LocalRotate[1] + m_GlobalRotate[1]))
			+ movey * (1.0 - cos((m_LocalRotate[0] + m_GlobalRotate[0])));
	}
	
	SetModifiedFlag(REGION_BIT_WORKWFM);
}


// transformation functions - translate with around
void View::ButtonPressWithAround(CPoint point)
{
	Wfm *work = m_pDoc->GetWorkWfm();
	
	double Window = (h() > w()) ? ((double)h() / 2.0) : ((double)w() / 2.0);
	double movex = (point.x - m_point.x) / Window / (m_LocalScale * m_GlobalScale); // * 0.5; ... old version
	double movey = (m_point.y - point.y) / Window / (m_LocalScale * m_GlobalScale); // * 0.5; ... old version
	
				for(int i = 0; i < m_count; i++) {
					work->Sgridx(m_AnotherPointNo[i]) = m_PAnotherPoint[i].x() + 
						movex * cos((m_LocalRotate[1] + m_GlobalRotate[1]));
					work->Sgridy(m_AnotherPointNo[i]) = m_PAnotherPoint[i].y() + 
						movey * cos((m_LocalRotate[0] + m_GlobalRotate[0]));
					
					if(m_LocalRotate[0] >= 0.0) {
						work->Sgridz(m_AnotherPointNo[i]) = m_PAnotherPoint[i].z()
							+ movex * sin((m_LocalRotate[1] + m_GlobalRotate[1]))
							+ movey * (1.0 - cos((m_LocalRotate[0] + m_GlobalRotate[0])));
					}
					
					else {
						work->Sgridz(m_AnotherPointNo[i]) = m_PAnotherPoint[i].z()
							+ movex * sin((m_LocalRotate[1] + m_GlobalRotate[1]))
							+ movey * (1.0 - cos((m_LocalRotate[0] + m_GlobalRotate[0])));
					}
				}
				
				SetModifiedFlag(REGION_BIT_WORKWFM);
}

// transformation functions - translate default
void View::ButtonPressDefault(CPoint point)
{
	Wfm *work = m_pDoc->GetWorkWfm();
	TransFace *trans = m_pDoc->GetTransArray(m_FittingMode);
	if(!trans) return;
	
	// new version
	
	double Window = (h() > w()) ? ((double)h() / 2.0) : ((double)w() / 2.0);
	double movex = (point.x - m_point.x) / Window / (m_LocalScale * m_GlobalScale);
	double movey = (m_point.y - point.y) / Window / (m_LocalScale * m_GlobalScale);
	
	trans->setControlPoint(m_PointNo, 
		m_PGPoint.x() + movex * cos((m_LocalRotate[1] + m_GlobalRotate[1])), 
		m_PGPoint.y() + movey * cos((m_LocalRotate[0] + m_GlobalRotate[0])));
	trans->transform(m_PointNo, 0);
	
	SetModifiedFlag(REGION_BIT_WORKWFM);
}

void View::LeftMousePushEvent(int x, int y, int status)
{
	if(!m_pDoc->IsImageOpened()) return;
	
	m_point.x = x;
	m_point.y = y;
	m_status = status;
	m_bLButtonDown = true;
	
	if(status == GLUT_ACTIVE_SHIFT) {}	// no re-action
	else if(status == GLUT_ACTIVE_CTRL) {} // no re-action
	else if(m_pDoc->IsModelOpened()){
		
		// reading matrix prepare
		double modv[16], prov[16];
		
		// OpenGL make current
		glPushMatrix();
		
		// gloval model position set
		glTranslated(m_GlobalTranslate[0], m_GlobalTranslate[1], m_GlobalTranslate[2]);
		glRotated(m_GlobalRotate[0], 1.0, 0.0, 0.0);
		glRotated(m_GlobalRotate[1], 0.0, 1.0, 0.0);
		glRotated(m_GlobalRotate[2], 0.0, 0.0, 1.0);
		glScaled(m_GlobalScale, m_GlobalScale, m_GlobalScale);
		
		// local model position set
		glTranslated(m_LocalTranslate[0], m_LocalTranslate[1], m_LocalTranslate[2]);
		glRotated(m_LocalRotate[0], 1.0, 0.0, 0.0);
		glRotated(m_LocalRotate[1], 0.0, 1.0, 0.0);
		glRotated(m_LocalRotate[2], 0.0, 0.0, 1.0);
		glScaled(m_LocalScale, m_LocalScale, m_LocalScale);
		
		// read model-view and projection matrix
		glGetDoublev(GL_MODELVIEW_MATRIX, modv);
		glGetDoublev(GL_PROJECTION_MATRIX, prov);
		
		glPopMatrix();
		
		// prepare affine transform matrix : translocation read matrix
		Affine modelview(modv);
		modelview = t(modelview);	
		
		Affine projection(prov);	
		projection = t(projection);
		
		Affine matrix = projection * modelview;
		
		// prepare calculation values and set boolean initialize
		m_bDrag = false;
		m_PointNo = 0;
		
		Point vec(0.0, 0.0, 0.0, 1.0);
		Point origin = matrix * vec;
		
		Wfm *work = m_pDoc->GetWorkWfm();
		
		TransFace *trans = NULL;
		
		double dist, mindist = 0.03, anotherdist = 0.1;	
		int i;
		double mcpx = (double)m_point.x / ((double)w() / 2.0) - 1.0;
		double mcpy = 1.0 - (double)m_point.y / ((double)h() / 2.0);
		double min = 10000.0; // distans
		double d;
		
		// working
		int count = 0;
		if(work) {
			switch(m_FittingMode) {
			case TRANS_ALL:
				for(i = 1; i <= work->grn(); i++) {
					if(CheckRegion( i, CHECK_REGION_GRID_ALL )) {
						vec = work->Sgridv(i); 
						vec.w() = 1.0;
						vec = matrix * vec;
						if(origin.z() - vec.z() > -0.01) {
							dist = sqrt(SQR(vec.x() - mcpx) + SQR(vec.y() - mcpy));
							if(dist < mindist) { mindist = dist; m_bDrag = true; m_PointNo = i; }
						}
					}
				}
				
				if(m_bDrag) {
					m_PGPoint = work->Sgridv(m_PointNo);
				}
				break;
				
			case TRANS_WITHAROUND:
				for(i = 1; i <= work->grn(); i++) {
					if(CheckRegion( i, CHECK_REGION_GRID_ALL )) {
						vec = work->Sgridv(i);	
						vec.w() = 1.0;
						vec = matrix * vec;
						if(origin.z() - vec.z() > -0.01) {
							dist = sqrt(SQR(vec.x() - mcpx) + SQR(vec.y() - mcpy));
							if(dist < mindist) { mindist = dist; m_bDrag = true; m_PointNo = i; }
						}
					}
				}
				
				for(i = 1; i <= work->grn(); i++) {
					if(CheckRegion( i, CHECK_REGION_GRID_ALL )) {
						if(work->S2Ggridgn(i) > 3 && work->S2Ggridgn(i) < 20 && i != m_PointNo) {
							if((work->S2Ggridgn(i) < 6 && (work->S2Ggridpn(i) < 17 || work->S2Ggridpn(i) > 28)) ||
								work->S2Ggridgn(i) >= 6) {
								vec = work->Sgridv(i);	vec.w() = 1.0;
								vec = matrix * vec;
								
								if(origin.z() - vec.z() > -0.01) {
									dist = sqrt(SQR(vec.x() - mcpx) + SQR(vec.y() - mcpy));
									
									if(dist < anotherdist) { 
										m_AnotherPointNo[count] = i; if(count < 9) count++;
									}
								}
							}
						}
					}
				}
				
				if(m_bDrag) {
					m_count = count;
					
					for(i = 0; i < count; i++) {
						m_PAnotherPoint[i] = work->Sgridv(m_AnotherPointNo[i]);
					}
					
					m_PGPoint = work->Sgridv(m_PointNo);
				}
				break;
				
			default:
				if(trans = m_pDoc->GetTransArray(m_FittingMode)) trans->init();
				else return;
				
				for(i = 0; i < trans->numControlPoints(); i++) {
					//vec = modelview * trans->controlPoint(i);
					vec = trans->controlPoint(i);	
					vec.w() = 1.0;
					vec = matrix * vec;
					
					d = sqrt(SQR(vec.x() - mcpx) + SQR(vec.y() - mcpy));
					
					if(d < min) { 
						min = d;
						if(d < 5.0) {
							m_PointNo = i; 
							m_bDrag = true; 
						}
					}
				}
				
				if(m_bDrag && trans) {
					m_PGPoint.x() = trans->controlPoint(m_PointNo).x();
					m_PGPoint.y() = trans->controlPoint(m_PointNo).y();
					m_PGPoint.z() = trans->controlPoint(m_PointNo).z();
				}
				break;
			}
		}
  }
}

void View::RightMousePushEvent(int x, int y, int status)
{
	if(!m_pDoc->IsModelOpened()) return;
	
	CPoint point;
	point.x = x;
	point.y = y;
	m_status = status;

	m_point = point;
	m_bRButtonDown = true;
}

void View::MouseDragEvent(int x, int y, int status)
{
	if(!m_pDoc->IsImageOpened()) return;
	
	CPoint point;
	point.x = x;
	point.y = y;
	
	if(m_bLButtonDown) {
		if((m_status == GLUT_ACTIVE_SHIFT) && m_pDoc->IsModelOpened()) { 
			// with 'Shift' button : for wire-frame
			m_LocalTranslate[0] += (point.x - m_point.x) / (double)(w() / 2);
			m_LocalTranslate[1] -= (point.y - m_point.y) / (double)(h() / 2);
			m_point = point;
		}
		
		else if(m_status == GLUT_ACTIVE_CTRL) {	
			// with 'Control' for texture
			m_GlobalTranslate[0] += (point.x - m_point.x) / (double)(w() / 2);
			m_GlobalTranslate[1] -= (point.y - m_point.y) / (double)(h() / 2);
			m_point = point;
		}
		
		else if(m_pDoc->IsModelOpened()){
			if(m_bDrag) {
				switch(m_FittingMode) {
				case TRANS_ALL:
					ButtonPressTransAll(point);
					break;
				case TRANS_WITHAROUND:
					ButtonPressTransAll(point);
					ButtonPressWithAround(point);
					break;
				default:
					ButtonPressDefault(point);
					break;
				}
			}
		}
	}
	else if(m_bRButtonDown) {
		if(m_status == GLUT_ACTIVE_SHIFT) {
			m_LocalScale +=  (point.y - m_point.y) / (1.0 / m_LocalScale * 500.0);
			m_point = point;

		}
		else if(m_status == GLUT_ACTIVE_CTRL) {
			m_GlobalScale += (point.y - m_point.y) / (1.0 / m_GlobalScale * 500.0);
			m_point = point;

		}
	}
}

void View::LeftMouseReleaseEvent(int x, int y, int status)
{
	if(!m_pDoc->IsImageOpened()) return;
	
	if( m_pDoc->IsModelOpened() && (m_bDrag == true) ) {
		m_pDoc->AddUndo();
	}
	m_bLButtonDown = false;
	m_status = 0;
}

void View::RightMouseReleaseEvent(int x, int y, int status)
{
	if(!m_pDoc->IsImageOpened()) return;
	
	m_bRButtonDown = false;
	m_status = 0;
}

void View::HiperColor() 
{
	if(m_bColoring) m_bColoring = false;
	else m_bColoring = true;
	SetModifiedFlag(REGION_BIT_WORKWFM);
}

void View::EditUndo()
{
	m_pDoc->UseUndo();
	SetModifiedFlag(REGION_BIT_WORKWFM);
}

void View::EditRedo()
{
	m_pDoc->UseRedo();
	SetModifiedFlag(REGION_BIT_WORKWFM);
}

bool View::CheckRegion(int num, int i)
{
	Wfm *work = m_pDoc->GetWorkWfm();
	switch( i ) {
	case CHECK_REGION_GRID_ALL:
		if( work->S2Ggridgn(num) <= 19 || (work->S2Ggridgn(num) >= 30 && work->S2Ggridgn(num) <= 31)) {
			return true;
		} else {
			return false;
		}
		break;
	case CHECK_REGION_LINK_ALL:
		if( work->S2Glinkgn(num) <= 19 || (work->S2Glinkgn(num) >= 30 && work->S2Glinkgn(num) <= 31)) {
			return true;
		} else {
			return false;
		}
		break;
	default:
		break;
	}
	return false;
}

