/************************************************************************************/
/*	 TransFace.h														 */
/*	 t-misawa	 Version 1998.09.29										*/
/************************************************************************************/

#ifndef TransFace_H
#define TransFace_H

#include "Trans.h"
#include "Wfm.h"

#define TRANS_ALL 99
#define TRANS_WITHAROUND 100
#define TRANS_ADDTEX 1024

enum {
	TRANS_HEAD,
		TRANS_CONTOUR,
		TRANS_EYE,
		TRANS_BROW,
		TRANS_NOSE,
		TRANS_MOUTH,
		TRANS_NECK,
		
		MAX_MODE
};

class TransFace {
	
protected:
	Wfm *_wfm;
	int _n;	 /* Number of control points */
	PointNumber *_controlPointNumber;		/* Index of control point */
	PointNumber **_referencePointNumber;	/* Index of control point */
	PointNumber **_followingPointNumber;	/* Index of control point */
	Point *_controlPoint;	/* Location of control point */
	
	Point controlPoint0(int n) 
	{ return wfmPoint(_controlPointNumber[n]); }
	Point& controlPoint1(int n) { return controlPoint(n); }
	Point referencePoint(int n, int i, int j) 
	{ return wfmPoint(_referencePointNumber[n][i*2+j]); }
	void setWfmPoint(const PointNumber& n, const Point& p);
	void setWfmPoint(int g, int n, const Point& p);
	void setWfmPoint(int n, const Point& p);
	void transformWfm(const Affine& T);
	void affineTransform2D(int i,int flag);
	// void affineTransformYZ(int i);
	void linearTransform(int i);
	void transformFollowingPoints(const Matrix& T, int i);
	void transformGroupPoints(const Matrix& T, int g, int n);
	
public:
	TransFace(Wfm *wfm, int n = 0);
	virtual ~TransFace();
	
	void init();	/* Initialize data of control points to
	the wireframe data */
	virtual void transform(int,int) {}
	Point wfmPoint(int n);
	Point wfmPoint(int i, int j);
	Point wfmPoint(const PointNumber& n);
	int numControlPoints() { return _n; }
	int controlPointIndex(int n)
	{ return _wfm->G2Sgrid(_controlPointNumber[n].gn, _controlPointNumber[n].pn); } 
	Point& controlPoint(int n) { return _controlPoint[n]; }
	void setControlPoint(int n, Point& p) { _controlPoint[n] = p; }
	void setControlPoint(int n, double x, double y)
	{ _controlPoint[n].x() = x; _controlPoint[n].y() = y; }
	void setControlPointYZ(int n, double z, double y)
	{ _controlPoint[n].x() = z; _controlPoint[n].y() = y; }
	int controlPointNumberGN(int n) { return _controlPointNumber[n].gn; }
	int controlPointNumberPN(int n) { return _controlPointNumber[n].pn; }
};

class TransHead : public TransFace {
public:
	TransHead(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransContour : public TransFace {
public:
	TransContour(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransBrow : public TransFace {
public:
	TransBrow(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransEye : public TransFace {
protected:
	void transformEyeball(int eyeballControlPoint, 
		int eyeGroup, 
		int eyeballGroup);
public:
	TransEye(Wfm *wfm);
	virtual void transform(int n, int flag);
};

class TransEyeFine : public TransFace {
public:
	TransEyeFine(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransNose : public TransFace {
public:
	TransNose(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransMouth : public TransFace {
public:
	TransMouth(Wfm *wfm);
	virtual void transform(int n,int flag);
	void transformLip(int flag);
};

class TransMouthFine : public TransFace {
public:
	TransMouthFine(Wfm *wfm);
	virtual void transform(int n,int flag);
};

class TransNeck : public TransFace {
public:
	TransNeck(Wfm *wfm);
	virtual void transform(int n,int flag);
};

#endif

