
#ifndef __TEXTURE_IMAGE_H__
#define __TEXTURE_IMAGE_H__

/*+++
Texture.h
- a header file for setup texture image routines.

  (c)2001, Shin Ogata <shin@ee.seikei.ac.jp>
  for Morishima-lab., Seikei University.
  Referred to Takafumi Misawa & Daisuke Ito's code.
  
	First Created: Man Jul 16 11:55:45 JST 2001
	Last Modified: under development for Change Alpha routine.
---*/

#include "ImageData.h"

class Texture : public ImageData {
public:
	// public constructors, default : with alpha channel.
	Texture(int alphaCh = ON_ALPHA) : ImageData(alphaCh) {};
	Texture(const char *fileName, int alphaCh = ON_ALPHA) : ImageData(fileName, alphaCh) {}
	Texture(const Texture &tex);	// copy constructor
	
	// public destructor
	virtual ~Texture() {}
	
	// public data output function
	void GetSize(int& x, int& y) { x = m_width; y = m_height; }
	
	// public process function
	int SetAlpha()	 { return SetAlphaChannel(); }
	int ResetAlpha() { return ResetAlphaChannel(); }
	
	// change alpha value functions
	void ChangeAlpha(int x, int y, byte value);	// for one pixel
	void ChangeAlpha(const byte *lumImg);		// using luminance image
};

#endif	// __TEXTURE_IMAGE_H__
