#ifndef __RESOURCE_H__
#define __RESOURCE_H__

#define MAIN_TITLE		"Face Fit V2"
#define MAIN_WIDTH		512
#define MAIN_HEIGHT		512
#define MAIN_X			0
#define MAIN_Y			0

#define EDITOR_TITLE		"Face Model Editor"
#define EDITOR_TITLE_AU		"Face Model Editor (AUs)"
#define EDITOR_TITLE_EYE	"Face Model Editor (Eyes)"
#define EDITOR_TITLE_VIEWER	"Face Model Editor (Viewer)"
#define EDITOR_TITLE_TEETH	"Face Model Editor (Teeth)"
#define EDITOR_WIDTH		512
#define EDITOR_HEIGHT		512
#define EDITOR_X			700
#define EDITOR_Y			28

#define FS_WINDOW_TITLE		"File Selector"
#define FS_TITLE_OPEN_IMG	"Open face image file [*.rgb, *.bmp]"
#define FS_TITLE_OPEN_PNT	"Open wire frame model file [*.pnt]"
#define FS_TITLE_SAVE_PNT	"Save wire frame model file [*.pnt]"
#define FS_TITLE_OPEN_EYE	"Open eye define file [*.def_e]"
#define FS_TITLE_SAVE_EYE	"Save eye define file [*.def_e]"
#define FS_TITLE_IMAG_EYE	"Open eye texture image [*.rgb, *.bmp]"
#define FS_TITLE_SAVE_AU	"Save your au flie [*.pnt]"
#define FS_TITLE_OPEN_AU	"Open your au file [*.pnt]"
#define FS_TITLE_SAVE_TEETH	"Save teeth define file [*.def_t]"
#define FS_TITLE_OPEN_TEETH "Open teeth define file [*.def_t]"
#define FS_WIDTH			320
#define FS_HEIGHT			270
#define FS_FONT_COLOUR   1,1,1,1

#define MS_WINDOW_TITLE		"Information"
#define MS_WIDTH			400
#define MS_HEIGHT			150
#define MS_FONT_COLOUR   1,1,1,1

#define BTN_WIDTH		140
#define BTN_HEIGHT		40
#define BTN_DUR			40
#define BTN_FONT_COLOUR   1,1,1,1

#define DEFAULT_PNT_FILE "../data/fheadv2.pnt"
#define DEFAULT_LNK_FILE "../data/fheadv2.lnk"
#define DEFAULT_EYE_FILE "../data/eye.obj"
#define DEFAULT_MOUTHWALL_FILE			"../data/mouthwall.obj"
#define DEFAULT_MOUTHEALL_IMAGE_FILE	"../data/mouthwall.bmp"
#define DEFAULT_TEETH_U_FILE			"../data/teethUpper.obj"
#define DEFAULT_TEETH_L_FILE			"../data/teethLower.obj"


//////////
// Define MENU BUTTON

// Main Menu Button
void main_file_cb(puObject *);
void main_edit_cb(puObject *);
void main_region_cb(puObject *);
void main_view_cb(puObject *);
void main_help_cb(puObject *);

static char *MAIN_MENU_NAME[] = {
	"File",
		"Edit",
		"Region",
		"View",
		"Help",
};
static puCallback MAIN_MENU_CB[] = 
{
	main_file_cb,
		main_edit_cb,
		main_region_cb,
		main_view_cb,
		main_help_cb,
};
enum {
	MAIN_FILE_B = 0,
		MAIN_EDIT_B,
		MAIN_REGION_B,
		MAIN_VIEW_B,
		MAIN_HELP_B,
		MAIN_B_NUM,
};
extern puOneShot *main_b[MAIN_B_NUM];

// "File" SubMenu Button
void clear_file_cb(puObject *);
void open_face_cb(puObject *);
void open_pnt_cb(puObject *);
void save_pnt_cb(puObject *);
void eye_open_cb(puObject *);
void eye_save_cb(puObject *);
void eye_tex_open_cb(puObject *);
void au_open_cb(puObject *);
void au_save_cb(puObject *);
void teeth_open_cb(puObject *);
void teeth_save_cb(puObject *);
void quit_cb(puObject *);

static char *FILE_SUBMENU_NAME[] = 
{  
	"New Editting",
		"Open Face Image",
		"Open Pnt File",
		"Save Pnt File", 
		"Open Eye Texture",
		"Open Eye Def. File",
		"Open Teeth Def. File",
		"Open AU File",
		"Quit",
};
static puCallback FILE_SUBMENU_CB[] = 
{ 
	clear_file_cb, 
		open_face_cb, 
		open_pnt_cb, 
		save_pnt_cb, 
		eye_tex_open_cb,
		eye_open_cb,
		teeth_open_cb,
		au_open_cb, 
		quit_cb,
};
enum {
	FILE_NEW_EDIT_B = 0,
		FILE_OPEN_FACE_IMAGE_B,
		FILE_OPEN_PNT_B,
		FILE_SAVE_PNT_B,
		FILE_OPEN_EYE_TEX,
		FILE_OPEN_EYE_B,
		FILE_OPEN_TEETH_B,
		FILE_OPEN_AU_B,
		FILE_QUIT_B,
		FILE_B_NUM,
};
extern puOneShot *file_b[FILE_B_NUM];

// "Edit" SubMenu Button
void undo_cb(puObject *);
void redo_cb(puObject *);
void reset_model_cb(puObject *);
void reset_all_cb(puObject *);
void reset_window_cb(puObject *);

static char *EDIT_SUBMENU_NAME[] = 
{  
	"Undo", 
		"Redo", 
		"Reset Model Tex Pos", 
		"Reset Window Size", 
};
static puCallback EDIT_SUBMENU_CB[] = 
{ 
	undo_cb, 
		redo_cb, 
		reset_all_cb, 
		reset_window_cb,	
};
enum {
	EDIT_UNDO_B = 0,
		EDIT_REDO_B,
		EDIT_RESET_ALL_B,
		EDIT_RESET_WINDOW_B,
		EDIT_B_NUM,
};
extern puOneShot *edit_b[EDIT_B_NUM];

// "Region" SubMenu Button
void select_neck_cb(puObject *);
void select_mouth_cb(puObject *);
void select_nose_cb(puObject *);
void select_brows_cb(puObject *);
void select_eyes_cb(puObject *);
void select_outline_cb(puObject *);
void select_head_cb(puObject *);
void select_with_around_cb(puObject *);
void select_any_points_cb(puObject *);

static char *REGION_SUBMENU_NAME[] = 
{  
	"Any Points", 
		"With Around",
		"Head", 
		"Outline", 
		"Eyes", 
		"Brows",
		"Nose",
		"Mouth",	
		"Neck",
};
static puCallback REGION_SUBMENU_CB[] = 
{ 
	select_any_points_cb,
		select_with_around_cb,
		select_head_cb,
		select_outline_cb,
		select_eyes_cb,
		select_brows_cb, 
		select_nose_cb, 
		select_mouth_cb, 
		select_neck_cb, 
};
enum {
	REGION_ANY_POINTS_B = 0,
		REGION_WITH_AROUNT_B,
		REGION_HEAD_B,
		REGION_OUTLINE_B,
		REGION_EYES_B,
		REGION_BROWS_B,
		REGION_NOSE_B,
		REGION_MOUTH_B,
		REGION_NECK_B,
		REGION_B_NUM,
};
extern puOneShot *region_b[REGION_B_NUM];

// "View" SubMenu Button
void view_color_cb(puObject *);
void view_editor_cb(puObject *);

static char *VIEW_SUBMENU_NAME[] = 
{  
		"Face Model Editor",
		"Coloring Facial Parts",
};
static puCallback VIEW_SUBMENU_CB[] = 
{ 
		view_editor_cb,
		view_color_cb, 
};
enum {
		VIEW_COLOR_B = 0,
		VIEW_EDITOR_B,
		VIEW_B_NUM,
};
extern puOneShot *view_b[VIEW_B_NUM];


// "Help" SubMenu Button
void help_shortcut_cb(puObject *);
void help_version_cb(puObject *);

static char *HELP_SUBMENU_NAME[] = 
{  
	"Shortcut Keys",
		"Version Info.", 
};
static puCallback HELP_SUBMENU_CB[] = 
{ 
	help_shortcut_cb, 
		help_version_cb,
};
enum {
	HELP_SHORTCUT_B = 0,
		HELP_VERSION_B,
		HELP_B_NUM,
};
extern puOneShot *help_b[HELP_B_NUM];
// Define MENU BUTTON
//////////

static char help_how_to[] = {
"\
Shortcut keys:\n\
[ctrl + n] New edit\n\
[ctrl + o] Open face image\n\
[ctrl + p] Open Wireframe model [pnt]\n\
[ctrl + s] Save Wireframe model [pnt]\n\n\
[ctrl + z] Undo\n\
[ctrl + y] Redo\n\
[ctrl + r] Reset model and texture position\n\n\
[1] Region select: any points\n\
[2] Region select: with around\n\
[3] Region select: head\n\
[4] Region select: outline\n\
[5] Region select: eyes\n\
[6] Region select: brows\n\
[7] Region select: nose\n\
[8] Region select: mouth\n\
[9] Region select: neck\n\n\
"
};

static char help_version_info[] = {
"\
Version information:\n\
Model Fitting Tool Version 2.01 (alpha) \n\
Copyright (C)2001-2003 Morishima-Lab, Seikei University.\n\
"
};



#endif //__RESOURCE_H__
