#ifndef __DOCUMENT_H__
#define __DOCUMENT_H__

class Texture;
class TransFace;
class Wfm;
class ObjModel;
class ObjectModel;
class AUMove;

#define MAX_UNDO 20

class Document
{
	
	// user definition data members
private:
	// for background image data members
	Wfm *m_pWorkWfm;		// work wire-frame model
	Wfm *m_pStdWfm;			// defalut wire-frame model
	Wfm *m_pTempWfm;		// moving wire-frame model
	
	Wfm *m_pUndoWfm[MAX_UNDO];		// wire-frame model for undo
	int m_dStartUndo;
	int m_dCurrntUndo;
	int m_dUndoCount;
	
	Texture	   *m_pBackTex;		// background texture
	TransFace **m_pTrans;		// transform face model, mode and information matrix
	
	AUMove *m_pAuMove;

	// eye object;
	Texture    *m_pEyeTex;
	ObjModel *m_pEyeObj;
	char m_cEyeFile[256];
	double m_EyeR_Trans[3], m_EyeR_Rot[3], m_EyeR_Scale;
	double m_EyeL_Trans[3], m_EyeL_Rot[3], m_EyeL_Scale;
	double m_EyeR_Local_T[3], m_EyeR_Local_R[3], m_EyeR_Local_S;
	double m_EyeL_Local_T[3], m_EyeL_Local_R[3], m_EyeL_Local_S;
	double m_Eye_Tex_S;

	// boolean
	bool m_bRenewal;		// file renewal information boolean
	bool m_bImgOpen;		// image setup boolean
	bool m_bPntOpen;		// pnt setup boolean
	bool m_bAutoAngle;		// auto angle adjustment boolean
	
	// private user definition function
	void Cleanup();
	bool TextureEvaluation();
	void CreateTransModeMatrix();
	void SetOnXaxis(Wfm *wfm);
	void SetBasePosition(Wfm *baseWfm, Wfm *transWfm);
	
	char *m_cStd_lnk_name, *m_cStd_pnt_name, *m_cEye_obj_name;

	// for teeth model and mouthwall model
	ObjectModel *m_upperTeethObj;
	ObjectModel *m_lowerTeethObj; 
	ObjectModel *m_mouthwallObj; 
	Texture *m_pMouthWallTex;
	float m_dTeethAmbColor[4];
	float m_dTeethDifColor[4];
	float m_dTeethSpeColor[4];



	char *m_cUpperTeeth_name, *m_cLowerTeech_name, *m_cMouthwall_name;
	char *m_cMouthwall_image_name;
	char *m_cAU_dir;
	int m_cMax_AU_num;
	
public:
	Document(char *pnt_name, char *lnk_name, char *eye_obj, 
		char *mouthwall, char *mouthwall_img, char *teeth_u, char *teeth_l,
						   char *au_dir, int max_au_num);
	~Document();
	
	// process function
	bool StdPntOpen();
	void FirstAngleInitialize(Wfm *pStdWfm);
	void FileSaveAs(char *filename);
	bool ImageOpen(char *filename);
	bool PntOpen(char *filename);
	void FileClear();
	bool EyeFileOpen(char *filename);
	bool EyeFileSave(char *filename);
	bool EyeTextureOpen(char *filename);
	bool TeethFileOpen(char *filename);
	bool TeethFileSave(char *filename);

	// for Undo
	void AddUndo();
	void UseUndo();
	void UseRedo();
	void ResetUndo();
	

	// access funcitons
	AUMove*		GetAUMove()				{ return m_pAuMove; }
	Wfm*		GetStdWfm()             { return m_pStdWfm; }
	Wfm*		GetWorkWfm()			{ return m_pWorkWfm; }
	Wfm*		GetTempWfm()			{ return m_pTempWfm; }
	Texture*	GetTexture()			{ return m_pBackTex; }
	Texture*	GetEyeTexture()			{ return m_pEyeTex; }
	ObjModel*	GetEyeObject()			{ return m_pEyeObj; }
	ObjectModel* GetUpperTeethObj()		{ return m_upperTeethObj; }
	ObjectModel* GetLowerTeethObj()		{ return m_lowerTeethObj; }
	ObjectModel* GetMoutthWallObj()		{ return m_mouthwallObj; }
	float *		GetTeethAmbColor()		{ return m_dTeethAmbColor; }
	float *		GetTeethDifColor()		{ return m_dTeethDifColor; }
	float *		GetTeethSpeColor()		{ return m_dTeethSpeColor; }
	Texture*   GetMouthwallTexture()	{ return m_pMouthWallTex; }
	TransFace* GetTransArray(int mode)	{ return m_pTrans[mode]; }
	bool	   IsRenewalDoc()			{ return m_bRenewal; }
	bool	   IsImageOpened()			{ return m_bImgOpen; }
	bool	   IsModelOpened()			{ return m_bPntOpen; }
	bool	   IsAutoAngle()			{ return m_bAutoAngle; }
	void	   ResetRenewalInfo()		{ m_bRenewal = false; }
	double* GetEyeRTrans() { return m_EyeR_Trans; }
	double* GetEyeLTrans() { return m_EyeL_Trans; }
	double* GetEyeRRot() { return m_EyeR_Rot; }
	double* GetEyeLRot() { return m_EyeL_Rot; }
	double& GetEyeRScale() { return m_EyeR_Scale; }
	double& GetEyeLScale() { return m_EyeL_Scale; }

	double* GetEyeRLocalTrans() { return m_EyeR_Local_T; }
	double* GetEyeLLocalTrans() { return m_EyeL_Local_T; }
	double* GetEyeRLocalRot() { return m_EyeR_Local_R; }
	double* GetEyeLLocalRot() { return m_EyeL_Local_R; }
	double& GetEyeRLocalScale() { return m_EyeR_Local_S; }
	double& GetEyeLLocalScale() { return m_EyeL_Local_S; }
	
	double& GetEyeTexScale() { return m_Eye_Tex_S; }

	void OpenObjFile();

};

#endif __DOCUMENT_H__

