#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Document.h"
#include "Texture.h"
#include "TransFace.h"
#include "ObjModel.h"
#include "ObjectModel.h"
#include "AUMove.h"

#include "Wfm.h"

Document::Document(char *pnt_name, char *lnk_name, char *eye_obj, 
				   char *mouthwall, char *mouthwall_img, char *teeth_u, char *teeth_l,
				   char *au_dir, int max_au_num)
{
	// pointer members
	m_pStdWfm = NULL;
	m_pTempWfm = NULL;
	m_pWorkWfm = NULL;
	m_pBackTex = NULL;
	m_pTrans = new TransFace* [MAX_MODE];
	m_pEyeObj = NULL;
	m_pEyeTex = NULL;
	m_pAuMove = NULL;

	m_cAU_dir = au_dir;
	m_cMax_AU_num = max_au_num;

	// init. of Teeth Obj
	m_upperTeethObj = NULL;
	m_lowerTeethObj = NULL;
	m_mouthwallObj = NULL;
	m_cUpperTeeth_name = teeth_u;
	m_cLowerTeech_name = teeth_l;
	m_cMouthwall_name = mouthwall;
	m_cMouthwall_image_name = mouthwall_img;
	m_pMouthWallTex = new Texture( m_cMouthwall_image_name );
	m_dTeethAmbColor[0] = m_dTeethAmbColor[1] = m_dTeethAmbColor[2] = 0.0;
	m_dTeethDifColor[0] = m_dTeethDifColor[1] = m_dTeethDifColor[2] = 1.0;
	m_dTeethSpeColor[0] = m_dTeethSpeColor[1] = m_dTeethSpeColor[2] = 1.0;
	m_dTeethAmbColor[3] = m_dTeethDifColor[3] = m_dTeethSpeColor[3] = 1.0;

	int i;

	for(i = 0; i < MAX_MODE; i++) m_pTrans[i] = NULL;
	
	for(i = 0; i < MAX_UNDO; i++ ) m_pUndoWfm[i] = NULL;
	m_dStartUndo = 0;
	m_dCurrntUndo = 0;
	m_dUndoCount = 0;
	
	// boolean
	m_bRenewal   = false;
	m_bImgOpen   = false;
	m_bPntOpen   = false;
	m_bAutoAngle = true;
	
	m_cStd_pnt_name = pnt_name;
	m_cStd_lnk_name = lnk_name;
	m_cEye_obj_name = eye_obj;
	strcpy(m_cEyeFile, "\0");
	
	if( StdPntOpen() == false ) exit(1);

	m_pEyeObj = new ObjModel(m_cEye_obj_name);
	m_pEyeObj->ReCalcTexture(1.0);

	m_EyeR_Trans[0] = m_EyeR_Trans[1] = m_EyeR_Trans[2] = 0.0;
	m_EyeL_Trans[0] = m_EyeL_Trans[1] = m_EyeL_Trans[2] = 0.0;
	m_EyeR_Rot[0] = m_EyeR_Rot[1] = m_EyeR_Rot[2] = 0.0;
	m_EyeL_Rot[0] = m_EyeL_Rot[1] = m_EyeL_Rot[2] = 0.0;
	m_EyeR_Scale = m_EyeR_Scale = 1.0;

	m_EyeR_Local_T[0] = m_EyeR_Local_T[1] = m_EyeR_Local_T[2] = 0.0;
	m_EyeL_Local_T[0] = m_EyeL_Local_T[1] = m_EyeL_Local_T[2] = 0.0;
	m_EyeR_Local_R[0] = m_EyeR_Local_R[1] = m_EyeR_Local_R[2] = 0.0;
	m_EyeL_Local_R[0] = m_EyeL_Local_R[1] = m_EyeL_Local_R[2] = 0.0;
	m_EyeR_Local_S = m_EyeR_Local_S = 1.0;

	m_Eye_Tex_S = 1.0;
}

Document::~Document()
{
	if( m_pStdWfm != NULL ) { delete m_pStdWfm; }
	if( m_pTempWfm != NULL ) { delete m_pTempWfm; }
	if( m_pWorkWfm != NULL ) { delete m_pWorkWfm; }
	if( m_pBackTex != NULL ) { delete m_pBackTex; }
	if( m_pEyeTex != NULL ) { delete m_pEyeTex; }
	if( m_pEyeObj != NULL ) { delete m_pEyeObj; }
	if( m_pAuMove != NULL ) { delete m_pAuMove; }

	if( m_upperTeethObj != NULL ) { delete m_upperTeethObj; }
	if( m_lowerTeethObj != NULL ) { delete m_lowerTeethObj; }
	if( m_mouthwallObj != NULL ) { delete m_mouthwallObj; }
	if( m_pMouthWallTex != NULL ) { delete m_pMouthWallTex; }
	int i;
	for(i = 0; i < MAX_MODE; i++) {
		if( m_pTrans[i] != NULL ) { delete [] m_pTrans[i]; }
	}
	for( i = 0; i < MAX_UNDO; i++ ) {
		if( m_pUndoWfm[i] != NULL ) { delete m_pUndoWfm[i]; }
	}
	delete [] m_pTrans;
}

bool Document::StdPntOpen()
{
	m_pStdWfm = new Wfm(m_cStd_pnt_name);
	if(!m_pStdWfm->success()) {
		//fl_message("Cannot Open [%s]", m_cStd_pnt_name);
		return false;
	}
	
	// load and set link
	if(m_pStdWfm->loadLink(m_cStd_lnk_name) == false ) {
		//fl_message("Cannot Open [%s]", m_cStd_lnk_name);
		return false;
	}
	
	m_pStdWfm->setLink();
	
	m_pAuMove = new AUMove(m_cAU_dir, m_cMax_AU_num);

	return true;
}

void Document::FileClear() 
{
	Cleanup();
	
	m_bRenewal   = false;
	m_bImgOpen   = false;
	m_bPntOpen   = false;
	m_bAutoAngle = true;
}

bool Document::ImageOpen(char *filename) 
{
	try {
		// read texture image
		m_pBackTex = new Texture(filename);
		if(int err = m_pBackTex->ErrorJudge())	throw err;
	}
	
	catch (int) {
		//fl_message("Cannot Open Image File!! [%s]", filename);
		Cleanup();
		return false;
	}
	
	if(!TextureEvaluation()) {
		//fl_message("Cannot Open Image File!! [%s]", filename);
		Cleanup();
		return false;
	}
	
	
	// set boolean
	m_bRenewal = true;
	m_bImgOpen = true;
	
	return true;
}

bool Document::EyeTextureOpen(char *filename)
{
	try {
		// read texture image
		if( m_pEyeTex != NULL ) { delete m_pEyeTex; m_pEyeTex = NULL; }
		m_pEyeTex = new Texture(filename);
		if(int err = m_pEyeTex->ErrorJudge())	throw err;
	}
	
	catch (int) {
		//fl_message("Cannot Open Eye Image File!! [%s]", filename);
		Cleanup();
		return false;
	}
	
	if(!TextureEvaluation()) {
		//fl_message("Cannot Open Eye Image File!! [%s]", filename);
		Cleanup();
		return false;
	}
	strcpy(m_cEyeFile, filename);
	return true;
}

bool Document::TeethFileOpen(char *filename)
{
	char temp[256];
	std::ifstream in(filename);
	if( !in ) {
		return false;
	}
	in.getline(temp, sizeof(temp) );
	
	sscanf(temp, "%f %f %f", &m_dTeethDifColor[0], &m_dTeethDifColor[1], &m_dTeethDifColor[2]);

	in.close();

	return true;
}
bool Document::TeethFileSave(char *filename)
{
	std::ofstream out(filename);
	if( !out ) {
		return false;
	}

	out << m_dTeethDifColor[0];
	out << " ";
	out << m_dTeethDifColor[1];
	out << " ";
	out << m_dTeethDifColor[2];

	out.close();

	return true;
}

bool Document::EyeFileOpen(char *filename)
{
	std::ifstream in(filename, std::ios::in | std::ios::binary);
	if( !in ) {
		//fl_message("Cannot Open File!! [%s]", filename);
		return false;
	}
	in.read((char *) m_EyeR_Trans, sizeof(double) * 3);
	in.read((char *) m_EyeR_Rot, sizeof(double) * 3);
	in.read((char *) &m_EyeR_Scale, sizeof(double));
	in.read((char *) m_EyeL_Trans, sizeof(double) * 3);
	in.read((char *) m_EyeL_Rot, sizeof(double) * 3);
	in.read((char *) &m_EyeL_Scale, sizeof(double));
	in.read((char *) m_EyeR_Local_T, sizeof(double) * 3);
	in.read((char *) m_EyeR_Local_R, sizeof(double) * 3);
	in.read((char *) &m_EyeR_Local_S, sizeof(double));
	in.read((char *) m_EyeL_Local_T, sizeof(double) * 3);
	in.read((char *) m_EyeL_Local_R, sizeof(double) * 3);
	in.read((char *) &m_EyeL_Local_S, sizeof(double));
	in.read((char *) &m_Eye_Tex_S, sizeof(double));
	
	in.close();

	return true;
}

bool Document::EyeFileSave(char *filename)
{
	if( strcmp(m_cEyeFile, "\0") == 0 ) {
		printf("Texture image is not opened!! [%s]\n", filename);
	}

	std::ofstream out(filename, std::ios::out | std::ios::binary);
	if( !out ) {
		printf("!!Cannot Save File!! [%s]\n", filename);
		return false;
	}
	out.write((char *) m_EyeR_Trans, sizeof(double) * 3);
	out.write((char *) m_EyeR_Rot, sizeof(double) * 3);
	out.write((char *) &m_EyeR_Scale, sizeof(double));
	out.write((char *) m_EyeL_Trans, sizeof(double) * 3);
	out.write((char *) m_EyeL_Rot, sizeof(double) * 3);
	out.write((char *) &m_EyeL_Scale, sizeof(double));
	out.write((char *) m_EyeR_Local_T, sizeof(double) * 3);
	out.write((char *) m_EyeR_Local_R, sizeof(double) * 3);
	out.write((char *) &m_EyeR_Local_S, sizeof(double));
	out.write((char *) m_EyeL_Local_T, sizeof(double) * 3);
	out.write((char *) m_EyeL_Local_R, sizeof(double) * 3);
	out.write((char *) &m_EyeL_Local_S, sizeof(double));
	out.write((char *) &m_Eye_Tex_S, sizeof(double));
	
	out.close();

	return true;
}

bool Document::PntOpen(char *filename)
{
	// read wire-frame model
	try {
		m_pWorkWfm = new Wfm(filename);
		
		if(int err = !m_pWorkWfm->success())	throw err;
	}
	
	catch(int) {
		//fl_message("Cannot Open Pnt File!! [%s]", filename);
		Cleanup();
		return false;
	}
	
	
	// check pnt file version
	if( (m_pWorkWfm->grn()) != (m_pStdWfm->grn()) ) {
		delete m_pWorkWfm;
		return false;
	}


	// create transform face mode matrix
	CreateTransModeMatrix();
	
	for( int i = 0; i < MAX_UNDO; i++ ) {
		m_pUndoWfm[i] = new Wfm(filename);
	}
	ResetUndo();

	// create temp wfm
	m_pTempWfm = new Wfm(filename);


	// set boolean
	m_bRenewal = true;
	m_bPntOpen = true;
	
	return true;
}

void Document::FileSaveAs(char *filename) 
{
	// save work 
	m_pWorkWfm->save(filename);
}

void Document::OpenObjFile()
{
	// create tempWfm
	m_pTempWfm->copyGrn(*m_pWorkWfm);
	
	// create au
	m_pAuMove->setWfm(m_pWorkWfm, m_pTempWfm);

	// delete teeth and mouthwall obj
	if( m_upperTeethObj != NULL ) delete m_upperTeethObj;
	if( m_lowerTeethObj != NULL ) delete m_lowerTeethObj;
	if( m_mouthwallObj != NULL ) delete m_mouthwallObj;

	// create teeth and mouthwall obj
	m_upperTeethObj = new ObjectModel(m_cUpperTeeth_name, 
		TEETH_UPPER, m_pWorkWfm, m_pTempWfm);
	m_lowerTeethObj = new ObjectModel(m_cLowerTeech_name, 
		TEETH_LOWER, m_pWorkWfm, m_pTempWfm);
	m_mouthwallObj = new ObjectModel(m_cMouthwall_name, 
		MOUTH_WALL, m_pWorkWfm, m_pTempWfm);
	
	m_upperTeethObj->adjustTeeth(TEETH_UPPER);
	m_lowerTeethObj->adjustTeeth(TEETH_LOWER);
	m_mouthwallObj->calcTexturePoint();
	m_mouthwallObj->adjustMouthwall();
}

void Document::Cleanup()
{
	if( m_pWorkWfm != NULL ) {delete m_pWorkWfm; m_pWorkWfm = NULL;}
	if( m_pTempWfm != NULL ) {delete m_pTempWfm; m_pTempWfm = NULL;}
	if( m_pBackTex != NULL ) {delete m_pBackTex; m_pBackTex = NULL;}
	if( m_pEyeTex != NULL ) {delete m_pEyeTex; m_pEyeTex = NULL;}

	strcpy( m_cEyeFile, "\0");
	int i;
	for(i = 0; i < MAX_MODE; i++) { 
		delete m_pTrans[i]; m_pTrans[i] = NULL; 
	}
	
	for( i = 0; i < MAX_UNDO; i++ ) {
		if( m_pUndoWfm[i] != NULL ) {
			delete m_pUndoWfm[i];
			m_pUndoWfm[i] = NULL;
		}	
	}
}

bool Document::TextureEvaluation()
{
	// +++ check texture size - 2^n size. +++
	int	   n;
	int	   tx_x = m_pBackTex->GetWidth();
	double ck_x = frexp((double)tx_x, &n);	// "frexp(double, int&)" : defined by <math.h>
	
	if(ck_x != 0.50)	return false;
	
	int	    tx_y = m_pBackTex->GetHeight();
	double	ck_y = frexp((double)tx_y, &n);
	
	if(ck_y != 0.50)	return false;
	// --- check texture size - 2^n size. ---
	
	return true;
}

void Document::CreateTransModeMatrix()
{
	m_pTrans[0] = new TransHead(m_pWorkWfm);
	m_pTrans[1] = new TransContour(m_pWorkWfm);
	m_pTrans[2] = new TransEye(m_pWorkWfm);
	m_pTrans[3] = new TransBrow(m_pWorkWfm);
	m_pTrans[4] = new TransNose(m_pWorkWfm);
	m_pTrans[5] = new TransMouth(m_pWorkWfm);
	m_pTrans[6] = new TransNeck(m_pWorkWfm);
}

void Document::FirstAngleInitialize(Wfm *pStdWfm)
{
	// call standard wire-frame model
	Wfm* pCopyWfm = new Wfm();
	*pCopyWfm = *pStdWfm;
	
	// set wire-frame's coodinate on x axis
	SetOnXaxis(pCopyWfm);
	SetOnXaxis(m_pWorkWfm);
	
	// transform to top of nose point
	double AngleToNose = atan(pCopyWfm->Sgridy(88) / pCopyWfm->Sgridz(88))
					   - atan(m_pWorkWfm->Sgridy(88) / m_pWorkWfm->Sgridz(88));
	
	Point  vec(0.0, 0.0, 0.0, 1.0);
	Affine RotateX = rotateX(AngleToNose);
	for(int i = 1; i <= m_pWorkWfm->grn(); i++, vec.w() = 1.0) {
		vec = m_pWorkWfm->Sgridv(i);
		vec = RotateX * vec;
		
		m_pWorkWfm->Sgridx(i) = vec.x();
		m_pWorkWfm->Sgridy(i) = vec.y();
		m_pWorkWfm->Sgridz(i) = vec.z();
	}
	
	// translate default position
	SetBasePosition(pStdWfm, m_pWorkWfm);
	
	m_bAutoAngle = false;
	delete pCopyWfm;
}

void Document::SetOnXaxis(Wfm *wfm)
{
	int i;
	// prepare members
	Point  vec(0.0, 0.0, 0.0, 1.0);
	Affine TransLeft = translate(-(wfm->Sgridx(379)), -(wfm->Sgridy(379)), -(wfm->Sgridz(379))); 
	
	// left temple adjustment - standard wire-frame model
	for(i = 1; i <= wfm->grn(); i++, vec.w() = 1.0) {
		vec = wfm->Sgridv(i);
		vec = TransLeft * vec;
		
		wfm->Sgridx(i) = vec.x();
		wfm->Sgridy(i) = vec.y();
		wfm->Sgridz(i) = vec.z();
	}
	
	// rotate rite-temple coodinate to x axis. - standard wire-frame model
	double angleZtoXaxis = -(atan(wfm->Sgridy(399) / wfm->Sgridx(399)));
	Affine RotateZ = rotateZ(angleZtoXaxis);
	
	for(i = 1; i <= wfm->grn(); i++, vec.w() = 1.0) {
		vec = wfm->Sgridv(i);
		vec = RotateZ * vec;
		
		wfm->Sgridx(i) = vec.x();
		wfm->Sgridy(i) = vec.y();
		wfm->Sgridz(i) = vec.z();
	}
	
	double angleYtoXaxis = atan(wfm->Sgridz(399) / wfm->Sgridx(399));
	Affine RotateY   = rotateY(angleYtoXaxis);
	
	for(i = 1; i <= wfm->grn(); i++, vec.w() = 1.0) {
		vec = wfm->Sgridv(i);
		vec = RotateY * vec;
		
		wfm->Sgridx(i) = vec.x();
		wfm->Sgridy(i) = vec.y();
		wfm->Sgridz(i) = vec.z();
	}
}

void Document::SetBasePosition(Wfm *baseWfm, Wfm *transWfm)
{
	Point  vec(0.0, 0.0, 0.0, 1.0);
	double trans_x = baseWfm->Ggridx(3, 15) - transWfm->Ggridx(3, 15);
	double trans_y = baseWfm->Ggridy(3, 15) - transWfm->Ggridy(3, 15);
	double trans_z = baseWfm->Ggridz(3, 15) - transWfm->Ggridz(3, 15);
	Affine revise_z = translate(trans_x, trans_y, trans_z);
	
	for(int i = 1; i <= transWfm->grn(); i++, vec.w() = 1.0) {
		vec = transWfm->Sgridv(i);
		vec = revise_z * vec;
		
		transWfm->Sgridx(i) = vec.x();
		transWfm->Sgridy(i) = vec.y();
		transWfm->Sgridz(i) = vec.z();
	}
}

void Document::AddUndo() 
{
	int tempUndo = m_dCurrntUndo + 1;
	if( tempUndo == MAX_UNDO ) tempUndo = 0;
	
	m_pUndoWfm[tempUndo]->copyGrn(*m_pWorkWfm);
	
	m_dCurrntUndo++;
	if( m_dCurrntUndo == MAX_UNDO ) {
		m_dCurrntUndo = 0;
	}
	if( m_dCurrntUndo == m_dStartUndo ) {
		m_dStartUndo++;
		if( m_dStartUndo == MAX_UNDO ) {
			m_dStartUndo = 0;
		}
	}
	
	m_dUndoCount = 0;
}

void Document::UseUndo()
{
	if( m_dCurrntUndo > m_dStartUndo ) {
		m_dCurrntUndo--;
		m_pWorkWfm->copyGrn(*(m_pUndoWfm[m_dCurrntUndo]));
		m_dUndoCount++;
	} else if( m_dCurrntUndo < m_dStartUndo ) {
		m_dCurrntUndo--;
		if( m_dCurrntUndo == -1 ) {
			m_dCurrntUndo = MAX_UNDO - 1;
		}
		m_pWorkWfm->copyGrn(*(m_pUndoWfm[m_dCurrntUndo]));
		m_dUndoCount++;
	}
}

void Document::UseRedo()
{
	if( m_dUndoCount > 0 ) {
		m_dCurrntUndo++;
		if( m_dCurrntUndo == MAX_UNDO ) {
			m_dCurrntUndo = 0;
		}
		m_pWorkWfm->copyGrn(*(m_pUndoWfm[m_dCurrntUndo]));
		
		m_dUndoCount--;		
	}
}

void Document::ResetUndo()
{
	m_dCurrntUndo = 0;
	m_dStartUndo = 0;
	m_dUndoCount = 0;
	m_pUndoWfm[m_dCurrntUndo]->copyGrn(*m_pWorkWfm);
}
