/*++
AUMove.c++
Copyright (c) 1999, Takafumi MISAWA. ALL RIGHTS RESERVED.
--*/

#include "AUMove.h"

#include <stdio.h>
#include <stdlib.h>

#include "Wfm.h"
#include <iostream>
#include <string>

AUMove::AUMove(char *dirname, int maxAU)
{	
	m_dirname = dirname;
	m_maxAU = maxAU;
	
	for(int i = 0; i < m_maxAU; i++) m_auData[i] = NULL;

	openAUData();
}

AUMove::~AUMove()
{
	for(int i = 0; i < m_maxAU; i++) delete m_auData[i];
}

void AUMove::setWfm(Wfm *orgWfm, Wfm *workWfm)
{	
	m_orgWfm = orgWfm;
	m_workWfm = workWfm;
}

void AUMove::resetWfm()
{
	m_workWfm->copyGrn(*m_orgWfm);
}

void AUMove::auMove(float *auParam)
{
	int i;
	
	for(i = 0; i < m_maxAU; i++) m_auParam[i] = auParam[i];
	
	for(i = 0; i < m_maxAU; i++) {
		if(m_auParam[i] != 0.0) {
			for(int j = 1; j <= m_workWfm->grn(); j++) {
				m_workWfm->Sgridx(j) += m_auData[i]->Sgridx(j) * (float)m_auParam[i];
				m_workWfm->Sgridy(j) += m_auData[i]->Sgridy(j) * (float)m_auParam[i];
				m_workWfm->Sgridz(j) += m_auData[i]->Sgridz(j) * (float)m_auParam[i];
			}
		}
	}
}

void AUMove::openAUData()
{
	char number[32];

	std::string filename = m_dirname;
	std::string fileext = ".pnt";
	std::string au_file;

	for(int i = 0; i <( m_maxAU - 1); i++) {
		m_auData[i] = new Wfm;
		
		sprintf( number, "AU%02d", i + 1 );
		 au_file = filename + number + fileext;

		if(!m_auData[i]->load(au_file.c_str())) {
			printf("can't au read\n");
			exit(1);
		}
	}
	
	std::string userfile = "test.pnt";
	au_file = filename + userfile;
	m_auData[m_maxAU - 1] = new Wfm;
	if(!m_auData[m_maxAU - 1]->load(au_file.c_str())) {
		printf("can't au read\n");
		exit(1);
	}
}

bool AUMove::openUserDefAUData(char *filename)
{
	if( m_auData[m_maxAU - 1] != NULL ) { 
		delete m_auData[m_maxAU - 1];
		m_auData[m_maxAU - 1] = new Wfm;
	}
	std::string userfile = filename;
	if(!m_auData[m_maxAU - 1]->load(userfile.c_str())) {
		printf("can't au read\n");
		return false;
	}
	return true;
}
