/*++
ReadCommand.h
--*/

#ifndef __READ_COMMAND_H__
#define __READ_COMMAND_H__

#ifdef WIN32
#pragma warning (disable: 4786)
#endif


#include <iostream>

#include "CommandSet.h"

using namespace std;

class ReadCommand : public CommandSet {
	
public:
	// public constructor
	ReadCommand();
	
	// public destructor
	~ReadCommand();
	
private:
	vector<string> m_vsToken;
	vector<string> m_vsCmdParamName;
	vector<string> m_vsCmdSlotName;
	vector<string> m_vsCmdMethodName;
	vector<int> m_vsCmdMethodNum;
	vector<int> m_vsCmdMethodSubNum;
	
	bool FuncCommentOut(int dummy);          // Unknown Command
	bool FuncInqProtocolVersion(int dummy);  // inq ProtocolVersion
	bool FuncInqModuleVersion(int dummy);    // inq ModuleVersion
	bool FuncInqRun(int dummy);              // inq Run
	bool FuncInqLipSync(int num);            // inq LipSync
	bool FuncInqSpeak(int num);              // inq Speak
	bool FuncInqMaskSet(int dummy);          // inq MaskSet
	bool FuncSetFace(int num);               // set Face
	bool FuncSetMouth(int num);              // set Mouse
	bool FuncSetHeadRotRel(int num);         // set HeadRotRel
	bool FuncSetHeadRotAbs(int num);         // set HeadRotAbs
	bool FuncSetFaceMot(int dummy);          // set FaceMot
	bool FuncSetFaceExp(int dummy);          // set FaceExp
	bool FuncSetLipSync(int num);            // set LipSync
	bool FuncSetSpeak(int num);              // set Speak
	bool FuncSetMask(int dummy);             // set Mask
	bool FuncSetAutonomous(int dummy);       // set Autonomous
	bool FuncSetMouthScale(int dummy);       // set MouthScale
	bool FuncInqMouthScale(int dummy);       // inq MouthScale
	bool FuncPropSpeak(int num);             // prop Speak
	bool FuncSetSaveImage(int dummy);        // set ImageSave
	bool FuncSetBackground(int dummy);		 // set Background
	bool FuncInqBackgroundSet(int dummy);	 // inq Background
	bool FuncInqNowMask(int dummy);			 // inq NowMask
	bool FuncInqNowBackground(int dummy);    // inq NowBackground
	bool FuncSetEyeRot(int dummy);			// set EyeRot
	bool FuncSetEyeRotLeft(int dummy);		// set EyeRotLeft
	bool FuncSetEyeRotRight(int dummy);		// set EyeRotRight
	bool FuncSetViewMode(int dummy);		// set ViewMode
	bool FuncInqViewMode(int dummy);		// inq ViewMode
	bool FuncSetViewBackground(int dummy);	// set ViewBackground
	bool FuncInqViewBackground(int dummy);	// inq ViewBackground
	bool FuncSetRun(int dummy);				// set Run

	// bZ[W𑗂iPreqj
	void SendMessageCommand( string message );
	
	// R}hQ̓ǂݏo
	bool ReadCommandSet();
	
	// Tokenɕ
	void SplitToken(string buffer);
	
	// Tokeñ`FbN 
	// ߂l 0:false  1:'='  2:'<'  3:"<<"
	int CheckToken();
	
	// Token̐̃`FbN
	//  Token̐
	bool CheckTokenNum( int num );
	
	// ݂̎l
	void NowTime( int &day, int &hr, int &mm, int &ss, int &ms );
	
public:
	bool AnalysisCmd( string command );
};

#endif

