#ifndef __FACEVIEW_H__
#define __FACEVIEW_H__

#include <iostream>
#include <string>

#include "Wfm.h"

#ifndef __FV_TEXTURED__ 
#define __FV_TEXTURED__

enum {
	FV_TEXTURED = 0,
		FV_WITH_WIRE,
		FV_ONLY_WIRE,
};

#endif

class FaceModel;

using namespace std;

#ifndef __CPOINT__
#define __CPOINT__
class CPoint
{
public:
	int x;
	int y;
};

#endif

class FaceView {
private:
	
protected:
	FaceModel **_model;
	int _height, _width;
	float _translate[3], _rotate[3], _scale[3], _rotateM[16];
	int _modelView;
	char *_saveFilename;
	int _backgroundVisible;
	int _saveImageFlag;
	
	
	// mouse
	CPoint m_point;												// mouse point
	bool   m_bLButtonDown, m_bRButtonDown, m_bMButtonDown;		// mouse button status

	// object position
	double m_trans[3];
	double m_rot[3];
	double m_scale;

	double m_HeadTrans[3];
	double m_HeadRot[3];


	// User definable process functions
	virtual void drawFaceModel(FaceModel *);
	
public:
	// Public constructors
	FaceView::FaceView(FaceModel **model, int width, int height);
	
	// Destructor
	virtual ~FaceView();
	
	// Process function
	virtual void redraw(int num);
	virtual void setModelView(int mode) { _modelView = mode; }
	virtual int getModelView() { return _modelView; }
	virtual void setBackgroundVisible(int n) { _backgroundVisible = n; }
	virtual void resetTransform();
	void setSaveFilename(char *filename) {
		if(_saveFilename) delete [] _saveFilename;
		_saveFilename = new char[strlen(filename) + 1];
		strcpy(_saveFilename, filename);
	}
	void setSaveImageFlag(int n) { _saveImageFlag = n; }
	
	// Data input function
	virtual void setTranslate(float x, float y, float z)
    { _translate[0] = x; _translate[1] = y; _translate[2] = z; }
	virtual void setRotate(float x, float y, float z)
    { _rotate[0] = x; _rotate[1] = y; _rotate[2] = z; }
	virtual void setScale(float x, float y, float z)
    { _scale[0] = x; _scale[1] = y; _scale[2] = z; }
	
	virtual void getTranslate(float &x, float &y, float &z)
    { x = _translate[0]; y = _translate[1]; z = _translate[2]; }
	virtual void getRotate(float &x, float &y, float &z)
    { x = _rotate[0]; y = _rotate[1]; z = _rotate[2]; }
	virtual void getScale(float &x, float &y, float &z)
    { x = _scale[0]; y = _scale[1]; z = _scale[2]; }
	
	// Data output function
	virtual int saveImage(char *filename, int num);

	// mouse
	bool GetLButtonDown() { return m_bLButtonDown; }
	bool GetRButtonDown() { return m_bRButtonDown; }
	bool GetMButtonDown() { return m_bMButtonDown; }
	void GetPoint( int &x, int &y ) { x = m_point.x; y = m_point.y; }
	
	void SetLButtonDown(bool flag) { m_bLButtonDown = flag; }
	void SetRButtonDown(bool flag) { m_bRButtonDown = flag; }
	void SetMButtonDown(bool flag) { m_bMButtonDown = flag; }
	void SetPoint( int x, int y ) { m_point.x = x; m_point.y = y; }

	void LeftMousePushEvent(int x, int y, int status);
	void RightMousePushEvent(int x, int y, int status);
	void MidMousePushEvent(int x, int y, int status);
	void LeftMouseReleaseEvent(int x, int y, int status);
	void RightMouseReleaseEvent(int x, int y, int status);
	void MidMouseReleaseEvent(int x, int y, int status);
	void MouseDragEvent(int x, int y, int status, int w, int h);

	void ResetTrans() { 
		m_trans[0] = m_trans[1] = m_trans[2] = m_rot[0] = m_rot[1] = m_rot[2] = 0.0;
		m_scale = 1.0;
	}

	void ResetHeadTrans() {
		m_HeadTrans[0] = m_HeadTrans[1] = m_HeadTrans[2] = 0.0;
		m_HeadRot[0] = m_HeadRot[1] = m_HeadRot[2] = 0.0;
	}

	double *GetHeadRot() { return m_HeadRot; }

};

#endif

