//
// MMIVXetgGhVer1.1
// ^C}[ǗW[
//
// TimerCtrl.h / TimerCtrl.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _TIMERCTRL_H_
#define _TIMERCTRL_H_

#pragma once

#include "InputModality.h"
#include "OutputModality.h"
#include "ProcessTracer.h"

using namespace std;


typedef enum _TIMERSTATE
{
	STATE_INIT     = -1,
	STATE_COUNTING = 0,
	STATE_PAUSING,
	STATE_SLEEPING
} TIMERSTATE;

class CState;
class CStateCounting;
class CStatePausing;
class CStateSleeping;



//
// CTimer
//
class CTimer
{
private:
	class CState
	{
	public:
		CState();
		virtual ~CState();

		virtual const TIMERSTATE handleGetState();
		virtual int handleTimeout( CTimer *pTimer );
		virtual int handleCount( CTimer *pTimer );
		virtual int handlePause( CTimer *pTimer );
		virtual int handleSleep( CTimer *pTimer );
		virtual int handleResume( CTimer *pTimer );
		virtual int handleSet( CTimer *pTimer, const long interval );
	};

	class CStateCount : public CState
	{
	public:
		CStateCount();
		virtual ~CStateCount();
		
		virtual const TIMERSTATE handleGetState();
		virtual int handleTimeout( CTimer *pTimer );
		virtual int handlePause( CTimer *pTimer );
		virtual int handleSleep( CTimer *pTimer );
	};

	class CStatePause : public CState
	{
	public:
		CStatePause();
		virtual ~CStatePause();
		
		virtual const TIMERSTATE handleGetState();
		virtual int handleCount( CTimer *pTimer );
		virtual int handleSleep( CTimer *pTimer );
		virtual int handleResume( CTimer *pTimer );
		virtual int handleSet( CTimer *pTimer, const long interval );
	};

	class CStateSleep : public CState
	{
	public:
		CStateSleep();
		virtual ~CStateSleep();
		
		virtual const TIMERSTATE handleGetState();
		virtual int handleCount( CTimer *pTimer );
		virtual int handleSet( CTimer *pTimer, const long interval );
	};

public:
	static vector < CState* >		 m_States;
	static int						 m_nNumOfTimers;

private:
	string					 m_sTimerID;
	CState*					 m_pCurrentState;
	long					 m_nInterval;
	unsigned long			 m_nBaseTime;
	unsigned long			 m_nPreCount;
	
public:
	CTimer();
	CTimer( const string id, const unsigned long interval, const TIMERSTATE state = STATE_COUNTING );
	virtual ~CTimer();

	const string& GetID();

	int requestTimeout();
	int requestCount();
	int requestPause();
	int requestSleep();
	int requestResume();
	int requestSet( const long interval );
	const TIMERSTATE GetState();

	CTimer& operator = ( const CTimer& timer );

private:
	int Init();
	
	int SetState( TIMERSTATE timerstate );
	
	friend class CStateCount;
	friend class CStatePause;
	friend class CStateSleep;

};



//
// CTimerCtrl
//
class CTimerCtrl : public CInputModality, public COutputModality
{
private:
	class CCmdCreate : public COutputCommand
	{
	public:
		CCmdCreate( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdCreate();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdDelete : public COutputCommand
	{
	public:
		CCmdDelete( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdDelete();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdStart : public COutputCommand
	{
	public:
		CCmdStart( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdStart();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdStop : public COutputCommand
	{
	public:
		CCmdStop( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdStop();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdSuspend : public COutputCommand
	{
	public:
		CCmdSuspend( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSuspend();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdResume : public COutputCommand
	{
	public:
		CCmdResume( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdResume();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

	class CCmdSet : public COutputCommand
	{
	public:
		CCmdSet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSet();

	public:
		virtual EXECRESULT Execute();
		virtual EXECRESULT Terminate();
	};

public:
	// ^C}[pNX萔
	static const char* _TYPE_TIMER;
	static const char* _EVENT_TIMEOUT;
	static const char* _EVENT_CREATE;
	static const char* _EVENT_DELETE;
	static const char* _EVENT_START;
	static const char* _EVENT_STOP;
	static const char* _EVENT_SUSPEND;
	static const char* _EVENT_RESUME;
	static const char* _EVENT_SET;
	static const char* _TEMPORARY_NAME;

private:
	HWND m_hMainWnd;
	list < CTimer* > m_Timerlist;
	int m_WindowTimer;
	CProcessTracer* m_pProcessTracer;
	static CTimerCtrl* m_Instance;

public:
	// CTimerCtrl
	static CTimerCtrl* GetInstance();
	static void InitInstance( CInputManager* im, COutputManager* om, int ModalityID, HWND hWnd, CProcessTracer* tracer );
	static void ReleaseInstance();
	static void CALLBACK Timeout( HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime );

	bool Add( const string& id, int interval );
	bool Remove( const string& id );
	CTimer* Find( const string& id );

	// from CInputModality
	virtual bool Analyze( const string& path, const CInputInfo& info );

	// from COutputModality
	virtual COutputCommand* StoreCommand( const string& msg );
	virtual bool Execute();
	virtual bool Terminate();

	// I/O
	virtual string GetTypeAttribute();
	virtual list < string > GetEventAttribute();


private:
	CTimerCtrl( CInputManager* im, COutputManager* om, int ModalityID, HWND hWnd, CProcessTracer* tracer );
	virtual ~CTimerCtrl();

};

#endif _TIMERCTRL_H_
