//
// MMIVXetgGhVer1.1
// ^C}[ǗW[
//
// Timer.h / Timer.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "StdAfx.h"
#include "Kiosk.h"
#include "TimerCtrl.h"
#include "XMLManager.h"

#include <mmsystem.h>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define _WINDOWTIMER 1000

//
// CTimer
//

int CTimer::m_nNumOfTimers			 = 0;
vector < CTimer::CState* > CTimer::m_States;

CTimer::CTimer()
{
}

CTimer::CTimer( const string id, const unsigned long interval, const TIMERSTATE state ) : m_sTimerID( id ), m_nInterval( interval ), m_nBaseTime( 0 ), m_nPreCount( 0 )
{
	if( m_nNumOfTimers == 0 )
		Init();
	SetState( state );
	m_nNumOfTimers++;
	m_nBaseTime = static_cast< unsigned long >( timeGetTime() );
}

CTimer::~CTimer()
{
	m_nNumOfTimers--;
	if( m_nNumOfTimers == 0 )
	{
		for( int i = 0; i < 3; i++ )
		{
			delete m_States[i];
		}
		m_States.clear();
	}
}

//
// ֐ : int CTimer::Init()
// @  \ : 
//    : Ȃ
// ߂l : 
//
int CTimer::Init()
{
	CStateCount* count = NULL;
	CStatePause* pause = NULL;
	CStateSleep* sleep = NULL;
	try
	{
		count = new CStateCount();
		pause = new CStatePause();
		sleep = new CStateSleep();
		m_States.resize(3);
		m_States[0] = static_cast< CState* > ( count );
		m_States[1] = static_cast< CState* > ( pause );
		m_States[2] = static_cast< CState* > ( sleep );
	}
	catch( std::bad_alloc )
	{
		delete count;
		delete pause;
		delete sleep;

		return -1;
	}
	
	return 0;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
const string& CTimer::GetID()
{
	return m_sTimerID;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
const TIMERSTATE CTimer::GetState()
{
	return m_pCurrentState->handleGetState();
}

//
// ֐ : int CTimer::requestTimeout()
// @  \ : ^C}[΂ĂȂm߂
//    : Ȃ
// ߂l : Ύ 1 ΂ĂȂ 0 G[ -1
//
int CTimer::requestTimeout()
{
	return m_pCurrentState->handleTimeout( this );
}

//
// ֐ : int CTimer::requestCount()
// @  \ : ^C}[̃JEgJn
//    : Ȃ
// ߂l :  1 ωȂ 0 G[ -1
//
int CTimer::requestCount()
{
	return m_pCurrentState->handleCount( this );
}

//
// ֐ : int CTimer::requestPause()
// @  \ : ^C}[ꎞ~ɂ
//    : Ȃ
// ߂l :  1 ωȂ 0 G[ -1
//
int CTimer::requestPause()
{
	return m_pCurrentState->handlePause( this );
}

//
// ֐ : int CTimer::requestSleep()
// @  \ : ^C}[~Ԃɂ
//    : Ȃ
// ߂l :  1 ωȂ 0 G[ -1
//
int CTimer::requestSleep()
{
	return m_pCurrentState->handleSleep( this );
}

//
// ֐ : int CTimer::requestResume()
// @  \ : ^C}[~Ԃɂ
//    : Ȃ
// ߂l :  1 ωȂ 0 G[ -1
//
int CTimer::requestResume()
{
	return m_pCurrentState->handleResume( this );
}

//
// ֐ : int CTimer::requestSet( const long interval )
// @  \ : C^[o[ݒ肷
//    : Interval - C^[ol
// ߂l :  1 s 0
//
int CTimer::requestSet( const long interval )
{
	return m_pCurrentState->handleSet( this, interval );
}

//
// ֐ : int CTimer::SetState( TIMERSTATE timerstate )
// @  \ : ^C}[̏Ԃݒ肷
//    : timerstate - ^C}[̏
// ߂l :  1 s -1
//
int CTimer::SetState( TIMERSTATE timerstate )
{
//
//	int state = static_cast< int > ( timerstate );
//	if( state < 0 || 2 < state )
//	{
//		return 0;
//	}
	m_pCurrentState = m_States[timerstate];
	return 1;
}


//////////////////////////////////////////////////////////////////////
// CState
//////////////////////////////////////////////////////////////////////

CTimer::CState::CState()
{

}

CTimer::CState::~CState()
{

}

//
// ֐ : const TIMERSTATE CTimer::CState::handleGetState()
// @  \ : ^C}[̏ԂԂftHg̊֐
//    : Ȃ
// ߂l : STATE_INIT
//
const TIMERSTATE CTimer::CState::handleGetState()
{
	return STATE_INIT;
}

//
// ֐ : int CTimer::CState::handleTimeout( CTimer *pTimer )
// @  \ : Check()֐̃ftHg
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : 0i΂ĂȂj
//
int CTimer::CState::handleTimeout( CTimer *pTimer )
{
	return 0;
}

//
// ֐ : int CTimer::CState::handleCount( CTimer *pTimer )
// @  \ : ^C}[ANeBuȏԂɂ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : 0isj
//
int CTimer::CState::handleCount( CTimer *pTimer )
{
	return 0;
}

//
// ֐ : int CTimer::CState::handlePause( CTimer *pTimer )
// @  \ : ^C}[ꎞ~
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : 0isj
//
int CTimer::CState::handlePause( CTimer *pTimer )
{
	return 0;
}

//
// ֐ : int CTimer::CState::handleSleep( CTimer *pTimer )
// @  \ : ^C}[~
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : 0isj
//
int CTimer::CState::handleSleep( CTimer *pTimer )
{
	return 0;
}

//
// ֐ : int CTimer::CState::handleResume( CTimer *pTimer )
// @  \ : ꎞ~Ԃ̃^C}[̃JEgĊJ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : 0isj
//
int CTimer::CState::handleResume( CTimer *pTimer )
{
	return 0;
}

//
// ֐ : int CTimer::CState::handleSet( CTimer *pTimer, const long Interval )
// @  \ : C^[oݒ肷
//    : *pTimer - ^C}[NX̃CX^X|C^
//        : Interval - C^[o
// ߂l : 0isj
//
int CTimer::CState::handleSet( CTimer *pTimer, const long Interval )
{
	return 0;
}


//////////////////////////////////////////////////////////////////////
// CStateCount
//////////////////////////////////////////////////////////////////////

CTimer::CStateCount::CStateCount()
{
	
}

CTimer::CStateCount::~CStateCount()
{
	
}

//
// ֐ : const TIMERSTATE CTimer::CStateCount::handleGetState()
// @  \ : ^C}[̏ԂԂ
//    : Ȃ
// ߂l : STATE_COUNTING
//
const TIMERSTATE CTimer::CStateCount::handleGetState()
{
	return STATE_COUNTING;
}

//
// ֐ : int CTimer::CStateCount::handleTimeout( CTimer *pTimer )
// @  \ : ^C}[΂ĂȂׂ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l : Ύ 1 ΂ĂȂ 0 G[ -1
//
int CTimer::CStateCount::handleTimeout( CTimer *pTimer )
{
	if( pTimer->m_nBaseTime < 1 )
	{
		return -1;
	}
	
	unsigned long CurrentTime = static_cast< unsigned long >( timeGetTime() );
	
	if( CurrentTime - pTimer->m_nBaseTime >= pTimer->m_nInterval )
	{
		pTimer->m_nBaseTime = CurrentTime;
		return 1;
	}
	
	return 0;
}

//
// ֐ : int CTimer::CStateCount::handlePause( CTimer *pTimer )
// @  \ : ^C}[ꎞ~Ԃɂ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStateCount::handlePause( CTimer *pTimer )
{
	unsigned long current_time = static_cast< unsigned long > ( timeGetTime() );
	unsigned long gap = current_time - pTimer->m_nBaseTime;
	
	if( gap > 0 )
	{
		pTimer->m_nPreCount = gap;
		return pTimer->SetState( STATE_PAUSING );
	}
	else
	{
		return -1;
	}
}

//
// ֐ : int CTimer::CStateCount::handleSleep( CTimer *pTimer )
// @  \ : ^C}[~
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStateCount::handleSleep( CTimer *pTimer )
{
	return pTimer->SetState( STATE_SLEEPING );
}


//////////////////////////////////////////////////////////////////////
// CStatePause
//////////////////////////////////////////////////////////////////////

CTimer::CStatePause::CStatePause()
{
	
}

CTimer::CStatePause::~CStatePause()
{
	
}

//
// ֐ : const TIMERSTATE CTimer::CStatePause::handleGetState()
// @  \ : ^C}[̏ԂԂ
//    : Ȃ
// ߂l : STATE_PAUSING
//
const TIMERSTATE CTimer::CStatePause::handleGetState()
{
	return STATE_PAUSING;
}

//
// ֐ : int CTimer::CStatePause::handleCount( CTimer *pTimer )
// @  \ : ^C}[ANeBuȏԂɂ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStatePause::handleCount( CTimer *pTimer )
{
	pTimer->m_nBaseTime = static_cast< unsigned long >( timeGetTime() );
	return pTimer->SetState( STATE_COUNTING );
}

//
// ֐ : int CTimer::CStatePause::handleResume( CTimer *pTimer )
// @  \ : ꎞ~Ԃ̃^C}[̃JEgĊJ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStatePause::handleResume( CTimer *pTimer )
{
	pTimer->m_nBaseTime = static_cast< unsigned long >( timeGetTime() );
	pTimer->m_nBaseTime -= pTimer->m_nPreCount;
	pTimer->SetState( STATE_COUNTING );
	return 0;
}

//
// ֐ : int CTimer::CStatePause::handleSleep( CTimer *pTimer )
// @  \ : ^C}[~
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStatePause::handleSleep( CTimer *pTimer )
{
	return pTimer->SetState( STATE_SLEEPING );
}

//
// ֐ : int CTimer::CStatePause::handleSet( CTimer *pTimer, const long interval )
// @  \ : ^C}[~
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStatePause::handleSet( CTimer *pTimer, const long interval )
{
	pTimer->m_nInterval = interval;
	return 1;
}

//////////////////////////////////////////////////////////////////////
// CStateSleep
//////////////////////////////////////////////////////////////////////

CTimer::CStateSleep::CStateSleep()
{
	
}

CTimer::CStateSleep::~CStateSleep()
{
	
}

//
// ֐ : const TIMERSTATE CTimer::CStateSleep::handleGetState()
// @  \ : ^C}[̏ԂԂ
//    : Ȃ
// ߂l : STATE_SLEEPING
//
const TIMERSTATE CTimer::CStateSleep::handleGetState()
{
	return STATE_SLEEPING;
}

//
// ֐ : int CTimer::CStateSleep::handleCount( CTimer *pTimer )
// @  \ : ^C}[ANeBuȏԂɂ
//    : *pTimer - ^C}[NX̃CX^X|C^
// ߂l :  1 s 0
//
int CTimer::CStateSleep::handleCount( CTimer *pTimer )
{
	pTimer->m_nBaseTime = static_cast< unsigned long >( timeGetTime() );
	return pTimer->SetState( STATE_COUNTING );
}

//
// ֐ : int CTimer::CStateSleep::handleSet( CTimer *pTimer, const long interval )
// @  \ : C^[oݒ肷
//    : *pTimer - ^C}[NX̃CX^X|C^
//    : Interval - C^[ol          
// ߂l :  1 s 0
//
int CTimer::CStateSleep::handleSet( CTimer *pTimer, const long interval )
{
	pTimer->m_nInterval = interval;
	return 1;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimer& CTimer:: operator = ( const CTimer& timer )
{
	if( &timer == this ){ return *this; }

	m_nBaseTime = timer.m_nBaseTime;
	m_nInterval = timer.m_nInterval;
	m_nPreCount = timer.m_nPreCount;
	m_pCurrentState = timer.m_pCurrentState;
	m_sTimerID = timer.m_sTimerID;

	return *this;
}



//
// CTimerCtrl
//


// NX萔
const char* CTimerCtrl::_TYPE_TIMER = "timer";
const char* CTimerCtrl::_EVENT_TIMEOUT = "timeout";
const char* CTimerCtrl::_EVENT_CREATE = "create";
const char* CTimerCtrl::_EVENT_DELETE = "delete";
const char* CTimerCtrl::_EVENT_START = "start";
const char* CTimerCtrl::_EVENT_STOP = "stop";
const char* CTimerCtrl::_EVENT_SUSPEND = "suspend";
const char* CTimerCtrl::_EVENT_RESUME = "resume";
const char* CTimerCtrl::_EVENT_SET = "set";
const char* CTimerCtrl::_TEMPORARY_NAME = "temp";

CTimerCtrl* CTimerCtrl::m_Instance = NULL;

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdCreate::CCmdCreate( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdCreate::~CCmdCreate()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdCreate::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	string str_interval;

	if( GetParamValue( "name", "id", timer_ids ) < 1)
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}

	if( !GetParamValue( "name", "interval", str_interval ) )
	{
		Error( this, "C^[ol^ĂȂ" );
		return RESULT_FAILED;
	}

	int interval = atoi( str_interval.c_str() );
	interval *= 1000;
	list < string > :: iterator ite = timer_ids.begin();
	while( ite != timer_ids.end() )
	{
		if( !ptc->Add( static_cast< string& >( *ite ), interval ) )
		{
			Error( this, "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdCreate::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdDelete::CCmdDelete( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdDelete::~CCmdDelete()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdDelete::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( false );

	list < string > timer_ids;
	if( GetParamValue( "name", "id", timer_ids ) < 1 )
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}
	list < string > :: iterator ite = timer_ids.begin();
	while( ite != timer_ids.end() )
	{
		if( !ptc->Remove( *ite ) )
		{
			Error( this, "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdDelete::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdStart::CCmdStart( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdStart::~CCmdStart()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdStart::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	if( !GetParamValue( "name", "id", timer_ids ) )
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}
	list < string > :: iterator ite = timer_ids.begin();
	CTimer* pTimer = NULL;
	while( ite != timer_ids.end() )
	{
		pTimer = ptc->Find( *ite );
		if( pTimer == NULL )
		{
			Error( this, "^C}[݂Ȃ" );
			return RESULT_FAILED;
		}
		if( pTimer->requestCount() == -1 )
		{
			Error( this, "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdStart::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdStop::CCmdStop( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdStop::~CCmdStop()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdStop::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	if( !GetParamValue( "name", "id", timer_ids ) )
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}
	list < string > :: iterator ite = timer_ids.begin();
	CTimer* pTimer = NULL;
	while( ite != timer_ids.end() )
	{
		pTimer = ptc->Find( *ite );
		if( pTimer == NULL )
		{
			Error( this, "^C}[݂Ȃ" );
			return RESULT_FAILED;
		}
		if( pTimer->requestSleep() == -1 )
		{
			Error( this, "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdStop::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdSuspend::CCmdSuspend( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdSuspend::~CCmdSuspend()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdSuspend::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	if( !GetParamValue( "name", "id", timer_ids ) )
	{
		Error( static_cast< COutputCommand* >( this ), "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}
	list < string > :: iterator ite = timer_ids.begin();
	CTimer* pTimer = NULL;
	while( ite != timer_ids.end() )
	{
		pTimer = ptc->Find( static_cast< string& >( *ite ) );
		if( pTimer == NULL )
		{
			Error( static_cast< COutputCommand* >( this ), "^C}[݂Ȃ" );
			return RESULT_FAILED;
		}
		if( pTimer->requestPause() == -1 )
		{
			Error( static_cast< COutputCommand* >( this ), "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdSuspend::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdResume::CCmdResume( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdResume::~CCmdResume()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdResume::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	if( !GetParamValue( "name", "id", timer_ids ) )
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}
	list < string > :: iterator ite = timer_ids.begin();
	CTimer* pTimer = NULL;
	while( ite != timer_ids.end() )
	{
		pTimer = ptc->Find( static_cast< string& >( *ite ) );
		if( pTimer == NULL )
		{
			Error( static_cast< COutputCommand* >( this ), "^C}[݂Ȃ" );
			return RESULT_FAILED;
		}
		if( pTimer->requestResume() == -1 )
		{
			Error( static_cast< COutputCommand* >( this ), "G[" );
			return RESULT_FAILED;
		}
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdResume::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdSet::CCmdSet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CCmdSet::~CCmdSet()
{
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdSet::Execute()
{
	CTimerCtrl* ptc = static_cast< CTimerCtrl* >( m_pModality );
	ptc->Lock( true );

	list < string > timer_ids;
	string str_interval;

	if( GetParamValue( "name", "id", timer_ids ) < 1)
	{
		Error( this, "^C}[ID^ĂȂ" );
		return RESULT_FAILED;
	}

	if( GetParamValue( "name", "interval", str_interval ) )
	{
		Error( this, "C^[ol^ĂȂ" );
		return RESULT_FAILED;
	}

	int interval = atoi( str_interval.c_str() );
	list < string > :: iterator ite = timer_ids.begin();
	CTimer* pTimer = NULL;
	while( ite != timer_ids.end() )
	{
		pTimer = ptc->Find( *ite );
		if( pTimer == NULL )
		{
			Error( this, "G[" );
			return RESULT_FAILED;
		}
		pTimer->requestSet( interval );
		ite++;
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
EXECRESULT CTimerCtrl::CCmdSet::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::CTimerCtrl( CInputManager* im, COutputManager* om, int ModalityID, HWND hWnd, CProcessTracer* tracer ) : CInputModality( im, ModalityID ), COutputModality( om, ModalityID ), m_hMainWnd( hWnd ), m_Timerlist(), m_WindowTimer( -1 ), m_pProcessTracer( tracer )
{
	CInputModality::m_State = false;
	COutputModality::m_State = false;
	if( m_hMainWnd != NULL )
	{
		m_WindowTimer = SetTimer( m_hMainWnd, _WINDOWTIMER, 1000, CTimerCtrl::Timeout );
		if( m_WindowTimer != 0 )
		{
			m_Timerlist.clear();
			if( CInputModality::Regist() )
			{
				CInputModality::m_State = true;
				m_pProcessTracer->AppendLine( " - ͊Ǘɓo^" );
			}
			if( COutputModality::Regist() )
			{
				COutputModality::m_State = true;
				m_pProcessTracer->AppendLine( " - o͊Ǘɓo^" );
			}
		}
	}
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimerCtrl::~CTimerCtrl()
{
	m_pProcessTracer->Write( "^C}[Ǘ", "..." );
	if( KillTimer( m_hMainWnd, _WINDOWTIMER ) != 0 )
	{
		if( m_Timerlist.size() > 0 )
		{
			m_pProcessTracer->Append( "폜ĂȂ^C}[܂..." );
			list < CTimer* > :: iterator ite = m_Timerlist.begin();
			while( ite != m_Timerlist.end() )
			{
				delete *ite;
				ite++;
			}
			m_pProcessTracer->AppendLine( "Sč폜܂" );
		}
		m_Timerlist.clear();
	}
	if( CInputModality::Release() )
	{
		m_pProcessTracer->AppendLine( " - ͊Ǘ폜" );
	}
	if( COutputModality::Release() )
	{
		m_pProcessTracer->AppendLine( " - o͊Ǘ폜" );
	}
	m_pProcessTracer->AppendLine( "" );
}

//
// ֐ : 
// @  \ : B̃CX^X擾
//    : 
//    :           
// ߂l : 
//
CTimerCtrl* CTimerCtrl::GetInstance()
{	
	return m_Instance;
}

//
// ֐ : 
// @  \ : B̃CX^X폜
//    : 
//    :           
// ߂l : 
//
void CTimerCtrl::InitInstance( CInputManager* im, COutputManager* om, int ModalityID, HWND hWnd, CProcessTracer* tracer )
{
	tracer->Write( "^C}[Ǘ", " - " );
	if( m_Instance == NULL )
	{
		m_Instance = new CTimerCtrl( im, om, ModalityID, hWnd, tracer );
	}
	tracer->AppendLine( " - " );
}

//
// ֐ : 
// @  \ : B̃CX^X폜
//    : 
//    :           
// ߂l : 
//
void CTimerCtrl::ReleaseInstance()
{
	if( m_Instance != NULL )
	{
		delete m_Instance;
		m_Instance = NULL;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
void CTimerCtrl::Timeout( HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime )
{
	CTimerCtrl* tc = CTimerCtrl::GetInstance();
	list < CTimer* > :: iterator ite = tc->m_Timerlist.begin();

	while( ite != tc->m_Timerlist.end() )
	{
		if( static_cast< CTimer* >( *ite )->requestTimeout() == 1 )
		{
			CTimer* timer = static_cast< CTimer* >( *ite );

			CVariables vars;
			vars.Add( _TEMPORARY_NAME, timer->GetID(), 0 );

			tc->Input( _TYPE_TIMER, _EVENT_TIMEOUT, timer->GetID(), "", vars );
		}
		ite++;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
string CTimerCtrl::GetTypeAttribute()
{
	return _TYPE_TIMER;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
list < string > CTimerCtrl::GetEventAttribute()
{
	list < string > events;
	events.push_back( _EVENT_TIMEOUT );
	events.push_back( _EVENT_CREATE );
	events.push_back( _EVENT_DELETE );
	events.push_back( _EVENT_START );
	events.push_back( _EVENT_STOP );
	events.push_back( _EVENT_SUSPEND );
	events.push_back( _EVENT_RESUME );
	events.push_back( _EVENT_SET );
	return events;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool CTimerCtrl::Analyze( const string& path, const CInputInfo& info )
{
	CInputInfo& ii = const_cast< CInputInfo& >( info );
	m_pProcessTracer->Write( "^C}[Ǘ", " - <input>̉" );
	m_pProcessTracer->Append( " - " );
	m_pProcessTracer->AppendLine( ii.toXML().c_str() );
	// <input>ƋLqĂ邩
	const string& match = info.GetMatchAttr();
	if( match.size() == 0 )
	{
		// match0̎̓^C}[IDԂ
		CVariables vars = info.GetVariables();
		if( info.GetVariables().GetSize() != 1 )
		{
			m_pProcessTracer->AppendLine( " - matchreturnł" );
			m_pProcessTracer->AppendLine( " - o^܂" );
			return true;
			//return false;
		}
		m_pProcessTracer->AppendLine( " - o^܂" );
		return true;
	}
	else
	{
		// matchLqĂꍇ
		// ^C}[݂邩`FbN
		// ͕ʂɃRgAEgĂ܂
		list < CTimer* > :: iterator ite = m_Timerlist.begin();
		while( ite != m_Timerlist.end() )
		{
			if( match == static_cast< CTimer* >( *ite )->GetID() )
			{
				m_pProcessTracer->AppendLine( " - o^܂" );
				return true;
			}
			ite++;
		}
		m_pProcessTracer->AppendLine( " - ݂Ȃ^C}[IDw肳Ă܂" );
		m_pProcessTracer->AppendLine( " - o^܂" );
		return false;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
COutputCommand* CTimerCtrl::StoreCommand( const string& msg )
{
	m_pProcessTracer->Write( "^C}[Ǘ", "<output>̉" );
	m_pProcessTracer->AppendLine( msg.c_str() );

	// <parameter>...</parameter>
	string count, event, path;
	bool bargein;
	CVariables vars;
	list < COutputParam > pars;

	if( !AnalyzeOutput( msg, count, bargein, path, event, vars, pars ) ){ return NULL; }

	COutputCommand* pCmd;
	if( event == _EVENT_CREATE )
	{
		CCmdCreate* pCreate = new CCmdCreate( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pCreate );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdDelete* pDelete = new CCmdDelete( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pDelete );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdStart* pStart = new CCmdStart( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pStart );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdStop* pStop = new CCmdStop( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pStop );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdSuspend* pSuspend = new CCmdSuspend( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pSuspend );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdResume* pResume = new CCmdResume( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pResume );
	}
	else if( event == _EVENT_DELETE )
	{
		CCmdSet* pSet = new CCmdSet( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pSet );
	}
	else
	{
		m_pProcessTracer->Append( "\r\n - <output>\r\n" );
		return NULL;
	}

	m_Cmdlist.push_back( pCmd );

	return pCmd;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool CTimerCtrl::Execute()
{
	m_pProcessTracer->Write( "^C}[Ǘ", " - <output>̎s" );
	return COutputModality::Execute();
	
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool CTimerCtrl::Terminate()
{
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
CTimer* CTimerCtrl::Find( const string& id )
{
	list < CTimer* > :: iterator ite = m_Timerlist.begin();
	while( ite != m_Timerlist.end() )
	{
		CTimer* timer = static_cast< CTimer* >( *ite );
		if( timer->GetID() == id )
		{
			return timer;
		}
		ite++;
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool CTimerCtrl::Add( const string& id, int interval )
{
	if( !Find( id ) )
	{
		CTimer* timer = new CTimer( id, interval );
		m_Timerlist.push_back( timer );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool CTimerCtrl::Remove( const string& id )
{
	list < CTimer* > :: iterator ite = m_Timerlist.begin();
	while( ite != m_Timerlist.end() )
	{
		if( static_cast< CTimer* >( *ite )->GetID() == id )
		{
			delete *ite;
			m_Timerlist.erase( ite );
			return true;
		}
		ite++;
	}
	return false;
}

