// TTSCtrl.h: CTTSCtrl NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TTSCTRL_H__DEF10D28_DA5C_4F5F_AEED_0898C3DBACE6__INCLUDED_)
#define AFX_TTSCTRL_H__DEF10D28_DA5C_4F5F_AEED_0898C3DBACE6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "OutputModality.h"
#include "SSMClient.h"
#include "OutputModality.h"
#include "ProcessTracer.h"

class CTTSCtrl : public COutputModality  
{
private:
	class CCmdSpeech : public COutputCommand
	{
	public:
		CCmdSpeech( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSpeech();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdSpeaker : public COutputCommand
	{
	public:
		CCmdSpeaker( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSpeaker();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

public:
	static const char* _TYPE_TTS;
	static const char* _EVENT_SPEECH;
	static const char* _EVENT_SPEAKER;

private:
	CSSMClient m_SSMClient;
	PROCESS_INFORMATION m_piSSM;
	CProcessTracer* m_pProcessTracer;

public:
	CTTSCtrl( COutputManager* om, int ModalityID, CProcessTracer* tracer );
	virtual ~CTTSCtrl();

	virtual string GetTypeAttribute();
	virtual list < string > GetEventAttribute();
	virtual COutputCommand* StoreCommand( const string& msg );
	virtual bool Execute();
	virtual bool Terminate();

	BOOL ConnectEngine();
	void ConnectFSM(CFSMCtrl *pFSMCtrl);
	void OnSpeakFinished();
	void OnSpeakReady(LPCTSTR lpszPho);
	EXECRESULT Speak( LPCSTR lpszText,bool bEndsync );
	EXECRESULT SetSpeaker( LPCSTR lpszSpeaker );
	BOOL IsSpeaking();
	void Stop();
};

#endif // !defined(AFX_TTSCTRL_H__DEF10D28_DA5C_4F5F_AEED_0898C3DBACE6__INCLUDED_)
