// SpeechInput.h: CSpeechInput NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPEECHINPUT_H__1BF53548_29D6_454F_984F_7A3F960B4F90__INCLUDED_)
#define AFX_SPEECHINPUT_H__1BF53548_29D6_454F_984F_7A3F960B4F90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>
#include <list>
#include <vector>
#include <fstream>
using namespace std;

#include "InputModality.h"
#include "ProcessTracer.h"
#include "SRMClient.h"
#include "Documentmanagement.h"
#include "inputinfo.h"

class CGrmVocabulary
{

protected:
	int m_nGrmID;
	string m_strGrmPrefix;
	CInputInfo m_InputInfo;
	vector < string > m_Terms;	//@̌bXg

public:
	CInputInfo& GetInputInfo(){return m_InputInfo;}
	void SetInputInfo(const CInputInfo &iInfo){m_InputInfo = iInfo;}
	LPCTSTR GetGrmPrefix(){return m_strGrmPrefix.c_str();}
	int GetGrmID(){return m_nGrmID;}
	LPCTSTR GetTerm( int nNumber );
	int GetTermID( LPCTSTR lpszTerm );
	BOOL CreateTermList(int nTermCount);

public:
	CGrmVocabulary(int nGrmID,LPCTSTR lpszGrmPrefix);
	virtual ~CGrmVocabulary();

	bool operator == ( const CGrmVocabulary& voca );
	bool operator != ( const CGrmVocabulary& voca );
	CGrmVocabulary& operator = ( const CGrmVocabulary& voca );
};

class CSpeechInput : public CInputModality  
{
public:
	static const char* _TYPE_SPEECH;
	static const char* _EVENT_RECOGNIZE;

private:
	CProcessTracer* m_pProcessTracer;

protected:
	CDocumentManagement m_DocMgr;
	CSRMClient m_SRMClient;
	PROCESS_INFORMATION m_piSRM;

	int m_nGrmNum;		//g[^̕@t@C
	int m_nRegGrmCount;	//ANeBuȕ@t@C̐
	bool m_bNewGrm;
	list < CGrmVocabulary > m_GrmList;	//҂󂯒@̌bZbgXg

public:
	CSpeechInput( CInputManager* im, int ModalityID, CProcessTracer* tracer, CWnd* parent );
	virtual ~CSpeechInput();

	virtual string GetTypeAttribute();
	virtual list < string > GetEventAttribute();
	virtual bool Analyze( const string& path, const CInputInfo& info );

//	virtual void Input( CInputInfo info );
	virtual void OnBeforeUpdate();
	virtual void OnUpdateFinished();
	
	int GetActiveGrm(){return m_nRegGrmCount;}
	BOOL ConnectEngine();
	void OnAddGrammar(LPCTSTR lpszGrmInfo);
	void OnRecognize(LPCTSTR lpszRecoResult);
	void OnRecEvent(int nEvent);
};

#endif // !defined(AFX_SPEECHINPUT_H__1BF53548_29D6_454F_984F_7A3F960B4F90__INCLUDED_)
