// SpeechInput.cpp: CSpeechInput NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "kiosk.h"
#include "SpeechInput.h"
#include "MainFrame.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// EBhEnh擾AvP[VIB
BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM lParam)
{
    // CreateProcess()Ŏ擾PROCESS_INFORMATION\̂̃|C^擾
    PROCESS_INFORMATION* pi = (PROCESS_INFORMATION*)lParam;

    // EChE쐬vZXID擾B
    DWORD lpdwProcessId = 0;
    ::GetWindowThreadProcessId(hWnd, &lpdwProcessId);

    // CreateProcessŋNAṽvZXIDƃCEBhE
    // 쐬vZXIDꍇANAvIB
	if (GetWindow( hWnd, GW_OWNER ) == NULL)
    {
		if(pi->dwProcessId == lpdwProcessId)
		{
			::PostMessage(hWnd, WM_CLOSE, 0, 0);
			return FALSE;
		}
	}
    return TRUE;
}



//////////////////////////////////////////////////////////////////////
// class CGrmVocabulary
//////////////////////////////////////////////////////////////////////
CGrmVocabulary::CGrmVocabulary(int nGrmID,LPCTSTR lpszGrmPrefix)
{
	m_nGrmID = nGrmID;
	m_strGrmPrefix = lpszGrmPrefix;
}

CGrmVocabulary::~CGrmVocabulary()
{
	m_Terms.clear();
}

bool CGrmVocabulary:: operator == ( const CGrmVocabulary& voca )
{
	if( &voca == this ){ return true; }

	if(m_nGrmID == voca.m_nGrmID)
		return true;

	return false;
}

bool CGrmVocabulary:: operator != ( const CGrmVocabulary& voca )
{
	if( &voca == this ){ return false; }

	if(m_nGrmID != voca.m_nGrmID)
		return true;

	return false;
}

CGrmVocabulary& CGrmVocabulary:: operator = ( const CGrmVocabulary& voca )
{
	if( &voca == this ){ return *this; }

	m_nGrmID = voca.m_nGrmID;
	m_Terms = voca.m_Terms;
	return *this;
}

BOOL CGrmVocabulary::CreateTermList(int nTermCount)
{
	ifstream fin;
    char buf[80];

	string strTermFile = m_strGrmPrefix;
	strTermFile += ".term";
    fin.open(strTermFile.c_str());
    if(fin.fail()){
        fin.close();
        return FALSE;
    }

	m_Terms.reserve(nTermCount+1);
	int nIndex = 0;
    while(!fin.eof()){
        fin.getline(buf, 80);
		string strTerm = buf;
		int nLen = strTerm.length();
		for(int i=0;i<nLen;i++)
		{
			if(isalpha(buf[i]))	
			{
				strTerm.erase(0,i);
				if(isalnum(strTerm[strTerm.length()-1]) == 0 )
					strTerm.erase(strTerm.length()-1,1);
				break;
			}
		}
		m_Terms.push_back(strTerm);
		nIndex++;
    }

	fin.close();
	return TRUE;
}

LPCTSTR CGrmVocabulary::GetTerm( int nNumber )
{
	if(nNumber > m_Terms.size())
		ASSERT(NULL);

	return m_Terms.at(nNumber).c_str();
}

int CGrmVocabulary::GetTermID( LPCTSTR lpszTerm )
{
	int nID = 0;
	vector <string>::iterator ite = m_Terms.begin();
	while( ite != m_Terms.end() )
	{
		if((*ite).compare(lpszTerm) == 0)
			return nID;
		nID++;
		ite++;
	}
	return -1;
}

//////////////////////////////////////////////////////////////////////
// class CSpeechInput
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
const char* CSpeechInput::_TYPE_SPEECH = "speech";
const char* CSpeechInput::_EVENT_RECOGNIZE = "recognize";

CSpeechInput::CSpeechInput( CInputManager* im, int ModalityID, CProcessTracer* tracer, CWnd* parent ) : CInputModality( im, ModalityID ), m_pProcessTracer( tracer ), m_SRMClient(this)
{
	m_pProcessTracer->Write( "SRǗ", " - " );
	if( Regist() )
	{
		m_pProcessTracer->AppendLine( " - ͊Ǘɓo^" );
	}

	m_pProcessTracer->AppendLine( " - FGWN" );

	CWinApp *pApp = AfxGetApp();
	CString strJulian = pApp->GetProfileString("SRM","Path",NULL);
	CString strAModel = pApp->GetProfileString("SRM","AModel",NULL);
	CString strDFA = pApp->GetProfileString("SRM","DFA",NULL);
	CString strDICT = pApp->GetProfileString("SRM","DICT",NULL);

	CString strCLine;
	strCLine.Format("%s -h \"%s\" -dfa \"%s\" -v \"%s\" -input mic -module 10500",strJulian,strAModel,strDFA,strDICT);
	STARTUPINFO si;
    // CreateProcess()̈ݒ
    ZeroMemory(&si, sizeof(STARTUPINFO));
    ZeroMemory(&m_piSRM, sizeof(PROCESS_INFORMATION));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_MINIMIZE;
    if(!CreateProcess(NULL,
			strCLine.GetBuffer(strCLine.GetLength()),
//            _T("D:\\IPA\\engine\\SRM\\Galatea_SRM_Windows_0301\\bin\\julian.exe -h D:\\IPA\\engine\\SRM\\Galatea_SRM_Windows_0301\\AcousticModel\\hmmdefs,mono16mix,gid.gz -dfa D:\\IPA\\engine\\SRM\\Galatea_SRM_Windows_0301\\GramJulian\\intro\\intro.dfa -v D:\\IPA\\engine\\SRM\\Galatea_SRM_Windows_0301\\GramJulian\\intro\\intro.dict -input mic -module 10500"),
            NULL,
            NULL,  
            FALSE,  
            0,  
            NULL,  
            NULL,  
            &si,  
            &m_piSRM)){  
		pApp->WriteProfileInt("ENGINE","Validate",0);
        AfxMessageBox(_T("JulianNł܂ł\nċNƐݒ_CAO\܂"));  
	}
	strCLine.ReleaseBuffer();

	m_nGrmNum = 1;
	m_nRegGrmCount = 0;
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	string strTempPath = chrCurrent;
	strTempPath += "\\Temp";
	m_DocMgr.setTemporaryPath(strTempPath);
}


CSpeechInput::~CSpeechInput()
{
	m_GrmList.clear();

	m_pProcessTracer->Write( "SRǗ", " - ..." );
	if( Release() )
	{
		m_pProcessTracer->AppendLine( " - ͊Ǘ폜" );
	}
	m_SRMClient.Stop();

	// R[obN֐̌ĂяoB
	EnumWindows(EnumWindowsProc, (LPARAM)&m_piSRM);

	::CloseHandle(m_piSRM.hThread);
	::CloseHandle(m_piSRM.hProcess);

	m_pProcessTracer->AppendLine( " - FGW~" );
	
	m_pProcessTracer->AppendLine( " - " );
}


BOOL CSpeechInput::ConnectEngine()
{
	m_pProcessTracer->Write( "SRǗ", " - Julianɐڑ" );
	int nRet = m_SRMClient.Initialize();
	if(nRet == -1)
	{
		m_pProcessTracer->AppendLine( " - \Pbg쐬s" );
		return FALSE;
	}
	else if(nRet == -2)
	{
		m_pProcessTracer->AppendLine( " - ڑvs" );
		return FALSE;
	}

	m_SRMClient.Run();
	m_pProcessTracer->AppendLine( " - MXbhJn" );
	return TRUE;
}

string CSpeechInput::GetTypeAttribute()
{
	return _TYPE_SPEECH;
}

list < string > CSpeechInput::GetEventAttribute()
{
	list < string > events;
	events.push_back( _EVENT_RECOGNIZE );
	return events;
}

bool CSpeechInput::Analyze( const string& path, const CInputInfo& info )
{
	string strPrefix;
	string strPath;
	string strMatch = info.GetMatchAttr();
	int nIndex = strMatch.rfind("/");
	if(nIndex == -1)
		strPrefix = strMatch + ".dmy";
	else
		strPrefix = strMatch.substr(nIndex+1) + ".dmy";

	strPath = path + strPrefix;
	if(m_DocMgr.setServerInfo(strPath) == -1)
		ASSERT(NULL);

	if(m_DocMgr.changeRelativeToAbsolutePath(&strMatch) == -1)
		ASSERT(NULL);

	if(strPath.find("http:") != string::npos)
	{
		string strGrmFile;
		if(m_DocMgr.downloadFile(strMatch+".term",1,&strGrmFile) < 0)
		{
			m_pProcessTracer->Write( "SRǗ", " - ***.termDLɎs" );
			m_pProcessTracer->Write( "SRǗ", strMatch.c_str() );
			return false;
		}
		if(m_DocMgr.downloadFile(strMatch+".dfa",1,&strGrmFile) < 0)
		{
			m_pProcessTracer->Write( "SRǗ", " - ***.dfaDLɎs" );
			m_pProcessTracer->Write( "SRǗ", strMatch.c_str() );
			return false;
		}
		if(m_DocMgr.downloadFile(strMatch+".dict",1,&strGrmFile) < 0)
		{
			m_pProcessTracer->Write( "SRǗ", " - ***.dictDLɎs" );
			m_pProcessTracer->Write( "SRǗ", strMatch.c_str() );
			return false;
		}
		strPrefix = strGrmFile.erase(strGrmFile.length()-5,5);
	}
	else
	{
		if(strMatch.find("file:") != string::npos)
			strMatch.erase(0,7);
		if(strMatch[0] == '/')
			strMatch.erase(0,1);

		strPrefix = strMatch;
	}

	CGrmVocabulary voca(m_nGrmNum,strPrefix.c_str());
	voca.SetInputInfo(info);
	m_nGrmNum++;
	m_nRegGrmCount++;
	m_GrmList.push_back(voca);

	BOOL bRet;
	if(m_bNewGrm)
	{
		TRACE("VK@");
		bRet = m_SRMClient.japi_change_grammar(strPrefix.c_str());
		m_bNewGrm = false;
	}
	else
	{
		TRACE("@ǉ");
		bRet = m_SRMClient.japi_add_grammar(strPrefix.c_str());
	}

	if(!bRet)
	{
		m_pProcessTracer->Write( "SRǗ", " -@t@C܂" );
		m_pProcessTracer->Append(info.GetMatchAttr().c_str());
		m_nGrmNum--;
		m_nRegGrmCount--;
		m_GrmList.pop_back();
		return false;
	}

	return true;
}

void CSpeechInput::OnBeforeUpdate()
{
	m_State = false;
	m_bNewGrm = true;
	m_nRegGrmCount = 0;
	m_GrmList.clear();
	CMainFrame *pFrm = (CMainFrame*)AfxGetApp()->GetMainWnd();
	pFrm->m_pSpeechOprDlg->ResetGrm();

	//@؂ւ̂ŃGWꎞ~
	m_SRMClient.japi_terminate_recog();
	m_pProcessTracer->Write( "SRǗ", " - @o^̂ߔFf" );
}

void CSpeechInput::OnUpdateFinished()
{
	m_pProcessTracer->Write( "SRǗ", " - @o^ߑMI" );
	m_State = true;
}

void CSpeechInput::OnAddGrammar(LPCTSTR lpszGrmInfo)
{
	CString strGrmNum;
	CString strGrmInfo = lpszGrmInfo;

	if(m_GrmList.empty())
		return;
	
	if(strGrmInfo.Find("(new)") != -1)
	{
		//ǉ@̐ʒm̂ŁCŌ̒ʒm̂Ƃ܂Ŕ΂܂
		m_nRegGrmCount--;
		if(m_nRegGrmCount != 0)
			return;
		//FGWĊJ
		m_SRMClient.japi_resume_recog();
		m_pProcessTracer->Write( "SRǗ", " - FĊJ" );
		return;
	}
	else if(m_nRegGrmCount != 0)
		return;

	CMainFrame *pFrm = (CMainFrame*)AfxGetApp()->GetMainWnd();
	//GWĊJɂxĂ΂܂
	list <CGrmVocabulary>::iterator ite = m_GrmList.begin();
	while( ite != m_GrmList.end() )
	{
		strGrmNum.Format("#%2d",(*ite).GetGrmID());
		int nID = strGrmInfo.Find(strGrmNum);
		if(nID == -1)
			ASSERT(NULL);

		int nStart = strGrmInfo.Find("words",nID)+6;
		int nEnd = strGrmInfo.Find("categories",nStart);

		CString strTermNum = strGrmInfo.Mid(nStart,nEnd-nStart);
		strTermNum.Remove(' ');
		if(!(*ite).CreateTermList(atoi((LPCTSTR)strTermNum)))
		{
			m_pProcessTracer->Append(" - ***.termopenł܂" );
		}

		pFrm->m_pSpeechOprDlg->AddNewGrm((LPCTSTR)(*ite).GetGrmPrefix());
		ite++;
	}
	pFrm->m_pSpeechOprDlg->ViewSentence();
}

//<RECOGOUT>
//  <SHYPO RANK="1" SCORE="-2546.554443" GRAM="1">
//    <WHYPO WORD="silB" CLASSID="1" PHONE="silB"/>
//    <WHYPO WORD="ɂ" CLASSID="0" PHONE="k o N n i ch i w a"/>
//    <WHYPO WORD="silE" CLASSID="2" PHONE="silE"/>
//  </SHYPO>
//</RECOGOUT>
//FŝƂ͋󕶎
void CSpeechInput::OnRecognize(LPCTSTR lpszRecoResult)
{
	//GrmID𔲂o
	string strRecoResult = lpszRecoResult;
	if(strRecoResult.empty())
	{
		m_pProcessTracer->Write( "SRǗ", " - Fs" );
		return;
	}

	int nStart = strRecoResult.find("GRAM=");
	if(nStart == -1)
		ASSERT(NULL);
	int nEnd = strRecoResult.find("\">",nStart);
	nStart += 6;
	int nGrmID = atoi(strRecoResult.substr(nStart,nEnd-nStart).c_str());

	//GrmID̂T
	bool bFlag = false;
	list <CGrmVocabulary>::iterator ite = m_GrmList.begin();
	while( ite != m_GrmList.end() )
	{
		if((*ite).GetGrmID() == nGrmID)
		{
			bFlag = true;

			//InputInforeturn̊eϐɒl
			CInputInfo info = (*ite).GetInputInfo();
			CVariables* pVarUser = info.GetVariablesPtr();
			string strVarName = "";
			string value = "";
			bool bOK = true;
			int var_size = pVarUser->GetSize();
			for( int i = 0; i < var_size; i++ )
			{
				const string* var_name = pVarUser->GetName( i );
				int nTermID = (*ite).GetTermID(var_name->c_str());
				char chrID[10];
				itoa(nTermID,chrID,10);
				string strFind = "CLASSID=\"";
				strFind += chrID;
				strFind += "\"";
				nEnd = strRecoResult.find(strFind)-2;
				if(nEnd>0)
				{
					nStart = strRecoResult.rfind("WORD=",nEnd)+6;
					value = strRecoResult.substr(nStart,nEnd-nStart);
					int nBr = value.find("{");
					if(nBr != -1)
					{
						nBr++;
						int nBrEnd = value.find("}");
						value = value.substr(nBr,nBrEnd-nBr);
					}
				}
				else
				{
					bOK = false;
					value = "";
					strVarName += pVarUser->GetName(i)->c_str();
					strVarName += " ";
				}
				pVarUser->SetValue(i,value.c_str());
			}

			m_pProcessTracer->Write( "SRǗ", lpszRecoResult );

			if(!bOK)
			{
				strVarName.append("Fł܂ł");
				CMainFrame *pFrm = (CMainFrame*)AfxGetApp()->GetMainWnd();
				pFrm->m_pSpeechOprDlg->SetInfo(strVarName.c_str());
			}
			Input(info);
			m_GrmList.erase(ite);
			return;
		}
		ite++;
	}
	m_pProcessTracer->Append("- Fs");
}

void CSpeechInput::OnRecEvent(int nEvent)
{
}

/*
void CSpeechInput::Input( CInputInfo info )
{
	m_pProcessTracer->Write( "͊Ǘ", " - [U" );
	m_pProcessTracer->Append( " - " );
	m_pProcessTracer->AppendLine( info.toXML().c_str() );


	for( int i = 0; i < 2; i++ )
	{
		CInputInfoList* info_list = m_pMyManager->GetInputInfoManager()->GetInputList( _MODALITY_ID_SRM, i );
		if( info_list )
		{
			if( info_list->Exist( info ) )
			{
				CVariables* pVarUser = info.GetVariablesPtr();
				CVariables* pVarOrg = info_list->GetVariablesPtrByInputInfo( info );
				string value;
				int var_size = pVarOrg->GetSize();
				for( int i = 0; i < var_size; i++ )
				{
					const string* var_name = pVarOrg->GetName( i );
//					value = (LPCSTR)( m_SPT.DesideReturnVar( var_name->c_str() ) );
					pVarUser->Add( *var_name, value, i );
				}
				if( m_pMyManager->GetState() )
				{
					m_pMyManager->NotifyInput( info );
					return;
				}
			}
		}
	}
}
*/