// SRMClient.cpp: CSRMClient NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Kiosk.h"
#include "SRMClient.h"
#include "SpeechInput.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

static char buf[MAXLINELEN];
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
//
// O		:UINT CSRMClient::RecvThread( LPVOID pParam )
// @\		:MpXbh
// 		:*lpParam - gւ̃|C^
// ߂l	:Ȃ
//
UINT CSRMClient::RecvThread( LPVOID pParam )
{
//	cout << "Enter Thread." << endl;

	CSRMClient *pSRMClient = (CSRMClient*)pParam;

	int nRecv;						// MTCYێ
	string strMsg;					// Mf[^i[
	char szBuff[RECV_BUFFER_SIZE+1];		// Mpobt@

	TRACE("SRMMJn\n");
	while( 1 )
	{
		szBuff[0] = '\0';
		nRecv = pSRMClient->m_Socket.Recv( szBuff );

		if( nRecv == SOCKET_ERROR )
		{
			int ret = WSAGetLastError();
			TRACE("SRMMs\n");
			break;
		}

		strMsg.append( szBuff, nRecv );		

		int nIndex = strMsg.find(".\n",0);
		while(nIndex != -1)
		{
			string str = strMsg.substr(0,nIndex);
			pSRMClient->AnalyzeMsg(str.c_str());
			strMsg.erase(0,nIndex+2);
			nIndex = strMsg.find(".\n",0);
		}
	}

//	cout << "Exit Thread." << endl;
//	pSRMClient->m_Socket.Close();
//	WSACleanup();
//	ExitThread( pSRMClient->m_pThread->m_hThread );
	return 0;
}

CSRMClient::CSRMClient(CSpeechInput *pSInput)
{
	m_pSInput = pSInput;
	m_pThread = NULL;
//	WinSockInit();
}

CSRMClient::~CSRMClient()
{

}

//
// O		:void CSRMClient::WinSockInit()
// @\		:WinSock̏
// 		:Ȃ
// ߂l	:Ȃ
//
void CSRMClient::WinSockInit()
{
	// WinSock̏
	int		nResult;
	WORD	wRequireVersion;	// gpWinSock̃o[W
	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );
	if( nResult != 0  )
	{
//		cerr << "WinSock̏Ɏs" << endl;
	}

	// WinSock̃o[Wv̂mF
	if( lpWSAData.wVersion != wRequireVersion )
	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
	}
}

//
// O		:void CSRMClient::Run()
// @\		:MpXbh̊Jn
// 		:Ȃ
// ߂l	:Ȃ
//
void CSRMClient::Run()
{
	if( m_Socket.IsValid() )
	{
		m_pThread = AfxBeginThread(RecvThread,(LPVOID)this);
//		m_dwThread = (DWORD)CreateThread( NULL, 0, CMsgServer::RecvThread,(LPVOID)this, 0, NULL );
		//m_dwThread = _beginthread( CMsgServer::RecvThread, 0, (LPVOID)this );
	}
}

//
// O		:void CSRMClient::Run()
// @\		:MpXbh̒~
// 		:Ȃ
// ߂l	:Ȃ
//
void CSRMClient::Stop()
{
	// ڑҋ@p\Pbg
	SendMsg("set Run = STOP./\n");
	m_Socket.Close();

	// XbhI܂őҋ@
	if(m_pThread!=NULL)
		WaitForSingleObject( m_pThread->m_hThread, /*INFINITE*/2000 );

//	cout << "Thread End." << endl;
}

//
// O		:int CSRMClient::Initialize()
// @\		:CX^X̏
// 		:
// ߂l	: - 0 s - -1 or -2
//
int CSRMClient::Initialize()
{
	CWinApp *pApp = AfxGetApp();
	CString strIP = pApp->GetProfileString("ENGINE","IP",NULL);
	int nPort = pApp->GetProfileInt("SRM","Port",10500);

	if(!m_Socket.Socket())
	{
		TRACE("\Pbg쐬s");
		return -1;
	}

	if(!m_Socket.Connect(strIP,nPort))
	{
		TRACE("ڑvs");
		return -2;
	}
	return 0;
}


//
// O		:BOOL CSRMClient::SendMsg( LPCTSTR lpszMsg )
// @\		:msg𑗐M
// 		:&msg - M郁bZ[W
// ߂l	: - TRUE s - FALSE
//
BOOL CSRMClient::SendMsg( LPCTSTR lpszMsg )
{
	// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
	string msg = lpszMsg;
	size_t nSize = msg.length();
	size_t nRet = 0;
	int nRetBuf = 0;
	m_Socket.Lock();
	while( 1 )
	{
		if( nRet >= nSize )
			break;
		nRetBuf = m_Socket.Send( &msg[nRet], nSize - nRet );
		if( nRetBuf == SOCKET_ERROR )
		{
			TRACE("SRMFMs\n");
			break;
		}
		nRet += nRetBuf;
	}
	m_Socket.Unlock();
	return TRUE;
}

void CSRMClient::AnalyzeMsg(LPCTSTR lpszMsg)
{
//	AfxMessageBox(lpszMsg);
	CString strMsg = lpszMsg;
	if(strMsg.Find("<GRAMINFO>") != -1)
	{
		m_pSInput->OnAddGrammar(lpszMsg);
	}
	else if(strMsg.Find("<RECOGOUT>") != -1)
	{
		m_pSInput->OnRecognize(lpszMsg);
	}
	else if(strMsg.Find("STARTREC") != -1)
	{
		m_pSInput->OnRecEvent(RECEVENT_START);
	}
	else if(strMsg.Find("ENDREC") != -1)
	{
		m_pSInput->OnRecEvent(RECEVENT_END);
	}
	else if(strMsg.Find("<RECOGFAIL>") != -1)
	{
		m_pSInput->OnRecognize("");
	}
}


BOOL CSRMClient::japi_die()
{
	return SendMsg("DIE\n");
}

BOOL CSRMClient::japi_get_version()
{
	return SendMsg("VERSION\n");
}

BOOL CSRMClient::japi_get_status()
{
	return SendMsg("STATUS\n");
}

BOOL CSRMClient::japi_pause_recog()
{
	return SendMsg("PAUSE\n");
}

BOOL CSRMClient::japi_terminate_recog()
{
	return SendMsg("TERMINATE\n");
}

BOOL CSRMClient::japi_resume_recog()
{
	return SendMsg("RESUME\n");
}

BOOL CSRMClient::japi_get_grammar(LPCTSTR lpszPrefixpath, CString &strSendMsg)
{
  FILE *fp;
  
  CString strPath;
  strPath.Format("%s.dfa",lpszPrefixpath);
  if ((fp = fopen(strPath, "r")) == NULL) {
    AfxMessageBox(".dfat@C݂܂");
	return FALSE;
  }
  while(fgets(buf, MAXLINELEN, fp) != NULL) {
    strSendMsg += buf;
  }
  fclose(fp);
  strSendMsg += "DFAEND\n";

  strPath.Empty();
  strPath.Format("%s.dict",lpszPrefixpath);
  if ((fp = fopen(strPath, "r")) == NULL) {
    AfxMessageBox(".dictt@C݂܂");
	return FALSE;
  }
  while(fgets(buf, MAXLINELEN, fp) != NULL) {
    strSendMsg += buf;
  }
  fclose(fp);
  strSendMsg += "DICEND\n";

  return TRUE;
}

BOOL CSRMClient::japi_change_grammar(LPCTSTR lpszPrefixpath)
{
	CString strSendMsg;
	if(!japi_get_grammar(lpszPrefixpath,strSendMsg))
		return FALSE;
	
	strSendMsg.Insert(0,"CHANGEGRAM\n");
	
	return SendMsg(strSendMsg);
}

BOOL CSRMClient::japi_add_grammar(LPCTSTR lpszPrefixpath)
{
	CString strSendMsg;
	if(!japi_get_grammar(lpszPrefixpath,strSendMsg))
		return FALSE;
	
	strSendMsg.Insert(0,"ADDGRAM\n");
	
	return SendMsg(strSendMsg);
}

BOOL CSRMClient::japi_delete_grammar(LPCTSTR lpszIdlist)
{
	CString strSendMsg = "DELGRAM\n";
	strSendMsg += lpszIdlist;
	strSendMsg += "\n";

	return SendMsg(strSendMsg);
}

BOOL CSRMClient::japi_activate_grammar(LPCTSTR lpszIdlist)
{
	CString strSendMsg = "ACTIVATEGRAM\n";
	strSendMsg += lpszIdlist;
	strSendMsg += "\n";

	return SendMsg(strSendMsg);
}

BOOL CSRMClient::japi_deactivate_grammar(LPCTSTR lpszIdlist)
{
	CString strSendMsg = "DEACTIVATEGRAM\n";
	strSendMsg += lpszIdlist;
	strSendMsg += "\n";

	return SendMsg(strSendMsg);
}
