//
// MMIVXe Ver.1.1 tgGh
// GUI
//
// ProcessTracer.h / ProcessTracer.cpp
//
// 2002/10/25 Fri. G
//
//
//

#include "stdafx.h"
#include "Kiosk.h"
#include "ProcessTracer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//
// CProcessTracer
//

BEGIN_MESSAGE_MAP( CProcessTracer, baseCProcessTracer )
	ON_WM_CREATE()
END_MESSAGE_MAP()

CProcessTracer::CProcessTracer()
{

}

CProcessTracer::~CProcessTracer()
{

}

int CProcessTracer::OnCreate(  LPCREATESTRUCT lpCreateStruct )
{
	if( baseCProcessTracer::OnCreate( lpCreateStruct ) == -1 )
	{
		return -1;
	}

	SetSCBStyle( GetSCBStyle() | SCBS_SIZECHILD );

	DWORD dwStyle = ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN | ES_LEFT | ES_READONLY;
	if( !m_Edit.Create( dwStyle | WS_CHILD | WS_VISIBLE | WS_VSCROLL, CRect( 0,0,0,0 ), this, IDV_EDITCTRL2 ) )
	{
		return -1;
	}

	m_Edit.ModifyStyleEx( 0, WS_EX_CLIENTEDGE );

	return 0;
}

void CProcessTracer::OnSize( UINT nType, int cx, int cy )
{
	m_Edit.MoveWindow( 0, 0, cx, cy );
	baseCProcessTracer::OnSize( nType, cx, cy );
}

void CProcessTracer::Write( LPCSTR tag, LPCSTR str )
{
	CString log;
	if(m_Edit.GetSafeHwnd()==NULL)return;
	m_Edit.GetWindowText( log );
	log += "\r\n";
	CTime time = CTime::GetCurrentTime();
	log += (LPCSTR)time.Format( "%H:%M:%S - " );
	log += tag;
	log += "\r\n";
	log += str;
	log += "\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );

}

void CProcessTracer::Append( LPCSTR str )
{
	CString log;
	if(m_Edit.GetSafeHwnd()==NULL)return;
	m_Edit.GetWindowText( log );
	log += str;
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

void CProcessTracer::AppendLine( LPCSTR str )
{
	CString log;
	if(m_Edit.GetSafeHwnd()==NULL)return;
	m_Edit.GetWindowText( log );
	log += str;
	log += "\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}
