//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// OutputCommand.h / OutputCommand.cpp
//
// 2002/10/26 Sat. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "OutputParam.h"
#include "XMLManager.h"

#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;



//
// COutputParam
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputParam::COutputParam()
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputParam::~COutputParam()
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputParam::SetValue( const string& value )
{
	m_Value = value;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputParam::SetAttribute( const string& name, const string& value )
{
	XMLAttributeList :: const_iterator c_ite = m_Attr.find( name );
	if( c_ite == m_Attr.end() )
	{
		m_Attr.insert( pair< string, string >( name, value ) );
	}
	else
	{
		m_Attr[name] = value;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string* COutputParam::GetAttributeValue( const string& attr_name )
{
	XMLAttributeList :: const_iterator c_ite = m_Attr.find( attr_name );
	if( c_ite != m_Attr.end() )
	{
		return &( c_ite->second );
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string* COutputParam::GetValue()
{
	return &m_Value;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int COutputParam::GetAttrSize()
{
	return m_Attr.size();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputParam::ExistAttribute( const string& attr_name )
{
	XMLAttributeList :: const_iterator c_ite = m_Attr.find( attr_name );
	if( c_ite != m_Attr.end() )
	{
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputParam::Clear()
{
	m_Value = "";
	m_Attr.clear();
}

string COutputParam::Dump()
{
	string dump = "<param ";
	XMLAttributeList:: iterator ite = m_Attr.begin();
	while( ite != m_Attr.end() )
	{
		dump += ite->first + "=\"";
		dump += ite->second + "\" ";
	}
	dump += ">";
	dump += m_Value + "</param>";
	return dump;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputParam& COutputParam:: operator = ( const COutputParam& param )
{
	if( &param == this ){ return *this; }

	m_Value = param.m_Value;
	m_Attr.clear();
	
	COutputParam& para = const_cast< COutputParam& >( param );
	XMLAttributeList :: iterator rhs = para.m_Attr.begin();

	while( rhs != para.m_Attr.end() )
	{
		m_Attr.insert( pair< string, string >( static_cast< string >( rhs->first ), static_cast< string >( rhs->second ) ) );
		rhs++;
	}
	
	return *this;
}

