//
// MMIVXetgGhVer1.1
// o͊Ǘ
//
// OutputModality.h / OutputModality.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "OutputModality.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// COutputModality
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputModality::COutputModality( COutputManager* manager, int ModalityID ) : m_pMyManager( manager ), m_ModalityID( ModalityID ), m_State( true )
{
	if( !m_pMyManager )
		m_State = false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputModality::~COutputModality()
{
	if( m_Cmdlist.size() > 0 )
	{
		list < COutputCommand* > :: iterator ite = m_Cmdlist.begin();
		while( ite != m_Cmdlist.end() )
		{
			delete static_cast< COutputCommand* >( *ite );
			ite++;
		}
		m_Cmdlist.clear();
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int COutputModality::GetID()
{
	return m_ModalityID;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool COutputModality::Regist()
{
	return m_pMyManager->Regist( static_cast< COutputModality* >( this ) );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool COutputModality::Release()
{
	return m_pMyManager->Release( static_cast< COutputModality* >( this ) );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool COutputModality::GetState()
{
	return m_State;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void COutputModality::SetState( bool state )
{
	m_State = state;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputModality::Execute()
{
	OUTPUT::EXECRESULT result = (*m_Cmdlist.begin())->Execute();
	if( result == OUTPUT::RESULT_SUCCEEDED )
	{
		Finish();
		return true;
	}
	else if( result == RESULT_FAILED )
	{
		RemoveCommand();
	}
	else if( result == RESULT_CONTINUE )
	{
		return true;
	}
	else
	{
		// ?
	}
	return false;
}


//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
void COutputModality::Error( COutputCommand* pcmd, const string& message )
{
	m_pMyManager->Error( pcmd, message );
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
void COutputModality::Error( const string& msg )
{
	m_pMyManager->Error( msg );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputModality::AddCommand( COutputCommand* pcmd )
{
	m_Cmdlist.push_back( pcmd );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputModality::RemoveCommand()
{
	delete static_cast< COutputCommand* >( *( m_Cmdlist.begin()) );
	*( m_Cmdlist.begin() ) = NULL;
	m_Cmdlist.pop_front();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputModality::Finish()
{
	list < COutputCommand* > :: const_iterator c_ite = m_Cmdlist.begin();
	m_pMyManager->NotifyOutput( static_cast< COutputCommand* >( *c_ite ) );
	RemoveCommand();
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
void COutputModality::Lock( bool state )
{
	m_pMyManager->Lock( state );
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool COutputModality::AnalyzeOutput( const string& msg, string& count, bool& bargein, string& path, string& event, CVariables& vars, list < COutputParam >& pars )
{
	bargein = false;
	CXMLManager xml;
	if( xml.LoadXML( msg.c_str() ) != 0 ){ return false; }
	
	string bi;
	if( !GetNodeValue( xml, string("count"), count ) ){ return false; }
	if( !GetNodeValue( xml, string("bargein"), bi ) ){ return false; }
	if( !GetNodeValue( xml, string("path"), path ) ){ return false; }
	if( bi == "on" ){ bargein = true; }
	if( !GetNodeAttr( xml, string("output"), string("event"), event ) ){ return false; }

	string str_return;
	if( GetNodeAttr( xml, string("output"), string("return"), str_return ) )
	{
		int start = 0;
		int end = 0;
		int pos = 0;
		if( str_return.size() != 0 )
		{
			string var_name;
			while( ( end = str_return.find_first_of( ",", start ) ) != string::npos )
			{
				if( start != end )
				{
					vars.Add( str_return.substr( start, end - start ), "", pos );
				}
				start = end +1 ;
				pos++;
			}
			if( start != str_return.size() )
			{
				vars.Add( str_return.substr( start ), "", pos );
			}
		}
	}

	int param_start = msg.find( "<![CDATA[" );
	int param_end = msg.find( "]]>" );
	if( param_start == string::npos || param_end == string::npos ){ return false; }

	CXMLManager man;
	string temp = msg.substr( param_start + 9, param_end - (param_start+9) );
	temp.insert( 0, "<temp>" );
	temp.append( "</temp>" );
	if( man.LoadXML( temp.c_str() ) != 0 ){ return false; }

	MSXML2::IXMLDOMNode* pNode = NULL;
	XMLNodeArray array;
	XMLAttributeList attr;
	XMLAttributeList :: iterator ite;
	int array_size = -1;
	COutputParam op;

	if( ( array_size = man.FindNodesByTagName( "param", array ) ) < 1 ){ return false; }
	for( int i = 0; i < array_size; i++ )
	{
		pNode = static_cast< MSXML2::IXMLDOMNode* >( array[i] );
		if( man.GetAttributes( pNode, attr ) < 1 ){ return false; }
		ite = attr.begin();
		while( ite != attr.end() )
		{
			op.SetAttribute( static_cast< string >( ite->first ), static_cast< string >( ite->second ) );
			ite++;
		}
		op.SetValue( man.GetNodeValue( pNode ) );
		pars.push_back( op );
		op.Clear();
	}

	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool COutputModality::GetNodeValue( CXMLManager& xml, string& name, string& value )
{
	XMLNodeArray array;
	if( xml.FindNodesByTagName( name.c_str(), array ) < 1 )
	{
		return false;
	}
	value = xml.GetNodeValue( static_cast< MSXML2::IXMLDOMNode* >( *( array.begin() ) ) );
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
//    :           
// ߂l : 
//
bool COutputModality::GetNodeAttr( CXMLManager& xml, string& node, string& attr, string& value )
{
	XMLNodeArray array;
	XMLAttributeList attrlist;
	XMLAttributeList :: iterator ite;
	if( xml.FindNodesByTagName( node.c_str(), array ) < 1 )
	{
		return false;
	}
	if( xml.GetAttributes( static_cast< MSXML2::IXMLDOMNode* >( *( array.begin() ) ), attrlist ) < 1 )
	{
		return false;
	}
	ite = attrlist.find( attr );
	if( ite == attrlist.end() )
	{
		return false;
	}
	value = static_cast< string >( ite->second );

	return true;
}



