//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// OutputManager.h / OutputManager.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _OUTPUTMANAGER_H_
#define _OUTPUTMANAGER_H_

#pragma once

#include "OutputModality.h"
#include "InputManager.h"
#include "ProcessTracer.h"
#include "Communicater.h"

using namespace std;

class CInputManager;
class COutputCommand;
class COutputModality;
class CCommunicater;

class COutputManager  
{
private:
	CInputManager* m_pInputManager;
	COutputModality* m_pCurrentOutput;
	CProcessTracer* m_pProcessTracer;
	CCommunicater* m_pCommunicater;
	map < int, COutputModality* > m_RegistedModality;

public:
	COutputManager();
	virtual ~COutputManager();

	void Init( CCommunicater* pCom, CInputManager* pIM, CProcessTracer* tracer );
	bool Regist( COutputModality* moda );
	bool Release( COutputModality* moda );

	void NotifyOutput( COutputCommand* pcmd );
	void Error( COutputCommand* pcmd, const string& message );
	void Error( const string& msg );
	void Terminate();
	void Lock( bool state = false );
	bool GetState();

	void Analyze( const string msg );

};

#endif _OUTPUTMANAGER_H_
