//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// OutputManager.h / OutputManager.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "OutputManager.h"
#include "XMLManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// COutputManager
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputManager::COutputManager() : m_pInputManager( NULL ), m_pCurrentOutput( NULL ), m_pProcessTracer( NULL ), m_pCommunicater( NULL )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputManager::~COutputManager()
{
	if( m_RegistedModality.size() > 0 )
	{
		COutputModality* pmoda = NULL;
		map < int, COutputModality* > :: iterator ite = m_RegistedModality.begin();
		while( ite != m_RegistedModality.end() )
		{
			delete static_cast< COutputModality* >( ite->second );
			ite++;
		}
		m_RegistedModality.clear();
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::Init( CCommunicater* pCom, CInputManager* pIM, CProcessTracer* tracer )
{
	m_pCommunicater = pCom;
	m_pInputManager = pIM;
	m_pProcessTracer = tracer;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputManager::Regist( COutputModality* moda )
{
	int id = moda->GetID();
	map < int, COutputModality* > :: const_iterator c_ite = m_RegistedModality.find( id );
	if( c_ite == m_RegistedModality.end() )
	{
		m_RegistedModality.insert( pair< int, COutputModality* >( id, moda ) );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputManager::Release( COutputModality* moda )
{
	int id = moda->GetID();
	map < int, COutputModality* > :: const_iterator c_ite = m_RegistedModality.find( id );
	if( c_ite == m_RegistedModality.end() )
	{
		return false;
	}
	m_RegistedModality.erase( id );
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::Lock( bool state )
{
	m_pInputManager->SetState( !state );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::NotifyOutput( COutputCommand* pcmd )
{
	m_pProcessTracer->AppendLine( " - \r\n - end_outputM" );

	m_pCommunicater->Send( CCommunicater::_COMMAND_END_OUTPUT, pcmd->toXML().c_str() );
	m_pCurrentOutput = NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::Error( COutputCommand* pcmd, const string& message )
{
	m_pProcessTracer->Append( " - " );
	m_pProcessTracer->AppendLine( message.c_str() );
	m_pProcessTracer->AppendLine( " - G[ʒms" );
	// errorʒm
	string param = "<count>";
	param += pcmd->GetCount() + "</count><comment>";
	param += message + "</comment>";
	m_pCommunicater->Send( CCommunicater::_COMMAND_ERROR_OUTPUT, param.c_str() );
}

void COutputManager::Error( const string& msg )
{
	m_pProcessTracer->AppendLine( " - <output>̍\G[" );
	int start = msg.find( "<count>" );
	int end = msg.find( "</count>" ) + 8;
	string count = msg.substr( start, end - start );
	count += "<comment></comment>";
	m_pProcessTracer->AppendLine( " - G[ʒms" );
	m_pCommunicater->Send( CCommunicater::_COMMAND_ERROR_OUTPUT, count.c_str() );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::Terminate()
{
	if( m_pCurrentOutput )
	{
		m_pCurrentOutput->Terminate();
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputManager::GetState()
{
	if( m_pCurrentOutput )
	{
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputManager::Analyze( const string msg )
{
	m_pProcessTracer->Write( "o͊Ǘ", " - execute_output̉" );

	XMLNodeArray array;
	XMLAttributeList attr;
	XMLAttributeList :: iterator ite;
	CXMLManager xml;
	
	if( xml.LoadXML( msg.c_str() ) == 0 )
	{
		if( xml.FindNodesByTagName( "output", array ) == 1 )
		{
			MSXML2::IXMLDOMNode* pNode = static_cast< MSXML2::IXMLDOMNode* >( *( array.begin() ) );
			if( xml.GetAttributes( pNode, attr ) > 0 )
			{
				ite = attr.find( "type" );
				if( ite != attr.end() )
				{
					m_pProcessTracer->AppendLine( " - ͊" );
					m_pProcessTracer->Append( " - o̓_eB̌..." );
					string type = ite->second;
					COutputModality* pModa = NULL;
					map < int, COutputModality* > :: iterator moda_ite = m_RegistedModality.begin();
					while( moda_ite != m_RegistedModality.end() )
					{
						pModa = moda_ite->second;
						if( type == pModa->GetTypeAttribute() )
						{
							m_pProcessTracer->AppendLine( "" );
							m_pCurrentOutput = pModa;
							COutputCommand* pCmd = m_pCurrentOutput->StoreCommand( msg );
							if( pCmd )
							{
								m_pProcessTracer->Append( " - s : " );
								m_pProcessTracer->AppendLine( pCmd->GetCount().c_str() );
								m_pCurrentOutput->Execute();
							}
							else
							{
								m_pProcessTracer->AppendLine( " - error_outputM" );
								m_pCommunicater->Send( CCommunicater::_COMMAND_ERROR_OUTPUT, "" );
							}
							return;
						}
						moda_ite++;
					}
					m_pProcessTracer->AppendLine( "s" );
				}
			}
		}		
	}
	m_pProcessTracer->Append( " - <output>̍\G[\r\n - " );
	m_pProcessTracer->AppendLine( msg.c_str() );
}
