//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// OutputCommand.h / OutputCommand.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _OUTPUTCOMMAND_H_
#define _OUTPUTCOMMAND_H_

#pragma once

#include <list>

#include "Variables.h"
#include "OutputParam.h"
#include "OutputModality.h"

using namespace std;

class COutputModality;

class COutputCommand  
{
public:
	static const char* _ENDOUTPUT_NORMAL;
	static const char* _ENDOUTPUT_INTERRUPT;

protected:
	COutputModality* m_pModality;
	string m_Count;
	bool m_Bargein;
	string m_Path;
	string m_Event;
	CVariables m_Vars;
	list < COutputParam > m_Param;
	const char* m_EndState;

public:
	COutputCommand( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& m_Param );
	virtual ~COutputCommand();

	void SetCount( const string& count );
	void SetBargein( bool bargein );
	void SetEvent( const string& event );
	void SetParam( list < COutputParam >& param );
	const string& GetCount();
	const char* GetEndState();
	void SetEndState( const char* );

	virtual OUTPUT::EXECRESULT Execute() = 0;
	virtual OUTPUT::EXECRESULT Terminate() = 0;

	const string toXML();
	void Error( COutputCommand* pcmd, const string& message );

protected:
	int GetParamValue( const string& attr_name, const string& attr_value, list < string >& values );
	bool GetParamValue( const string& attr_name, const string& attr_value, string& value );
	int GetParam( const string& attr_name, const string& attr_value, list < COutputParam >& params );
	bool GetParam( const string& attr_name, const string& attr_value, COutputParam& param );

};

#endif _OUTPUTCOMMAND_H_
