//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// OutputCommand.h / OutputCommand.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "OutputCommand.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// COutputCommand
//

const char* COutputCommand::_ENDOUTPUT_INTERRUPT = "interrupt";
const char* COutputCommand::_ENDOUTPUT_NORMAL = "normal";

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputCommand::COutputCommand( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& param ) : m_pModality( modality ), m_Count( count ), m_Bargein( bargein ), m_Path( path ), m_Event( event ), m_Vars( vars ), m_Param( param ), m_EndState ( "" )
{
	m_pModality->Lock( false );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputCommand::~COutputCommand()
{
	m_pModality->Lock( false );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::SetCount( const string& count )
{
	m_Count = count;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::SetBargein( bool bargein )
{
	m_Bargein = bargein;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::SetEvent( const string& event )
{
	m_Event = event;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::SetParam( list < COutputParam >& param )
{
	m_Param = param;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string& COutputCommand::GetCount()
{
	return m_Count;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const char* COutputCommand::GetEndState()
{
	return m_EndState;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::SetEndState( const char* state )
{
	m_EndState = state;;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string COutputCommand::toXML()
{
	string ret = "<count>" + m_Count + "</count><condition>";
	ret += m_EndState;
	ret += "</condition>";

	if( m_Vars.GetSize() > 0 )
	{
		ret += m_Vars.toXML();
	}

	return ret;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void COutputCommand::Error( COutputCommand* pcmd, const string& message )
{
	m_pModality->Error( pcmd, message );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int COutputCommand::GetParamValue( const string& attr_name, const string& attr_value, list < string >& values )
{
	values.clear();
	list < COutputParam > :: iterator ite = m_Param.begin();
	while( ite != m_Param.end() )
	{
		COutputParam& param = static_cast< COutputParam& >( *ite );
		if( *(param.GetAttributeValue( attr_name )) == attr_value )
		{
			values.push_back( *( param.GetValue() ) );
		}
		ite++;
	}
	return values.size();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputCommand::GetParamValue( const string& attr_name, const string& attr_value, string& value )
{
	list < COutputParam > :: iterator ite = m_Param.begin();
	while( ite != m_Param.end() )
	{
		COutputParam& param = static_cast< COutputParam& >( *ite );
		if( *(param.GetAttributeValue( attr_name )) == attr_value )
		{
			value = *( param.GetValue() );
			return true;
		}
		ite++;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int COutputCommand::GetParam( const string& attr_name, const string& attr_value, list < COutputParam >& params )
{
	params.clear();
	list < COutputParam > :: iterator ite = m_Param.begin();
	while( ite != m_Param.end() )
	{
		COutputParam& param = static_cast< COutputParam& >( *ite );
		if( *(param.GetAttributeValue( attr_name )) == attr_value )
		{
			params.push_back( param );
		}
		ite++;
	}
	return params.size();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool COutputCommand::GetParam( const string& attr_name, const string& attr_value, COutputParam& param )
{
	param.Clear();
	list < COutputParam > :: iterator ite = m_Param.begin();
	while( ite != m_Param.end() )
	{
		COutputParam& p = static_cast< COutputParam& >( *ite );
		if( *(p.GetAttributeValue( attr_name )) == attr_value )
		{
			param = p;
			return true;
		}
		ite++;
	}
	return false;
}

