//
// MMIVXetgGhVer1.1
// ^b`͕
//
// MouseInput.h / MouseInput.cpp
//
// 2002/10/26 Sat. G
//
//
//

#include "stdafx.h"
#include "MouseInput.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//
// CMouseInput
//

const char* CMouseInput::_TYPE_TOUCH = "touch";
const char* CMouseInput::_EVENT_CLICK = "click";
const char* CMouseInput::_EVENT_DCLICK = "dclick";
const char* CMouseInput::_EVENT_DRAGANDDROP = "dragdrop";
const char* CMouseInput::_TEMPORARY_NAME_X = "x";
const char* CMouseInput::_TEMPORARY_NAME_Y = "y";
const char* CMouseInput::_TEMPORARY_NAME_ID = "id";


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CMouseInput::CMouseInput( CInputManager* manager, int ModalityID, CProcessTracer* tracer ) : CInputModality( manager, ModalityID ), m_pProcessTracer( tracer )
{
	m_pProcessTracer->Write( "^b`͊Ǘ", " - " );
	m_State = false;
	if( Regist() )
	{
		m_pProcessTracer->AppendLine( " - ͊Ǘɓo^" );
		m_State = true;
	}
	m_pProcessTracer->AppendLine( " - " );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CMouseInput::~CMouseInput()
{
	m_pProcessTracer->Write( "^b`͊Ǘ", " - " );
	if( Release() )
	{
		m_pProcessTracer->AppendLine( " - ͊Ǘ폜" );
	}
	m_pProcessTracer->AppendLine( " - " );
}

string CMouseInput::GetTypeAttribute()
{
	return _TYPE_TOUCH;
}

list < string > CMouseInput::GetEventAttribute()
{
	list < string > events;
	events.clear();
	events.push_back( _EVENT_CLICK );
	events.push_back( _EVENT_DCLICK );
	events.push_back( _EVENT_DRAGANDDROP );
	return events;
}

bool CMouseInput::Analyze( const string& path, const CInputInfo &info )
{
	return true;
}

void CMouseInput::Input( const string& type, const string& event, const string& match, const string& target, const CVariables& vars )
{
	if( !m_State ){ return; }
	
	CInputInfo user_input( type, event, match, target, vars );
	m_pProcessTracer->Write( "͊Ǘ", " - [U" );
	m_pProcessTracer->Append( " - " );
	m_pProcessTracer->AppendLine( user_input.toXML().c_str() );

	int idx_start = match.find( "[" );
	if( idx_start == string::npos )
	{
		m_pMyManager->Validate( _MODALITY_ID_MOUSE, user_input );
		return;
	}

	string org = match;
	string match_substr = org.erase( idx_start, match.find( "]" ) - idx_start + 1 );

	CInputInfoList* info_list;

	for( int i = 0; i < 2; i++ )
	{
		info_list = m_pMyManager->GetInputInfoManager()->GetInputList( _MODALITY_ID_MOUSE, i );
		if( info_list )
		{
			list < CInputInfo >* infolist = info_list->GetList();
			list < CInputInfo > :: iterator ite = infolist->begin();
			while( ite != infolist->end() )
			{
				string match_org = (*ite).GetMatchAttr();
				idx_start = match_org.find( "[" );
				if( idx_start != string::npos )
				{
					if( match_org.find( ":=" ) != string::npos )
					{
						match_org = match_org.erase( idx_start, match_org.find( "]" ) - idx_start + 1 );
						if( match_substr == match_org )
						{
							CVariables* var_user = user_input.GetVariablesPtr();
							CVariables* var_org = info_list->GetVariablesPtrByInputInfo( (*ite) );
							if( var_org == NULL ){ return; }
							if( var_org->GetSize() > 0 && var_org->GetSize() == var_user->GetSize() )
							{
								for( int j = 0; j < var_org->GetSize(); j++ )
								{
									var_user->SetName( j, *( var_org->GetName( j ) ) );
								}
							}
							if( m_pMyManager->GetState() )
							{
								m_pMyManager->NotifyInput( user_input );
								return;
							}
						}
						ite++;
					}
					else
					{
						if( match == match_org )
						{
							CVariables* var_user = user_input.GetVariablesPtr();
							CVariables* var_org = info_list->GetVariablesPtrByInputInfo( (*ite) );
							if( var_org == NULL ){ return; }
							if( var_org->GetSize() > 0 && var_org->GetSize() == var_user->GetSize() )
							{
								for( int j = 0; j < var_org->GetSize(); j++ )
								{
									var_user->SetName( j, *( var_org->GetName( j ) ) );
								}
							}
							if( m_pMyManager->GetState() )
							{
								m_pMyManager->NotifyInput( user_input );
								return;
							}
						}
						ite++;
					}
				}
				else
				{
					if( org == match_org )
					{
						CVariables* var_user = user_input.GetVariablesPtr();
						CVariables* var_org = info_list->GetVariablesPtrByInputInfo( (*ite) );
						if( var_org == NULL ){ return; }
						if( var_org->GetSize() > 0 && var_org->GetSize() == var_user->GetSize() )
						{
							for( int j = 0; j < var_org->GetSize(); j++ )
							{
								var_user->SetName( j, *( var_org->GetName( j ) ) );
							}
						}
						if( m_pMyManager->GetState() )
						{
							m_pMyManager->NotifyInput( user_input );
							return;
						}
					}
					ite++;
				}
			}
		}
	}
}

