//
// MMIVXe Ver.1.1 tgGh
// 
//
// MainFrame.h / MainFrame.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _MAINFRAME_H_
#define _MAINFRAME_H_

#pragma once

#include "IEFrame.h"
#include "ProcessTracer.h"
#include "MessageTracer.h"
#include "InputTracer.h"
#include "SpeechOprDlg.h"

#include "InputManager.h"
#include "OutputManager.h"

#include "TimerCtrl.h"
#include "KeyInput.h"
#include "MouseInput.h"
#include "SpeechInput.h"
#include "IECtrl.h"
#include "TTSCtrl.h"
#include "FSMCtrl.h"


class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)

public:
	CInputManager m_InputManager;
	COutputManager m_OutputManager;
	CCommunicater m_Communicater;
	CSpeechOprDlg *m_pSpeechOprDlg;

	CKeyInput* m_pKeyInput;
	CMouseInput* m_pMouseInput;
	CSpeechInput* m_pSpeechInput;

	CTimerCtrl* m_pTimerCtrl;
	CIECtrl* m_pIECtrl;
	CTTSCtrl* m_pTTSCtrl;
	CFSMCtrl* m_pFSMCtrl;

public:
	CMainFrame();
	virtual ~CMainFrame();

public:
	void OnBrowserEvent( CIEFrame* frame );
	void DisplayInputSentence();

	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
	CProcessTracer m_ProcessTracer;
	CInputTracer m_InputTracer;
	CMessageTracer m_MessageTracer;
	void JointToolBar(CFrameWnd *_pFrameWnd,CControlBar *_pBar,CControlBar *_pCB);

protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnMainProcess();
	afx_msg void OnUpdateMainProcess(CCmdUI* pCmdUI);
	afx_msg void OnCommicate();
	afx_msg void OnUpdateCommicate(CCmdUI* pCmdUI);
	afx_msg void OnInputinfo();
	afx_msg void OnUpdateInputinfo(CCmdUI* pCmdUI);
	afx_msg void OnConfigure();
	afx_msg void OnNewDialogue();
	afx_msg void OnViewSnaviDlg();
	afx_msg void OnUpdateViewSnaviDlg(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMove(int x, int y);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//{{AFX_INSERT_LOCATION}}

#endif _MAINFRAME_H_
