//
// MMIVXe Ver.1.1 tgGh
// o͊Ǘ
//
// MainFrame.h / MainFrame.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "Kiosk.h"

#include "MainFrame.h"
#include "CfgNetwork.h"
#include "OpenXisl.h"
#include "CFGEngineDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(IDM_MAIN_PROCESS, OnMainProcess)
	ON_UPDATE_COMMAND_UI(IDM_MAIN_PROCESS, OnUpdateMainProcess)
	ON_COMMAND(IDM_COMMICATE, OnCommicate)
	ON_UPDATE_COMMAND_UI(IDM_COMMICATE, OnUpdateCommicate)
	ON_COMMAND(IDM_INPUTINFO, OnInputinfo)
	ON_UPDATE_COMMAND_UI(IDM_INPUTINFO, OnUpdateInputinfo)
	ON_COMMAND(IDM_CONFIGURE, OnConfigure)
	ON_COMMAND(IDM_NEW_DIALOGUE, OnNewDialogue)
	ON_COMMAND(ID_VIEW_SNAVI_DLG, OnViewSnaviDlg)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SNAVI_DLG, OnUpdateViewSnaviDlg)
	ON_WM_SIZE()
	ON_WM_MOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // Xe[^X C CWP[^
	ID_INDICATOR_KANA,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

CMainFrame::CMainFrame()
{

}

CMainFrame::~CMainFrame()
{

}

void CMainFrame::OnClose()
{
	m_Communicater.Send( CCommunicater::_COMMAND_END_WORLD, "" );
	if( m_pFSMCtrl )
		delete m_pFSMCtrl;
	if( m_pMouseInput )
		delete m_pMouseInput;
	if( m_pKeyInput )
		delete m_pKeyInput;
	if( m_pTimerCtrl )
		CTimerCtrl::ReleaseInstance();
	if( m_pIECtrl )
		delete m_pIECtrl;
	if( m_pTTSCtrl )
		delete m_pTTSCtrl;
	if(m_pSpeechOprDlg)
		m_pSpeechOprDlg->DestroyWindow();
	if( m_pSpeechInput )
		delete m_pSpeechInput;

	CMDIFrameWnd::OnClose();
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if( !m_Communicater.Create( NULL, NULL, WS_CHILD, CRect(0,0,0,0), this, IDW_COMMUNICATER ) )
	{
		return -1;
	}

	if (!m_wndToolBar.CreateEx(this) || !m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;
	}

	if (!m_wndStatusBar.Create(this) || !m_wndStatusBar.SetIndicators(indicators,sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;
	}

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY);
	EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

#ifdef _SCB_REPLACE_MINIFRAME
	m_pFloatingFrameClass = RUNTIME_CLASS(CSCBMiniDockFrameWnd);
#endif

	if( m_ProcessTracer.Create( "Ҳ", this, IDW_TRACER_PROCESS ) == -1 )
	{
		return -1;
	}
	m_ProcessTracer.SetBarStyle( m_ProcessTracer.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC );
	m_ProcessTracer.EnableDocking( CBRS_ALIGN_ANY );
	DockControlBar( &m_ProcessTracer, AFX_IDW_DOCKBAR_BOTTOM );

	if( m_MessageTracer.Create( "ʐM۸", this, IDW_TRACER_MESSAGE ) == -1 )
	{
		return -1;
	}
	m_MessageTracer.SetBarStyle( m_MessageTracer.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC );
	m_MessageTracer.EnableDocking( CBRS_ALIGN_ANY );
	DockControlBar( &m_MessageTracer, AFX_IDW_DOCKBAR_BOTTOM );

	if( m_InputTracer.Create( "͏", this, IDW_TRACER_INPUT ) == -1 )
	{
		return -1;
	}
	m_InputTracer.SetBarStyle( m_InputTracer.GetBarStyle() | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC );
	m_InputTracer.EnableDocking( CBRS_ALIGN_ANY );
	DockControlBar( &m_InputTracer, AFX_IDW_DOCKBAR_BOTTOM );

	m_Communicater.Init( &m_InputManager, &m_OutputManager, &m_MessageTracer );
	m_InputManager.Init( &m_Communicater, &m_OutputManager, &m_ProcessTracer, &m_InputTracer );
	m_OutputManager.Init( &m_Communicater, &m_InputManager, &m_ProcessTracer );

	ShowControlBar( &m_MessageTracer, FALSE, FALSE );
	ShowControlBar( &m_InputTracer, FALSE, FALSE );
	ShowControlBar( &m_ProcessTracer, FALSE, FALSE );

	m_Communicater.Run();

	CWinApp *pApp = AfxGetApp();
	int nValidate = pApp->GetProfileInt("ENGINE","Validate",0);
	if(nValidate == 0)
	{
		CCFGEngineDlg cfgEngDlg;
		if(cfgEngDlg.DoModal() != IDOK)
			return -1;
	}
	//JgfBNgGalatea_FÊfBNgɂ
	int dir_length=0;
	char cPath[MAX_PATH];
	GetModuleFileName(NULL, cPath, sizeof(cPath));//AvP[V̂fBNg擾(t@Ct)
	dir_length = strlen(cPath);//擾t@Cl[̒擾(fBNg܂)
	//AvP[V
	while(dir_length){
		if(cPath[dir_length]=='\\'){
			cPath[dir_length]='\0';
			break;
		}
		else
			dir_length--;
	}
	//JgfBNgݒ
	SetCurrentDirectory(cPath);
	
	m_pFSMCtrl = new CFSMCtrl( &m_OutputManager, _MODALITY_ID_AGENT, &m_ProcessTracer );

	if(!m_pFSMCtrl->ConnectEngine()){
		//FSMƂ̐ڑsDJďI
		MessageBox("ڑvs:烂W[(FSM)GW̃pXmFĂ\ntgGhI܂","Can't Connect FSM Engine",MB_OK);
		m_pFSMCtrl->Stop();
		WSACleanup();
		delete m_pFSMCtrl; m_pFSMCtrl=NULL;
		pApp->WriteProfileInt("ENGINE","Validate",0);
		return -1;
	}

	m_pKeyInput = new CKeyInput( &m_InputManager, _MODALITY_ID_KEY, &m_ProcessTracer );
	CKioskApp* pKiosk = (CKioskApp*)AfxGetApp();
	pKiosk->m_pKeyInput = m_pKeyInput;
	m_pMouseInput = new CMouseInput( &m_InputManager, _MODALITY_ID_MOUSE, &m_ProcessTracer );
	m_pSpeechInput = new CSpeechInput( &m_InputManager, _MODALITY_ID_SRM, &m_ProcessTracer, this );
	Sleep(1500);
	if(!m_pSpeechInput->ConnectEngine()){
		//SRMƂ̐ڑsDJďI
		MessageBox("ڑvs:(SRM)GW̃pXmFĂ\ntgGhI܂","Can't Connect SpeechInput Engine",MB_OK);
		m_pFSMCtrl->Stop();
		WSACleanup();
		delete m_pFSMCtrl; m_pFSMCtrl=NULL;
		delete m_pMouseInput; m_pMouseInput=NULL;
		delete m_pKeyInput; m_pKeyInput = NULL;
		delete m_pSpeechInput; m_pSpeechInput = NULL;
		pApp->WriteProfileInt("ENGINE","Validate",0);
		return -1;
	}

	CTimerCtrl::InitInstance( &m_InputManager, &m_OutputManager, _MODALITY_ID_TIMER, this->m_hWnd, &m_ProcessTracer );
	m_pTimerCtrl = CTimerCtrl::GetInstance();
	m_pTTSCtrl = new CTTSCtrl( &m_OutputManager, _MODALITY_ID_TTS, &m_ProcessTracer );
	Sleep(1500);
	if(!m_pTTSCtrl->ConnectEngine()){
		//SSMƂ̐ڑsDJďI
		MessageBox("ڑvs:(SSM)GW̃pXmFĂ\ntgGhI܂","Can't Connect TTS Engine",MB_OK);
		m_pFSMCtrl->Stop();
		WSACleanup();
		delete m_pFSMCtrl; m_pFSMCtrl=NULL;
		delete m_pMouseInput; m_pMouseInput=NULL;
		delete m_pKeyInput; m_pKeyInput = NULL;
		delete m_pSpeechInput; m_pSpeechInput = NULL;
		m_pTTSCtrl->Stop();
		WSACleanup();
		delete m_pTTSCtrl; m_pTTSCtrl = NULL;
		pApp->WriteProfileInt("ENGINE","Validate",0);
		return -1;
	}
	m_pTTSCtrl->ConnectFSM(m_pFSMCtrl);
	m_pIECtrl = new CIECtrl( &m_OutputManager, _MODALITY_ID_BROWSER, this, m_pMouseInput );
	m_pIECtrl->SetTracer( &m_ProcessTracer );

	m_pSpeechOprDlg = new CSpeechOprDlg(this);
	//sapi.lib 
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

void CMainFrame::OnBrowserEvent( CIEFrame* frame )
{
	if( m_pIECtrl->m_IsNavi )
	{
		m_pIECtrl->Finish();
		m_pIECtrl->m_IsNavi = false;
	}
}

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

void CMainFrame::OnMainProcess() 
{
	ShowControlBar( &m_ProcessTracer, !m_ProcessTracer.IsVisible(), FALSE );
}

void CMainFrame::OnUpdateMainProcess(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck( m_ProcessTracer.IsVisible() );	
}

void CMainFrame::OnCommicate() 
{
	ShowControlBar( &m_MessageTracer, !m_MessageTracer.IsVisible(), FALSE );
}

void CMainFrame::OnUpdateCommicate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck( m_MessageTracer.IsVisible() );
}

void CMainFrame::OnInputinfo() 
{
	ShowControlBar( &m_InputTracer, !m_InputTracer.IsVisible(), FALSE );
}

void CMainFrame::OnUpdateInputinfo(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable();
	pCmdUI->SetCheck( m_InputTracer.IsVisible() );
}

void CMainFrame::OnConfigure() 
{
	CCfgNetwork cfg(this);

	struct sockaddr_in si = m_Communicater.GetDMAddr();
	cfg.m_Port = ntohs( si.sin_port );
	if( si.sin_addr.s_addr != NULL )
	{
		cfg.SetAddr( (BYTE)si.sin_addr.S_un.S_un_b.s_b1, (BYTE)si.sin_addr.S_un.S_un_b.s_b2, (BYTE)si.sin_addr.S_un.S_un_b.s_b3, (BYTE)si.sin_addr.S_un.S_un_b.s_b4 ); 
	}
	cfg.m_MyPort = m_Communicater.GetMyPort();

	if( cfg.DoModal() == IDOK )
	{
		m_Communicater.SetDMAddr( (LPCSTR)cfg.GetAddress(), cfg.m_Port );
		if( !m_Communicater.Stop() || !m_Communicater.Run() )
		{
			AfxMessageBox( "lbg[NG[", MB_OK, NULL );
		}
	}
}

void CMainFrame::OnNewDialogue() 
{
	COpenXisl ox;

	if( ox.DoModal() == IDOK )
	{
		m_pIECtrl->ClearAll();
		CString uri = "<uri>";
		uri += ox.m_strXISL;
		uri += "</uri>";

		m_Communicater.Send( CCommunicater::_COMMAND_START_SESSION, (LPCSTR)uri );		
	}
}

void CMainFrame::JointToolBar(CFrameWnd *_pFrameWnd,CControlBar *_pBar,CControlBar *_pCB)
{
	DWORD dw;
	UINT n=0;
	CRect rect;

	_pFrameWnd->RecalcLayout();
	_pCB->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=_pCB->GetBarStyle();
	n = (dw & CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw & CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw & CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw & CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	_pFrameWnd->DockControlBar(_pBar,n,&rect);
}

void CMainFrame::OnViewSnaviDlg() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	if(!m_pSpeechOprDlg->IsWindowVisible())
	{
		CRect rectDlg,rectWnd,rectNew;
		m_pSpeechOprDlg->GetWindowRect(&rectDlg);
		GetClientRect(&rectWnd);
		ClientToScreen(&rectDlg);
		ClientToScreen(&rectWnd);
		rectNew.top = rectWnd.top;
		rectNew.left = rectWnd.right - rectDlg.Width();
		rectNew.bottom = rectDlg.Height() + rectNew.top;
		rectNew.right = rectNew.left + rectDlg.Width();

	//	ClientToScreen(&rectNew);
	//	ScreenToClient(&rectNew);
		m_pSpeechOprDlg->MoveWindow(&rectNew);
		m_pSpeechOprDlg->ShowWindow(SW_SHOWNA);
	}
	else
		m_pSpeechOprDlg->ShowWindow(SW_HIDE);
}

void CMainFrame::OnUpdateViewSnaviDlg(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->Enable();
	pCmdUI->SetCheck(m_pSpeechOprDlg->IsWindowVisible());
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CMDIFrameWnd::OnSize(nType, cx, cy);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(m_pSpeechOprDlg)
	{
		if(m_pSpeechOprDlg->IsWindowVisible())
		{
			CRect rectDlg,rectWnd,rectNew;
			m_pSpeechOprDlg->GetWindowRect(&rectDlg);
			GetClientRect(&rectWnd);
			ClientToScreen(&rectDlg);
			ClientToScreen(&rectWnd);
			rectNew.top = rectWnd.top;
			rectNew.left = rectWnd.right - rectDlg.Width();
			rectNew.bottom = rectDlg.Height() + rectNew.top;
			rectNew.right = rectNew.left + rectDlg.Width();

			m_pSpeechOprDlg->MoveWindow(&rectNew);
		}
	}
}

void CMainFrame::OnMove(int x, int y) 
{
	CMDIFrameWnd::OnMove(x, y);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(m_pSpeechOprDlg)
	{
		if(m_pSpeechOprDlg->IsWindowVisible())
		{
			CRect rectDlg,rectWnd,rectNew;
			m_pSpeechOprDlg->GetWindowRect(&rectDlg);
			GetClientRect(&rectWnd);
			ClientToScreen(&rectDlg);
			ClientToScreen(&rectWnd);
			rectNew.top = rectWnd.top;
			rectNew.left = rectWnd.right - rectDlg.Width();
			rectNew.bottom = rectDlg.Height() + rectNew.top;
			rectNew.right = rectNew.left + rectDlg.Width();

			m_pSpeechOprDlg->MoveWindow(&rectNew);
		}
	}	
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	return CMDIFrameWnd::PreTranslateMessage(pMsg);
}
