//
// MMIVXetgGhVer1.1
// ͊Ǘ
//
// InputModality.h / InputModality.cpp
//
// 2002/12/11 Wed. G
//
//
//

#ifndef _INPUTMODALITY_H_
#define _INPUTMODALITY_H_

#pragma once

#include "InputInfo.h"
#include "Variables.h"
#include "InputManager.h"

using namespace std;

class CInputManager;

class CInputModality
{
protected:
	CInputManager* m_pMyManager;
	int m_ModalityID;
	bool m_State;

public:
	CInputModality( CInputManager* manager, int ModalityID );
	virtual ~CInputModality();

	int GetID();
	virtual bool Regist();
	virtual bool Release();

	virtual void OnBeforeUpdate();
	virtual void OnUpdateFinished();

	virtual void Input( CInputInfo& info );
	virtual void Input( const string& type, const string& event, const string& match, const string& target, const CVariables& vars );

	virtual string GetTypeAttribute() = 0;
	virtual list < string > GetEventAttribute() = 0;
	virtual bool Analyze( const string& path, const CInputInfo& info ) = 0;
};

#endif _INPUTMODALITY_H_
