//
// MMIVXe Ver.1.1 tgGh
// GUI
//
// InputListView.h / InputListView.cpp
//
// 2002/10/25 Fri. G
//
//
//

#include "stdafx.h"
#include "Kiosk.h"
#include "InputListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BEGIN_MESSAGE_MAP( CInputListView, CListCtrl)
	//{{AFX_MSG_MAP(CInputListView)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CInputListView::CInputListView()
{
}

CInputListView::~CInputListView()
{
}


void CInputListView::Initialize()
{
	LVCOLUMN col;
	ZeroMemory( &col, sizeof( LVCOLUMN ) );

	col.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	col.fmt = LVCFMT_LEFT;
	col.cx = 80;
	
	col.pszText = "Enable";
	col.iSubItem = 0;
	InsertColumn( 0, &col );

	col.pszText = "type";
	col.iSubItem = 1;
	InsertColumn( 1, &col );

	col.pszText = "event";
	col.iSubItem = 2;
	InsertColumn( 2, &col );

	col.pszText = "target";
	col.iSubItem = 3;
	InsertColumn( 3, &col );
	
	col.pszText = "return";
	col.iSubItem = 3;
	InsertColumn( 4, &col );
	
	col.pszText = "match";
	col.iSubItem = 3;
	InsertColumn( 5, &col );
}

void CInputListView::OnSize(UINT nType, int cx, int cy) 
{
	CRect rect;
	GetParent()->GetClientRect( &rect );

	LVCOLUMN col;
	ZeroMemory( &col, sizeof( LVCOLUMN ) );
	col.mask |= LVCF_WIDTH;

	int col_width = 0;
	int width = rect.right - rect.left;

	for( int i = 0; i < 5; i++ )
	{
		GetColumn( i, &col );
		col_width += col.cx;
	}

	if( col_width < width )
	{
		GetColumn( 5, &col );
		col.cx = width - col_width - GetSystemMetrics( SM_CXSIZEFRAME );
		SetColumn( 5, &col );
	}

	CListCtrl::OnSize(nType, cx, cy);
}

BOOL CInputListView::SetInput( CInputInfo& info )
{
	char enable[ COLUMN_ENABLE + 1 ];
	char type[ COLUMN_TYPE + 1 ];
	char event[ COLUMN_EVENT + 1 ];
	char target[ COLUMN_TARGET + 1];
	char ret[ COLUMN_RETURN + 1 ];
	char match[ COLUMN_MATCH + 1 ];

	memset( enable, '\0', COLUMN_ENABLE + 1 );
	memset( type, '\0', COLUMN_TYPE + 1 );
	memset( event, '\0', COLUMN_EVENT + 1 );
	memset( target, '\0', COLUMN_TARGET + 1 );
	memset( ret, '\0', COLUMN_RETURN + 1 );
	memset( match, '\0', COLUMN_MATCH + 1 );

	if( info.m_Enable ){ strcpy( enable, "T" ); }
	else { strcpy( enable, "F" ); }
	strncpy( type, info.GetTypeAttr().c_str(), COLUMN_TYPE );
	strncpy( event, info.GetEventAttr().c_str(), COLUMN_EVENT );
	strncpy( target, info.GetTargetAttr().c_str(), COLUMN_TARGET );
	strncpy( ret, info.GetVariablesPtr()->toXISL( false ).c_str(), COLUMN_RETURN );
	strncpy( match, info.GetMatchAttr().c_str(), COLUMN_MATCH );


	SetColumnItem( enable, type, event, target, ret, match );
	SetItemData( GetItemCount(), (LPARAM)&info );

	return TRUE;
}

void CInputListView::SetColumnItem( char* enable, char* type, char* event, char* target, char* ret, char* match )
{
	LVITEM item;
	ZeroMemory( &item, sizeof( LVITEM ));
	item.mask = LVIF_TEXT;

	item.pszText = enable;
	item.iSubItem = 0;
	item.iItem = GetItemCount();
	InsertItem( &item );

	item.pszText = type;
	item.iSubItem = 1;
	SetItem( &item );

	item.pszText = event;
	item.iSubItem = 2;
	SetItem( &item );

	item.pszText = target;
	item.iSubItem = 3;
	SetItem( &item );

	item.pszText = ret;
	item.iSubItem = 4;
	SetItem( &item );

	item.pszText = match;
	item.iSubItem = 5;
	SetItem( &item );
}

void CInputListView::Remove( int index )
{
	DeleteItem( index );
}

void CInputListView::RemoveAll()
{
	DeleteAllItems();
}
