//
// MMIVXetgGhVer1.1
// uEUǗW[
//
// IECtrl.h / IECtrl.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _IECTRL_H_
#define _IECTRL_H_

#pragma once

#include "OutputModality.h"
#include "IEFrame.h"
#include "IEModalDialog.h"
#include "ProcessTracer.h"
#include "MouseInput.h"

using namespace std;

class CIECtrl : public COutputModality  
{
private:
	class CCmdOpen : public COutputCommand
	{
	public:
		CCmdOpen( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdOpen();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdClose : public COutputCommand
	{
	public:
		CCmdClose( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdClose();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdNavigate : public COutputCommand
	{
	public:
		CCmdNavigate( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdNavigate();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdBack : public COutputCommand
	{
	public:
		CCmdBack( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdBack();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdReload : public COutputCommand
	{
	public:
		CCmdReload( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdReload();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdMax : public COutputCommand
	{
	public:
		CCmdMax( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdMax();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdMin : public COutputCommand
	{
	public:
		CCmdMin( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdMin();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdResize : public COutputCommand
	{
	public:
		CCmdResize( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdResize();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdMove : public COutputCommand
	{
	public:
		CCmdMove( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdMove();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdSet : public COutputCommand
	{
	public:
		CCmdSet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSet();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

	class CCmdGet : public COutputCommand
	{
	public:
		CCmdGet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdGet();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};


public:
	static const char* _TYPE_BROWSER;
	static const char* _EVENT_OPEN;
	static const char* _EVENT_CLOSE;
	static const char* _EVENT_MOVE;
	static const char* _EVENT_RESIZE;
	static const char* _EVENT_NAVIGATE;
	static const char* _EVENT_BACK;
	static const char* _EVENT_RELOAD;
	static const char* _EVENT_MAX;
	static const char* _EVENT_MIN;
	static const char* _EVENT_GET;
	static const char* _EVENT_SET;

private:
	CWnd* m_pParent;
	list < CIEFrame* > m_BrowserList;
	CProcessTracer* m_pProcessTracer;

public:
	bool m_IsModal;
	CIEModalDialog m_Modal;
	bool m_IsNavi;

public:
	CIECtrl( COutputManager* om, int ModalityID, CWnd* parent, CMouseInput* pMouseInput );
	virtual ~CIECtrl();
	
	void SetTracer( CProcessTracer* pTracer );
	CWnd* GetMainWnd();

	virtual string GetTypeAttribute();
	virtual list < string > GetEventAttribute();
	virtual COutputCommand* StoreCommand( const string& msg );
	virtual bool Execute();
	virtual bool Terminate();

	void ClearAll();

public:
	bool Open( const string& id );
	bool Close( const string& id );
	bool IsExist( const string& id );
	CIEFrame* Get( const string& id );
};

#endif _IECTRL_H_