//
// MMIVXetgGhVer1.1
// uEUǗW[
//
// IECtrl.h / IECtrl.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "IECtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif _DEBUG


//
// CIECtrl::CCmdOpen
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdOpen::CCmdOpen( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdOpen::~CCmdOpen()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
OUTPUT::EXECRESULT CIECtrl::CCmdOpen::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return OUTPUT::RESULT_FAILED;
	}

	string browser_id = *( param.GetValue() );
	if( !pCtrl->IsExist( browser_id ) )
	{
		if( !pCtrl->Open( browser_id ) )
		{
			Error( this, "s" );
			return RESULT_FAILED;;
		}
	}	

	m_EndState = _ENDOUTPUT_NORMAL;

	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdOpen::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdClose
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdClose::CCmdClose( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdClose::~CCmdClose()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdClose::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );


	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	if( pCtrl->m_IsModal )
	{
		if( pCtrl->m_Modal.m_IsValid == TRUE && pCtrl->m_Modal.m_ID == browser_id.c_str() )
		{
			pCtrl->m_Modal.EndDialog( IDOK );
		}
		pCtrl->m_IsModal = false;
		m_EndState = _ENDOUTPUT_NORMAL;
		return RESULT_SUCCEEDED;
	}
	else
	{
		pCtrl->Close( browser_id );
		m_EndState = _ENDOUTPUT_NORMAL;
	}
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdClose::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdNavigate
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdNavigate::CCmdNavigate( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdNavigate::~CCmdNavigate()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdNavigate::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "uri", param ) )
	{
		Error( this, "URL^ĂȂ" );
		return RESULT_FAILED;
	}

	string location = *( param.GetValue() );
	if( location.find( "://" ) == string::npos )
	{
		location.insert( 0, m_Path );
	}

	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	int width = -1;
	int height = -1;
	if( GetParam( "name", "width", param ) )
	{
		string str_width = *( param.GetValue() );
		width = atoi( str_width.c_str() );
	}

	if( GetParam( "name", "height", param ) )
	{
		string str_height = *( param.GetValue() );
		height = atoi( str_height.c_str() );
	}

	int px = -1;
	int py = -1;
	string pos;
	if( GetParam( "name", "position", param ) )
	{
		pos = (*param.GetValue());
	}

	if( GetParam( "name", "modal", param ) )
	{
		if( !pCtrl->m_IsModal )
		{
			pCtrl->m_Modal.m_ID = browser_id.c_str();
			pCtrl->m_Modal.m_Width = width;
			pCtrl->m_Modal.m_Height = height;
			pCtrl->m_Modal.m_Navigate = location.c_str();
			pCtrl->m_Modal.m_Position = pos.c_str();
			m_EndState = _ENDOUTPUT_NORMAL;
			return RESULT_OTHER;
		}
		m_EndState = _ENDOUTPUT_NORMAL;
		return RESULT_SUCCEEDED;
	}
	else
	{
		if( !pCtrl->m_IsModal )
		{
			CIEFrame* pBrowser = NULL;
			if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL )
			{
				if( !pCtrl->Open( browser_id ) )
				{
					return RESULT_FAILED;
				}
				pBrowser = pCtrl->Get( browser_id );
			}
			
			if( !pBrowser->IsZoomed() && !pBrowser->IsIconic() )
			{
				CRect rect;
				pBrowser->GetWindowRect( &rect );

				if( width == -1 )
					width = rect.right - rect.left;
				if( height == -1 )
					height = rect.bottom - rect.top;

				CRect rectParent;
				pCtrl->GetMainWnd()->GetClientRect( &rectParent );
				
				if( pos == "center" )
				{
					px = ( rectParent.right - width ) / 2;
					py = ( rectParent.bottom - height ) / 2;
				}
				else if( pos == "left-top" )
				{
					px = 0;
					py = 0;
				}
				else if( pos == "left-bottom" )
				{
					px = 0;
					py = rectParent.bottom - height;
				}
				else if( pos == "right-top" )
				{
					px = rectParent.right - width;
					py = 0;
				}
				else if( pos == "right-bottom" )
				{
					px = rectParent.right - width;
					py = rectParent.bottom - height;
				}
				else
				{
					px = rect.left;
					py = rect.top;
				}
				pBrowser->MoveWindow( px, py, width, height );
			}

			pCtrl->m_IsNavi = true;
			if( location.find(":") == string::npos )
			{
				location.insert( 0, m_Path );
				pBrowser->Navigate( location.c_str() );
			}
			else
			{
				pBrowser->Navigate( location.c_str() );
			}
			m_EndState = _ENDOUTPUT_NORMAL;
		}
		else
		{
			pCtrl->m_Modal.Navigate();
			m_EndState = _ENDOUTPUT_NORMAL;
		}
	}
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_CONTINUE;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdNavigate::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdBack
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdBack::CCmdBack( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdBack::~CCmdBack()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdBack::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	pBrowser->GoBack();
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdBack::Terminate()
{
	return RESULT_SUCCEEDED;
}



//
// CIECtrl::CCmdReload
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdReload::CCmdReload( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdReload::~CCmdReload()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdReload::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	pBrowser->Reload();

	m_EndState = _ENDOUTPUT_NORMAL;

	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdReload::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdMax
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMax::CCmdMax( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMax::~CCmdMax()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMax::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );
	
	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	pBrowser->MDIMaximize();
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMax::Terminate()
{
	return RESULT_SUCCEEDED;
}



//
// CIECtrl::CCmdMin
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMin::CCmdMin( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMin::~CCmdMin()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMin::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	pBrowser->CloseWindow();
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMin::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdResize
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdResize::CCmdResize( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdResize::~CCmdResize()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdResize::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL && pCtrl->m_Modal.m_ID != browser_id.c_str() )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	if( pCtrl->m_IsModal )
	{
		int height;
		int width;

		if( !GetParam( "name", "width", param ) )
			width = -1;
		else
		{
			string str_width = *( param.GetValue() );
			width = atoi( str_width.c_str() );
		}
		if( !GetParam( "name", "height", param ) )
			height = -1;
		else
		{
			string str_height = *( param.GetValue() );
			height = atoi( str_height.c_str() );
		}
		
		pCtrl->m_Modal.ResizeWnd( width, height );
	}
	else
	{
		if( pBrowser->IsIconic() || pBrowser->IsZoomed() )
		{
			pBrowser->MDIRestore();
		}

		CRect rect;
		pBrowser->GetWindowRect( &rect );
		int height;
		int width;

		if( !GetParam( "name", "width", param ) )
		{
			width = rect.right - rect.left;
		}
		else
		{
			string str_width = *( param.GetValue() );
			width = atoi( str_width.c_str() );
		}
		if( !GetParam( "name", "height", param ) )
		{
			height = rect.bottom - rect.top;
		}
		else
		{
			string str_height = *( param.GetValue() );
			height = atoi( str_height.c_str() );
		}

		pBrowser->SetWindowPos( NULL, 0, 0, width, height, SWP_NOMOVE );
	}

	m_EndState = _ENDOUTPUT_NORMAL;

	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdResize::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdMove
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMove::CCmdMove( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdMove::~CCmdMove()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMove::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "position", param ) )
	{
		Error( this, "ړʒu^ĂȂ" );
		return RESULT_FAILED;
	}
	string position = *( param.GetValue() );

	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );


	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL && pCtrl->m_Modal.m_ID != browser_id.c_str() )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	if( pCtrl->m_IsModal )
	{
		pCtrl->m_Modal.MoveWnd( position.c_str() );
	}
	else
	{
		if( !pBrowser->IsZoomed() && !pBrowser->IsIconic() )
		{
			CRect rect;
			pBrowser->GetWindowRect( &rect );
			int height = rect.bottom - rect.top;
			int width  = rect.right - rect.left;

			CRect rectParent;
			CWnd* pParent = pBrowser->GetParent();
			pParent->GetClientRect( &rectParent );

			pBrowser->MoveWnd( position.c_str() );
		}
	}
/*
	int cx, cy;
	if( position == "center" )
	{
		cx = ( rectParent.right - width ) / 2;
		cy = ( rectParent.bottom - height ) / 2;
	}
	else if( position == "left-top" )
	{
		cx = 0;
		cy = 0;
	}
	else if( position == "left-bottom" )
	{
		cx = 0;
		cy = rectParent.bottom - height;
	}
	else if( position == "right-top" )
	{
		cx = rectParent.right - width;
		cy = 0;
	}
	else if( position == "right-bottom" )
	{
		cx = rectParent.right - width;
		cy = rectParent.bottom - height;
	}
	else
	{
		Error( this, "ړw肪s" );
		return false;
	}

	pBrowser->SetWindowPos( NULL, cx, cy, 0, 0, SWP_NOSIZE );
*/
	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdMove::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// CIECtrl::CCmdSet
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdSet::CCmdSet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdSet::~CCmdSet()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdSet::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL && pCtrl->m_Modal.m_ID != browser_id.c_str() )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	list < COutputParam > param_list;
	if( !GetParam( "name", "value", param_list ) )
	{
		Error( this, "Zbgl^ĂȂ" );
		return RESULT_FAILED;
	}

	list < COutputParam > :: iterator ite = param_list.begin();
	while( ite != param_list.end() )
	{
		const string* object = ite->GetAttributeValue( "target" );
		const string* value = ite->GetValue();
		if( pCtrl->m_IsModal )
			pCtrl->m_Modal.SetValue( object->c_str(), value->c_str() );
		else
			pBrowser->SetValue( object->c_str(), value->c_str() );
		ite++;
	}

	m_EndState = _ENDOUTPUT_NORMAL;

	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdSet::Terminate()
{
	return RESULT_SUCCEEDED;
}


//
// CIECtrl::CCmdGet
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdGet::CCmdGet( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CCmdGet::~CCmdGet()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdGet::Execute()
{
	CIECtrl* pCtrl = static_cast< CIECtrl* >( m_pModality );
	pCtrl->Lock( true );

	COutputParam param;
	if( !GetParam( "name", "id", param ) )
	{
		Error( this, "uEUID^ĂȂ" );
		return RESULT_FAILED;
	}
	string browser_id = *( param.GetValue() );

	CIEFrame* pBrowser = NULL;
	if( ( pBrowser = pCtrl->Get( browser_id ) ) == NULL && pCtrl->m_Modal.m_ID != browser_id.c_str() )
	{
		Error( this, "uEUȂ" );
		return RESULT_FAILED;
	}

	list < COutputParam > param_list;
	if( !GetParam( "name", "var", param_list ) )
	{
		Error( this, "p[^Ȃ" );
		return RESULT_FAILED;
	}

	int var_num = m_Vars.GetSize();
	list < COutputParam > :: iterator ite = param_list.begin();
	while( ite != param_list.end() )
	{
		const string* var_name = ite->GetValue();
		const string* target = ite->GetAttributeValue( "target" );
		CString val;
		if( pCtrl->m_IsModal )
			val = pCtrl->m_Modal.GetValue( target->c_str() );
		else
			val = pBrowser->GetValue( target->c_str() );
		for( int i = 0; i < var_num; i++ )
		{
			const string* var_n = m_Vars.GetName( i );
			if( *var_n == *var_name )
			{
				m_Vars.SetValue( i, (LPCSTR)val );
			}
		}
		ite++;
	}

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
EXECRESULT CIECtrl::CCmdGet::Terminate()
{
	return RESULT_SUCCEEDED;
}



//
// CIECtrl
//

const char* CIECtrl::_TYPE_BROWSER = "browser";
const char* CIECtrl::_EVENT_NAVIGATE = "navigate";
const char* CIECtrl::_EVENT_BACK = "back";
const char* CIECtrl::_EVENT_OPEN = "open";
const char* CIECtrl::_EVENT_CLOSE = "close";
const char* CIECtrl::_EVENT_MOVE = "move";
const char* CIECtrl::_EVENT_RESIZE = "resize";
const char* CIECtrl::_EVENT_RELOAD = "reload";
const char* CIECtrl::_EVENT_MAX = "max";
const char* CIECtrl::_EVENT_MIN = "min";
const char* CIECtrl::_EVENT_GET = "get";
const char* CIECtrl::_EVENT_SET = "set";


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::CIECtrl( COutputManager* om, int ModalityID, CWnd* parent, CMouseInput* pMouseInput ) : COutputModality( om, ModalityID ), m_pParent( parent ), m_pProcessTracer( NULL ), m_IsNavi( false ), m_IsModal( false )
{
	m_Modal.m_pParent = parent;
	Regist();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIECtrl::~CIECtrl()
{
	Release();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CIECtrl::SetTracer( CProcessTracer* pTracer )
{
	m_pProcessTracer = pTracer;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
string CIECtrl::GetTypeAttribute()
{
	return _TYPE_BROWSER;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
list < string > CIECtrl::GetEventAttribute()
{
	list < string > events;
	events.push_back( _EVENT_NAVIGATE );
	events.push_back( _EVENT_OPEN );
	events.push_back( _EVENT_CLOSE );
	events.push_back( _EVENT_MOVE );
	events.push_back( _EVENT_RESIZE );
	events.push_back( _EVENT_RELOAD );
	events.push_back( _EVENT_MAX );
	events.push_back( _EVENT_MIN );
	events.push_back( _EVENT_GET );
	events.push_back( _EVENT_SET );
	return events;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
COutputCommand* CIECtrl::StoreCommand( const string& msg )
{
	string count, event, path;
	bool bargein;
	CVariables vars;
	list < COutputParam > pars;

	if( !AnalyzeOutput( msg, count, bargein, path, event, vars, pars ) )
	{
		Error( msg );
		return NULL;
	}


	COutputCommand* pCmd = NULL;
	if( event == _EVENT_OPEN )
	{
		CCmdOpen* pEvent = new CCmdOpen( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_CLOSE )
	{
		CCmdClose* pEvent = new CCmdClose( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_NAVIGATE )
	{
		CCmdNavigate* pEvent = new CCmdNavigate( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_GET )
	{
		CCmdGet* pEvent = new CCmdGet( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_SET )
	{
		CCmdSet* pEvent = new CCmdSet( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_RELOAD )
	{
		CCmdReload* pEvent = new CCmdReload( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_BACK )
	{
		CCmdBack* pEvent = new CCmdBack( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_MAX )
	{
		CCmdMax* pEvent = new CCmdMax( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_MIN )
	{
		CCmdMin* pEvent = new CCmdMin( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_MOVE )
	{
		CCmdMove* pEvent = new CCmdMove( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else if( event == _EVENT_RESIZE )
	{
		CCmdResize* pEvent = new CCmdResize( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pEvent );
	}
	else
	{
		Error( msg );
		return NULL;
	}

	m_Cmdlist.push_back( pCmd );

	return pCmd;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool CIECtrl::Execute()
{
	m_pProcessTracer->Write( "uEUǗ", " - <output>̎s" );
	EXECRESULT ret = (*m_Cmdlist.begin())->Execute();
	if( ret == RESULT_SUCCEEDED )
	{
		Finish();
		return true;
	}	
	else if( ret == RESULT_FAILED )
	{
		RemoveCommand();
		return false;
	}	
	else if( ret == RESULT_CONTINUE )
	{
		return true;
	}
	else if( ret == RESULT_OTHER )
	{
		m_IsNavi = true;
		m_IsModal = true;
		m_Modal.DoModal();
		return true;
	}
	return true;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool CIECtrl::Terminate()
{
	return true;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool CIECtrl::Open( const string& id )
{
	CIEFrame* pBrowser = ((CKioskApp*)AfxGetApp())->CreateBrowser();
	pBrowser->SetWndID( id.c_str() );
	m_BrowserList.push_back( pBrowser );
	return true;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool CIECtrl::Close( const string& id )
{
	CIEFrame* pBrowser = Get( id );
	if( pBrowser == NULL )
	{
		return false;
	}
	pBrowser->DestroyWindow();
	m_BrowserList.remove( pBrowser );
	return true;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CWnd* CIECtrl::GetMainWnd()
{
	return m_pParent;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
bool CIECtrl::IsExist( const string& id )
{
	// imi naina..
	if( !Get( id ) )
	{
		return false;
	}
	return true;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEFrame* CIECtrl::Get( const string& id )
{
	list < CIEFrame* > :: iterator ite = m_BrowserList.begin();

	while( ite != m_BrowserList.end() )
	{
		CIEFrame* pBrowser = static_cast< CIEFrame* >( *ite );
		if( id == pBrowser->GetWndID() )
		{
			return pBrowser;
		}
		ite++;
	}

	return NULL;
}

void CIECtrl::ClearAll()
{
	list < CIEFrame* > :: iterator ite = m_BrowserList.begin();
	while( ite != m_BrowserList.end() )
	{
		CIEFrame* pFrame = *ite;
		if( IsWindow( pFrame->m_hWnd ) )
		{
			pFrame->DestroyWindow();
		}
		ite++;
	}
	m_BrowserList.clear();

	m_Cmdlist.clear();
}


