//
// MMIVXe Ver.1.1 tgGh
// ʐM䕔
//
// Communicater.h / Communicater.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _COMMUNICATER_H_
#define _COMMUNICATER_H_

#include <winsock.h>
#include <string>

#include "MessageTracer.h"
#include "InputManager.h"
#include "OutputManager.h"

using namespace std;

class CInputManager;
class COutputManager;


class CCommunicater : public CWnd
{
public:
	static const char* _COMMAND_START_SESSION;
	static const char* _COMMAND_SEND_INPUT_NORMAL;
	static const char* _COMMAND_SEND_INPUT_INTERRUPT;
	static const char* _COMMAND_USER_INPUT;
	static const char* _COMMAND_EXECUTE_OUTPUT;
	static const char* _COMMAND_END_OUTPUT;
	static const char* _COMMAND_END_SESSION;
	static const char* _COMMAND_END_SYSTEM;
	static const char* _COMMAND_ERROR_OUTPUT;
	static const char* _COMMAND_ERROR_INPUT;
	static const char* _COMMAND_ERROR_SCENARIO;

	// ?
	static const char* _COMMAND_END_WORLD;

protected:
	CMessageTracer*		 m_pTracer;	
	CInputManager*		 m_pInputManager;
	COutputManager*		 m_pOutputManager;
	bool				 m_State;
	int					 m_MyPort;
	SOCKET				 m_Accept;
	SOCKET				 m_Recv;
	string				 m_Buff;
	struct sockaddr_in	 m_DMAddr;

	char *GetHostNameAndIP(DWORD *LocalIP);
	DWORD GetHostByNameAlias(const char *strHostName);

public:
	CCommunicater();
	virtual ~CCommunicater();

	bool Run();
	bool Stop();

	void Init( CInputManager* pInput, COutputManager* pOutput, CMessageTracer* pTracer );
	void SetMyNetCfg( int port );
	void SetDMAddr( const string& ip, int port = 20200 );
	void SetTracer( CMessageTracer* pTracer );
	void SetManager( CInputManager* pInput, COutputManager* pOutput );
	void Send( const string& cmd, const string& param );
	void AnalyzeMessage();

	int GetMyPort();
	struct sockaddr_in GetDMAddr();

	bool IsRunning();

	//{{AFX_VIRTUAL(CCommunicater)
protected:
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CCommunicater)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif _COMMUNICATER_H_
