// CFGEngineDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "kiosk.h"
#include "CFGEngineDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCFGEngineDlg _CAO


CCFGEngineDlg::CCFGEngineDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCFGEngineDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCFGEngineDlg)
	m_strAModel = _T("");
	m_strDFA = _T("");
	m_strDICT = _T("");
	m_strFSM = _T("");
	m_strGtalk = _T("");
	m_strJulian = _T("");
	m_strGenerate = _T("");
	m_cfgpath = FALSE;
	m_strSsmconf = _T("");
	//}}AFX_DATA_INIT
}


void CCFGEngineDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCFGEngineDlg)
	DDX_Text(pDX, IDC_EDIT_AMODEL, m_strAModel);
	DDX_Text(pDX, IDC_EDIT_DFA, m_strDFA);
	DDX_Text(pDX, IDC_EDIT_DICT, m_strDICT);
	DDX_Text(pDX, IDC_EDIT_FSM, m_strFSM);
	DDX_Text(pDX, IDC_EDIT_GTALK, m_strGtalk);
	DDX_Text(pDX, IDC_EDIT_JULIAN, m_strJulian);
	DDX_Text(pDX, IDC_EDIT_GENE, m_strGenerate);
	DDX_Check(pDX, IDC_CFG_PATH, m_cfgpath);
	DDX_Text(pDX, IDC_EDIT_SSMCONF, m_strSsmconf);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCFGEngineDlg, CDialog)
	//{{AFX_MSG_MAP(CCFGEngineDlg)
	ON_BN_CLICKED(IDC_BUTTON_AMODEL, OnButtonAmodel)
	ON_BN_CLICKED(IDC_BUTTON_DFA, OnButtonDfa)
	ON_BN_CLICKED(IDC_BUTTON_DICT, OnButtonDict)
	ON_BN_CLICKED(IDC_BUTTON_FSM, OnButtonFsm)
	ON_BN_CLICKED(IDC_BUTTON_GTALK, OnButtonGtalk)
	ON_BN_CLICKED(IDC_BUTTON_JULIAN, OnButtonJulian)
	ON_BN_CLICKED(IDC_BUTTON_GENE, OnButtonGene)
	ON_BN_CLICKED(IDC_CFG_DEFAULT, OnCfgDefault)
	ON_BN_CLICKED(IDC_BUTTON_SSMCONF, OnButtonSsmconf)
	ON_BN_CLICKED(IDC_CFG_PATH, OnCfgPath)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCFGEngineDlg bZ[W nh

void CCFGEngineDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	if(m_strAModel.IsEmpty() | m_strJulian.IsEmpty() | m_strDFA.IsEmpty() | m_strDICT.IsEmpty()
		| m_strFSM.IsEmpty() | m_strGtalk.IsEmpty() | m_strGenerate.IsEmpty() | m_strSsmconf.IsEmpty())
	{
		AfxMessageBox("ׂĂ̍ڂݒ肵Ă");
		return;
	}

	CWinApp *pApp = AfxGetApp();
	pApp->WriteProfileString("SRM","Path",m_strJulian);
	pApp->WriteProfileString("SRM","AModel",m_strAModel);
	pApp->WriteProfileString("SRM","DFA",m_strDFA);
	pApp->WriteProfileString("SRM","DICT",m_strDICT);
	pApp->WriteProfileString("SRM","Generate",m_strGenerate);
	pApp->WriteProfileInt("SRM","Port",10500);
	
	pApp->WriteProfileString("SSM","Path",m_strGtalk);
	if(m_cfgpath==TRUE){
		if(m_strSsmconf.Find("..\\..\\")==-1)
			pApp->WriteProfileString("SSM","ConfigFile",m_strSsmconf);
		else {
			MessageBox("SSM̐ݒt@C΃pXł͂ȂC΃pXŎw肳Ă܂D\n΃pXŎw肷邩CyW[̃pX΃pXŎw肷z̃`FbN͂Ă",NULL,MB_OK);
			return;
		}
	}
	else{
		m_strSsmconf=m_strGtalk;
		m_strSsmconf.Replace("gtalk.exe","ssm.conf");
		pApp->WriteProfileString("SSM","ConfigFile",m_strSsmconf);
	}
	pApp->WriteProfileInt("SSM","Port",10600);

	pApp->WriteProfileString("FSM","Path",m_strFSM);
	pApp->WriteProfileInt("FSM","Port",10700);

	pApp->WriteProfileInt("ENGINE","Validate",1);

	CDialog::OnOK();
}

void CCFGEngineDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	int index = MessageBox("GWݒ肵ȂƋNł܂D\nAvP[VI܂낵łH","x",MB_OKCANCEL|MB_ICONEXCLAMATION);
	if(index == IDOK){
		CWinApp *pApp = AfxGetApp();
		pApp->WriteProfileInt("ENGINE","Validate",0);
		exit(0);
	}
//		CDialog::OnCancel();
}

void CCFGEngineDlg::OnButtonAmodel() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"gz","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"f(*.gz)|*.gz|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strAModel="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			 m_strAModel += str.Right(dir_length-enginefulder_length);
			 str.ReleaseBuffer();
		}
		else
			m_strAModel = fileDlg.GetPathName();
	}
	UpdateData(FALSE);	
}

void CCFGEngineDlg::OnButtonDfa() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"dfa","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"@t@C(*.dfa)|*.dfa|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strDFA="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			 m_strDFA += str.Right(dir_length-enginefulder_length);
			 str.ReleaseBuffer();
		}
		else
			m_strDFA = fileDlg.GetPathName();
	}
	UpdateData(FALSE);
}

void CCFGEngineDlg::OnButtonDict() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ	
	UpdateData();
	CFileDialog fileDlg(TRUE,"dict","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"t@C(*.dict)|*.dict|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strDICT="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			m_strDICT += str.Right(dir_length-enginefulder_length);
			str.ReleaseBuffer();
		}
		else
			m_strDICT = fileDlg.GetPathName();
	}
	UpdateData(FALSE);
}

void CCFGEngineDlg::OnButtonFsm() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"exe","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"fsm(*.exe)|*.exe|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strFSM="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			m_strFSM += str.Right(dir_length-enginefulder_length);
			str.ReleaseBuffer();
		}
		else
			m_strFSM = fileDlg.GetPathName();
	}
	UpdateData(FALSE);	
}

void CCFGEngineDlg::OnButtonGtalk() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"exe","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"gtalk(*.exe)|*.exe|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strGtalk="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			m_strGtalk += str.Right(dir_length-enginefulder_length);
			str.ReleaseBuffer();
		}
		else
			m_strGtalk = fileDlg.GetPathName();
	}
	UpdateData(FALSE);	
}

void CCFGEngineDlg::OnButtonJulian() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"exe","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"Julian(*.exe)|*.exe|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strJulian="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			m_strJulian += str.Right(dir_length-enginefulder_length);
			str.ReleaseBuffer();
		}
		else
			m_strJulian = fileDlg.GetPathName();
	}
	UpdateData(FALSE);
}

void CCFGEngineDlg::OnButtonGene() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"exe","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"Generate(*.exe)|*.exe|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		if(m_cfgpath==FALSE){
			m_strGenerate="..\\..\\";
			CString str = fileDlg.GetPathName();
			int dir_length = str.GetLength();
			int enginefulder_length = str.Find("engine");
			m_strGenerate += str.Right(dir_length-enginefulder_length);
			str.ReleaseBuffer();
		}
		else
			m_strGenerate = fileDlg.GetPathName();
	}
	UpdateData(FALSE);
	
}

void CCFGEngineDlg::OnCfgDefault() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_strJulian = "..\\..\\engine\\SRM\\bin\\julian.exe";
	m_strAModel = "..\\..\\engine\\SRM\\AcousticModel\\hmmdefs,mono16mix,gid.gz";
	m_strDFA = "..\\..\\engine\\SRM\\GramJulian\\intro\\intro.dfa";
	m_strDICT = "..\\..\\engine\\SRM\\GramJulian\\intro\\intro.dict";
	m_strGenerate = "..\\..\\engine\\SRM\\bin\\generate.exe";
	m_strGtalk = "..\\..\\engine\\SSM\\gtalk-1.0\\gtalk.exe";
	m_strFSM = "..\\..\\engine\\FSM\\bin\\fsm_mmi.exe";
	m_strSsmconf = "..\\..\\engine\\SSM\\gtalk-1.0\\ssm.conf";
	UpdateData(FALSE);
}

BOOL CCFGEngineDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	//AvP[VIuWFNg擾
	CWinApp *pApp = AfxGetApp();
	m_strJulian = pApp->GetProfileString("SRM","Path","..\\..\\engine\\SRM\\bin\\julian.exe");
	m_strAModel = pApp->GetProfileString("SRM","AModel","..\\..\\engine\\SRM\\AcousticModel\\hmmdefs,mono16mix,gid.gz");
	m_strDFA = pApp->GetProfileString("SRM","DFA","..\\..\\engine\\SRM\\GramJulian\\intro\\intro.dfa");
	m_strDICT = pApp->GetProfileString("SRM","DICT","..\\..\\engine\\SRM\\GramJulian\\intro\\intro.dict");
	m_strGenerate = pApp->GetProfileString("SRM","Generate","..\\..\\engine\\SRM\\bin\\generate.exe");
	m_strGtalk = pApp->GetProfileString("SSM","Path","..\\..\\engine\\SSM\\gtalk-1.0\\gtalk.exe");
	m_strSsmconf = pApp->GetProfileString("SSM","ConfigFile","..\\..\\engine\\SSM\\gtalk-1.0\\ssm.conf");
	m_strFSM = pApp->GetProfileString("FSM","Path","..\\..\\engine\\FSM\bin\\fsm.exe");
	m_cfgpath=FALSE;
	//ssm.conf̎w𖳌ɂ
	CEdit *pEdit=(CEdit *)GetDlgItem(IDC_EDIT_SSMCONF);
	CButton *pButton = (CButton *)GetDlgItem(IDC_BUTTON_SSMCONF);
	pEdit->EnableWindow(FALSE);
	pButton->EnableWindow(FALSE);
	UpdateData(FALSE);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CCFGEngineDlg::OnButtonSsmconf() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	CFileDialog fileDlg(TRUE,"exe","",
		OFN_EXPLORER|OFN_FILEMUSTEXIST|OFN_NONETWORKBUTTON,
		"ssm(*.conf)|*.conf|");
	
	char chrCurrent[MAX_PATH];
	::GetCurrentDirectory(MAX_PATH,(LPTSTR)chrCurrent);
	fileDlg.m_ofn.lpstrInitialDir = chrCurrent;
	if(fileDlg.DoModal() == IDOK){
		m_strSsmconf = fileDlg.GetPathName();
	}
	UpdateData(FALSE);
}

void CCFGEngineDlg::OnCfgPath() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if(m_cfgpath==FALSE){
		m_cfgpath = TRUE;
		//ssm.conf̐ݒLɂ
		CEdit *pEdit=(CEdit *)GetDlgItem(IDC_EDIT_SSMCONF);
		CButton *pButton = (CButton *)GetDlgItem(IDC_BUTTON_SSMCONF);
		pEdit->EnableWindow(TRUE);
		pButton->EnableWindow(TRUE);
	}
	else {
		m_cfgpath = FALSE;
		//ssm.conf̎w𖳌ɂ
		CEdit *pEdit=(CEdit *)GetDlgItem(IDC_EDIT_SSMCONF);
		CButton *pButton = (CButton *)GetDlgItem(IDC_BUTTON_SSMCONF);
		pEdit->EnableWindow(FALSE);
		pButton->EnableWindow(FALSE);
	}
}
