//
// XMLt@CǗW[
// 
// XMLManager.h / XMLManager.cpp
//
// 2001/11/13 Tue. JF
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "stdafx.h"
#include <string.h>
#include <string>

#include <assert.h>

#include "XMLManager.h"

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//

//
// NX CXMLManager
//

//
// ֐ : CXMLManager::CXMLManager()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CXMLManager::CXMLManager()
{
	m_pDocument = NULL;
}

//
// ֐ : CXMLManager::~CXMLManager()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CXMLManager::~CXMLManager()
{
	if ( m_pDocument != NULL ) {
		m_pDocument->Release();
	}
}

//
// ֐ : int CXMLManager::LoadFile( const char *filename )
// @  \ : XMLǂݍށit@Cj
//    : filename --- XML̃t@C
// ߂l : 0Cs0ȊOԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CXMLManager::LoadFile( const char *filename )
{
	if ( m_pDocument != NULL ) { m_pDocument->Release(); }
	// COMCȕ
	CoInitialize( NULL );

	// MSXML2::IXMLDOMDocument IuWFNg̐
	CoCreateInstance( MSXML2::CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER, MSXML2::IID_IXMLDOMDocument, (void**)&m_pDocument );

	// 񓯊̓ǂݍ݂OFFɂ
	m_pDocument->put_async( VARIANT_FALSE );

	VARIANT vFile = AsciiToVARIANT( filename );
	VARIANT_BOOL vb;
	HRESULT hr;

	hr = m_pDocument->load( vFile, &vb );
	if ( FAILED( hr ) || ( vb == VARIANT_FALSE ) ) { return -1; }
	
	return 0;
}

//
// ֐ : int CXMLManager::LoadXML( const char *source )
// @  \ : XMLǂݍށi񂩂j
//    : source --- XML\(ASCII)
// ߂l : 0Cs0ȊOԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CXMLManager::LoadXML( const char *source )
{
	if ( m_pDocument != NULL ) { m_pDocument->Release(); }
	// COMCȕ
	CoInitialize( NULL );

	// MSXML2::IXMLDOMDocument IuWFNg̐
	CoCreateInstance( MSXML2::CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER, MSXML2::IID_IXMLDOMDocument, (void**)&m_pDocument );

	// 񓯊̓ǂݍ݂OFFɂ
	m_pDocument->put_async( VARIANT_FALSE );

	BSTR bstrSource = AsciiToBSTR( source );
	VARIANT_BOOL vb;
	HRESULT hr;

	hr = m_pDocument->loadXML( bstrSource, &vb );
	::SysFreeString( bstrSource );
	if ( FAILED( hr ) || ( vb == VARIANT_FALSE ) ) { return -1; }

	return 0;
}

//
// ֐ : int CXMLManager::FindeNodesByTagName( const char *tag, XMLNodeArray &array );
// @  \ : w肵^Ovf擾
//    : tag ---- ^O̖O
//			array -- vfi[z
// ߂l : 擾ɐ΁C擾vf̐CsȂ畉̒lԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CXMLManager::FindNodesByTagName( const char *tag, XMLNodeArray &array )
{
	try {
		if ( m_pDocument == NULL ) { throw -1; }
		array.clear();
		
		// JnB
		MSXML2::IXMLDOMNodeList *pList  = NULL;
		MSXML2::IXMLDOMNode		*pChild = NULL;
		long length;
		HRESULT hr;
		hr = m_pDocument->get_childNodes( &pList );
		if ( FAILED( hr ) ) { throw -2; }
		
		pList->get_length( &length );
		for ( long i = 0; i < length; i ++ ) {
			hr = pList->get_item( i, &pChild );
			if ( FAILED( hr ) ) { continue; }
			FindNodesByTagName( tag, pChild, array );
		}
		pList->Release();
	}
	catch ( int error ) {		// G[
		return error;
	}

	return array.size();		// 擾vfԂ
}


//
// ֐ : int CXMLManager::FindNodesByTagName( const char *tag, MSXML2::IXMLDOMNode *pNode, XMLNodesArray &array )
// @  \ : w肵^Ovf擾iċAĂяopj
//    : tag ---- ^O
//			pNode -- Ώۂ̃m[h
//			array -- ʂi[z
// ߂l : 擾ɐC擾vf̐CsȂ畉̒lԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CXMLManager::FindNodesByTagName( const char *tag, MSXML2::IXMLDOMNode *pNode, XMLNodeArray &array )
{
	if ( pNode == NULL ) { throw -2; }

	// ܂CpNodeɂĒׂB
	// 1.m[h̎ނ𒲂ׂ
	MSXML2::DOMNodeType type;
	HRESULT hr = pNode->get_nodeType( &type );
	if ( FAILED( hr ) ) { throw -3; }
	
	if ( type == MSXML2::NODE_ELEMENT ) {
		// m[h^Cvvf
		// 2.Ƀ^O𒲂ׂ
		BSTR bstrNodeName;
		char strNodeName[ NODENAME_LENGTH + 1 ];

		hr = pNode->get_nodeName( &bstrNodeName );
		if ( FAILED( hr ) ) { throw -3; }
		BSTRToAscii( bstrNodeName, strNodeName, NODENAME_LENGTH );
		::SysFreeString( bstrNodeName );

		if ( ! strcmp( strNodeName, tag ) ) {
			// ^OȂCXgɒǉ
			array.push_back( pNode );
		}

		// qm[hɂĂׂB
		MSXML2::IXMLDOMNodeList *pList = NULL;
		hr = pNode->get_childNodes( &pList );
		if ( FAILED( hr ) ) { throw -3; }
		
		long length;
		pList->get_length( &length );
		for ( long i = 0; i < length; i ++ ) {
			MSXML2::IXMLDOMNode *pChild = NULL;
			hr = pList->get_item( i, &pChild );
			if ( FAILED( hr ) ) { continue; }

			try {
				FindNodesByTagName( tag, pChild, array );
			}
			catch ( int error ) {
				throw error;
			}
		}
		pList->Release();
	}

	return array.size();
}

//
// ֐ : int CXMLManager::GetAttributes( MSXML2::IXMLDOMNode *pNode, XMLAttributeList &attr )
// @  \ : m[hɕt鑮擾
//    : pNode --- m[h
//			attr ---- Ƒl̑΂̃Xg
// ߂l : 擾̐
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CXMLManager::GetAttributes( MSXML2::IXMLDOMNode *pNode, XMLAttributeList &attr )
{
	try {
		if ( pNode == NULL ) { throw -1; }

		attr.clear();

		// ܂Cm[h̎ނ`FbNiƂ肠CNODE_ELEMENT̂݁j
		MSXML2::DOMNodeType type;
		pNode->get_nodeType( &type );
		if ( type != MSXML2::NODE_ELEMENT ) { return 0; }

		// 𒲂ׂB
		MSXML2::IXMLDOMNamedNodeMap *pNodeMap = NULL;
		MSXML2::IXMLDOMNode *pAttr = NULL;
		MSXML2::IXMLDOMNode *pAttrValue = NULL;
		HRESULT hr;
		BSTR bstrName;
		VARIANT vValue;
		char strName[ NODENAME_LENGTH + 1 ], strValue[ NODENAME_LENGTH + 1 ];
		long length;

		hr = pNode->get_attributes( &pNodeMap );
		if ( FAILED( hr ) ) { throw -2; }
		
		pNodeMap->get_length( &length );

		// BSTRASCIIցBƑlyAɂăXgɒǉ
		for ( long i = 0; i < length; i ++ ) {
			hr = pNodeMap->get_item( i, &pAttr );
			if ( FAILED( hr ) ) { continue; }
			// 擾
			hr = pAttr->get_nodeName( &bstrName );
			BSTRToAscii( bstrName, strName, NODENAME_LENGTH );
			::SysFreeString( bstrName );

			// l擾
			hr = pAttr->get_firstChild( &pAttrValue );
			if ( FAILED( hr ) || ( pAttrValue == NULL ) ) { continue; }
			hr = pAttrValue->get_nodeValue( &vValue );
			if ( FAILED( hr ) ) { continue; }
			VARIANTToAscii( vValue, strValue, NODENAME_LENGTH );
			VariantInit( &vValue );

			// Xgɒǉ
			attr.insert( pair < string, string >( strName, strValue ) );
		}
		pNodeMap->Release();
	}
	catch ( int error ) {
		return error;
	}

	return attr.size();
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//



//
// ֐ : BSTR CXMLManager::AsciiToBSTR(LPCTSTR pszAscii)
// @  \ : ASCIIBSTR^ɕϊ
//    : pszAscii -- ϊ镶
// ߂l : ϊ̕ւ̃|C^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
BSTR CXMLManager::AsciiToBSTR(LPCTSTR pszAscii)
{
	int len = MultiByteToWideChar(CP_ACP, 0, pszAscii, -1, NULL, 0);
	if (len < 1)
	len = lstrlen(pszAscii) * 2;
	wchar_t *pWStr = new wchar_t[len + 1];
	::MultiByteToWideChar(CP_ACP, 0, pszAscii, -1, pWStr, len + 1);
	BSTR wstr = SysAllocString(pWStr);
	delete(pWStr);
	return wstr;
}


//
// ֐ : LPTSTR CXMLManager::BSTRToAscii( BSTR wstr, LPTSTR astr, int len) 
// @  \ : BSTR^ASCIIɕϊ
//    : wstr ---- ϊ镶
//			astr ---- ϊ̕i[̈ւ̃|C^
//			len  ---- astr̒
// ߂l : astr ̃|C^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
LPTSTR CXMLManager::BSTRToAscii( BSTR wstr, LPTSTR astr, int len )
{
	::WideCharToMultiByte(CP_ACP, 0, wstr, -1, astr, len, NULL, NULL);
	return  (astr);
}

//
// ֐ : VARIANT CXMLManager::AsciiToVARIANT(LPCTSTR pszAscii)
// @  \ : ACSII񂩂VARIANT^ւ̕ϊ
//    : pszAscii --- ϊ镶
// ߂l : ϊVARIANT\
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
VARIANT CXMLManager::AsciiToVARIANT(LPCTSTR pszAscii)
{
	VARIANT vStr;
	VariantInit(&vStr);
	BSTR pBURL = AsciiToBSTR(pszAscii);
	vStr.vt = VT_BSTR;
	V_BSTR(&vStr) = pBURL;
	return vStr;
}


//
// ֐ : LPTSTR CXMLManager::VARIANTToAscii(VARIANT &value, LPTSTR buff, int len )
// @  \ : VARIANT^ACSIIւ̕ϊ
//    : value --- ϊVARIANT\
//			buff ---- ϊ̕i[̈ւ̃|C^
//			len ----- i[łő̃TCY
// ߂l : buff ̃|C^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
LPTSTR CXMLManager::VARIANTToAscii(VARIANT &value, LPTSTR buff, int len )
{
	BSTRToAscii(V_BSTR(&value), buff, len );
	return buff;
}

//
// ֐ : string CXMLManager::GetNodeName( MSXML2::IXMLDOMNode *pNode )
// @  \ : w肳ꂽm[h̖O擾
//    : pNode --- Ώۂ̃m[h
// ߂l : 擾łm[h
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
string CXMLManager::GetNodeName( MSXML2::IXMLDOMNode *pNode )
{
	assert( pNode != NULL );

	BSTR bstrName;
	char strName[ NODENAME_LENGTH + 1 ];
	HRESULT hr;

	hr = pNode->get_nodeName( &bstrName );
	assert( SUCCEEDED( hr ) );

	BSTRToAscii( bstrName, strName, NODENAME_LENGTH );

	::SysFreeString( bstrName );

	return string( strName );
}

//
// ֐ : string CXMLManager::GetNodeValue( MSXML2::IXMLDOMNode *pNode )
// @  \ : w肳ꂽm[h̒l擾
//    : pNode -- Ώۂ̃m[h
// ߂l : 擾l
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
string CXMLManager::GetNodeValue( MSXML2::IXMLDOMNode *pNode )
{
	assert( pNode != NULL );

	MSXML2::IXMLDOMNode *pChild = NULL;
	HRESULT hr;

	hr = pNode->get_firstChild( &pChild );
	if ( FAILED( hr ) || ( pChild == NULL ) ) { return ""; }

	MSXML2::DOMNodeType type;
	hr = pChild->get_nodeType( &type );
	if ( FAILED( hr ) || ( type != MSXML2::NODE_TEXT ) ) {
		return "";
	}

	VARIANT var;
	char value[ NODENAME_LENGTH + 1 ];

	::VariantInit( &var );
	hr = pChild->get_nodeValue( &var );
	if ( FAILED( hr ) ) { return ""; }
	VARIANTToAscii( var, value, NODENAME_LENGTH );
	::VariantInit( &var );

	return value;
}


//
// ֐ : int CXMLManager::GetChildNodes( MSXML2::IXMLDOMNode *pNode, XMLNodeArray &array )
// @  \ : qm[h
//    : pNode ---- m[h
//			array ---- qm[hi[郊Xg
// ߂l : 擾qm[h̐
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CXMLManager::GetChildNodes( MSXML2::IXMLDOMNode *pNode, XMLNodeArray &array )
{
	assert( pNode != NULL );

	array.clear();

	MSXML2::IXMLDOMNodeList *pNodeList = NULL;
	HRESULT hr;

	hr = pNode->get_childNodes( &pNodeList );
	if ( FAILED( hr ) ) { return -1; }

	long len;
	pNodeList->get_length( &len );
	MSXML2::IXMLDOMNode *pChild = NULL;

	for ( long i = 0; i < len; i ++ ) {
		pNodeList->get_item( i, &pChild );
		if ( pChild != NULL ) {
			array.push_back( pChild );
		}
		pChild = NULL;
	}

	return array.size();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//

