//
// MMIVXe Ver.1.1 ͓
// ͓W[
//
// XISLNodeList.h / XISLNodeList.cpp
//
// 2002/07/07 Sun. G
// g͑J񂪍܂
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _XISLNODELIST_H_
#define _XISLNODELIST_H_

#include <string>
#include <set>

using namespace std;

//
// XISLNONTERMINALTYPE 񋓌^
//
enum XISLNODETYPE
{
	TYPE_NODE_UNKNOWN = -1,		// s
	TYPE_NODE_DIALOG,			// <dialog>
	TYPE_NODE_EXCHANGE,			// <exchange>
	TYPE_NODE_COMBINATION,		// <???_exchange> & <???_input>
};

//
// CXISLNodeInfo
//
class CXISLNodeInfo
{
private:
	string m_strNodeName;		// m[h  \̔I[L
	XISLNODETYPE m_nNodeType;	// m[h̎ށireducȅ߂)

public:
	CXISLNodeInfo();
	CXISLNodeInfo( string &nodename, XISLNODETYPE type = TYPE_NODE_UNKNOWN );
	CXISLNodeInfo( const CXISLNodeInfo &info );

	virtual ~CXISLNodeInfo();

public:
	string		 GetNodeName() const;
	XISLNODETYPE GetNodeType() const;

	void SetNodeInfo( string &nodename, XISLNODETYPE type );

public:
	CXISLNodeInfo &operator = ( const CXISLNodeInfo &info );
	bool operator == ( const CXISLNodeInfo &info ) const;
	bool operator < ( const CXISLNodeInfo &info ) const;
};


//
// CXISLNodeList
//
class CXISLNodeList
{
private:
	set < CXISLNodeInfo > m_NodeInfoList;		// m[hXg

public:
	CXISLNodeList();
	CXISLNodeList( const CXISLNodeList &nodelist );
	
	virtual ~CXISLNodeList();

public:
	int GetNodeCount();

	CXISLNodeInfo GetNodeInfo( int index );
	CXISLNodeInfo GetNodeInfo( string &nodename );

	int AddNodeInfo( CXISLNodeInfo &info );

	const set < CXISLNodeInfo > &GetNodeList() const;

	void Init();

public:
	CXISLNodeList &operator = ( CXISLNodeList &nodelist );
};

#endif _XISLNODELIST_H_