//
// SLR(1)\͊쐬vO
// L\
//
// SymbolTable.h / SymbolTable.cpp
//
// 2001/10/30 Tue. JF
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <iostream>

#include "SymbolTable.h"

using namespace std;

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

//
// NX CSymbol
//


//
// ֐ : CSymbol::CSymbol()
// @  \ : ftHgRXgN^
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

CSymbol::CSymbol()
{
	m_strSymbol[0] = '\0';
	m_nType = SYMBOL_UNKNOWN;
}

//
// ֐ : CSymbol::CSymbol( const char *sym, SYMBOLTYPE type )
// @  \ : RXgN^ELݒ肷
//    : sym ---- L
//			type --- L^Cv
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

CSymbol::CSymbol( const char *sym, SYMBOLTYPE type )
{
	try {
		SetSymbol( sym, type );
	}
	catch ( int ) {
	}
}


//
// ֐ : CSymbol::CSymbol( const CSymbol& sym )
// @  \ : Rs[RXgN^
//    : sym --- Rs[
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CSymbol::CSymbol( const CSymbol &sym )
{
	strcpy( m_strSymbol, sym.GetSymbol() );
	m_nType = sym.GetSymType();
}

//
// ֐ : CSymbol::~CSymbol()
// @  \ : fXgN^
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

CSymbol::~CSymbol()
{
}


//
// ֐ : const char *CSymbol::GetSymbol() const
// @  \ : L擾
//    : Ȃ
// ߂l : L\
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

const char *CSymbol::GetSymbol() const
{
	return m_strSymbol;
}


//
// ֐ : SYMBOLTYPE CSymbol::GetSymType() const
// @  \ : L^Cv擾
//    : Ȃ
// ߂l : 񋓌^SYMBOLTYPE ̒l
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

SYMBOLTYPE CSymbol::GetSymType() const
{
	return m_nType;
}

//
// ֐ : void CSymbol::SetSymbol( const char *sym, SYMBOLTYPE type )
// @  \ : Lݒ肷
//    : sym ---- L
//			type --- L^Cv
// ߂l : void
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

void CSymbol::SetSymbol( const char *sym, SYMBOLTYPE type ) throw ( int )
{
	try {
		if ( sym == NULL ) { throw -1; }

		// L
		// sym̒SYMBOL_LENGTH蒷Ƃ́CSYMBOL_LENGTHRs[Ȃ
		int pos = 0;
		while ( ( sym[ pos ] != '\0' ) && ( pos < SYMBOL_LENGTH ) ) {
			m_strSymbol[ pos ] = sym[ pos ];
			pos ++;
		}
		m_strSymbol[ pos ] = '\0';

		// L^Cv
		m_nType = type;
	}
	catch ( int error ) {	// O
		throw error; 
	}
}

//
// ֐ : CSymbol &CSymbol::operator = ( const CSymbol &sym )
// @  \ : Zq
//    : sym ---- Rs[CSymbolIuWFNgւ̎Q
// ߂l : ̎IuWFNgւ̎Q
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
CSymbol &CSymbol::operator = ( const CSymbol &sym )
{
	if ( &sym == this ) { return *this; }	// ӂ̃IuWFNg

	// 
	SetSymbol( sym.GetSymbol(), sym.GetSymType() );	

	return *this;
}



//
// ֐ : void CSymbol::Display()
// @  \ : o
//    : s --- o̓Xg[
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
void CSymbol::Display()
{
	cout << "[" << m_strSymbol << ", ";
	switch ( m_nType ) {
	case SYMBOL_TERMINAL:    cout << "TERMINAL"; break;
	case SYMBOL_NONTERMINAL: cout << "NONTERMINAL"; break;
	default:				 cout << "UNKNOWN"; break;
	}

	cout << "]";
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//


//
// NX CSymbolTable 
//


//
// ֐ : CSymbolTable::CSymboltable()
// @  \ : ftHgRXgN^
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
CSymbolTable::CSymbolTable()
{
}


//
// ֐ : CSymbolTable::~CSymbolTable()
// @  \ : fXgN^
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
CSymbolTable::~CSymbolTable()
{
	RemoveAll();
}


//
// ֐ : int CSymbolTable::GetSize() const
// @  \ : o^ĂL̐ԂB
//    : Ȃ
// ߂l : o^ĂL
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G
//

int CSymbolTable::GetSize() const
{
	return m_SymbolTable.size();
}

//
// ֐ : int CSymbolTable::RemoveAll()
// @  \ : o^Sč폜
//    : Ȃ
// ߂l : void
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
void CSymbolTable::RemoveAll()
{
	int size = m_SymbolTable.size();
	map < string, CSymbol * >::iterator mp = m_SymbolTable.begin();

	while ( mp != m_SymbolTable.end() ) {
		delete (CSymbol*)mp->second;
		mp ++;
	}

	m_SymbolTable.clear();
}

//
// ֐ : int CSymbolTable::AddSymbol( const char *sym, SYMBOLTYPE type )
// @  \ : L\ɒǉ
//    : sym ---- L
//			type --- L^Cv
// ߂l : Βǉ̗vfCsȂ畉̒lԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

int CSymbolTable::AddSymbol( const char *sym, SYMBOLTYPE type )
{
	try {
		// CSymbolIuWFNg𐶐
		CSymbol *pSym = new CSymbol( sym, type );
		if ( pSym == NULL ) { throw -2; }

		// ̃Zbg
		pSym->SetSymbol( sym, type );

		// }bvւ̒ǉ
		m_SymbolTable.insert( pair < string, CSymbol * >( sym, pSym ) );
		
	} 
	catch ( int error ) {	// O
		return error;
	}

	return m_SymbolTable.size();		// o^Ԃ
}

//
// ֐ : int CSymbolTable::RemoveSymbol( const char *sym )
// @  \ : L\폜
//    : sym --- 폜L
// ߂l : Ȃ폜̗vfCs畉̒l
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::RemoveSymbol( const char *sym )
{
	try {
		// vf擾
		map < string, CSymbol * >::iterator dp = m_SymbolTable.find( sym );
		if ( dp == m_SymbolTable.end() ) { throw -3; }
		
		// CSymbolIuWFNg̍폜
		delete (CSymbol*)dp->second;

		// }bṽZ폜
		m_SymbolTable.erase( dp );
		
	} 
	catch ( int error ) {
		return error;
	}

	return m_SymbolTable.size();
}

//
// ֐ : int CSymbolTable::RemoveSymbol( int index )
// @  \ : L\폜
//    : index --- 폜L̈ʒu
// ߂l : Ȃ폜̗vfCs畉̒l
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::RemoveSymbol( int index )
{
	try {
		if ( ( index < 0 ) || ( index >= m_SymbolTable.size() ) ) { throw -4; }

		// vf̌
		map < string, CSymbol * >::iterator dp = m_SymbolTable.begin();
		while ( ( index > 0 ) && ( dp != m_SymbolTable.end() ) ) {
			dp ++;
			index --;
		}

		// Ƃ́Cvf폜
		if ( ( index == 0 ) && ( dp != m_SymbolTable.end() ) ) {
			delete (CSymbol*)dp->second;
			m_SymbolTable.erase( dp );
		}
		else { throw -5; }		// vfȂ
	} 
	catch ( int error ) {
		return error;
	}

	return m_SymbolTable.size();
}

//
// ֐ : SYMBOLTYPE CSymbolTable::GetSymType( const char *sym )
// @  \ : w肵L̃^Cv擾
//    : sym ---- ^Cv擾L
// ߂l : w肵L̃^Cv
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
SYMBOLTYPE CSymbolTable::GetSymType( const char *sym )
{
	try {
		map < string, CSymbol * >::iterator sp = SearchSymbol( sym );
		return (sp->second)->GetSymType();
	}
	catch ( ... ) {
		return SYMBOL_UNKNOWN;
	}
}

//
// ֐ : bool CSymbolTable::ExistSymbol( const char *sym )
// @  \ : w肵L\ɑ݂邩ǂ𒲂ׂ
//    : sym ---- L
// ߂l : L\Ɏw肵L݂tureCȂꂪfalseԂB
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
bool CSymbolTable::ExistSymbol( const char *sym )
{
	try {
		if ( SearchSymbol( sym ) != m_SymbolTable.end() ) {	return true;  }	// 
		else									  { return false; }	// ȂB
	}
	catch ( ... ) {	// O!
		return false;
	}
}


//
// ֐ : int CSymbolTable::GetTerminalSymTable( CSymbolTable &table )
// @  \ : I[L̋L\
//    : table --- o͂L\̃IuWFNgւ̎Q
// ߂l : ɐC̕\̗vfCsȂ畉̒lԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::GetTerminalSymTable( CSymbolTable &table )
{
	return GetSubTable( SYMBOL_TERMINAL, table );
}

//
// ֐ : int CSymbolTable::GetNonTerminalSymTable( CSymbolTable &table )
// @  \ : I[L̋L\
//    : table --- o͂L\̃IuWFNgւ̎Q
// ߂l : ɐC̕\̗vfCsȂ畉̒lԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::GetNonterminalSymTable( CSymbolTable &table )
{
	return GetSubTable( SYMBOL_NONTERMINAL, table );
}





//
// ֐ : map < string, CSymbol * >::iterator CSymbolTable::SearchSymbol( const char *sym )
// @  \ : L\̎w肵Lɑ΂锽q擾
//    : sym ---- L
// ߂l : w肵LL\ɂ΁C̈ʒuqCȂ΃}bv̖qԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

map < string, CSymbol * >::iterator CSymbolTable::SearchSymbol( const char *sym ) throw ( int )
{
	try { 
		if ( sym == NULL ) { throw -1; }

		map < string, CSymbol * >::iterator sp = m_SymbolTable.find( sym );
		return sp;
	}
	catch ( int error ) {
		throw error;
	}
}



//
// ֐ : int CSymbolTable::GetTable( SYMBOLTYPE type, CSymbolTable &table )
// @  \ : w肵^Cv݂̂̋L\\
//    : type ---- \\L^Cv
//			table --- \𐶐IuWFNgւ̎Q
// ߂l : ɐC\̗vfCs畉̒lԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::GetSubTable( SYMBOLTYPE type, CSymbolTable &table )
{
	try {
		if ( &table == this ) { throw -7; }	// IuWFNgɍ邱Ƃ͂łȂ

		table.RemoveAll();

		if ( type == SYMBOL_UNKNOWN ) { throw -8; }	// L^CvȂ

		// w肳ꂽL^Cv̋LCo͗p̕\ɒǉĂB
		map < string, CSymbol * >::iterator sp = m_SymbolTable.begin();
		SYMBOLTYPE symtype;
		while ( sp != m_SymbolTable.end() ) {
			symtype = (sp->second)->GetSymType();
			if ( symtype == type ) {
				table.AddSymbol( (sp->second)->GetSymbol(), type );
			}
			sp ++;
		}
	}
	catch ( int error ) {
		return error;
	}

	return table.GetSize();
}

//
// ֐ : int CSymbolTable::GetSymbol( int index, const CSymbol &symbol ) const
// @  \ : wʒűL擾
//    : index --- 擾L̈ʒu
//			symbol --- 擾LQƂ
// ߂l : Ύ擾ʒuCsȂ畉̒lԂ
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
int CSymbolTable::GetSymbol( int index, CSymbol &symbol )
{
	int pos = index;

	try { 
		if ( ( index < 0 ) && ( index >= m_SymbolTable.size() ) ) { throw -1; }	// wʒus

		map < string, CSymbol * >::iterator sp = m_SymbolTable.begin();
		map < string, CSymbol * >::iterator ep = m_SymbolTable.end();

		while ( ( sp != ep ) && ( index > 0 ) ) {
			// ړI̋LIuWFNg
			sp ++; index --;
		}
		if ( sp == ep ) {
			// Ȃ
			throw -2;
		}

		// ̂ŁC̋LԂ
		symbol = *( sp->second );
	}
	catch ( int error ) {
		return error;
	}
		
	return pos;

}


//
// ֐ : CSymbolTable &CSymbolTable::operator = ( CSymbolTable &table )
// @  \ : Zq
//    : table --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//
CSymbolTable &CSymbolTable::operator = ( CSymbolTable &table )
{
	if ( &table == this ) { return *this; }

	RemoveAll();

	CSymbol sym;
	int size = table.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		table.GetSymbol( i, sym );
		AddSymbol( sym.GetSymbol(), sym.GetSymType() );
	}

	return *this;
}


//
// ֐ : void CSymbolTable::Display()
// @  \ : \
//    :
// ߂l : 
// 쐬 : 2001/11/15 The.
// 쐬 : J F
//
// ŏIXV : 2001/15 The.
//
void CSymbolTable::Display()
{
	map < string, CSymbol * >::iterator sp, ep;
	sp = m_SymbolTable.begin();
	ep = m_SymbolTable.end();
	int i = 0;

	for ( ; sp != ep; sp ++ ) {
		cout << i << ": ";
		(sp->second)->Display();
		cout << endl;
		i ++;
	}
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/30 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/10/30 Tue.
//

