#include "StdAfx.h"
#include "NewIV.h"
#include "Socket.h"
#include "LogDlg.h"
//#include "HistoryManagement.h"


//extern CHistoryManagement historyManagement;
extern CLogDlg *g_pComLogDlg;
extern DWORD ThreadID;

//////////////////////////////////////////////////////////////////////
// CSockAddr NX
//////////////////////////////////////////////////////////////////////

//
// O		:CSockAddr::CSockAddr()
// @\		:ftHgRXgN^
// 		:
// ߂l	:
//
CSockAddr::CSockAddr()
{
	memset( (void*)&m_InetSockAddr, 0, sizeof( struct sockaddr_in ) );
}

//
// O		:CSockAddr::CSockAddr( const char *IpAddr, const int nPort )
// @\		:tRXgN^
// 		:
// ߂l	:
// 
CSockAddr::CSockAddr( const char *IpAddr, const int nPort )
{
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:CSockAddr::CSockAddr( const CSockAddr &Addr )
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
// 
CSockAddr::CSockAddr( const CSockAddr &Addr )
{
	m_InetSockAddr = Addr.m_InetSockAddr;
}

//
// O		:CSockAddr::~CSockAddr()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSockAddr::~CSockAddr()
{

}

//
// O		:CSockAddr& CSockAddr::operator = ( const CSockAddr &Addr )
// @\		:Zq
// 		:
// ߂l	:
//
CSockAddr& CSockAddr::operator = ( const CSockAddr &Addr )
{
	if( this == &Addr ){ return *this; }

	m_InetSockAddr = Addr.m_InetSockAddr;
	
	return *this;
}

//
// O		:void CSockAddr::Set( const char *IpAddr, const int nPort )
// @\		:IPAhXƃ|[gԍZbg
// 		:IpAddr - IPAhX
//			:nPort - |[gԍ
// ߂l	:Ȃ
//
void CSockAddr::Set( const char *IpAddr, const int nPort )
{
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:int CSockAddr::GetPort() const
// @\		:ZbgĂ|[gԍԂ
// 		:Ȃ
// ߂l	:|[gԍ
//
int CSockAddr::GetPort() const
{
	return (int)ntohs( m_InetSockAddr.sin_port );
}

//
// O		:const char* CSockAddr::GetIpAddr() const
// @\		:ZbgĂIPAhXԂ
// 		:Ȃ
// ߂l	:IPAhX\zւ̃|C^
//
const char* CSockAddr::GetIpAddr() const
{
	return inet_ntoa( m_InetSockAddr.sin_addr );
}

//
// O		:const struct sockaddr* CSockAddr::GetSockaddr() const
// @\		:osockaddr_in\̂̃|C^sockaddr^ɃLXgĕԂ
// 		:Ȃ
// ߂l	:õ|C^
//
const struct sockaddr* CSockAddr::GetSockaddr() const
{
	return (struct sockaddr*)&m_InetSockAddr;
}

//
// O		:const struct sockaddr* CSockAddr::GetSockaddr() const
// @\		:osockaddr_in\̂̃|C^Ԃ
// 		:Ȃ
// ߂l	:õ|C^
//
const struct sockaddr_in* CSockAddr::GetSockaddrIN() const
{
	return &m_InetSockAddr;
}


//////////////////////////////////////////////////////////////////////
// CSockAddr NX
//////////////////////////////////////////////////////////////////////

//
// O		:CMMIModuleAddr::CMMIModuleAddr()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr()
{

}

//
// O		:CMMIModuleAddr::CMMIModuleAddr()
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr( const char *szName, const char *IpAddr, const int nPort )
{
	strcpy( m_szModule, szName );
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:CMMIModuleAddr::CMMIModuleAddr( const CMMIModuleAddr &Addr )
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr( const CMMIModuleAddr &Addr )
{
	strcpy( m_szModule, Addr.m_szModule );
	m_InetSockAddr = Addr.m_InetSockAddr;
}

//
// O		:CMMIModuleAddr::~CMMIModuleAddr()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::~CMMIModuleAddr()
{

}

//
// O		:CMMIModuleAddr& CMMIModuleAddr::operator = ( const CMMIModuleAddr &Addr )
// @\		:Zq
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr& CMMIModuleAddr::operator = ( const CMMIModuleAddr &Addr )
{
	if( &Addr == this ) { return *this; }

	strcpy( m_szModule, Addr.m_szModule );
	m_InetSockAddr = Addr.m_InetSockAddr;

	return *this;
}

//
// O		:void CMMIModuleAddr::Set( const char *Module, const char *IpAddr, const int nPort )
// @\		:o̒lZbg
// 		:Module - W[
//			:IpAddr - IPAhXiXXX.XXX.XXX.XXX`j
//			:nPort - |[gԍ
// ߂l	:Ȃ
//
void CMMIModuleAddr::Set( const char *Module, const char *IpAddr, const int nPort )
{
	strcpy( m_szModule, Module );
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:const char* CMMIModuleAddr::GetName() const
// @\		:W[Ԃ
// 		:Ȃ
// ߂l	:W[\zւ̃|C^
//
const char* CMMIModuleAddr::GetName() const
{
	return m_szModule;
}


//////////////////////////////////////////////////////////////////////
// CSock NX
//////////////////////////////////////////////////////////////////////

//
// O		:CSock::CSock()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::CSock()
{
	m_hSocket = INVALID_SOCKET;
}

//
// O		:CSock::~CSock()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::~CSock()
{

}

//
// O		:void CSock::Attach( SOCKET hSocket )
// @\		:\Pbgnh֘At
// 		:hSocket - \Pbgnh
// ߂l	:Ȃ
//
void CSock::Attach( SOCKET hSocket )
{
	m_hSocket = hSocket;
}

//
// O		:void CSock::Detach()
// @\		:õ\Pbgnh
// 		:Ȃ
// ߂l	:Ȃ
//
void CSock::Detach()
{
	if( m_hSocket != INVALID_SOCKET )
	{
		shutdown( m_hSocket, 0x02 );
		closesocket( m_hSocket );
		m_hSocket = INVALID_SOCKET;
	}
}

//
// O		:bool CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
// @\		:V\Pbgnh쐬
// 		:nAddrFamily - AhXt@~
//			:nSocketType - \Pbg̎
//			:nProtocol - vgR
// ߂l	: - true s - false
//
bool CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
{
	m_hSocket = socket( nAddrFamily, nSocketType, nProtocol );
	if( m_hSocket == INVALID_SOCKET ){return false;}
	return true;
}

//
// O		:bool CSock::Bind( CSockAddr *addr )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Bind( CSockAddr *addr )
{
	if( m_hSocket == INVALID_SOCKET ||
		addr == NULL
		){return false;}

	if( bind( m_hSocket, addr->GetSockaddr(), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return false;
	return true;
}

//
// O		:bool CSock::Bind( CSockAddr *addr )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Listen( int nMaxCon )
{
	if( m_hSocket == INVALID_SOCKET ||
		nMaxCon < 1
		){return false;}

	if( listen( m_hSocket, nMaxCon ) == SOCKET_ERROR )
		return false;
	return true;
}

//
// O		:bool CSock::Accept( CSock &sock )
// @\		:̃\PbgŐڑṽANZvg
// 		:&sock - ANZvgp̃\Pbg
// ߂l	: - TRUE s - FALSE
//
bool CSock::Accept( CSock &sock )
{
	if( m_hSocket == INVALID_SOCKET ){return FALSE;}

	int nSize = sizeof( sockaddr );
	SOCKET hSocket = accept( m_hSocket, NULL, &nSize );

	if( hSocket != INVALID_SOCKET )
	{
		sock.Attach( hSocket );
		return true;
	}
	return false;
}

//
// O		:bool CSock::Connect( CSockAddr *addr )
// @\		:̃AhXɐڑ
// 		:*addr - ڑAhXێCX^X̃|C^
// ߂l	: - true s - false
//
bool CSock::Connect( CSockAddr *addr )
{
	if( m_hSocket == INVALID_SOCKET ||
		addr == NULL 
		){return false;}

	if( connect( m_hSocket, addr->GetSockaddr(), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return false;
	return true;
}

//
// O		:void CSock::Detach()
// @\		:õ\Pbgnh
// 		:
// ߂l	:
//
void CSock::Close()
{
	shutdown( m_hSocket, 0x02 );
	closesocket( m_hSocket );
	m_hSocket = INVALID_SOCKET;
}

//
// O		:int CSock::Send( const char *szMsg, int nByte )
// @\		:sMsgnByteoCg
// 		:sMsg - Mobt@̃|C^
//			:nByte - oCg
// ߂l	:ۂɑꂽoCg
//
int CSock::Send( const char *szMsg, size_t nByte )
{
	if( m_hSocket == INVALID_SOCKET ){return 0;}
	return send( m_hSocket, szMsg, nByte, 0 );
}

//
// O		:int CSock::Recv( char *szBuff )
// @\		:MāAsBuffɊi[
// 		:szBuff - Mpobt@̃|C^
// ߂l	:MoCg
//
int CSock::Recv( char *szBuff )
{
	if( m_hSocket == INVALID_SOCKET ){return 0;}
	return recv( m_hSocket, szBuff, RECV_BUFFER_SIZE, 0 );
}

//
// O		:bool CSock::Detach()
// @\		:õ\PbgnhLׂ
// 		:
// ߂l	:L - true  - false
//
bool CSock::IsValid()
{
	if( m_hSocket == INVALID_SOCKET ){return false;}
	return true;
}

//////////////////////////////////////////////////////////////////////
// CComMsg NX
//////////////////////////////////////////////////////////////////////

//
// O		:CComMsg::CComMsg()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg()
{

}

//
// O		:CComMsg::CComMsg( string &msg )
// @\		:tRXgN^
// 		:msg - bZ[W
// ߂l	:Ȃ
//
CComMsg::CComMsg( string &msg )
{
	m_Msg = msg;
}

//
// O		:CComMsg::CComMsg( LPCSTR msg )
// @\		:tRXgN^
// 		:msg - bZ[W
// ߂l	:Ȃ
//
CComMsg::CComMsg( LPCSTR msg )
{
	m_Msg = msg;
}

//
// O		:CComMsg::CComMsg()
// @\		:Rs[RXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg( const CComMsg &msg )
{
	m_Msg = msg.m_Msg;
}

//
// O		:CComMsg::CComMsg( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param )
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param )
{
	Set( from, to, cmd, param );
}

//
// O		:CComMsg::CComMsg()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::~CComMsg()
{

}

//
// O		:CComMsg::CComMsg()
// @\		:Zq
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg& CComMsg::operator = ( const CComMsg &msg )
{
	if( this == &msg ) return *this;

	m_Msg = msg.m_Msg;

	return *this;
}

//
// O		:int CComMsg::Set( string &msg )
// @\		:bZ[W̃Zbg
// 		:msg - bZ[W
// ߂l	:펞 0 ُ펞 -1
//
int CComMsg::Set( string &msg )
{
	m_Msg = msg;
	return IsValid();
}

//
// O		:int CComMsg::Set( LPCSTR &msg )
// @\		:bZ[W̃Zbg
// 		:msg - bZ[W
// ߂l	:펞 0 ُ펞 -1
//
int CComMsg::Set( LPCSTR msg )
{
	m_Msg = msg;
	return IsValid();
}

//
// O		:int CComMsg::Set( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param )
// @\		:bZ[W쐬
// 		:from - <from>
//  		:to - <to>
//          :cmd - <command>
//          :param - <parameter>
// ߂l	:펞 0 ُ펞 -1
//
int CComMsg::Set( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param )
{
	string sf = "<from></from>";
	sf.insert( 6, from );
	string st = "<to></to>";
	st.insert( 4, to );
	string sc = "<command></command>";
	sc.insert( 9, cmd );
	string sp = "<parameter></parameter>";
	sp.insert( 11, param );

	m_Msg = "<msg><head>" + sf + st + "</head><body>";
	m_Msg += sc + sp + "</body>" + "</msg>";

	return IsValid();
}

//
// O		:string CComMsg::Get()
// @\		:bZ[W擾
// 		:Ȃ
// ߂l	:bZ[W
//
string CComMsg::Get()
{
	return m_Msg;
}

//
// O		:string CComMsg::GetCmd() const
// @\		:bZ[W<command>̒l擾
// 		:Ȃ
// ߂l	:<command>̒l
//
string CComMsg::GetCmd() const
{
	return GetSubstring( "<command>" );
}

//
// O		:string CComMsg::GetCmdWithTag() const
// @\		:bZ[W<command>̒l擾i^Otj
// 		:Ȃ
// ߂l	:<command>...</command>
//
string CComMsg::GetCmdWithTag() const
{
	string ret = GetSubstring( "<command>" );
	ret.insert( 0, "<command>" );
	ret.append( "</command>" );
	return ret;
}

//
// O		:string CComMsg::GetParam() const
// @\		:bZ[W<parameter>̒l擾
// 		:Ȃ
// ߂l	:<parameter>̒l
//
string CComMsg::GetParam() const
{
	return GetSubstring( "<parameter>" );
}

//
// O		:string CComMsg::GetParamWithTag() const
// @\		:bZ[W<parameter>̒l擾i^Otj
// 		:Ȃ
// ߂l	:<parameter>...</parameter>
//
string CComMsg::GetParamWithTag() const
{
	string ret = GetSubstring( "<parameter>" );
	ret.insert( 0, "<parameter>" );
	ret.append( "</parameter>" );
	return ret;
}

//
// O		:string CComMsg::GetFrom() const
// @\		:bZ[W<from>̒l擾
// 		:Ȃ
// ߂l	:<from>̒l
//
string CComMsg::GetFrom() const
{
	return GetSubstring( "<from>" );
}

//
// O		:string CComMsg::GetFromWithTag() const
// @\		:bZ[W<from>̒l擾i^Otj
// 		:Ȃ
// ߂l	:<from>...</from>
//
string CComMsg::GetFromWithTag() const
{
	string ret = GetSubstring( "<from>" );
	ret.insert( 0, "<from>" );
	ret.append( "</from>" );
	return ret;
}

//
// O		:string CComMsg::GetTo() const
// @\		:bZ[W<to>̒l擾
// 		:Ȃ
// ߂l	:<to>̒l
//
string CComMsg::GetTo() const
{
	return GetSubstring( "<to>" );
}

//
// O		:string CComMsg::GetToWithTag() const
// @\		:bZ[W<to>̒l擾i^Otj
// 		:Ȃ
// ߂l	:<to>...</to>
//
string CComMsg::GetToWithTag() const
{
	string ret = GetSubstring( "<to>" );
	ret.insert( 0, "<to>" );
	ret.append( "</to>" );
	return ret;
}

//
// O		:string CComMsg::GetBody() const
// @\		:bZ[W<body>̒l擾
// 		:Ȃ
// ߂l	:<body>...</body>
//
string CComMsg::GetBody() const
{
	return GetSubstring( "<body>" );
}

//
// O		:string CComMsg::GetBodyWithTag() const
// @\		:bZ[W<body>̒l擾i^Otj
// 		:Ȃ
// ߂l	:<body>...</body>
//
string CComMsg::GetBodyWithTag() const
{
	string ret = GetSubstring( "<body>" );
	ret.insert( 0, "<body>" );
	ret.append( "</body" );
	return ret;
}

//
// O		:string CComMsg::GetSubstring( const char *szTag ) const
// @\		:Ŏw肳ꂽ^O̕擾
// 		:szTag - 擾^O̖O
// ߂l	:szTag^O̕
//
string CComMsg::GetSubstring( const char *szTag ) const
{
	string closer = szTag;
	closer.insert( 1, "/" );

	size_t nStart = m_Msg.find( szTag ) + strlen( szTag );
	size_t nEnd = m_Msg.find( closer, nStart );

	if( nStart == string::npos || nEnd == string::npos )
	{
		return "";
	}
	else
	{
		return m_Msg.substr( nStart, nEnd - nStart );
	}
}

void CComMsg::Dump()
{
	cout << m_Msg << endl;
}

int CComMsg::IsValid()
{
	// MSXMLgăf[^ׂقǏɎԂ邩
	// ʐMW[ŕKKvȃ^O邩ǂׂ
	// ɃG[ĂmI
	char tag_o[7][12] = { "<msg>", "<head>", "<body>", "<from>", "<to>", "<command>", "<parameter>" };
	char tag_c[7][13] = { "</msg>", "</head>", "</body>", "</from>", "</to>", "</command>", "</parameter>" };

	if( m_Msg.empty() ){return -1;}

	for( int i = 0; i < 7; i++ )
	{
		if( m_Msg.find( tag_o[i] ) == string::npos ||
			m_Msg.find( tag_c[i] ) == string::npos
			){return -1;}
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////
// CMsgServer NX
//////////////////////////////////////////////////////////////////////

//
// O		:CMsgServer::CMsgServer()
// @\		:RXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMsgServer::CMsgServer()
{
	WinSockInit();
	// ꉞNA
	m_Addrlist.clear();
	m_MsgDeque.clear();
	// AhXǂݍ
	ReadAddrFile( ADDRFILE );
	
	// ftHgbZ[WL[̃NeBJZNV
	InitializeCriticalSection( &m_CriticalSection );
}

//
// O		:CMsgServer::CMsgServer()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMsgServer::~CMsgServer()
{
	// NeBJZNV̔j
	DeleteCriticalSection( &m_CriticalSection );

	// new čĂ̂ŕK`FbN
	if( !m_Addrlist.empty() )
	{
		ClearAddr();
	}
	
	// L[̃NA
	while( m_MsgDeque.size() > 0 )
	{
		delete (CComMsg*)m_MsgDeque.front();
		m_MsgDeque.pop_front();
	}

}

//
// O		:void CSock::WinSockInit()
// @\		:WinSock̏
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::WinSockInit()
{
	// WinSock̏
	int		nResult;
	WORD	wRequireVersion;	// gpWinSock̃o[W
	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );
	if( nResult != 0  )
	{
//		cerr << "WinSock̏Ɏs" << endl;
	}

	// WinSock̃o[Wv̂mF
	if( lpWSAData.wVersion != wRequireVersion )
	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
	}
}

//
// O		:void CMsgServer::ReadAddrFile( LPCSTR szFile )
// @\		:AhXt@Cǂݍ
// 		:szFile - t@C
// ߂l	:Ȃ
//
void CMsgServer::ReadAddrFile( LPCSTR szFile )
{
	char name[RECV_BUFFER_SIZE+1];	// W[
	char ip[16];			// XXX.XXX.XXX.XXX`IP
	int port;				// |[gԍ

	// Xg̏
	m_Addrlist.clear();
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();

	// ǂݍ݃[hŃt@CJ
	fstream fs( szFile, ios::in );
	if( fs.is_open() != 0 )
	{
		// EOFԂ܂Ńt@Cǂ
		while( !fs.eof() )
		{
			fs >> name >> ip >> port;
			// ǂ񂾃f[^i[
			CMMIModuleAddr *addr = new CMMIModuleAddr( name, ip, port );
			m_Addrlist.insert( ite, addr );
		}
	}
	// t@C
	fs.close();
}

//
// O		:void CMsgServer::ClearAddr()
// @\		:AhXNA
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::ClearAddr()
{
	// Ce[^̏
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();
	while( ite != m_Addrlist.end() )
	{
		// Ă
		delete (*ite);
		ite++;
	}
	// ꉞXgNA
	m_Addrlist.clear();
//	cout << "Addrlist cleared." << endl;
}

//
// O		:CMMIModuleAddr* CMsgServer::GetAddr( LPCSTR szModule )
// @\		:szModulẽAhX擾
// 		:Ȃ
// ߂l	:AhX
//
CMMIModuleAddr* CMsgServer::GetAddr( LPCSTR szModule )
{
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();
	while( ite != m_Addrlist.end() )
	{
		if( !strcmp( (*ite)->GetName(), szModule ) )
		{
			return *ite;
		}
		ite++;
	}
	return NULL;
}

//
// O		:void CMsgServer::Run()
// @\		:MpXbh̊Jn
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::Run()
{
	if( m_Socket.IsValid() )
		m_dwThread = (DWORD)CreateThread( NULL, 0, CMsgServer::RecvThread,(LPVOID)this, 0, NULL );
		//m_dwThread = _beginthread( CMsgServer::RecvThread, 0, (LPVOID)this );
}

//
// O		:void CMsgServer::Run()
// @\		:MpXbh̒~
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::Stop()
{
	// ڑҋ@p\Pbg
	m_Socket.Close();

	// XbhI܂őҋ@
	WaitForSingleObject( (HANDLE)m_dwThread, INFINITE );

//	cout << "Thread End." << endl;
}

//
// O		:BOOL CMsgServer::Initialize( LPCSTR szModule )
// @\		:CX^X̏
// 		:szModule - W[
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::Initialize( LPCSTR szModule )
{
	strcpy( m_szModule, szModule );

	// W[玩IPAhXƃ|[gԍ߂
	CMMIModuleAddr *addr = GetAddr( szModule );
	if( addr != NULL )
	{
		// \Pbg̃oCh
		m_Socket.Socket();
		if( m_Socket.Bind( addr ) )
		{
			return TRUE;
		}
	}
//	cerr << "bind failed." << endl;

	return FALSE;
}

//
// O		:void CMsgServer::RecvThread( void *lpParam )
// @\		:MpXbh
// 		:*lpParam - gւ̃|C^
// ߂l	:Ȃ
//
DWORD WINAPI CMsgServer::RecvThread( void *lpParam )
{
//	cout << "Enter Thread." << endl;

	CMsgServer *lpServ = (CMsgServer*)lpParam;

	CSock SockCon;					// Mp\Pbg
	int nRecv;						// MTCYێ
	string sMsg;					// Mf[^i[
	char szBuff[RECV_BUFFER_SIZE+1];		// Mpobt@

	// bZ[WM[vɓ
	if( !lpServ->m_Socket.Listen() )
	{
//		cerr << "listen failed." << WSAGetLastError() << endl;
		ExitThread( lpServ->m_dwThread );
	}

	while( 1 )
	{
		if( !lpServ->m_Socket.Accept( SockCon ) )
		{
			// ڑҋ@p̃\Pbgꂽ̂ŃXbhI
			break;
		}
			// 肪ؒf܂ŎM
		while( 1 )
		{
			nRecv = SockCon.Recv( szBuff );
			if( nRecv == SOCKET_ERROR )
			{
				int ret = WSAGetLastError();
				TRACE( "\PbgG[F%d\n",ret );
				break;
			}
			else if( nRecv == 0 )
			{
				break;
			}
			sMsg.append( szBuff, nRecv );	
		}
		
		// M
		SockCon.Close();
		
		if( nRecv != SOCKET_ERROR )
		{
			// MbZ[WKɏ
			lpServ->AnalyzeMessage( sMsg );
			
			// Mobt@NA
			sMsg = "";
		}
	}

//	cout << "Exit Thread." << endl;
	lpServ->m_Socket.Close();
	WSACleanup();
	ExitThread( lpServ->m_dwThread );
	return 0;
}


//
// O		:void CMsgServer::AnalyzeMessage( string &msg )
// @\		:MbZ[WL[Ɋi[
// 		:&msg - MbZ[W
// ߂l	:Ȃ
//
void CMsgServer::AnalyzeMessage( string &msg )
{
	CComMsg *Msg = new CComMsg( msg );
	
	EnterCriticalSection( &m_CriticalSection );
	m_MsgDeque.push_back( Msg );
	LeaveCriticalSection( &m_CriticalSection );

	int i=ThreadID;
	if(PostThreadMessage(ThreadID, WM_USER, 0, 0)==0)
	{
		i++;
		return;
	}
}

//
// O		:BOOL CMsgServer::GetMsg( CComMsg &message )
// @\		:L[烁bZ[Wo
// 		:&message - bZ[Wi[p̃CX^X
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::GetMsg( CComMsg &message )
{
	if( m_MsgDeque.size() != 0 )
	{
		EnterCriticalSection( &m_CriticalSection );
		message = *m_MsgDeque.front();
		delete m_MsgDeque.front();
		m_MsgDeque.pop_front();
		LeaveCriticalSection( &m_CriticalSection );

		//O͂
		CString strLog;
		strLog.Format("%s\r\n",message.m_Msg.c_str());
		g_pComLogDlg->setText(strLog);

		return TRUE;
	}
	return FALSE;
}

BOOL CMsgServer::GetMsg( string &msg )
{
	CComMsg cmsg;
	BOOL ret = GetMsg( cmsg );
	msg = cmsg.Get();
	return ret;
}

//
// O		:BOOL CMsgServer::SendMsg( CComMsg &msg )
// @\		:msg𑗐M
// 		:&msg - M郁bZ[W
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::SendMsg( CComMsg &msg )
{

	//ʐMOfo
	CString strLog;
	strLog.Format("%s\r\n",msg.m_Msg.c_str());
	g_pComLogDlg->setText(strLog);


	CSock sock;
	// M̃AhX擾
	CMMIModuleAddr *addr = GetAddr( msg.GetTo().c_str() );

	if( addr != NULL )
	{
		// ڑ
		if( sock.Socket() && sock.Connect( addr ) )
		{
			// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
			size_t nSize = msg.Get().length();
			size_t nRet = 0;
			while( 1 )
			{
				if( nRet >= nSize )
					break;
				nRet += sock.Send( &(msg.Get())[nRet], nSize - nRet );
			}
			// I\Pbg
			sock.Close();
			return TRUE;
		}
	}
	return FALSE;
}

BOOL CMsgServer::SendMsg( string &msg )
{
	CComMsg cmsg( msg );
	return SendMsg( cmsg );
}
