//
// SLR(1)\͊쐬vO
// SLR(1)\͕\
//
// SLRTableCreator.h / SLRTableCreator.cpp
//
// 2001/11/06 Tue. JF
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <iostream>
#include <map>

#include "CanonicalLR0Collection.h"
#include "LRTable.h"
#include "SLRTableCreator.h"

using namespace std;

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//

//
// NX CFollowSet
//


//
// ֐ : CFollowSet::CFollowSet()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
CFollowSet::CFollowSet() : m_FollowSet()
{
}

//
// ֐ : CFollowSet::~CFollowSet()
// @  \ : fXgN^
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
CFollowSet::~CFollowSet()
{
	m_FollowSet.clear();
}

//
// ֐ : int CFollowSet::MakeFollowSet( CContextFreeGrammar &grammar )
// @  \ : FollowWvZ
//    : grammar ---- Ώۂ̕@
// ߂l : SĂ̔I[LFollowW̃TCY̍v
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CFollowSet::MakeFollowSet( CContextFreeGrammar &grammar )
{
	CSymbolTable   &nonterminal = grammar.GetNonterminalSymbol();
	list < string > follow_s;
	CSymbol sym;

	m_Grammar = grammar;

	m_FollowSet.clear();

	int size = nonterminal.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		follow_s.clear();
		nonterminal.GetSymbol( i, sym );
		MakeFollowSet( grammar, sym.GetSymbol(), follow_s );

		// Wǉ
		list < string >::iterator sp, ep;
		sp = follow_s.begin();
		ep = follow_s.end();

		for ( ; sp != ep; sp ++ ) {
			m_FollowSet.insert( pair < string, string >( sym.GetSymbol(), *sp ) );
		}
	}

	return m_FollowSet.size();
}


//
// ֐ : int CFollowSet::GetFollowSet( const char *sym, vector < string > &set )
// @  \ : LsymFollowW擾
//    : sym ---- L
//			set ---- FollowW
// ߂l : FollowW̃TCY
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CFollowSet::GetFollowSet( const char *sym, vector < string > &set )
{
	set.clear();

	multimap < string, string >::iterator p = m_FollowSet.find( sym );

	if ( p != m_FollowSet.end() ) {
		do {
			set.push_back( p->second );
			p ++;
		} while ( p != m_FollowSet.upper_bound( sym ) );
	}

	return set.size();
}

//
// ֐ : int CFollowSet::MakeFirstSet( CContextFreeGrammar &grammar, const char *sym, list < string > &first_s ) 
// @  \ : w肳ꂽLsymFirstW߂
//    : grammar --- @
//			sym ------- WvZL
//			first_s --- ʂo͂z
// ߂l : W̃TCY
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CFollowSet::MakeFirstSet( CContextFreeGrammar &grammar, const char *sym, list < string >&first_s )
{
	if ( grammar.GetTerminalSymbol().ExistSymbol( sym ) )  {
		// LI[L̏ꍇCfirstW͂̋L
		first_s.push_back( sym );
	}
	else {
		// LI[L̏ꍇ́C̔I[L̉Eӂɂŏ̋LfirstW߂
		CProductionSet pro_set;
		grammar.GetProductionSet().GetProduction( sym, pro_set );
		int size = pro_set.GetSize();
		CProduction pro;
		for ( int i = 0; i < size; i ++ ) {
			pro_set.GetProduction( i, pro );
			MakeFirstSet( grammar, pro.GetRightSideSymbol( 0 ), first_s );
		}
	}

	return first_s.size();	// W̃TCYԂ
}

//
// ֐ : int CFollowSet::MakeFollowSet( CContextFreeGrammar grammar, const char *sym, vector < string > follow_s )
// @  \ : w肵I[Lɑ΂FOLLOWW߂
//    : grammar --- @
//			sym ------- I[L
//			follow_s ----- FOLLOWW
// ߂l : follow_s̃TCY
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CFollowSet::MakeFollowSet( CContextFreeGrammar &grammar, const char *sym, list < string > &follow_s )
{
	CProductionSet &production = grammar.GetProductionSet();
	CSymbolTable   &nonterminal = grammar.GetNonterminalSymbol();
	CProduction     pro;
	int procount, rightcount;
	const char *rightsym;
	list < string > first_set;

	if ( ! strcmp( sym, grammar.GetStartSymbol().GetSymbol() ) ) {
		// wLJnL̂Ƃ́CILFOLLOWWɒǉ
		follow_s.push_back( END_SYMBOL );
	}
	else {
		// JnLȊÓCEӂɏoƂɒׂB
		procount = production.GetSize();
		for ( int i = 0; i < procount; i ++ ) {
			production.GetProduction( i, pro );
			rightcount = pro.GetRightSideLength();

			for ( int j = 0; j < rightcount; j ++ ) {
				rightsym = pro.GetRightSideSymbol( j );

				if ( ! strcmp( sym, rightsym ) ) {
					if ( j == ( rightcount - 1 ) ) {
						// wI[LK̖ɂƂ́C̋K̍ӂ̔I[LFOLLOWWT
						MakeFollowSet( grammar, pro.GetLeftSideSymbol(), follow_s );
					}
					else {
						// ʏ́CwL̒ɑLFIRSTWǉ
						first_set.clear();
						MakeFirstSet( grammar, pro.GetRightSideSymbol( j + 1 ), first_set );

						// FOLLOWWɒǉ
						first_set.sort();
						first_set.unique();		// dȂ
						follow_s.sort();
						follow_s.merge( first_set );	// Xg̘A
					}
				}
			}
		}
	}

	// dLĂ
	follow_s.sort();
	follow_s.unique();

	return follow_s.size();
}

//
// ֐ : void CFollowSet::Display()
// @  \ : Wo
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
void CFollowSet::Display()
{
	CSymbolTable &nonterminal = m_Grammar.GetNonterminalSymbol();
	int size = nonterminal.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		CSymbol symbol;
		nonterminal.GetSymbol( i, symbol );

		cout << symbol.GetSymbol() << " = { ";

		multimap < string, string >::iterator p = m_FollowSet.find( symbol.GetSymbol() );
		if ( p != m_FollowSet.end() ) {
			do {
				cout << p->second << " ";
				p ++;
			} while ( p != m_FollowSet.upper_bound( symbol.GetSymbol() ) );
		}
		cout << " }" << endl;
	}
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//

//
// NX CSLRTableCreator
//

//
// ֐ : CSLRTableCreator::CSLRTableCreator()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
CSLRTableCreator::CSLRTableCreator()
{
}

//
// ֐ : CSLRTableCreator::~CSLRTableCreator()
// @  \ : fXgN^
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
CSLRTableCreator::~CSLRTableCreator()
{
}


//
// ֐ : int CSLRTableCreator::CreateSLRTable( CContextFreeGrammar &grammar, CLRTable &table )
// @  \ : SLR\͕\𐶐
//    : grammar --- \[XƂȂ镶@
//			table ----- 铝\
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
int CSLRTableCreator::CreateSLRTable( CContextFreeGrammar &grammar, CLRTable &table )
{
	// LR(0)W
	CCLR0Collection clrcollection;
	CCLR0CollectionCreator clrcreator;

	// FOLLOWW
	CFollowSet follow_s;

	// \͕\
	CLRSubTable    &action_t = table.GetActionTable();				// action\
	CLRSubTable	   &goto_t   = table.GetGotoTable();				// goto\

	// LR(0)W̓o
	clrcreator.CreateCollection( grammar, clrcollection );
//	clrcollection.OutFile( "collection.txt" );

	// FOLLOWW̌vZ
	follow_s.MakeFollowSet( grammar );
//	follow_s.Display();

	// action\̐
	CreateActionTable( grammar, clrcollection, follow_s, action_t );
//	cout << endl << "ACTION TABLE" << endl;
//	action_t.Display();

	// goto\̐
	CreateGotoTable( grammar, clrcollection, goto_t );
//	cout << endl << "GOTO TABLE" << endl;
//	goto_t.Display();

	return 1;
}



//
// ֐ : int CSLRTableCreator::CreateActionTable( CContextFreeGrammar &grammar, CCLR0Collection &collection, CFollowSet &folow_s, CLRSubTable &table )
// @  \ : action\𐶐
//    : grammar --- @
//			collection --- LR(0)W
//			foolow_s --- FOLLOWW
//			table ----- action\iój
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CSLRTableCreator::CreateActionTable( CContextFreeGrammar &grammar, CCLR0Collection &collection, CFollowSet &follow_s, CLRSubTable &table )
{
	// @
	CProductionSet &production  = grammar.GetProductionSet();		// K
	CSymbolTable   &terminal    = grammar.GetTerminalSymbol();		// I[L
	CSymbolTable   &nonterminal = grammar.GetNonterminalSymbol();	// I[L
	CSymbol		   &startsymbol = grammar.GetStartSymbol();			// JnL

	// LR0WɊւ
	CLR0ItemSetList &setlist  = collection.GetLR0ItemSetList();		// W񃊃Xg
	CLR0ItemList    &itemlist = collection.GetLR0ItemList();		// WXg
	CLR0ItemSet		 itemset;		// W
	CLR0ItemList	 subitemlist;	// LR0W

	vector < string > sym_list;

	int setcount;
	int itemcount;

	// \
	CSymbolTable action_input;
	action_input = terminal;
	action_input.AddSymbol( END_SYMBOL, SYMBOL_TERMINAL );
	table.MakeTable( setlist.GetSize(), action_input );

	// Z𖄂߂Ăc
	setcount = setlist.GetSize();
	for ( int i = 0; i < setcount; i ++ ) {	
		setlist.GetSet( i, itemset );

		if ( itemset.GetOperation() == GOTO_OPERATION ) {
			// gotoZłłW̎Ɂc
			subitemlist.RemoveAll();
			itemcount = itemlist.GetItem( itemset.GetSetNumber(), subitemlist );
			
			for ( int j = 0; j < itemcount; j ++ ) {
				CLR0Item &item = subitemlist.GetItem( j );
				
				// eLR(0)ɂāc
				CProduction &pro = item.GetProduction();
				int marker = item.GetCurrentMarkerPos();

				if ( marker == MARKER_END ) {
					// }[J[E[ɂƂ́CҌNB
					if ( ! strcmp( pro.GetLeftSideSymbol(), startsymbol.GetSymbol() ) ) {
						// JnL̐KŊҌNƂ́C󗝂ɂȂ
						CLRTableState &state = table.GetState( itemset.GetSetNumber() );
						state.SetCell( "$", ACTION_ACCEPT, -1 );
						
					}
					else {
						// ʏ́CҌ
						// Ҍ̔I[LFOLLOWW̗vf̂ꂼ͂ƂZɓLq
						CLRTableState &state = table.GetState( itemset.GetSetNumber() );
						sym_list.clear();
						int listsize = follow_s.GetFollowSet( pro.GetLeftSideSymbol(), sym_list );
//						cerr << "state-" << state.GetStateNumber() << " : Reduce[" << pro.GetNumber() << "]  input symbol{";
						for ( int k = 0; k < listsize; k ++ ) {
//							cerr << sym_list[ k ] << " ";
							state.SetCell( sym_list[ k ].c_str(), ACTION_REDUCE, pro.GetNumber() );
						}
//						cerr << "]" << endl;
					}
				}
					// }[J[̒ŐL𒲂ׂāc
				int front_pos = ( marker == MARKER_END ) ? pro.GetRightSideLength() - 1 : marker - 1;
				const char *front_sym = pro.GetRightSideSymbol( front_pos );
				CSymbol     input_sym;

				if( terminal.ExistSymbol( front_sym ) ) {
					// ŐLI[LŁc
					itemset.GetInputSymbol( input_sym );
					if ( ! strcmp( front_sym, input_sym.GetSymbol() ) ) {
						// }[J[̒ŐLgotoZɗpLc
						// gotoZɗpԂfront_sym̈ʒuɃVtgLq
						CLRTableState &state = table.GetState( itemset.GetOriginalSet() );
//						cerr << "state-" << state.GetStateNumber() << " : Shift[" << i << "]  input symbol{" << front_sym << "}" << endl;
						state.SetCell( front_sym, ACTION_SHIFT, i );
					}
				}
			}
		}
	}

	return 1;
}


//
// ֐ : int CSLRTableCreator::CreateGotoTable( CContextFreeGrammar &grammar, CCLR0Collection &collection, CLRSubTable &table )
// @  \ : goto\𐶐
//    : grammar --- @
//			collection --- LR(0)W
//			table ----- action\iój
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//
int CSLRTableCreator::CreateGotoTable( CContextFreeGrammar &grammar, CCLR0Collection &collection, CLRSubTable &table )
{
	// @
	CProductionSet &production  = grammar.GetProductionSet();		// K
	CSymbolTable   &terminal    = grammar.GetTerminalSymbol();		// I[L
	CSymbolTable   &nonterminal = grammar.GetNonterminalSymbol();	// I[L
	CSymbol		   &startsymbol = grammar.GetStartSymbol();			// JnL

	// LR0WɊւ
	CLR0ItemSetList &setlist  = collection.GetLR0ItemSetList();		// W񃊃Xg
	CLR0ItemList    &itemlist = collection.GetLR0ItemList();		// WXg
	CLR0ItemSet		 itemset;		// W
	CLR0ItemList	 subitemlist;	// LR0W

	// \
	CSymbolTable goto_input;
	goto_input = nonterminal;
	table.MakeTable( setlist.GetSize(), goto_input );

	// \𖄂߂Ă
	int state_count = setlist.GetSize();
	for ( int i = 0; i < state_count; i ++ ) {
		setlist.GetSet( i, itemset );

		if ( itemset.GetOperation() == GOTO_OPERATION ) {
			// gotoZłłWŁc
			
			CSymbol input_symbol;
			itemset.GetInputSymbol( input_symbol );
			if ( nonterminal.ExistSymbol( input_symbol.GetSymbol() ) ) {
				// Zɗp͋LI[L̂ƂC
//				cerr << "state-" << itemset.GetOriginalSet() << " : Shift[" << itemset.GetSetNumber() << "]  input symbol{" << input_symbol.GetSymbol() << "}" << endl;

				CLRTableState &state = table.GetState( itemset.GetOriginalSet() );
				state.SetCell( input_symbol.GetSymbol(), ACTION_SHIFT, itemset.GetSetNumber() );
			}
		}
	}

	return 1;
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu.
//

