//
// SLR(1)\͊vO
// LR\͕\
//
// Grammar.h / Grammar.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/09/10 Tue. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _LRTABLE_H_
#define _LRTABLE_H_

#include <list>
#include <map>
#include <vector>

#include "SymbolTable.h"
#include "CanonicalLR0Collection.h"

using namespace std;

//
// LRe[u̍\
// 1.action\
// 2.goto\
//
// f[^\́CRun-Lengthp
//

//
// 񋓌^ Z^Cv
//
enum CELLTYPE {
	TYPE_NOTHING = 0,		// 
	TYPE_ACTION,			// shiftreduceĂ
};

//
// 񋓌^ ANV^Cv
//
enum ACTIONTYPE {
	ACTION_NOTHING = 0,		// Ȃ
	ACTION_SHIFT,				// shift
	ACTION_REDUCE,			// reduce
	ACTION_ACCEPT,			// accept
};


//
// CSymbolToIndex
//
// @LԂɑ΂CfbNX
//
class CSymbolToIndex
{
private:
	map < string, int > m_SymbolMap;		// LCfbNX}bv

public:
	CSymbolToIndex();
	CSymbolToIndex( CSymbolTable &table );
	CSymbolToIndex( CSymbolToIndex &sym );

	virtual ~CSymbolToIndex();

public:
	int GetSize();

	int GetIndex( const char *symbol );
	const char *GetSymbol( int index );

	int MakeMap( CSymbolTable &table );

	void Init();


public:
	CSymbolToIndex & operator = ( CSymbolToIndex &sym );
};


//
// NX CLRTableAction
// 
// JڂƂɎsANVishift/reduce)̏
//
class CLRTableAction
{
private:
	ACTIONTYPE m_nAction;		// ANV̎
	int		   m_nParameter;	// ANṼp[^ (shiftJڐ̏Ԕԍ,reduceҌɓKp鐶Kԍ)

public:
	CLRTableAction();
	CLRTableAction( ACTIONTYPE action, int param = -1 );
	CLRTableAction( CLRTableAction &action );

	virtual ~CLRTableAction();

public:
	ACTIONTYPE GetActionType();
	int		   GetParameter();

	void SetAction( ACTIONTYPE action, int param = -1 );

public:
	CLRTableAction &operator = ( CLRTableAction &action );
};

//
// NX CLRTableCell
//
// \Ȃ̈̃Z̏ێ
//
class CLRTableCell
{
private:
	int					 m_nIndex;				// Z̃CfbNX
	CELLTYPE			 m_nType;				// Z̎
	int					 m_nContinuousCount;	// m_nType == TYPE_NOTHING̎C̃Z̘A
	list < CLRTableAction * >	 m_ActionList;			// ANVXg(ANVĂꍇɂ́C̗vfj

public:
	CLRTableCell();
	CLRTableCell( int index, CLRTableAction &action );
	CLRTableCell( int startindex, int continuous );
	CLRTableCell( CLRTableCell &cell );

	virtual ~CLRTableCell();

public:
	int      GetCellIndex();	
	CELLTYPE GetCellType();

	int		 GetContinuousCount();
	
	int		 GetActionCount();
	CLRTableAction &GetAction( int index = 0 );
	CLRTableAction *GetActionPtr( int index = 0 );
	

	void SetCellIndex( int index );
	void SetCellType( CELLTYPE type );
	
	void SetContinuousCount( int continuous );

	int  SetAction( ACTIONTYPE action, int param = -1 );
	int  SetAction( CLRTableAction &action );
	
	int  AddAction( ACTIONTYPE action, int param = -1 );
	int  AddAction( CLRTableAction &action );
	
public:
	void Initialize();

public:
	CLRTableCell &operator = ( CLRTableCell &cell );

protected:
	void RemoveAction();
};

//
// NX CLRTableState
//
// ͕\̊eԂɂ
//
class CLRTableState
{
private:
	int						   m_nStateNumber;		// Ԕԍ
	int						   m_nInputCount;		// ͐
	list < CLRTableCell * >    m_CellList;			// Z̃Xgi\̉j
	CSymbolToIndex             m_SymbolIndexMap;	// LCfbNX

public:
	CLRTableState();
	CLRTableState( int state, int input, CSymbolTable &symbol );
	CLRTableState( CLRTableState &state );
	
	virtual ~CLRTableState();

public:
	void Initialize();

	int GetCellCount();
	int GetInputCount();

	int	GetStateNumber();

	CLRTableCell &GetCell( const char *input );
	CLRTableCell &GetCellIndex( int index );

	int SetCell( const char *input, ACTIONTYPE action = ACTION_NOTHING, int param = -1, bool append = true );
	int ResetCell( const char *input );

	CSymbolToIndex &GetSymbolIndexMap();
	CSymbolToIndex *GetSymbolIndexMapPtr();

	int AddCell( CLRTableCell &cell );

public:
	CLRTableState &operator = ( CLRTableState &state );

protected:
	void InitializeCellList();

	CLRTableCell &GetCell( int index );
	int			  SetCell( int index, ACTIONTYPE action = ACTION_NOTHING, int param = -1, bool append = true );
	int			  ResetCell( int index );
};

//
// NX CLRSubTable
//

class CLRSubTable
{
private:
	vector < CLRTableState * > m_State;		// ԃXg(\̏cj

public:
	CLRSubTable();
	CLRSubTable( int state, CSymbolTable &symbol );
	CLRSubTable( CLRSubTable &table );

	virtual ~CLRSubTable();

public:
	void Initialize();
	int  MakeTable( int state, CSymbolTable &symbol );

	int GetStateCount();

	CLRTableState &GetState( int state );
	CLRTableState *GetStatePtr( int state );

public:
	CLRSubTable &operator = ( CLRSubTable &table );

	void Display();
};

//
// NX CLRTable
//

class CLRTable
{
private:
	CLRSubTable m_ActionTable;		// action\
	CLRSubTable m_GotoTable;		// goto\

public:
	CLRTable();
	CLRTable( CLRTable &table );

	virtual ~CLRTable();

public:
	CLRSubTable &GetActionTable();
	CLRSubTable *GetActionTablePtr();
	CLRSubTable &GetGotoTable();
	CLRSubTable *GetGotoTablePtr();

	void Init();

public:
	CLRTable &operator = ( CLRTable &table );
};

#endif  _LRTABLE_H_
