//
// SLR(1)\͊vO
// LR\͕\
//
// Grammar.h / Grammar.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/09/10 Tue. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <iostream>
#include <assert.h>

#include "LRTable.h"

using namespace std;

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//

//
// NX CSymbolToIndex
//


//
// ֐ : CSymbolToIndex::CSymbolToIndex()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex::CSymbolToIndex() : m_SymbolMap()
{
}

//
// ֐ : CSymbolToIndex::CSymbolToIndex( CSymbolTable &table )
// @  \ : RXgN^ie[u)
//    : table --- ̌ɂȂL\
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex::CSymbolToIndex( CSymbolTable &table )
{
	MakeMap( table );
}

//
// ֐ : CSymbolToIndex::CSymbolToIndex( CSymbolToIndex &sym )
// @  \ : Rs[RXgN^
//    : sym ---- Rs[
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex::CSymbolToIndex( CSymbolToIndex &sym ) : m_SymbolMap()
{
	int size = sym.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		m_SymbolMap.insert( pair < string, int >( sym.GetSymbol( i ), i ) );
	}
}

//
// ֐ : CSymbolToIndex::~CSymbolToIndex()
// @  \ : fXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex::~CSymbolToIndex()
{
	m_SymbolMap.clear();
}


//
// ֐ : int CSymbolToIndex::GetSize()
// @  \ : vfԂ
//    : Ȃ
// ߂l : m_SymbolMapIuWFNgvf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CSymbolToIndex::GetSize()
{
	return m_SymbolMap.size();
}

//
// ֐ : int CSymbolToIndex::GetIndex( const char *symbol )
// @  \ : LCfbNX擾
//    : symbol ---- CfbNX擾L
// ߂l : CfbNXl
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CSymbolToIndex::GetIndex( const char *symbol )
{
	// symbolL[[hɑΉCfbNX
	map < string, int >::iterator mp = m_SymbolMap.find( symbol );

	if ( mp != m_SymbolMap.end() ) { 
		// ̂ŁC̃CfbNXԂ
		return mp->second;
	}

	return -1;		// Ȃ
}

//
// ֐ : const char *CSymbolToIndex::GetSymbol( int index )
// @  \ : CfbNXΉL
//    : index ---- CfbNX
// ߂l : CfbNXɑΉL
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
const char *CSymbolToIndex::GetSymbol( int index )
{
	if ( ( index < 0 ) || ( index >= m_SymbolMap.size() ) ) {
		// CfbNX̎w肪ŝNULLԂ
		return NULL;
	}

	map < string, int >::iterator sp = m_SymbolMap.begin();
	map < string, int >::iterator ep = m_SymbolMap.end();

	while ( sp != ep ) {
		if ( sp->second == index ) {
			// !
			return (sp->first).c_str();
		}
		sp ++;
	}

	return NULL;	// ȂB
}

//
// ֐ : int CSymbolToIndex::MakeMap( CSymbolTable &table )
// @  \ : }bv𐶐
//    : table ---- ɂȂL\
// ߂l : L
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CSymbolToIndex::MakeMap( CSymbolTable &table )
{
	int size = table.GetSize();

	CSymbol sym;
	for ( int i = 0; i < size; i ++ ) {
		table.GetSymbol( i, sym );
		m_SymbolMap.insert( pair < string, int >( sym.GetSymbol(), i ) );
	}

	return m_SymbolMap.size();
}

//
// ֐ : CSymbolToIndex &CSymbolToIndex::operator = ( CSymbolToIndex &sym )
// @  \ : Zq
//    : sym --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex &CSymbolToIndex::operator = ( CSymbolToIndex &sym )
{
	if ( &sym == this ) { return *this; }

	m_SymbolMap.clear();

	int size = sym.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		m_SymbolMap.insert( pair < string, int >( sym.GetSymbol( i ), i ) );
	}

	return *this;
}

//
// ֐ : void CSymbolToIndex::Init()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/09/10 Tue.
// 쐬 :  G
//
// ŏIXV : 2002/09/10 Tue.
//
void CSymbolToIndex::Init()
{
	m_SymbolMap.clear();
}

//
// NX CLRTableAction
//

//
// ֐ : CLRTableAction::CLRTableAction()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction::CLRTableAction()
{
	m_nAction = ACTION_NOTHING;
	m_nParameter = -1;
}

//
// ֐ : CLRTableAction::CLRTableAction( ACTIONTYPE action, int param )
// @  \ : RXgN^
//    : action --- U镑̎
//			param ---- U镑̃p[^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction::CLRTableAction( ACTIONTYPE action, int param )
{
	m_nAction = action;
	m_nParameter = param;
}

//
// ֐ : CLRTableAction::CLRTableAction( CLRTableAction &action )
// @  \ : Rs[RXgN^
//    : action ---- Rs[
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction::CLRTableAction( CLRTableAction &action )
{
	m_nAction = action.GetActionType();
	m_nParameter = action.GetParameter();
}

//
// ֐ : CLRTableAction::~CLRTableAction()
// @  \ : fXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction::~CLRTableAction()
{
}

//
// ֐ : ACTIONTYPE CLRTableAction::GetActionType()
// @  \ : U镑̎ނ擾
//    : Ȃ
// ߂l : ACTIONTYPE񋓌^̒l
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
ACTIONTYPE CLRTableAction::GetActionType()
{
	return m_nAction;
}


//
// ֐ : int CLRTableAction::GetParameter()
// @  \ : U镑ɑΉp[^擾
//    : Ȃ
// ߂l : U镑ɑΉp[^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableAction::GetParameter()
{
	return m_nParameter;
}

//
// ֐ : void CLRTableAction::SetAction( ACTIONTYPE action, int param )
// @  \ : ANVݒ肷
//    : action ---- U镑̎
//			param ----- U镑ɑΉp[^
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableAction::SetAction( ACTIONTYPE action, int param )
{
	m_nAction = action;
	m_nParameter = param;
}

//
// ֐ : CLRTableAction &CLRTableAction::operator = ( CLRTableAction &action )
// @  \ : Zq
//    : action --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction &CLRTableAction::operator = ( CLRTableAction &action )
{
	if ( &action == this ) { return *this; }

	m_nAction = action.GetActionType();
	m_nParameter = action.GetParameter();

	return *this;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//

//
// NX CLRTableCell
//

//
// ֐ : CLRTableCell::CLRTableCell()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell::CLRTableCell() : m_ActionList()
{
	m_nIndex = -1;
	m_nType  = TYPE_NOTHING;
	m_nContinuousCount = -1;
}


//
// ֐ : CLRTableCell::CLRTableCell( int index, CLRTableAction &action )
// @  \ : RXgN^iU镑ݒpj
//    : index ---- CfbNX
//			action --- ANV
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell::CLRTableCell( int index, CLRTableAction &action )
{
	m_nIndex = index;
	m_nType = TYPE_ACTION;
	m_nContinuousCount = 1;

	AddAction( action );
}

//
// ֐ : CLRTableCell::CLRTableCell( int startindex, int continuous )
// @  \ : RXgN^(ANVȂݒpj
//    : startindex ---- 擪̃CfbNX
//			continuous ---- A
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell::CLRTableCell( int startindex, int continuous ) : m_ActionList()
{
	m_nIndex = startindex;
	m_nType = TYPE_NOTHING;
	m_nContinuousCount = continuous;
}

//
// ֐ : CLRTableCell::CLRTableCell( CLRTableCell &cell )
// @  \ : Rs[RXgN^
//    : cell ----- Rs[
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell::CLRTableCell( CLRTableCell &cell )
{
	m_nIndex = cell.GetCellIndex();
	m_nType  = cell.GetCellType();
	m_nContinuousCount = cell.GetContinuousCount();
	
	int size = cell.GetActionCount();
	for ( int i = 0; i < size; i ++ ) {
		AddAction( cell.GetAction( i ) );
	}
}

//
// ֐ : CLRTableCell::~CLRTableCell()
// @  \ : fXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell::~CLRTableCell()
{
	Initialize();
}

//
// ֐ : int CLRTableCell::GetCellIndex()
// @  \ : Z̃CfbNX擾
//    : Ȃ
// ߂l : m_nIndex ̒l
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::GetCellIndex()
{
	return m_nIndex;
}


//
// ֐ : CELLTYPE CLRTableCell:GetCellType()
// @  \ : Z̎ނ擾
//    : Ȃ
// ߂l : CELLTYPE 񋓌^̒l
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//

CELLTYPE CLRTableCell::GetCellType()
{
	return m_nType;
}

//
// ֐ : int CLRTableCell::GetContinuousCount()
// @  \ : Z̘A擾
//    : Ȃ
// ߂l : m_nContinousCount̒l
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::GetContinuousCount()
{
	return m_nContinuousCount;
}

//
// ֐ : int CLRTableCell::GetActionCount()
// @  \ : ĂANV̐Ԃ
//    : Ȃ
// ߂l : m_ActionList̗vf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::GetActionCount()
{
	return m_ActionList.size();
}

//
// ֐ : CLRTableAction &CLRTableCell::GetAction( int index )
// @  \ : ĂANV擾
//    : index ---- Xg̃CfbNX
// ߂l : ĂCLRTableActionIuWFNgւ̎Q
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableAction &CLRTableCell::GetAction( int index )
{
	assert( ( index >= 0 ) );

	list < CLRTableAction * >::iterator sp = m_ActionList.begin();
	list < CLRTableAction * >::iterator ep = m_ActionList.end();

	while ( sp != ep ) {
		if ( index == 0 ) break;
		sp ++; index --;
	}

	assert( sp != ep );

	return *(*sp);
}

//
// ֐ : CLRTableAction *CLRTableCell::GetActionPtr( int index )
// @  \ : ĂANV擾
//    : index ---- Xg̃CfbNX
// ߂l : ĂCLRTableActionIuWFNgւ̃|C^
// 쐬 : 2002/07/06 Sat.
// 쐬 : G
//
// ŏIXV : 2002/07/06 Sat. G
//
CLRTableAction *CLRTableCell::GetActionPtr( int index )
{
	assert( ( index >= 0 ) && ( index < m_ActionList.size() ) );

	list < CLRTableAction * >::iterator sp = m_ActionList.begin();
	list < CLRTableAction * >::iterator ep = m_ActionList.end();

	while ( sp != ep ) {
		if ( index == 0 ) break;
		sp ++; index --;
	}

	assert( sp != ep );

	return *sp;
}


//
// ֐ : void CLRTableCell::SetCellIndex( int index )
// @  \ : Z̃CfbNXݒ肷
//    : index ---- VCfbNX
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableCell::SetCellIndex( int index )
{
	m_nIndex = index;
}

//
// ֐ : void CLRTableCell::SetCellType( CELLTYPE type )
// @  \ : Z̎ނݒ肷
//    : type ---- Z̎ނ킷CELLTYPE񋓌^̒l
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableCell::SetCellType( CELLTYPE type )
{
	m_nType = type;
}


//
// ֐ : void CLRTableCell::SetContinuousCount( int continuous )
// @  \ : Z̘Aݒ肷
//    : continuous ---- Z̘A
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableCell::SetContinuousCount( int continuous )
{
	m_nContinuousCount = continuous;
}

//
// ֐ : int CLRTableCell::SetAction( ACTIONTYPE action, int param )
// @  \ : ܂ł̃ANVXgjCVANVݒ肷
//    : action --- ݒ肷ANV̎
//			param ---- ANVɑΉp[^
// ߂l : m_ActionList̒
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::SetAction( ACTIONTYPE action, int param )
{
	// ܂ł̂̂S폜
	RemoveAction();

	CLRTableAction *pAction = new CLRTableAction( action, param );
	assert( pAction != NULL );

	m_ActionList.push_back( pAction );

	return m_ActionList.size();
}

//
// ֐ : int CLRTableCell::SetAction( CLRTableAction &action )
// @  \ : ܂ł̃ANVXgjCVANVǉ
//    : action --- ݒ肷ANV
// ߂l : m_ActionList̒
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::SetAction( CLRTableAction &action )
{
	return SetAction( action.GetActionType(), action.GetParameter() );
}


//
// ֐ : int CLRTableCell::AddAction( ACTIONTYPE action, int param )
// @  \ : VANVANVXgɒǉ
//    : action ---- ݒ肷ANV̎
//			param ----- ANVɕtp[^
// ߂l : ǉm_ActionList̒
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::AddAction( ACTIONTYPE action, int param )
{
	CLRTableAction *pAction = new CLRTableAction( action, param );
	assert( pAction );

	m_ActionList.push_back( pAction );

	return m_ActionList.size();
}

//
// ֐ : int CLRTableCell::AddAction( CLRTableAction &action )
// @  \ : VANVANVXgɒǉ
//    : action ---- ǉANV
// ߂l : ǉm_ActionList̒
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableCell::AddAction( CLRTableAction &action )
{
	return AddAction( action.GetActionType(), action.GetParameter() );
}

//
// ֐ : void CLRTableCell:Initialize()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableCell::Initialize()
{
	m_nIndex = -1;
	m_nType = TYPE_NOTHING;
	m_nContinuousCount = -1;

	RemoveAction();
}

//
// ֐ : void CLRTableCell::RemoveAction()
// @  \ : ANVXg
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableCell::RemoveAction()
{
	list < CLRTableAction * >::iterator sp = m_ActionList.begin();
	list < CLRTableAction * >::iterator ep = m_ActionList.end();

	while ( sp != ep ) {
		delete *sp;
		sp ++;
	}

	m_ActionList.clear();
}

//
// ֐ : CLRTableCell& CLRTableCell::operator = ( CLRTableCell &cell )
// @  \ : Zq
//    : cell ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell &CLRTableCell::operator = ( CLRTableCell &cell )
{
	if ( &cell == this ) { return *this; }

	RemoveAction();

	m_nIndex = cell.GetCellIndex();
	m_nType  = cell.GetCellType();
	m_nContinuousCount = cell.GetContinuousCount();

	int size = cell.GetActionCount();
	for ( int i = 0; i < size; i ++ ) {
		CLRTableAction *pAction = new CLRTableAction ( cell.GetAction( i ) );
		assert( pAction );
		m_ActionList.push_back( pAction );
	}

	return *this;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//


//
// NX CLRTableState
//


//
// ֐ : CLRTableState::CLRTableState()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState::CLRTableState() :  m_SymbolIndexMap()
{
	m_nStateNumber = -1;
	m_nInputCount = -1;

	InitializeCellList();
}

//
// ֐ : CLRTableState::CLRTableState( int state, int input, CSymbolTable &symbol )
// @  \ : RXgN^
//    : state --- Ԕԍ
//			input --- ͐
//			symbol ---- L\
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState::CLRTableState( int state, int input, CSymbolTable &symbol ) 
	: m_CellList(), m_SymbolIndexMap( symbol )
{
	m_nStateNumber = state;
	m_nInputCount = input;

	InitializeCellList();
}

//
// ֐ : CLRTableState::CLRTableState( CLRTableState &state )
// @  \ : Rs[RXgN^
//    : state ---- Rs[
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState::CLRTableState( CLRTableState &state )
{
	// 
	Initialize();

	// õRs[
	m_nStateNumber = state.GetStateNumber();
	m_nInputCount = state.GetInputCount();
	m_SymbolIndexMap = state.GetSymbolIndexMap();

	// Xg̃Rs[
	int size = state.GetCellCount();
	for ( int i = 0; i < size; i ++ ) {
		AddCell( state.GetCellIndex( i ) );
	}
}


//
// ֐ : CLRTableState::~CLRTableState()
// @  \ : fXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState::~CLRTableState()
{
	Initialize();
}


//
// ֐ : void CLRTableState::Initialzie()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableState::Initialize()
{
	m_nStateNumber = -1;
	m_nInputCount = -1;
	m_SymbolIndexMap = CSymbolToIndex();

	// ł́CXgSɍ폜
	list < CLRTableCell * >::iterator sp = m_CellList.begin();
	list < CLRTableCell * >::iterator ep = m_CellList.end();

	while ( sp != ep ) {
		delete *sp;
		sp ++;
	}

	m_CellList.clear();
}

//
// ֐ : int CLRTableState::GetCellCount()
// @  \ : ĂZ̐擾
//    : Ȃ
// ߂l : m_CellList̗vf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::GetCellCount()
{
	return m_CellList.size();
}

//
// ֐ : int CLRTableState::GetInputCount()
// @  \ : ͐i̒C{̃Z̐j擾
//    : Ȃ
// ߂l : m_nInputCount̒lԂ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::GetInputCount()
{
	return m_nInputCount;
}


//
// ֐ : int CLRTableState::GetStateNumber()
// @  \ : Ԕԍ擾
//    : Ȃ
// ߂l : m_nStateNumber̒lԂ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::GetStateNumber()
{
	return m_nStateNumber;
}


//
// ֐ : CLRTableCell &CLRTableState::GetCell( const char *input )
// @  \ : Z擾
//    : input --- ͋L
// ߂l : CLRTableCellIuWFNgւ̎Q
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell &CLRTableState::GetCell( const char *input )
{
	int index = m_SymbolIndexMap.GetIndex( input );

	return GetCell( index );
}

//
// ֐ : CLRTableCell &CLRTableState::GetCellIndex( int index )
// @  \ : ۂ̃Xg̃CfbNXpăZ擾
//    : index ---- ۂ̃Xg̃CfbNX
// ߂l : CfbNXŎw肵ʒuɂvf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell &CLRTableState::GetCellIndex( int index )
{
	assert( ( index >= 0 ) && ( index < m_CellList.size() ) );

	list < CLRTableCell * >::iterator sp = m_CellList.begin();
	list < CLRTableCell * >::iterator ep = m_CellList.end();

	// 
	while ( ( sp != ep ) && ( index > 0 ) ) {
		sp ++; index --;
	}
	if ( sp == ep ) { assert( false ); }	// Ȃ

	return *(*sp);	// 
}

//
// ֐ : int CLRTableState::SetCell( const char *input, ACTIONTYPE action, int param, bool append )
// @  \ : Zݒ肷
//    : input --- ͋L
//			action -- ANV̎
//			param --- ANVɑΉp[^
//			append -- true̎́CANVǉBfalseł́CANVݒ肵Ȃ
// ߂l : ݒ肵ʒu
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::SetCell( const char *input, ACTIONTYPE action, int param, bool append )
{
	int index = m_SymbolIndexMap.GetIndex( input );

	return SetCell( index, action, param, append );
}

//
// ֐ : int CLRTabeState::ResetCell( const char *input );
// @  \ : vfZbgiANV̂ȂZɂj
//    : input ---- ͋L
// ߂l : ̃Xg̗vf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::ResetCell( const char *input )
{
	int index = m_SymbolIndexMap.GetIndex( input );

	return ResetCell( index );
}


//
// ֐ : CSymbolToIndex &CLRTableState::GetSymbolIndexMap()
// @  \ : LCfbNX\擾
//    : Ȃ
// ߂l : m_SymbolToIndexIuWFNgւ̎Q
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CSymbolToIndex &CLRTableState::GetSymbolIndexMap()
{
	return m_SymbolIndexMap;
}

//
// ֐ : CSymbolToIndex *CLRTableState::GetSymbolIndexMapPtr()
// @  \ : LCfbNX\擾
//    : Ȃ
// ߂l : m_SymbolToIndexIuWFNgւ̃|C^
// 쐬 : 2002/07/06 Sat.
// 쐬 : G
//
// ŏIXV : 2002/07/06 Sat. G
//
CSymbolToIndex *CLRTableState::GetSymbolIndexMapPtr()
{
	return &m_SymbolIndexMap;
}

//
// ֐ : int CLRTableState::AddCell( CLRTableCell &cell )
// @  \ : Zǉ
//    : cell ---- ǉZ
// ߂l : ǉ̃ZXg̃TCY
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::AddCell( CLRTableCell &cell )
{
	CLRTableCell *pCell = new CLRTableCell( cell );
	assert( pCell );

	m_CellList.push_back( pCell );

	return m_CellList.size();
}


//
// ֐ : CLRTableState &CLRTableState::operator = ( CLRTableState &state )
// @  \ : Zq
//    : state ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState &CLRTableState::operator = ( CLRTableState &state )
{
	if ( &state == this ) { return *this; }

	// 
	Initialize();

	// õRs[
	m_nStateNumber = state.GetStateNumber();
	m_nInputCount = state.GetInputCount();
	m_SymbolIndexMap = state.GetSymbolIndexMap();

	// Xg̃Rs[
	int size = state.GetCellCount();
	for ( int i = 0; i < size; i ++ ) {
		AddCell( state.GetCellIndex( i ) );
	}

	return *this;
}


//
// ֐ : void CLRTableState::InitializeCellList()
// @  \ : ZXg
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRTableState::InitializeCellList()
{
	// Ƃ肠CS
	list < CLRTableCell * >::iterator sp = m_CellList.begin();
	list < CLRTableCell * >::iterator ep = m_CellList.end();

	while ( sp != ep ) {
		delete *sp;
		sp ++;
	}

	m_CellList.clear();

	// m_nInputCount̋Z܂Ƃ߂ZЂƂ
	if ( m_nInputCount <= 0 ) { return; }	// ͐w肳ĂȂ̂ōȂ
	
	CLRTableCell *pCell = new CLRTableCell( 0, m_nInputCount );
	assert( pCell );

	// Xgɒǉ
	m_CellList.push_back( pCell );
}

//
// ֐ : CLRTableCell &CLRTableState::GetCell( int index )
// @  \ : ͂̃CfbNXZ擾
//    : index ---- ͋LɑΉCfbNX
// ߂l : Z
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableCell &CLRTableState::GetCell( int index )
{
	// sȂƂ͗O𔭐
	assert( ( index >= 0 ) && ( index < m_nInputCount ) );

	CLRTableCell *ret = NULL;		// returnIuWFNg̃|C^
	int size = GetCellCount();		// ۂ̃XgTCY

	for ( int i = 0; i < size; i ++ ) {
		// ۂɃXgĂZ𒲂ׂB

		CLRTableCell &cell = GetCellIndex( i );	
		int cellindex = cell.GetCellIndex();		// Z̃CfbNX

		if ( cell.GetCellType() == TYPE_ACTION ) {	
			// ZɃANVi[ĂƂ́CindexƃZm_nIndexł邱Ƃ𒲂ׂ
			if ( cellindex == index ) { 
				// ΃|C^retɑC[v𔲂
				ret = &cell; 
				break; 
			}
		}
		else {
			// ZɃANVi[ĂȂƂ́Cindex̃Z܂Ƃ߂Ă͈͂ɓĂ邩ǂ𒲂ׂ
			if ( ( cellindex <= index ) && ( ( cellindex + cell.GetContinuousCount() ) > index ) ) {
				// indexZ܂Ƃ߂Ă͈͂ɓĂ΁CZ̃|C^retɑ[v𔲂
				ret = &cell; 
				break;
			}
		}
	}

	assert ( ret );		// vfȂꍇ́CO𔭐

	return *ret;		// IuWFNg̎QƂԂ
}

//
// ֐ : int CLRTableState::SetCell( int index, ACTONTYPE action, int param, bool append )
// @  \ : w肵ʒũZɃANVݒ肷
//    : index ---- ANVݒ肷Z
//			action --- ANV̎
//			param  ---- ANVɑΉp[^
//			append ---- ANVǉĂꍇtrueCĂ炽ɂꍇfalse
// ߂l : ɃXgĂZ̐
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::SetCell( int index, ACTIONTYPE action, int param, bool append )
{
	assert ( ( index >= 0 ) && ( index < m_nInputCount ) ) ;

	list < CLRTableCell * >::iterator current = m_CellList.begin();
	list < CLRTableCell * >::iterator ep      = m_CellList.end();

	// ݒ肷Ž݈ʒu
	int currentindex;
	while ( current != ep ) {
		currentindex = (*current)->GetCellIndex();
		if ( index == currentindex ) {
			// Z̃CfbNXindex΁CύXʒuB
			break;
		}

		if ( ( (*current)->GetCellType() == TYPE_NOTHING ) && 
			 ( index >= currentindex ) && ( index < ( currentindex + (*current)->GetContinuousCount() ) ) ) 
		{
			//  ZZindex܂ޔ͈͂܂Ƃ߂ĂZł΁C̃ZύX
			break;

		}

		current ++;
	}

	assert( current != ep ) ;		// Ȃ
	
	// ݒʒuɉďs
	if ( ( currentindex == index ) && ( (*current)->GetContinuousCount() == 1 ) ) {
		// ݒ肵ZƗĂꍇ́C̃Z̓eύX
		// (*current)->m_nIndex̕ύX͂Ȃ
		// łɃANVĂꍇ́CKŏB
		(*current)->SetCellType( TYPE_ACTION );
		if ( append ) {
			// ANVǉ
			int action_c = (*current)->GetActionCount();
			for ( int i = 0; i < action_c; i ++ ) {
				CLRTableAction act = (*current)->GetAction( i );
				if ( ( action == act.GetActionType() ) && ( param == act.GetParameter() ) ) {
					// ANVꍇ́CǉsȂB
					break;
				}
			}
			if ( i == action_c ) {
				// ANṼANVǉ
				(*current)->AddAction( action, param );
			}
		}
		else {
			// ANVݒ肵Ȃ
			(*current)->SetAction( action, param );
		}
	}
	else {
		// ݒ肵Z͂ق̃Zƈꏏɂ܂Ƃ܂Ăꍇc
		// }IuWFNg𐶐
		CLRTableCell *pNew = new CLRTableCell( index, CLRTableAction( action, param ) );
		assert( pNew );

		if ( index == currentindex ) {
			// ݒ肵ZZ܂Ƃ߂Ă͈͂̐擪̗vf̎
			// Z܂Ƃ߂Ă͈͂}Z
			(*current)->SetCellIndex( currentindex + 1 );
			(*current)->SetContinuousCount( (*current)->GetContinuousCount() - 1 );
			// Z̑OɐVZ}
			m_CellList.insert( current, pNew );
		}
		else if ( index == ( currentindex + (*current)->GetContinuousCount() - 1 ) ) {
			// ݒ肵ZZ܂Ƃ߂Ă͈̖̗͂vf̂Ƃ
			// Z܂Ƃ߂Ă͈͂}Z
			(*current)->SetContinuousCount( (*current)->GetContinuousCount() - 1 );
			// ŽɐVZǉ
			current ++;
			if ( current != m_CellList.end() ) {
				m_CellList.insert( current, pNew );
			}
			else {
				m_CellList.push_back( pNew );
			}
		}
		else {
			// ݒ肵ZZ܂Ƃ߂Ă͈͂̓ɂ鎞
			// Z͈̔͂ݒ肵ʒu獶Eɕ
			// ݒ肷Z̑OɂZ
			CLRTableCell *pCell = new CLRTableCell( currentindex, index - currentindex );
			assert( pCell );
			// ŹCݒ肷Ž둤ɎĂ
			(*current)->SetCellIndex( index + 1 );
			(*current)->SetContinuousCount( (*current)->GetContinuousCount() + currentindex - index - 1 );
			// ܂ݒ肵Z}
			list < CLRTableCell * >::iterator p = m_CellList.insert( current, pNew );
			// OɂZ}
			m_CellList.insert( p, pCell );
		}
	}
	
	return m_CellList.size();		// ̃XgZ̐Ԃ
}


//
// ֐ : int CLRTableState::ResetCell( int index )
// @  \ : w肵ZZɖ߂
//    : index --- Zɖ߂Z̃CfbNX
// ߂l : m_CellListvf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRTableState::ResetCell( int index )
{
	assert( ( index >= 0 ) & ( index < m_nInputCount ) );

	list < CLRTableCell * >::iterator current = m_CellList.begin();
	list < CLRTableCell * >::iterator ep      = m_CellList.end();

	// ݒ肷Ž݈ʒu
	int currentindex;
	while ( current != ep ) {
		currentindex = (*current)->GetCellIndex();
		if ( index == currentindex ) {
			// Z̃CfbNXindex΁CύXʒuB
			break;
		}

		if ( ( (*current)->GetCellType() == TYPE_NOTHING ) && 
			 ( index >= currentindex ) && ( index < ( currentindex + (*current)->GetContinuousCount() ) ) ) 
		{
			//  ZZindex܂ޔ͈͂܂Ƃ߂ĂZł΁C̃ZύX
			break;

		}
	}

	assert( current != ep ) ;		// Ȃ

	if ( (*current)->GetCellType() == TYPE_NOTHING ) { return m_CellList.size(); }	// ƂƋZ̏ꍇ͏sȂ

	// ZbgZ̑OɂZ̏Ԃɉďs
	list < CLRTableCell * >::iterator p, q;
	p = current; p ++;	// ẼZ
	q = current; p --;	// ̃Z

	if ( ( current == m_CellList.begin() ) || ( (*q)->GetCellType() == TYPE_ACTION ) ) {
		// ZbgvfXg̐擪ɂC܂́C̃ZANVĂꍇ
		//    ˂܂CEɂA\Ȃ
		if ( (*p)->GetCellType() == TYPE_ACTION ) {
			// ẼZANVĂƂ́CZɏ
			*(*current) = CLRTableCell( index, 1 );
		}
		else {
			// ẼZZ̎́Cɋz
			(*p)->SetCellIndex( index );
			(*p)->SetContinuousCount( (*p)->GetContinuousCount() + 1 );
			delete *current;
			m_CellList.erase( current );	// ̃Z͍폜
		}
	}
	else if ( ( current == m_CellList.end() ) || ( (*p)->GetCellType() == TYPE_ACTION ) ) {
		// ZbgZXg̖ɂC܂́CẼZANVĂꍇ
		// @@˂܂CɂA\Ȃ
		if ( (*q)->GetCellType() == TYPE_ACTION ) {
			// ̃ZANVĂƂ͋Zɏ
			*(*current) = CLRTableCell( index, 1 );
		}
		else {
			// ̃ZẐƂ́Cɋz
			(*q)->SetContinuousCount( (*q)->GetContinuousCount() + 1 );
			delete *current;
			m_CellList.erase( current );	// ̃Z͍폜
		}
	}
	else {
		// ZbgZ̗[Z̎c
		// ZbgZƂ̉ẼZ̃Zɋz
		(*q)->SetContinuousCount( (*q)->GetContinuousCount() + (*p)->GetContinuousCount() + 1 );
		// ZbgZƂ̉ẼZ폜
		delete *current;
		delete *p;
		m_CellList.erase( current );
		m_CellList.erase( p );
	}

	return m_CellList.size();
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//

//
// CLRSubTableNX
//

//
// ֐ : CLRSubTable::CLRSubTable()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRSubTable::CLRSubTable() : m_State()
{
}

//
// ֐ : CLRSubTable::CLRSubTable( int state, CSymbolTable &symbol )
// @  \ : RXgN^
//    : state --- Ԑ
//			symbol --- ͋L
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRSubTable::CLRSubTable( int state, CSymbolTable &symbol ) 
{
	MakeTable( state, symbol );
}

//
// ֐ : CLRSubTable::CLRSubTable( CLRtable &table )
// @  \ : Rs[RXgN^
//    : table -- Rs[
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRSubTable::CLRSubTable( CLRSubTable &table )
{
	Initialize();

	int size = table.GetStateCount();
	for ( int i = 0; i < size; i ++ ) {
		m_State.push_back( new CLRTableState( table.GetState( i ) ) );
	}
}

//
// ֐ : CLRSubTable::~CLRSubTable()
// @  \ : fXgN^
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRSubTable::~CLRSubTable()
{
	Initialize();
}

//
// ֐ : void CLRSubTable::Initialize()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
void CLRSubTable::Initialize()
{
	int size = m_State.size();

	for ( int i = 0; i < size; i ++ ) {
		delete m_State[ i ];
	}

	m_State.clear();
}

//
// ֐ : int CLRSubTable::MakeTable( int state, CSymbolTable &symbol )
// @  \ : \𐶐
//    : state ---- Ԑ
//			symbol --- ͋L
// ߂l : Ԑ
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRSubTable::MakeTable( int state, CSymbolTable &symbol )
{
	Initialize();	// 

	// ԂǉĂc
	for ( int i = 0; i < state; i ++ ) {
		m_State.push_back( new CLRTableState( i, symbol.GetSize(), symbol ) );
	}

	return state;
}

//
// ֐ : int CLRSubTable::GetStateCount()
// @  \ : Ԑ擾
//    : Ȃ
// ߂l : m_Statevf
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
int CLRSubTable::GetStateCount()
{
	return m_State.size();
}

//
// ֐ : CLRTableState &CLRSubTable::GetState( int state )
// @  \ : w肳ꂽԂ擾
//    : state ---- Ԕԍ
// ߂l : CLRTableStateIuWFNgւ̎Q
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRTableState &CLRSubTable::GetState( int state )
{
	assert ( ( state >= 0 ) && ( state < m_State.size() ) );

	CLRTableState *pState = m_State[ state ];

	return *pState;
}

//
// ֐ : CLRTableState *CLRSubTable::GetStatePtr( int state )
// @  \ : w肳ꂽԂ擾
//    : state ---- Ԕԍ
// ߂l : CLRTableStateIuWFNgւ̎Q
// 쐬 : 2002/07/06 Sat.
// 쐬 : G
//
// ŏIXV : 2002/07/06 Sat. G
//
CLRTableState *CLRSubTable::GetStatePtr( int state )
{
	assert ( ( state >= 0 ) && ( state < m_State.size() ) );

	CLRTableState *pState = m_State[ state ];

	return pState;
}

//
// ֐ : CLRSubTable &CLRSubTable::operator = ( CLRSubTable &table )
// @  \ : Zq
//    : table --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/06 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/06 Tue.
//
CLRSubTable &CLRSubTable::operator = ( CLRSubTable &table )
{
	if ( &table == this ) { return *this; }

	Initialize();

	int size = table.GetStateCount();
	for ( int i = 0; i < size; i ++ ) {
		CLRTableState *pNew = new CLRTableState( table.GetState( i ) );
		m_State.push_back( pNew );
//		m_State.push_back( new CLRTableState( table.GetState( i ) ) );
	}

	return *this;
}

//
// ֐ : void CLRSubTable::Display()
// @  \ : \o͂
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
void CLRSubTable::Display()
{
	int size = GetStateCount();
	if ( size <= 0 ) { return; }

	CLRTableState state = GetState( 0 );
	CSymbolToIndex sti = state.GetSymbolIndexMap();
	int input_count = sti.GetSize();

	for ( int k = 0; k < sti.GetSize(); k ++ ) {
		cout << k << "-" << sti.GetSymbol( k ) << endl;
	}

	for ( int i = 0; i < size; i ++ ) {
		state = GetState( i );
		int cell_count = state.GetCellCount();

		for ( int j = 0; j < cell_count; j ++ ) {
			CLRTableCell cell = state.GetCellIndex( j );
			if ( cell.GetCellType() == TYPE_ACTION ) {
				cout << "[" << i << "," << sti.GetSymbol( cell.GetCellIndex() ) << "] = {";
				int action_count = cell.GetActionCount();
				for ( int i = 0; i < action_count; i ++ ) {
					CLRTableAction &action = cell.GetAction( i );
					switch ( action.GetActionType() ) {
					case ACTION_SHIFT:
						cout << "shift(" << action.GetParameter() << ")";
						break;
					case ACTION_REDUCE:
						cout << "reduce(" << action.GetParameter() << ")";
						break;
					case ACTION_ACCEPT:
						cout << "accept";
						break;
					default:
						break;
					}
				}
				cout << "}" << endl;
			}
		}
	}

}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//


//
// NX CLRTable
//

//
// ֐ : CLRTable::CLRTable()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRTable::CLRTable() : m_ActionTable(), m_GotoTable()
{
}

//
// ֐ : CLRTable::CLRTable( CLRTable &table )
// @  \ : Rs[RXgN^
//    : table --- Rs[
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRTable::CLRTable( CLRTable &table )
{
	m_ActionTable = table.GetActionTable();
	m_GotoTable   = table.GetGotoTable();
}



//
// ֐ : CLRTable::~CLRTable()
// @  \ : fXgN^
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRTable::~CLRTable()
{
}

//
// ֐ : CLRSubTable &CLRTable::GetActionTable()
// @  \ : action\擾
//    : Ȃ
// ߂l : m_ActionTableIuWFNgւ̎Q
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRSubTable &CLRTable::GetActionTable()
{
	return m_ActionTable;
}

//
// ֐ : CLRSubTable *CLRTable::GetActionTablePtr()
// @  \ : action\擾
//    : Ȃ
// ߂l : m_ActionTableIuWFNgւ̃|C^
// 쐬 : 2002/07/06 Sat.
// 쐬 : G
//
// ŏIXV : 2002/07/06 Sat. G
//
CLRSubTable *CLRTable::GetActionTablePtr()
{
	return &m_ActionTable;
}


//
// ֐ : CLRSubTable &CLRTable::GetGotoTable()
// @  \ : goto\擾
//    : Ȃ
// ߂l : m_GotoTableIuWFNgւ̎Q
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRSubTable &CLRTable::GetGotoTable()
{
	return m_GotoTable;
}

//
// ֐ : CLRSubTable &CLRTable::GetGotoTable()
// @  \ : goto\擾
//    : Ȃ
// ߂l : m_GotoTableIuWFNgւ̃|C^
// 쐬 : 2002/07/06 Sat.
// 쐬 : G
//
// ŏIXV : 2002/07/06 Sat. G
//
CLRSubTable *CLRTable::GetGotoTablePtr()
{
	return &m_GotoTable;
}


//
// ֐ : CLRTable &::CLRTable::operator = ( CLRTable &table )
// @  \ : Zq
//    : table -- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//
CLRTable &CLRTable::operator = ( CLRTable &table )
{
	if ( &table == this ) { return *this; }
	
//	cout << "before" << endl;
//	m_ActionTable.Display();


	m_ActionTable = table.GetActionTable();
	m_GotoTable   = table.GetGotoTable();

//	cout << "after" << endl;
//	m_ActionTable.Display();

	return *this;
}

//
// ֐ : void CLRTable::Init()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/09/10 Tue.
// 쐬 :  G
//
// ŏIXV : 2002/09/10 Tue.
//
void CLRTable::Init()
{
	m_ActionTable.Initialize();
	m_GotoTable.Initialize();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/08 Thu
// 쐬 : J F
//
// ŏIXV : 2001/11/08 Thu
//

