//
// MMIVXe Ver.1.1 ͓
// ͓\
// 
// IntegrationTableCreator2.h / IntegrationTableCreator2.cpp
//
// 2002/07/08 Mon. G
//
#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "stdafx.h"
#include <fstream>
#include <assert.h>
#include <queue>
#include <stdlib.h>

#include "IntegrationTableCreator2.h"
#include "SLRTableCreator.h"
#include "Grammar.h"
#include "XISLNodeList.h"
#include "InputInfo.h"


//
// Oϐ
//
extern const char *TIMEOUT_SYMBOL;		// I[Ltimeout

//
// K̔ԍ
static int production_number = 0;

// gp萔
// ^O̎
static const char * NODE_DIALOG			 = "dialog";		// <dialog>
static const char * NODE_EXCHANGE		 = "exchange";		// <exchange>
static const char * NODE_COMBINATION_SEQ = "seq_";			// <seq_exhange>,<seq_input>
static const char * NODE_COMBINATION_ALT = "alt_";			// <alt_exchange>,<alt_input>
static const char * NODE_COMBINATION_PAR = "par_";			// <par_exchange>,<par_input>
static const char * NODE_INPUT			 = "input";			// <input>
static const char * NODE_OPERATION		 = "operation";		// <operation>

// comb̎
static const char * COMB_SEQUENTIAL  = "seq";			// sequential
static const char * COMB_ALTERNATIVE = "alt";			// alternative
static const char * COMB_PARALLEL    = "par";			// parallel

// znumber̃TCY
#define NUMBER_SIZE 5


//
// CIntegrationTableCreator
//

//
// ֐ : CIntegrationTableCreator2::CIntegrationTableCreator2()
// @  \ : ftHgRXgN^
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon.
//
CIntegrationTableCreator2::CIntegrationTableCreator2()
{
}

//
// ֐ : CIntegrationTableCreator2::~CIntegrationTableCreator2()
// @  \ : fXgN^
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon.
//
CIntegrationTableCreator2::~CIntegrationTableCreator2()
{
}

//
// ֐ : int CIntegrationTableCreator2::IntegrationTableCreate( const char *source, CInputIntegrator2 &integrator, CInputInfoList &infolist )
// @  \ : \𐶐
//    : source ---- XISL̃\[X
//			integrator --- \iój
//			infolist ----- <input>iój
// ߂l : 0CȊO͕̒lԂ
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon.
//
int CIntegrationTableCreator2::IntegrationTableCreate( const char *source, CInputIntegrator2 &integrator, CInputInfoList &infolist )
{
//	fstream fs("OperationList.txt", ios::app | ios::out );
//	fs << " *** Received *** " << endl;
//	fs << source << endl << endl;
//	fs.close();

	const char *startsymbol = "DD";
	::production_number = 0;
	
	CXMLManager xml;
	XMLNodeArray dlglist;
	
	CGLRParser			 &parser		 = (CGLRParser&)integrator.GetParser();
	CContextFreeGrammar	 &grammar		 = parser.GetGrammar();
	CSymbolTable		 &nonterminal	 = grammar.GetNonterminalSymbol();
	CSymbolTable		 &terminal		 = grammar.GetTerminalSymbol();
	CProductionSet		 &production	 = grammar.GetProductionSet();
	CSymbol				 &start			 = grammar.GetStartSymbol();
	CXISLNodeList		 &nodelist		 = (CXISLNodeList&)integrator.GetNodeList();
	CLRTable			 &table			 = parser.GetLRTable();
	CProduction			 pro;
	
	if( xml.LoadXML( source ) < 0 ) { return -1; }
	
	// ^CAEgLǉ
	terminal.AddSymbol( TIMEOUT_SYMBOL, SYMBOL_TERMINAL );
	
	// <dialog>T
	// ͈Ȃ͂iver.1.1j
	int dlgcount = xml.FindNodesByTagName( "dialog", dlglist );
	if( dlgcount != 1 ){ return -2; }
	// id擾
	XMLAttributeList attrlist;
	XMLAttributeList::iterator mp;
	string id;
	
	xml.GetAttributes( dlglist[0], attrlist );
	mp = attrlist.find( "id" );
	if( mp == attrlist.end() ) { return -3; }
	id = mp->second;
	
	start.SetSymbol( startsymbol, SYMBOL_NONTERMINAL );
	// DD<dialog>idlL\ɒǉ
	nonterminal.AddSymbol( startsymbol, SYMBOL_NONTERMINAL );
	nonterminal.AddSymbol( id.c_str(), SYMBOL_NONTERMINAL );
	nodelist.AddNodeInfo( CXISLNodeInfo( id, TYPE_NODE_DIALOG ) );
	
	// DD = dialog ̐K𐶐
	pro.SetNumber( ::production_number++ );
	pro.SetLeftSideSymbol( startsymbol );
	pro.AddRightSideSymbol( (mp->second).c_str() );
	production.AddProduction( pro );
	
	// <dialog>comb擾
	mp = attrlist.find( "comb" );
	string comb;
	if( mp == attrlist.end() )
	{
		comb = "seq";
	}
	else
	{
		comb = mp->second;
	}
	
	// ȍ~̐K
	CreateGrammar( dlglist[0], id, id, comb, integrator, infolist );
	
	
	// \𐶐
	CSLRTableCreator creator;
	creator.CreateSLRTable( grammar, table );
	return 0;
}

//
// ֐ : int CIntegrationTableCreator2::CreateGrammar( MSXML2::IXMLDOMNode *pNode, string exchange_name, string &symbol, string &comb, CInputIntegrator2 &integrator, CInputInfoList &infolist )
// @  \ : @̍쐬
//    : pNode ---- K̍ӂɗpm[h
//			exchange_name --- <input><exchange>̋L
//			symbol ----- K̍ӂɂI[L
//			comb ---- comb̒l
//			integrator ---- \
//			infolist ---- ͏񃊃Xg
// ߂l : 0CȊO͕̒lԂ
// 쐬 : 2002/07/10 Wed.
// 쐬 : G
//
// ŏIXV : 2002/07/10 Wed.
//
int CIntegrationTableCreator2::CreateGrammar( MSXML2::IXMLDOMNode *pNode, string exchange_name, string &symbol, string &comb, CInputIntegrator2 &integrator, CInputInfoList &infolist )
{
	assert( pNode != NULL );
	
	// id̂ȂLɕt
	static int comb_number = 0;
	static int input_number = 0;
	
	char number[ NUMBER_SIZE + 1 ];
	
	CGLRParser			 &parser		 = (CGLRParser&)integrator.GetParser();
	CContextFreeGrammar	 &grammar		 = parser.GetGrammar();
	CSymbolTable		 &nonterminal	 = grammar.GetNonterminalSymbol();
	CSymbolTable		 &terminal		 = grammar.GetTerminalSymbol();
	CProductionSet		 &production	 = grammar.GetProductionSet();
	CXISLNodeList		 &nodelist		 = (CXISLNodeList&)integrator.GetNodeList();
	CProduction			 pro;
	CXMLManager			 xml;

	
	// ܂symbolӂɂ鐶K
	XMLNodeArray childlist;
	int childcount;
	childcount = xml.GetChildNodes( pNode, childlist );
	if( childcount < 1 )
	{
		// qm[hȂ̂ŐKȂ
		return 0;
	}
	
	// I[Lƃm[h̑Ή邽߂̃f[^
	map < string, MSXML2::IXMLDOMNode* > sym2node;
	
	// K鎞ɗp
	list < string > symlist;
	
	// qm[h𒲂ׂ
	string nodename, nodesym;
	XMLAttributeList attrlist;
	XMLAttributeList::iterator ap;
	CInputInfo input, input_out;
	CInputIndividualInfo indivi, indivi_out;
	CInputAnalyzer ana;
	
	static bool first_call = true;
	
	for( int i = 0; i < childcount; i++ )
	{
		nodename = xml.GetNodeName( childlist[i] );		 // m[h擾
		xml.GetAttributes( childlist[i], attrlist );	 // l擾
		
		// m[h̎ނɉďi<dialog>oĂ邱Ƃ͖͂)
		if( nodename == NODE_INPUT )
		{
			// target邩ׂ
			string target;
			ap = attrlist.find( "target" );
			if( ap == attrlist.end() )
			{
				// targetȂ<operation>target}
				// ܂<operation>T
				MSXML2::IXMLDOMNode *pOpeNode;
				if( childlist[i]->get_parentNode( &pOpeNode ) == S_OK )
				{
					string name = xml.GetNodeName( pOpeNode );
					if( name == "operation" )
					{
						// evf<operation>
						XMLAttributeList attr;
						xml.GetAttributes( pOpeNode, attr );
						ap = attr.find( "target" );
						if( ap == attr.end() ){	target = ""; }
						else { target = ap->second; }
					}
					else
					{
						// e<operation>ł͂Ȃ
						// ɂk
						MSXML2::IXMLDOMNode *pNode;
						if( pOpeNode->get_parentNode( &pNode ) == S_OK )
						{
							string name = xml.GetNodeName( pNode );
							if( name == "operation" )
							{	XMLAttributeList attr;
								xml.GetAttributes( pOpeNode, attr );
								ap = attr.find( "target" );
								if( ap == attr.end() ) { target = ""; }
								else { target = ap->second; }
							}
						}
					}
				}
				ana.AnalysisInput( childlist[i], exchange_name, input, indivi );
				input.SetTargetAttribute( target );
			}
			else
			{
				ana.AnalysisInput( childlist[i], exchange_name, input, indivi );
			}

			// 󋵂t@C֏o
			
//			ofstream ofs1;
//			if ( first_call ) { ofs1.open( "input_list.txt" ); }
//			else			  { ofs1.open( "input_list.txt", ios::out | ios::app ); }
//			if ( ofs1 ) {
//				ofs1 << "Base Info:<input type=\"" << input.GetTypeAttribute() << "\" event=\"" << input.GetEventAttribute() << "\" match=\"" << input.GetMatchAttribute() << "\" target=\"" << input.GetTargetAttribute() << "\"/>" << endl;
//				ofs1.close();
//			}
			
			first_call = false;
			
			if( !infolist.ExistInputInfo( input, input_out ) )
			{
				// ߂Ẵm[h^CvȂ̂ŁAm[h^ i1,i2,i*....
				nodename = string( "i" ) + itoa( input_number, number, NUMBER_SIZE );
				input_number++;
				
				input.SetInputSymbol( nodename );
				indivi.SetInputSymbol( nodename );
				
				// I[LWɒǉ
				terminal.AddSymbol( nodename.c_str(), SYMBOL_TERMINAL );
				// ͏񃊃Xgɒǉ
				infolist.AddInputInfo( input );
				infolist.AddInputIndividualInfo( indivi );
			}
			else
			{
				// łɑ݂^Cv̓
				if( !infolist.ExistInputIndividualInfo( indivi, indivi_out ) )
				{
					// ʏ񂪈قȂĂΒǉĂ
					nodename = input_out.GetInputSymbol();
					indivi.SetInputSymbol( nodename );
					infolist.AddInputIndividualInfo( indivi );
					
					if( !terminal.ExistSymbol( nodename.c_str() ) )
					{
						terminal.AddSymbol( nodename.c_str(), SYMBOL_TERMINAL );
					}
				}
			}
			
			symlist.push_back( nodename );
		}
		else if( nodename == NODE_EXCHANGE )
		{
			ap = attrlist.find( "id" );
			if( ap != attrlist.end() )
			{
				// id
				nodesym = ap->second;
				// eL\⃊Xg<exchange>o^
				nonterminal.AddSymbol( nodesym.c_str(), SYMBOL_NONTERMINAL );
				nodelist.AddNodeInfo( CXISLNodeInfo( nodesym, TYPE_NODE_EXCHANGE ) );
				sym2node.insert( pair < string, MSXML2::IXMLDOMNode* > ( nodesym, childlist[i] ) );
				symlist.push_back( nodesym );
			}
		}
		else if( nodename.find( NODE_COMBINATION_SEQ ) != string::npos )
		{
			// <seq_exchange>,<seq_input>
			nodename = string( "seq_comb" ) + itoa( comb_number, number, NUMBER_SIZE ) ;
			comb_number++;
			// eL\⃊Xgɓo^
			nonterminal.AddSymbol( nodename.c_str(), SYMBOL_NONTERMINAL );
			nodelist.AddNodeInfo( CXISLNodeInfo( nodename, TYPE_NODE_COMBINATION ) );
			sym2node.insert( pair < string, MSXML2::IXMLDOMNode* >( nodename, childlist[i] ) );
			symlist.push_back( nodename );
		}
		else if( nodename.find( NODE_COMBINATION_ALT ) != string::npos )
		{
			nodename = string( "alt_comb" ) + itoa( comb_number, number, NUMBER_SIZE ) ;
			comb_number++;
			// eL\⃊Xgɓo^
			nonterminal.AddSymbol( nodename.c_str(), SYMBOL_NONTERMINAL );
			nodelist.AddNodeInfo( CXISLNodeInfo( nodename, TYPE_NODE_COMBINATION ) );
			sym2node.insert( pair < string, MSXML2::IXMLDOMNode* >( nodename, childlist[i] ) );
			symlist.push_back( nodename );
		}
		else if( nodename.find( NODE_COMBINATION_PAR ) != string::npos )
		{
			nodename = string( "par_comb" ) + itoa( comb_number, number, NUMBER_SIZE ) ;
			comb_number++;
			// eL\⃊Xgɓo^
			nonterminal.AddSymbol( nodename.c_str(), SYMBOL_NONTERMINAL );
			nodelist.AddNodeInfo( CXISLNodeInfo( nodename, TYPE_NODE_COMBINATION ) );
			sym2node.insert( pair < string, MSXML2::IXMLDOMNode* >( nodename, childlist[i] ) );
			symlist.push_back( nodename );
		}
		else
		{
			continue;
		}
	}
	
	// K
	CreateProduction( symbol, comb, symlist, nodelist, production );
	
	// ŌɁAŗpI[LɊւ鐶K
	list < string >::iterator sp = symlist.begin();
	list < string >::iterator ep = symlist.end();
	map < string, MSXML2::IXMLDOMNode * >::iterator mp;
	string nodecomb, current_exchange;
	CXISLNodeInfo nodeinfo;

	int exchange_index = 0;
 
	for ( ; sp != ep; sp ++ ) {
		if ( ( mp = sym2node.find( *sp ) ) != sym2node.end() ) {
			// I[L̎c
			nodeinfo = nodelist.GetNodeInfo( *sp );
			MSXML2::IXMLDOMNode *pChild = mp->second;
			
			if ( nodeinfo.GetNodeType() == TYPE_NODE_EXCHANGE ) {
				// <exchange>̎́C<operation>comb擾
				XMLNodeArray oprlist;
				if ( xml.FindNodesByTagName( NODE_OPERATION, mp->second, oprlist ) == 1 ) {
					// <exchange>̎qvf́C<operation>̂
					xml.GetAttributes( oprlist[ 0 ], attrlist );
					if ( ( ap = attrlist.find( "comb" ) ) != attrlist.end() ) {
						// comb΁Cɏ]
						nodecomb = ap->second;
					}
					else {
						// ftHǵCcomb="par"
						nodecomb = "par";
					}

					// ̋LɊւ鐶K
//					cout << "MAKE GRAMMAR FOR " << *sp << endl;
					current_exchange = *sp;
					CreateGrammar( oprlist[ 0 ], *sp, *sp, nodecomb, integrator, infolist );
				}
			}
			else if ( nodeinfo.GetNodeType() == TYPE_NODE_COMBINATION ) {
				// ͐^O̎́C̃^Oɏ]
				nodename = xml.GetNodeName( pChild );
				if ( nodename.find( COMB_SEQUENTIAL ) != string::npos ) {
					// sequential
					nodecomb = "seq";
				}
				else if ( nodename.find( COMB_ALTERNATIVE ) != string::npos ) {
					// alternative
					nodecomb = "alt";
				}
				else if ( nodename.find( COMB_PARALLEL ) != string::npos ) {
					// parallel
					nodecomb = "par";
				}
				else {
					continue;
				}
				
				// ̋LɊւ鐶K
				//CreateGrammar( pChild, current_exchange, *sp, nodecomb, integrator, infolist );
				CreateGrammar( pChild, exchange_name, *sp, nodecomb, integrator, infolist );
			}
		
		}
	}
	
	
	return 0;
}

//
// ֐ : int CIntegrationTableCreator::CreateProduction( string &symbol, string &comb, list < string > &symlist, CXISLNodeList &nodelist, CProductionSet &production )
// @  \ : K
//    : symbol --- Kӂ̋L
//			comb ----- ̎
//			symlist -- Eӂ̋L̃Xg
//			nodelist - m[hXg
//			production - KW
// ߂l : ǉ̐K̑
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CIntegrationTableCreator2::CreateProduction( string &symbol, string &comb, list < string > &symlist, CXISLNodeList &nodelist, CProductionSet &production )
{
	CProduction   pro;
	CXISLNodeInfo nodeinfo;
	list < string >::iterator sp, ep;

	// ͐̎ނɉāCK
	if ( comb == COMB_SEQUENTIAL ) {
		// sequential
		pro.SetLeftSideSymbol( symbol.c_str() );
		sp = symlist.begin(); ep = symlist.end();
		

		for ( ; sp != ep; sp ++ ) {
			// Ƃ肠Cǉ
			pro.AddRightSideSymbol( sp->c_str() );

			// L<exchange>ɑΉꍇ́CɃ^CAEgLǉ
			nodeinfo = nodelist.GetNodeInfo( *sp );
			if ( nodeinfo.GetNodeName() == *sp ) {
				if ( nodeinfo.GetNodeType() == TYPE_NODE_EXCHANGE ) {
					pro.AddRightSideSymbol( ::TIMEOUT_SYMBOL );
				}
			}
		}
		pro.SetNumber( ::production_number ++ );
		production.AddProduction( pro );
	}
	else if ( comb == COMB_ALTERNATIVE ) {
		// alternative

		sp = symlist.begin(); ep = symlist.end();

		// LƂɐK
		for ( ; sp != ep; sp ++ ) {
			pro.Initialize();
			
			// ӂݒ
			pro.SetLeftSideSymbol( symbol.c_str() );

			// Ƃ肠Cǉ
			pro.AddRightSideSymbol( sp->c_str() );

			// L<exchange>ɑΉꍇ́CɃ^CAEgLǉ
			nodeinfo = nodelist.GetNodeInfo( *sp );
			if ( nodeinfo.GetNodeName() == *sp ) {
				if ( nodeinfo.GetNodeType() == TYPE_NODE_EXCHANGE ) {
					pro.AddRightSideSymbol( ::TIMEOUT_SYMBOL );
				}
			}
			pro.SetNumber( ::production_number ++ );
			production.AddProduction( pro );
		}
	}
	else if ( comb == COMB_PARALLEL ) {
		// parallel
		sp = symlist.begin(); ep = symlist.end();
		list < string > outlist, restlist;
		list < string >::iterator top;
		for ( ; sp != ep; sp ++ ) {
			outlist.clear();
			restlist = symlist;
			CreateParallelProduction( symbol, outlist, restlist, sp, nodelist, production );
		}
	}
	
	return production.GetSize();
}

//
// ֐ : int CIntegrationTableCreator::CreateParallelProduction( string &symbol, list < string > &symlist, list < string > &restsym, 
//															list < string >::iterator &top, CXISLNodeList &nodelist, CProductionSet &production )
// @  \ : paralell̐K
//    : symbol --- K̍ӂɗL
//			symlist -- 񂳂ꂽL
//			restsym -- 񂳂ĂȂL
//			top ------ ɑL
//			nodelist -- m[h
//			production - KW
// ߂l : ̐K̐
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CIntegrationTableCreator2::CreateParallelProduction( string &symbol, list < string > &symlist, list < string > &restsym, list < string > :: iterator top, CXISLNodeList &nodelist, CProductionSet &production )
{
	// ɗLǉ
	symlist.push_back( *top );

	list < string >::iterator sp;
	list < string >::iterator ep;

	if ( ( restsym.size() == 1 ) && ( restsym.front() == *top ) ) {
		// LSĐ񂵂ɁCK
		CProduction pro;
		pro.SetLeftSideSymbol( symbol.c_str() );
		sp = symlist.begin(); ep = symlist.end();

		for ( ; sp != ep; sp ++ ) {
			// Eӂɒǉ
			pro.AddRightSideSymbol( sp->c_str() );

			// L<exchange>ɑΉꍇ́CɃ^CAEgLǉ
			CXISLNodeInfo nodeinfo;
			nodeinfo = nodelist.GetNodeInfo( *sp );
			if ( nodeinfo.GetNodeName() == *sp ) {
				if ( nodeinfo.GetNodeType() == TYPE_NODE_EXCHANGE ) {
					pro.AddRightSideSymbol( ::TIMEOUT_SYMBOL );
				}
			}
		}
		pro.SetNumber( ::production_number ++ );
		return production.AddProduction( pro );		// Kǉ
	}

	// 񂪏IĂȂꍇ́CcĂL̕т̑SẴp^[B
	// ܂C݂top̋Lc̃Xg폜
	sp = restsym.begin(); ep = restsym.end();
	for ( ; sp != ep; sp ++ ) {
		if ( *sp == *top ) {
			restsym.erase( sp );
			break;
		}
	}

	// ɁCp^[𐶐B
	list < string > savesym  = symlist;	// ۑp
	list < string > saverest = restsym;
	sp = saverest.begin(); ep = saverest.end();
	
	for ( ; sp != ep; sp ++ ) {
		CreateParallelProduction( symbol, symlist, restsym, sp, nodelist, production );
		symlist = savesym;
		restsym = saverest;
	}
	
	return production.GetSize();
}

