//
// MMIVXe Ver.1.1 ͓
// ͓W[
//
// InputIntegrator2.h / InputIntegrator2.cpp
//
// 2002/09/06 Fri. G
//
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _INPUTINTEGRATOR2_H_
#define _INPUTINTEGRATOR2_H_

#include "StdAfx.h"
#include <fstream>
#include <queue>
#include <list>

#include "XMLManager.h"
#include "SymbolTable.h"
#include "Grammar.h"
#include "LRTable.h"
#include "GLRParser.h"
#include "InputInfo.h"
#include "XISLNodeList.h"
#include "IntegrationTableCreator2.h"


using namespace std;



/////////////////////////////////////////////////////////
#define _TIMEOUT_	 2000

/////////////////////////////////////////////////////////

class CInputIntegrator2
{
private:
	CGLRParser		 m_Parser;		 // GLRp[U
	CXISLNodeList	 m_NodeList;	 // m[hǗireduceɗpj
	bool			 m_bValid;		 // \̗LtO

public:
	CInputIntegrator2();
	CInputIntegrator2( const CInputIntegrator2 &integrator );
	virtual ~CInputIntegrator2();
	
	int Input( const char *symbol, list < string > &reduce_list );
	void InitializeState();
	
	const CGLRParser& GetParser() const;
	const CXISLNodeList& GetNodeList() const;
	const bool IsValid() const;
	
	bool SetValid( bool flag );
	void Init();
	
	CInputIntegrator2& operator = ( const CInputIntegrator2 &integrator );


};


//
// CInputIntegrationManager2
//
class CInputIntegrationManager2
{
private:
	
	CInputIntegrator2	 m_Integrator[2];		 // ʏ́荞ݓ͗p̓\
	CInputInfoList		 m_InputList[2];		 // ʏ́荞ݓ͗p̓͏Ǘ
	CRITICAL_SECTION	 m_CriIntegrator[2];	 // \p̃NeBJZNV
	// m_Integrator[0] - 荞ݓ͗p̓\
	// m_Integrator[1] - ʏ͗p̓\
	// m_InputList̓Yɏ]
	CInputInfoList		 m_Accepted;			 // 󗝂ꂽ͂ێ
public:
	DWORD				 m_Timeout;
	DWORD				 m_IntegrateInterval;

public:
	CInputIntegrationManager2();
	virtual ~CInputIntegrationManager2();

	// 
	void InitNormalTable();
	void InitInterruptTable();
	

	// \̐
	bool SetNormalInput( string &input );
	bool SetInterruptInput( string &input );
	void SetIntegrateInterval( DWORD interval );

	// ʏ͗p̓\̐CpX𑗐M悤ɉ
	bool SetNormalInput( string &input, string &path);

	// 荞ݓ͗p̓\̐CpX𑗐M悤ɉ
	bool SetInterruptInput( string &inputRoot, string &pathRoot, string &inputLeaf, string &pathLeaf );

	bool Input( string source, string &result );

	bool CheckTimeout();

	////////////////////////////////////////////

	bool SetNormalInput( LPCSTR szFile );
	bool SetInterruptInput( LPCSTR szFile );

	////////////////////////////////////////////

	/* ȂȁEEE
	bool SetValidNormalIntegrator( bool flag );
	bool SetValidInterruptIntegrator( bool flag );
	*/

private:
	bool Integrate( string source, string &exchange );
	void SendInputInfo( string cmd, string exchanges );

	//ʏ͑MpCpX𑗐M悤ɉ
	void SendNormalInputInfo( string exchanges, string path );
	//荞ݓ͑MpCpX𑗐M悤ɉ
	void SendInterruptInputInfo( string exchangesInRoot, string pathRoot, string exchangesInLeaf, string pathLeaf );

	void InitTimeout();
	
};

#endif _INPUTINTEGRATOR2_H_