//
// SLR(1)\͊vO
// @f[^
//
// Grammar.h / Grammar.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _GRAMMAR_H_
#define _GRAMMAR_H_

#include <map>
#include <list>

#include "SymbolTable.h"		// L\

using namespace std;

//
// dl		ŏIXV:2001/10/30 Tue.
// Egpł镶@́CMMIVXełx܂ŁB
// EI(|)́CpsB@ ӂ͘Â
// Eʂ́CpsB
// EJԂ(FA  AB*C*0ȏ̌JԂ)́CpsB
// 
//

#define GRAMMAR_LENGTH		256				// @t@C1s̍ő̒

//
// NX CProduction
//
// R@̐KǗ
//

class CProduction
{
private:
	int  m_nNumber;								// K̔ԍ
	char m_strLeftSide[ SYMBOL_LENGTH + 1 ];	// ӂ̔I[L
	list < string > m_listRightSide;			// Eӂ̕@L

public:
	CProduction();
	CProduction( int num, const char *source );
	CProduction( CProduction &pro );

	virtual ~CProduction();

public:
	int GetNumber();
	int GetRightSideLength();
	const char *GetLeftSideSymbol();
	const char *GetRightSideSymbol( int index );

	void SetNumber( int number );
	void SetLeftSideSymbol( const char *symbol );
	int  AddRightSideSymbol( const char *symbol );

	int Analyze( int num, const char *source );

	virtual void Initialize();


public:
	CProduction &operator = ( CProduction &pro );
	bool operator == ( CProduction &pro );

	void Display();
};

//
// NX CProductionSet
//
// R@̐K̏WǗ
//

class CProductionSet
{
public:
	enum SEARCHTYPE { SEARCH_NUMBER = 0, SEARCH_INDEX };	// GetProduction()֐C

private:
	list < CProduction * > m_listProduction;

public:
	CProductionSet();
	CProductionSet( CProductionSet &set );

	virtual ~CProductionSet();

public:
	int GetSize();
	
public:
	void RemoveAll();
	
	int GetProduction( int number, CProduction &pro, CProductionSet::SEARCHTYPE type = CProductionSet::SEARCH_INDEX );
	int GetProduction( const char *left, CProductionSet &subSet );

	int Analyze( list < string > &source );

	int AddProduction( int number, const char *source );
	int AddProduction( CProduction &pro );

public:
	CProductionSet &operator = ( CProductionSet &set );

	void Display();

};

//
// NX CContextFreeGrammar
//
// R@̕@f[^Ǘ
//

class CContextFreeGrammar
{
private:
	CSymbolTable	m_Terminal;			// I[L̏W
	CSymbolTable	m_Nonterminal;		// I[L̏W
	CProductionSet	m_Production;		// K̏W
	CSymbol			m_StartSymbol;		// JnL

public:
	CContextFreeGrammar();
	CContextFreeGrammar( CContextFreeGrammar &grammar );

	virtual ~CContextFreeGrammar();

public:
	CSymbolTable	 &GetTerminalSymbol();
	CSymbolTable	 &GetNonterminalSymbol();
	CProductionSet	 &GetProductionSet();
	CSymbol			 &GetStartSymbol();

	CSymbolTable	 *GetTerminalSymbolPtr();
	CSymbolTable	 *GetNonterminalSymbolPtr();
	CProductionSet	 *GetProductionSetPtr();
	CSymbol			 *GetStartSymbolPtr();

	void Init();

public:
	int OpenGrammarFile( const char *grammarfile );

protected:
	int AnalyzeTerminalSymbolSet( const char *symbols );
	int AnalyzeNonterminalSymbolSet( const char *symbols );
	int AnalyzeStartSymbol( const char *symbol );

	int AnalyzeSymbolSet( const char *symbols, CSymbolTable &table, SYMBOLTYPE type );

public:
	CContextFreeGrammar &operator = ( CContextFreeGrammar &grammar );

	void Display();
};



#endif  _GRAMMAR_H_