//
// SLR(1)\͊vO
// @f[^
//
// Grammar.h / Grammar.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <assert.h>
#include <iostream>
#include <fstream>
#include <string.h>

#include <list>
#include <map>

#include "Grammar.h"

using namespace std;

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//


//
// CProduction
//


//
// ֐ : CProduction::CProduction()
// @  \ : ftHgRXgN^
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProduction::CProduction()
{
	m_nNumber = 0;
	m_strLeftSide[ 0 ] = '\0';
	m_listRightSide.clear();
}


//
// ֐ : CProduction::CProduction( int num, const char *source )
// @  \ : RXgN^i\[X̉͂j
//    : num ---- K̔ԍ
//          source --- K̃\[X
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//

CProduction::CProduction( int num, const char *source )
{
	Analyze( num, source );
}


//
// ֐ : CProduction::CProduction( CProduction &proc )
// @  \ : Rs[RXgN^
//    : proc ---- Rs[IuWFNg
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CProduction::CProduction( CProduction &pro )
{
	if ( &pro == this ) { return; }

	// ܂́C
	Initialize();

	// Rs[
	m_nNumber = pro.GetNumber();
	strcpy( m_strLeftSide, pro.GetLeftSideSymbol() );
	
	int len = pro.GetRightSideLength();
	for ( int i = 0; i < len; i ++ ) {
		m_listRightSide.push_back( pro.GetRightSideSymbol( i ) );
	}
}

//
// ֐ : CProduction::~CProduction()
// @  \ : fXgN^ 
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProduction::~CProduction()
{
	Initialize();
}

//
// ֐ : int CProduction::GetNumber()
// @  \ : K̔ԍԂ
//    : Ȃ
// ߂l : K̔ԍ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProduction::GetNumber()
{
	return m_nNumber;
}

//
// ֐ : const char *CProduction::GetLeftSideSymbol()
// @  \ : ӂ̋L擾
//    : Ȃ
// ߂l : ӂ̔I[L킷
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
const char *CProduction::GetLeftSideSymbol()
{
	return m_strLeftSide;
}

//
// ֐ : const char *CProduction::GetRightSideSymbol( int index )
// @  \ : Eӂ\L̈擾
//    : index --- 擾L̈ʒu
// ߂l : 擾L\Bʒuw肪sȂNULLԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
const char *CProduction::GetRightSideSymbol( int index )
{
	if ( ( index < 0 ) || ( index >= m_listRightSide.size() ) ) {
		// index̎w肪s
		return NULL;
	}

	// w肵ʒuɂLԂ
	list < string >::iterator sp = m_listRightSide.begin();
	list < string >::iterator ep = m_listRightSide.end();

	while ( ( index > 0 ) && ( sp != ep ) ) {
		sp ++; index --;
	}
	if ( ( index == 0 ) && ( sp != ep ) ) {
		return sp->c_str();		// 
	}

	return NULL;		// Ȃ
}


//
// ֐ : int CProduction::Analyze( int num, const char *source )
// @  \ : K̃\[X͂Cf[^ۑ
//    : num ---- K̔ԍ
//			source -- K̃\[X
// ߂l : Eӂ̋LBsȂ畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProduction::Analyze( int num, const char *source )
{
	try {
		// 1.܂C
		Initialize();

		// 2.KԍێB
		m_nNumber = num;

		// 3.\[X͂B
		int pos = 0;			// \[X̎Qƈʒu
		int token_pos = 0;		// Li[̎Qƈʒu
		memset( m_strLeftSide, '\0', SYMBOL_LENGTH + 1 );	// z'\0'Ŗ߂

		// 3-1.ӂ̕擾B
		while ( ( source[ pos ] != '=' ) && ( source[ pos ] != '\0' ) ) {
			// ڂ'='܂łӂ̋LƂB
			if ( source[ pos ] != ' ' ) {
				// 󔒈ȊO̕L\̂ƂȂ
				if ( token_pos <= SYMBOL_LENGTH ) {
					// ǉł̂́CSYMBOL_LENGTH܂ŁB
					m_strLeftSide[ token_pos ] = source[ pos ];
					token_pos ++;	//@݈̏ʒu
				}
			}

			pos ++;		// ̓ǂݎʒu
		}

		if ( source[ pos ] == '\0' ) { 
			// ӂ̉͒'\0'!Lqs
			throw -1;
		}

		pos ++;		// '='̎̕

		// 3-2.Eӂ̕擾
		// K2Ԗڈȍ~ɏoĂ'='́CEӂ\I[LƂ

		// f[^
		char token[ SYMBOL_LENGTH + 1 ];		// Li[
		memset( token, '\0', SYMBOL_LENGTH + 1 );
		token_pos = 0;

		while ( source[ pos ] != '\0' ) {
			// Eӂ́C̏I肪܂ŁB
			if ( source[ pos ] != ' ' ) {
				// 󔒈ȊO̕L\̂ƂȂ
				if ( token_pos <= SYMBOL_LENGTH ) {
					// ǉł̂́CSYMBOL_LENGTHԂŁB
					token[ token_pos ] = source[ pos ];
					token_pos ++;
				}
			}

			pos ++;	// ̓ǂݎʒu

			if ( ( source[ pos ] == ' ' ) || ( source[ pos ] == '\0' ) ) {
				// ̕󔒂'\0'̎ɋLXgɒǉ
				m_listRightSide.push_back( token );

				// f[^
				memset( token, '\0', SYMBOL_LENGTH + 1 );
				token_pos = 0;
			}
		}
	}
	catch ( int error ) {		// O
		return error;
	}

	return m_listRightSide.size();	// Eӂ̋LԂ
}


//
// ֐ : void CProduction::Initialize()
// @  \ : f[^
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
void CProduction::Initialize()
{
	// o̓e
	m_nNumber = -1;
	m_strLeftSide[ 0 ] = '\0';
	m_listRightSide.clear();
}

//
// ֐ : int CProduction::GetRightSideLength()
// @  \ : Eӂ̋L̒Ԃ
//    : Ȃ
// ߂l : XgɒǉĂLԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProduction::GetRightSideLength()
{
	return m_listRightSide.size();
}

//
// ֐ : CProduction &CProduction::operator = ( CProduction &pro )
// @  \ : Zq
//    : pro ---- Rs[̃IuWFNg
// ߂l : IuWFNg
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CProduction &CProduction::operator = ( CProduction &pro )
{
	if ( &pro == this ) { return *this; }

	// ܂́C
	Initialize();

	// Rs[
	m_nNumber = pro.GetNumber();
	strcpy( m_strLeftSide, pro.GetLeftSideSymbol() );
	
	int len = pro.GetRightSideLength();
	for ( int i = 0; i < len; i ++ ) {
		m_listRightSide.push_back( pro.GetRightSideSymbol( i ) );
	}

	return *this;
}

//
// ֐ : bool CProduction::operator== ( CProduction &pro )
// @  \ : ֌WZq
//    : pro ---- rΏ
// ߂l : eȂtrueCȊOfalseԂ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
bool CProduction::operator == ( CProduction &pro )
{
	if ( &pro == this ) { return true; }

	// K̔ԍƍӂ̋L`FbN
	if ( ( m_nNumber != pro.GetNumber() ) || ( strcmp( m_strLeftSide ,pro.GetLeftSideSymbol() ) ) ) {
		return false;
	}

	// Eӂ̋L`FbN
	int len = m_listRightSide.size();
	// 
	if ( len != pro.GetRightSideLength() ) {
		return false; 
	}

	// L
	for ( int i = 0; i < len; i ++ ) {
		if ( strcmp( GetRightSideSymbol( i ), pro.GetRightSideSymbol( i ) ) ) {
			return false;
		}
	}

	// ׂẴ`FbNpX̂œ
	return true;
}


//
// ֐ : void CProduction::SetLeftSideSymbol( const char *symbol )
// @  \ : K ӂ̋Lݒ肷
//    : symbol ---- ݒ肷L
// ߂l : Ȃ
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
void CProduction::SetLeftSideSymbol( const char *symbol )
{
	// L̒𐧌ȓɒc
	int len = ( strlen( symbol ) <= SYMBOL_LENGTH ) ? strlen( symbol ) : SYMBOL_LENGTH;
	
	for ( int i = 0; i < len; i ++ ) {
		m_strLeftSide[ i ] = symbol[ i ];
	}
	m_strLeftSide[ i ] = '\0';
}

//
// ֐ : int CProduction::AddRightSideSymbol( const char *symbol )
// @  \ : K EӂɋLǉ
//    : symbol --- ǉL
// ߂l : ǉ̉Eӂ̋L
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CProduction::AddRightSideSymbol( const char *symbol )
{
	int len = strlen( symbol );
	char copy[ SYMBOL_LENGTH + 1 ];

	if ( len > SYMBOL_LENGTH ) {
		// KvȒɕ𒲐
		for ( int i = 0; i < SYMBOL_LENGTH; i ++ ) {
			copy[ i ] = symbol[ i ];
		}
		copy[ i ] = '\0';
		m_listRightSide.push_back( copy );
	}
	else {
		// ͕sKvȂ̂ł̂܂ܒǉc
		m_listRightSide.push_back( symbol );
	}

	return m_listRightSide.size();
}

//
// ֐ : void CProduction::SetNumber( int number )
// @  \ : Kԍݒ肷
//    : number --- ݒԍ
// ߂l : Ȃ
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//
void CProduction::SetNumber( int number )
{
	m_nNumber = number;
}

//
// ֐ : void CProduction::Display()
// @  \ : o
//    : 
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CProduction::Display()
{
	cout << "[" << m_nNumber << "] " << m_strLeftSide << " = ";
	
	int count = m_listRightSide.size();

	for ( int i = 0; i < count; i ++ ) {
		cout << GetRightSideSymbol( i ) << " ";
	}
}


//
// NX CProductionSet
//

//
// ֐ : CProductionSet::CProductionSet()
// @  \ : ftHgRXgN^
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProductionSet::CProductionSet()
{
	RemoveAll();
}


//
// ֐ : CProductionSet::CProductionSet( CProductionSet &set )
// @  \ : Rs[RXgN^
//    : set ---- Rs[
// ߂l : 
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProductionSet::CProductionSet( CProductionSet &set )
{
	CProduction pro, *pNew;
	int size = set.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		set.GetProduction( i, pro );
		pNew = new CProduction( pro );
		assert( pNew != NULL );
		m_listProduction.push_back( pNew );
	}
}

//
// ֐ : CProductionSet::~CProductionSet()
// @  \ : fXgN^
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProductionSet::~CProductionSet()
{
	RemoveAll();
}

//
// ֐ : int CProductionSet::GetSize()
// @  \ : K̐Ԃ
//    : Ȃ
// ߂l : Xg̒Ԃ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//

int CProductionSet::GetSize()
{
	return m_listProduction.size();
}


//
// ֐ : void CProductionSet::RemoveAll()
// @  \ : K̃Xg폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
void CProductionSet::RemoveAll()
{
	list < CProduction * >::iterator sp = m_listProduction.begin();
	list < CProduction * >::iterator ep = m_listProduction.end();

	// evfɕێĂ|C^w CProductionIuWFNg폜
	while ( sp != ep ) {
		delete (CProduction*)*sp;
		sp ++;
	}
	
	// Xgɂ
	m_listProduction.clear();
}

//
// ֐ : int CProductionSet::GetProduction( int number, CProduction &pro )
// @  \ : w肵ԍK̏擾
//    : number --- 鐶Kԍ
//			pro ------ KQƂ
// ߂l : 1CȂ0
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProductionSet::GetProduction( int number, CProduction &pro, CProductionSet::SEARCHTYPE type )
{
	list < CProduction * >::iterator sp = m_listProduction.begin();
	list < CProduction * >::iterator ep = m_listProduction.end();

	if ( type == CProductionSet::SEARCH_NUMBER ) {
		// w肵ԍKT
		while ( sp != ep ) {
			if ( (*sp)->GetNumber() == number ) {
				// !
				pro = *(*sp);
				return 1;
			}
			sp ++;	// 
		}
	}

	else {	// type == SEARCH_INDEX
		while ( ( sp != ep ) && ( number > 0 ) ) {
			sp ++; 
			number --;
		}
		if ( ( sp != ep ) && ( number == 0 ) ) {
			pro = *(*sp);
			return 1;
		}
	}

	// ȂB
	return 0;
}


//
// ֐ : int CProductionSet::GetProduction( const char *left, CProductionSet &subset );
// @  \ : w肵I[LӂɂȂ鐶KSĎ擾
//    : left ---- ӂ̐K
//			subset -- KL^郊Xg
// ߂l : 猟K̐BsȂ畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//

int CProductionSet::GetProduction( const char *left, CProductionSet &subset )
{
	subset.RemoveAll();	// o͗pXg

	list < CProduction * >::iterator sp = m_listProduction.begin();
	list < CProduction * >::iterator ep = m_listProduction.end();

	while ( sp != ep ) {
		if ( ! strcmp( left, (*sp)->GetLeftSideSymbol() ) ) {
			// Ώۂ̋K̍ӂwLƓȂCXgɒǉB
			subset.AddProduction( *(*sp) );
		}
		sp ++; // ցB
	}

	return subset.GetSize();	// Xg̃TCYԂ
}


//
// ֐ : int CProductionSet::Analyze( list < string > &source )
// @  \ : ^ꂽK̃\[XXg͂āCǂݍ
//    : source --- K̃\[X̃Xg
// ߂l : ͂K̐Cs畉̒lԂB
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProductionSet::Analyze( list < string > &source )
{
	list < string >::iterator sp = source.begin();
	list < string >::iterator ep = source.end();

	int number = 0;

	try {
		while ( sp != ep ) {
			// e\[X񂲂Ƃɉ͂ĂB
			if ( *sp != "" ) {			// ŝ݂͖B
				if ( AddProduction( number, sp->c_str() ) < 0 ) {
					// ͂Ŏs
					throw -1;
				}
				number ++;
			}
			sp ++;		// 
		}
	}
	catch ( int error ) {	// O
		return error;
	}

	return m_listProduction.size();
}

//
// ֐ : int CProductionSet::AddProduction( int number, const char *source )
// @  \ : ̐K̃\[X͂
//    : number --- Kɂԍ
//			source --- K̃\[X
// ߂l : 猻݂̐K,s畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CProductionSet::AddProduction( int number, const char *source )
{
	try {
		// IuWFNg𐶐C͂
		CProduction *p = new CProduction( number, source );

		if ( p == NULL ) { throw -1; }	// IuWFNg̐Ɏs

		// |C^Xgɒǉ
		m_listProduction.push_back( p );
	}
	catch ( int error ) {		// O
		return error;
	}

	return m_listProduction.size();	// ݂̐K̐Ԃ
}

//
// ֐ : int CProductionSet::AddProduction( CProduction &pro )
// @  \ : ̐K̃\[X͂
//    : pro --- ǉ鐶K
// ߂l : 猻݂̐K,s畉̒lԂ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CProductionSet::AddProduction( CProduction &pro )
{
	CProduction *p = new CProduction( pro );
	assert( p );

	m_listProduction.push_back( p );

	return m_listProduction.size();
}


//
// ֐ : CProductionSet &CProductionSet::operator = ( CProductionSet &set )
// @  \ : Zq
//    : Rs[
// ߂l :
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProductionSet &CProductionSet::operator = ( CProductionSet &set )
{
	if ( &set == this ) { return *this; }

	RemoveAll();

	CProduction pro, *pNew;
	int size = set.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		set.GetProduction( i, pro );
		pNew = new CProduction( pro );
		assert( pNew != NULL );
		m_listProduction.push_back( pNew );
	}

	return *this;
}

//
// ֐ : void CProductionSet::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CProductionSet::Display()
{
	int count = m_listProduction.size();
	CProduction pro;

	for ( int i = 0; i < count; i ++ ) {
		GetProduction( i, pro );
		pro.Display();
		cout << endl;
	}
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//


//
// CContextFreeGrammar
//


//
// ֐ : CContextFreeGrammar::CContextFreeGrammar()
// @  \ : ftHgRXgN^
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CContextFreeGrammar::CContextFreeGrammar()
	: m_Terminal(), m_Nonterminal(), m_Production(), m_StartSymbol()
{

}


//
// ֐ : CContextFreeGrammar::CContextFreeGrammar( CContextFreeGrammar &grammar )
// @  \ : Rs[RXgN^
//    : grammar --- Rs[
// ߂l :
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CContextFreeGrammar::CContextFreeGrammar( CContextFreeGrammar &grammar )
{
	m_Terminal = grammar.GetTerminalSymbol();
	m_Nonterminal = grammar.GetNonterminalSymbol();
	m_Production = grammar.GetProductionSet();
	m_StartSymbol = grammar.GetStartSymbol();
}


//
// ֐ : CContextFreeGrammar::~CContextFreeGrammar()
// @  \ : fXgN^
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CContextFreeGrammar::~CContextFreeGrammar()
{
}

//
// ֐ : const CSymbolTable &CContextFreeGrammar::GetTerminalSymbol()
// @  \ : I[LW擾
//    : Ȃ
// ߂l : I[LWǗCSymbolTableIuWFNgւ̎Q
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CSymbolTable &CContextFreeGrammar::GetTerminalSymbol()
{
	return m_Terminal;
}

//
// ֐ : CSymbolTable *CContextFreeGrammar::GetTerminalSymbolPtr()
// @  \ : I[LW擾
//    : Ȃ
// ߂l : I[LWǗCSymbolTableIuWFNgւ̃|C^
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
CSymbolTable *CContextFreeGrammar::GetTerminalSymbolPtr()
{
	return &m_Terminal;
}

//
// ֐ : const CSymbolTable &CContextFreeGrammar::GetNonterminalSymbol()
// @  \ : I[LW擾
//    : Ȃ
// ߂l : I[LWǗCSymbolTableIuWFNgւ̎Q
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CSymbolTable &CContextFreeGrammar::GetNonterminalSymbol()
{
	return m_Nonterminal;
}

//
// ֐ : CSymbolTable *CContextFreeGrammar::GetNonterminalSymbolPtr()
// @  \ : I[LW擾
//    : Ȃ
// ߂l : I[LWǗCSymbolTableIuWFNgւ̃|C^
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
CSymbolTable *CContextFreeGrammar::GetNonterminalSymbolPtr()
{
	return &m_Nonterminal;
}

//
// ֐ : const CProductionSet &CContextFreeGrammar::GetProductionSet()
// @  \ : KW擾
//    : Ȃ
// ߂l : KWǗCProductionSetIuWFNgւ̎Q
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CProductionSet &CContextFreeGrammar::GetProductionSet()
{
	return m_Production;
}

//
// ֐ : CProductionSet *CContextFreeGrammar::GetProductionSetPtr()
// @  \ : KW擾
//    : Ȃ
// ߂l : KWǗCProductionSetIuWFNgւ̃|C^
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
CProductionSet *CContextFreeGrammar::GetProductionSetPtr()
{
	return &m_Production;
}

//
// ֐ : const CSymbol &CContextFreeGrammar::GetStartSymbol()
// @  \ : JnL擾
//    : Ȃ
// ߂l : JnLCSymbolIuWFNgւ̎Q
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
CSymbol &CContextFreeGrammar::GetStartSymbol()
{
	return m_StartSymbol;
}

//
// ֐ : const CSymbol &CContextFreeGrammar::GetStartSymbol()
// @  \ : JnL擾
//    : Ȃ
// ߂l : JnLCSymbolIuWFNgւ̃|C^
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
CSymbol *CContextFreeGrammar::GetStartSymbolPtr()
{
	return &m_StartSymbol;
}

//
// ֐ : int CContextFreeGrammar::OpenGrammarFile( const char *grammarfile )
// @  \ : @t@CJāC@͂B
//    : grammarfile ---- @t@Cւ̃pX
// ߂l : 0CsȂ畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CContextFreeGrammar::OpenGrammarFile( const char *grammarfile )
{
	ifstream ifs;						// t@CXg[
	char line[ GRAMMAR_LENGTH + 1];		// 1sǂݏoz
	list < string > product;			// K\[X񃊃Xg
	int flag = 0;						// ԃtO

	// f[^
	m_Terminal.RemoveAll();
	m_Nonterminal.RemoveAll();
	m_Production.RemoveAll();
	m_StartSymbol = CSymbol();

	try {
		ifs.open( grammarfile );	// t@CJ
		if ( ! ifs.is_open() ) { throw -1; } // ĴɎs
		
		while ( ! ifs.eof() ) {
			ifs.getline( line, GRAMMAR_LENGTH );	// 1sǂݍ


			// ǂݍ񂾕`FbN
				 if ( ! strcmp( line, "_TERMINAL_SET_" ) )    { flag = 1; } // I[LWLqJn 
			else if ( ! strcmp( line, "_NONTERMINAL_SET_" ) ) { flag = 2; }	// I[LWLqJn
			else if ( ! strcmp( line, "_START_SYMBOL_" ) )	  { flag = 3; }	// JnLLqJn
			else if ( ! strcmp( line, "_PRODUCTION_SET_" ) )  { flag = 4; }	// KWLqJn
			else {	// ̑
				switch ( flag ) {
				case 1: { AnalyzeTerminalSymbolSet( line );     break; }	// I[LW
				case 2: { AnalyzeNonterminalSymbolSet( line );  break; }	// I[LW
				case 3: { AnalyzeStartSymbol( line ); flag = 5; break; }	// JnL
				case 4: { product.push_back( line );			break; }	// KW Xg
				default:{										break; }	// ̑
				}
			}
		}
		ifs.close();		// t@C

		m_Production.Analyze( product );		// KW͂
	}
	catch ( int error ) {	// O
		return error;
	}

	return 0;
}



//
// ֐ : int CContextFreeGrammar::AnalyzeTerminalSymbolSet( const char *symbols )
// @  \ : I[L̏W͂
//    : symbols ---- LW̕
// ߂l : o^L̐Cs畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CContextFreeGrammar::AnalyzeTerminalSymbolSet( const char *symbols )
{
	return AnalyzeSymbolSet( symbols, m_Terminal, SYMBOL_TERMINAL );
}


//
// ֐ : int CContextFreeGrammar::AnalyzeNonterminailSymbolSet( const char *symbols )
// @  \ : I[L̏W͂
//    : symbols ---- LW̕
// ߂l : o^L̐Cs畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//

int CContextFreeGrammar::AnalyzeNonterminalSymbolSet( const char *symbols )
{
	return AnalyzeSymbolSet( symbols, m_Nonterminal, SYMBOL_NONTERMINAL );
}

//
// ֐ : int CContextFreeGrammar::AnalyzeStartSymbol( const char * symbol )
// @  \ : JnL͂
//    : symbol --- JnL
// ߂l : 1Cs0Ԃ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//

int CContextFreeGrammar::AnalyzeStartSymbol( const char *symbol )
{
	char token[ SYMBOL_LENGTH + 1 ];
	int pos = 0, token_pos = 0;

	while ( ( symbol[ pos ] != ' ' ) && ( symbol[ pos ] != '\0' ) ) {
		// 󔒂'\0'łȂ̂CL\镶Ƃ
		if ( token_pos <= SYMBOL_LENGTH ) {
			// L̒SYMBOL_LENGTH܂
			token[ token_pos ] = symbol[ pos ];
			token_pos ++;
		}
		
		pos ++;	// ̕
		
	}
	token[ token_pos ] = '\0';		// Ō'\0'ǉ
	
	m_StartSymbol.SetSymbol( token, SYMBOL_NONTERMINAL );	// JnLIuWFNgɕۑ

	return 1;
}


//
// ֐ : int CContextFreeGrammar::AnalyzeSymbolSet( const char *symbol, CSymbolTable &table, SYMBOLTYPE type )
// @  \ : LW͂
//    : symbol ---- LW
//			table ----- LWi[IuWFNgւ̎Q
//			type ------ L^Cv
// ߂l : o^L̐CsȂ畉̒lԂ
// 쐬 : 2001/10/31 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/10/31 Wed.
//
int CContextFreeGrammar::AnalyzeSymbolSet( const char *symbol, CSymbolTable &table, SYMBOLTYPE type )
{
	char token[ SYMBOL_LENGTH + 1 ];
	int pos = 0, token_pos = 0;

	while ( ( symbol[ pos ] != '\0' ) ) {
		// 󔒂\0ȊO̕L

		if ( ( symbol[ pos ] != ' ' ) && ( token_pos <= SYMBOL_LENGTH ) ) {
			// L̒SYMBOL_LENGTH܂
			token[ token_pos ] = symbol[ pos ];
			token_pos ++;
		
			if ( ( symbol[ pos + 1 ] == ' ' ) || ( symbol[ pos + 1 ] == '\0' ) ) {
				// ̕󔒂\0ł΁Cň̋LI
				token[ token_pos ] = '\0';
				table.AddSymbol( token, type );			// L\ɒǉ
				token_pos = 0;							// Lz
				//pos ++;									// LW͎̕QƂ
			}
		}
		pos ++;			// ̕
	}
	
	return table.GetSize();
}


//
// ֐ : CContextFreeGrammar &CContextFreeGrammar::operator = ( CContextFreeGrammar &grammar )
// @  \ : Zq
//    : grammar -- Rs[
// ߂l :
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CContextFreeGrammar &CContextFreeGrammar::operator = ( CContextFreeGrammar &grammar )
{
	if ( &grammar == this ) { return *this; }

	m_Terminal = grammar.GetTerminalSymbol();
	m_Nonterminal = grammar.GetNonterminalSymbol();
	m_Production = grammar.GetProductionSet();
	m_StartSymbol = grammar.GetStartSymbol();

	return *this;
}

//
// ֐ : void CContextFreeGrammar::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//
void CContextFreeGrammar::Display()
{
	cout << "TERMINAL SYMBOLS" << endl;
	m_Terminal.Display();

	cout << endl << "NONTERMINAL SYMBOLS" << endl;
	m_Nonterminal.Display();
	
	cout << endl << "START SYMBOL" << endl;
	m_StartSymbol.Display();
	
	cout << endl << "PRODUCTIONS" << endl;
	m_Production.Display();

	cout << endl;
}


//
// ֐ : void CContextFreeGrammar::Init()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/09/10 Tue.
// 쐬 :  G
//
// ŏIXV : 2002/09/10 Tue.
//
void CContextFreeGrammar::Init()
{
	m_Terminal.RemoveAll();
	m_Nonterminal.RemoveAll();
	m_Production.RemoveAll();
}
