// DialogTreeNode.cpp: CDialogTreeNode NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "common.h"
//#include "DialogControl.h"
#include "DialogTreeNode.h"
#include "TreeManagement.h"
#include "ExchangeNode.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CTreeManagement treeManagement;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

int CDialogTreeNode::mDistanceFromDialogLength;

//RXgN^
CDialogTreeNode::CDialogTreeNode()
{
	mpListHead = mpListTail = NULL;
	//
	initNode();
}

CDialogTreeNode::~CDialogTreeNode()
{
	//m[h̏
	initNode();
	if( mpListHead != NULL ){
		//_~[m[h̏
		delete mpListHead;
	}
}

//ԂactiveԂɂ
void CDialogTreeNode::beActive(){
	this->mState = ACTIVE;
}

//ԂunvisitedԂɂ
void CDialogTreeNode::beUnvisited(){
	this->mState = UNVISITED;
}

//ԂvisitedԂɂD
int CDialogTreeNode::beVisited(){
	this->mState = VISITED;
	return 0;
}

//ԂpromptedԂɂD
void CDialogTreeNode::bePrompted(){
	this->mState = PROMPTED;
}


//ԂԂD
int CDialogTreeNode::getState()	{

	return this->mState;

}

//m[hZbgD
void CDialogTreeNode::setName(string strNodeName){
	this->mStrName = strNodeName;
}

//m[hԂD
void CDialogTreeNode::getName(string* pStrNodeName){
	
	pStrNodeName->assign( this->mStrName );

}

//idԍZbgD
void CDialogTreeNode::setId(int id){
	this->mId = id;
}

//idԍԂD
int CDialogTreeNode::getId(){
	return this->mId;
}

//m[ȟ^Ԃ
int CDialogTreeNode::getType(){
	return this->mType;
}

//m[h̏Cqvf̃Xg̑Sm[hIuWFNgD
void CDialogTreeNode::initNode(){

	CDialogTreeNode*	pDialogTreeNodeBuff;

	//m[h̏
	setName("");
	//idl̏
	setId(-1);
	//ԂunvisitedԂɂD
	beUnvisited();
	//^̏
	mType = -1;

	//eւ̃|C^̏
	mpParentNode = NULL;

	//Zւ̃|C^̏
	mpPrevNode = NULL;
	mpNextNode = NULL;

	if(mpListHead)
	{
		while((mpListHead->retNextNode())!= NULL){
			// 擪i_~[m[hj̎̃m[h擾
			pDialogTreeNodeBuff = (CDialogTreeNode*)mpListHead->retNextNode();
			// m[hϐǗXgO
			pDialogTreeNodeBuff->cutOffList();
			// m[hJ
			delete pDialogTreeNodeBuff;
		}

	}
}


//@\F
//		m[h̏𕶎ŕԂ(Θbc[̕\Ɏgp)
//		m[h̏ = ^Fid = idlCm[hCm[h̏
//F
//		char *cNodeInfoFm[hi[镶z
//߂lF
//		int 0F
int CDialogTreeNode::getNodeInfo(char *cNodeInfo){

	//m[ȟ^
	switch(this->mType){

		case APPLICATION:
			strcpy(cNodeInfo,"CApplicationNode:");
			break;
		case DOCUMENT:
			strcpy(cNodeInfo,"CDocumentNode:");
			break;
		case DIALOG:
			strcpy(cNodeInfo,"CDialogNode:");
			break;
		case BEGIN:
			strcpy(cNodeInfo,"CBeginNode:");
			break;
		case PARENTSofEXCHANGE:
			strcpy(cNodeInfo,"CParentesOfExchangeNode:");
			break;
		case END:
			strcpy(cNodeInfo,"CEndNode:");
			break;
		case EXCHANGE:
			strcpy(cNodeInfo,"CExchangeNode:");
			break;
		default:
			strcpy(cNodeInfo,"^`:");	
	}


	//id̑}
	strcat( cNodeInfo," id = ");
	char ch[10];
	itoa(this->mId,ch,10);
	strcat( cNodeInfo, ch);
	strcat( cNodeInfo,",");


	//m[h̑}
	strcat(cNodeInfo," name = ");
	strcat(cNodeInfo,this->mStrName.c_str());
	strcat( cNodeInfo,",");

	//m[h̏Ԃ̑}
	strcat(cNodeInfo," state = ");
	switch( this->mState ){

		case UNVISITED: 
			strcat(cNodeInfo,"unvisited");
			break;
		case PROMPTED:
			strcat(cNodeInfo,"prompted");
			break;		
		case ACTIVE:
			strcat(cNodeInfo,"active");
			break;
		case  VISITED:
			strcat(cNodeInfo,"visited");
			break;
		default:
			break;
	}

	return 0;

}

//@\F
//		̃m[hȉ̑Θbc[Cw肳ꂽid
//		m[hC΁C̃m[hANeBuԂɂD
//		̎C̐evfC܂̐evfƁCŏIIɃ[g܂ŁCANeBuԂɂȂD
//F
//		int idFm[hidl
//߂lF
//	int
//		0F.
//	   -1FȂD
int CDialogTreeNode::beActiveNode(int id){

	//̃m[hgm߂D
	if( this->mId == id ){

		//̃m[hgΏۃm[hȂC
		this->beActive();

		return 0;

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->beActiveNode(id);
			if( Ret == 0 ){
				//̃m[hgΏۃm[h̐êŁC

				//̎́Cqm[hHactiveɂ̂ŁC
				//PɃANeBuɂ邾C@I[o[[hANeBu͂тȂD
				CDialogTreeNode::beActive();
			
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;
}

//@\F
//		̃m[hȉ̑Θbc[Cw肳ꂽ_CAȎΓIȋ
//		Exchangem[hC΁C̃m[hANeBuԂɂD
//F
//		int DistanceFromDialogFCDialogNodȇΓIȈʒu
//߂lF
//	int
//		0F.
//	   -1FȂD
int CDialogTreeNode::beActiveExchangeFromDialog(int DistanceFromDialog){

	//̃m[hCExchangeNodeȂ
	if( this->mType == EXCHANGE ){

		//̃m[hgm߂D
		if( ((CExchangeNode*)this)->mDistanceFromDialog == DistanceFromDialog ){

			//̃m[hgΏۃm[hȂC
			this->beActive();

			return 0;

		}

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->beActiveExchangeFromDialog(DistanceFromDialog);
			if( Ret == 0 ){			
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;
}


//@\F
//		̃m[hȉ̑Θbc[Cw肳ꂽid
//		m[hC΁C̃m[hpromptedԂɂD
//		Ώۃm[hactiveԂȂCpromoptedɂ͂łȂD
//F
//		int idFm[hidl
//߂lF
//	int
//		0F.
//	   -1FȂD
int CDialogTreeNode::bePromptedNode(int id){

	//̃m[hgm߂D
	if( this->mId == id ){

		//̃m[hgΏۃm[hȂC

		if( this->getState() != ACTIVE ){

			this->bePrompted();

		}

		return 0;

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->bePromptedNode(id);
			if( Ret == 0 ){			
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;
}


//@\F
//		̃m[hȉ̑Θbc[Cw肳ꂽid
//		m[hC΁C̃m[hvisitedԂɂD
//		Θbc[̏ԂɂĂvisitedԂɂłȂꍇD
//F
//		int idFm[hidl
//߂lF
//	int
//		0F.
//	   -1FȂD
//	   -2:ԂvisitedɕύXłȂ
int CDialogTreeNode::beVisitedNode(int id){

	//̃m[hgm߂D
	if( this->mId == id ){

		int Ret;
		//̃m[hgΏۃm[hȂC
		Ret = this->beVisited();
		if( Ret == -1 ){
			return -2;
		}else{
			return 0;
		}

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->beVisitedNode(id);
			if( Ret != -1 ){			
				return Ret;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;
}

//@\F
//		̃m[hȉ̑Θbc[Cw肳ꂽid
//		m[hC΁C̃m[hIvisitedԂɂD
//F
//		int idFm[hidl
//߂lF
//	int
//		0F.
//	   -1FȂD
int CDialogTreeNode::forceBeVisitedNode(int id){

	//̃m[hgm߂D
	if( this->mId == id ){

		//̃m[hgΏۃm[hȂC
		//IvisitedԂɂD
		CDialogTreeNode::beVisited();
		//em[hvisitedԂɏoȂm߂
		( this->mpParentNode) ->beVisited();
		return 0;

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->forceBeVisitedNode(id);
			if( Ret == 0 ){			
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;
}


//@\Fw肳ꂽidlm[hTC̃m[hւ̃|C^Ԃ
//F
//		int id : m[hidl
//		CDialogTreeNode** pDialogTreeNode:̃m[hւ̃|C^̃|C^
//߂lF
//	 int  0: 
//	 int -1: Ȃ
int CDialogTreeNode::getDialogTreeNode(int id, CDialogTreeNode **pDialogTreeNode){

	//̃m[hgm߂D
	if( this->mId == id ){

		//̃m[hgΏۃm[hȂC
		*pDialogTreeNode = this;
		return 0;

	}

	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->getDialogTreeNode(id,pDialogTreeNode);
			if( Ret == 0 ){			
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//Ȃ
	return -1;


	
}

//@\F
//		tɍł߂ANeBuԂłm[hTC̃m[h̑Θbc[
//      m[hւ̃|C^ԂD
//F
//		̃m[hւ̃|C^
//߂lF
//		 int  0:ANeBuԂłm[h݂
//		     -1:ANeBuԂłm[hȂ
int CDialogTreeNode::getActiveNode(CDialogTreeNode** pDialogTreeNode){

	//̃m[hANeBuł͂Ȃ
	if( this->mState != ACTIVE ){
			pDialogTreeNode = NULL;
			return -1;
	}


	if( mpListHead ){

		CDialogTreeNode* tempDialogTreeNode;

		//_~[m[h̓ǂݔ΂
		tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( tempDialogTreeNode != NULL ){

			int Ret;
			Ret	= tempDialogTreeNode->getActiveNode(pDialogTreeNode);
			if( Ret == 0 ){
				//ANeBuԂ̃m[h̂
				return 0;
			}
			tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

		}

	}

	//qvfȂ,邢͎qvfɃANeBuԂ̃m[hȂ̂ŁC
	//̃m[hւ̃|C^ԂďI
	*pDialogTreeNode = this;
	return 0;

}

string CDialogTreeNode::getXML()
{
	char cXML[DOCUMENT_LENGTH];
	BSTR bstrXML;
	mpXislNode->get_xml(&bstrXML);
	BSTRToAscii(bstrXML,cXML,DOCUMENT_LENGTH);
	SysFreeString(bstrXML);
	return cXML;
}





