// DialogNode.cpp: CDialogNode NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NewIV.h"
#include "DialogNode.h"
#include "BeginNode.h"
#include "ParentsOfExchangeNode.h"
#include "EndNode.h"
#include "TreeManagement.h"
#include "common.h"
#include "logDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CNewIVApp theApp;
extern CTreeManagement treeManagement;
extern CLogDlg *g_pLogDlg;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

//RXgN^iΘbɓnȂj
//F
// IXMLDOMNode** pDialogNodeF<dialog>DOMNode
// CDialogTreeNode* pParentNodeF̃m[h̐em[hCDocument
CDialogNode::CDialogNode(IXMLDOMNode** pDialogNode,CDocumentNode* pParentNode)
{
	CString strLog;

	//m[h̏
	this->mSuccess = 0;
	this->mpXislNode = *pDialogNode;		//<dialog>DOMElement
	this->mpParentNode =  pParentNode;		//Θbc[̐em[hւ̃|C^̃Zbg

	//Ń_CAOexchangeԂ̋Zbg
	mDistanceFromDialogLength = 0;


	//m[h(_CAO)̎擾
	BSTR bStrId;
	VARIANT vArIdValue;
	char cDialogName[WORD_LENGTH];
	bStrId= SysAllocString(L"@id");
	IXMLDOMNode* pIdAttrNode;

	this->mpXislNode->selectSingleNode(bStrId,&pIdAttrNode);
	pIdAttrNode->get_nodeValue(&vArIdValue);
	VARIANTToAscii(vArIdValue,cDialogName);
	SysFreeString(bStrId);
	VariantClear(&vArIdValue);

	this->mStrName = cDialogName;				 //m[h̃Zbg

	//s[g񐔂̎擾
	BSTR bStrRepeat;
	VARIANT vArRepeatValue;
	char cRepeat[WORD_LENGTH];
	bStrRepeat= SysAllocString(L"@repeat");
	IXMLDOMNode* pRepeatAttrNode;

	this->mpXislNode->selectSingleNode(bStrRepeat,&pRepeatAttrNode);
	pRepeatAttrNode->get_nodeValue(&vArRepeatValue);
	VARIANTToAscii(vArRepeatValue,cRepeat);
	SysFreeString(bStrRepeat);
	VariantClear(&vArRepeatValue);
	
	this->mRepeatCount = atoi(cRepeat);				 //s[g񐔂̃Zbg
	//s[g񐔂̃G[`FbN
	if( this->mRepeatCount < 0 ){
			strLog = "<dialog id=";
			strLog += this->mStrName.c_str();
			strLog += "\">̃s[g񐔂̎w肪sł\r\n";
			g_pLogDlg->setText(strLog);
			this->mSuccess = 1;
	}

	if( this->mRepeatCount == 0 ){
		if( !strcmp(cRepeat,"indefinite") ){
			//s[g񐔖
			this->mRepeatCount = -1;
		}else{
			strLog = "<dialog id=";
			strLog += this->mStrName.c_str();
			strLog += "\">̃s[g񐔂̎w肪sł\r\n";
			g_pLogDlg->setText(strLog);
			this->mSuccess = 1;
		}
	}



	//comb̎擾
	BSTR bStrComb;
	VARIANT vArCombValue;
	char cComb[WORD_LENGTH];
	bStrComb= SysAllocString(L"@comb");
	IXMLDOMNode* pCombAttrNode;

	this->mpXislNode->selectSingleNode(bStrComb,&pCombAttrNode);
	pCombAttrNode->get_nodeValue(&vArCombValue);
	VARIANTToAscii(vArCombValue,cComb);
	SysFreeString(bStrComb);
	VariantClear(&vArCombValue);
	
	if(!strcmp(cComb,"par") ){
		this->mComb = PAR;
	}else if( !strcmp(cComb,"alt") ){
		this->mComb = ALT;
	}else if( !strcmp(cComb,"seq") ){
		this->mComb = SEQ;
	}

	//scope̎擾(_CAǑ^@荞orʁ@)
	BSTR bStrScope;
	VARIANT vArScopeValue;
	char cScope[WORD_LENGTH];
	bStrScope= SysAllocString(L"@scope");
	IXMLDOMNode* pScopeAttrNode;

	this->mpXislNode->selectSingleNode(bStrScope,&pScopeAttrNode);
	pScopeAttrNode->get_nodeValue(&vArScopeValue);
	VARIANTToAscii(vArScopeValue,cScope);
	SysFreeString(bStrScope);
	VariantClear(&vArScopeValue);

	if( !strcmp(cScope,"document") ){
		this->mDialogType = INTERRUPTDIALOG;
	}else if( !strcmp(cScope,"dialog") ){
		this->mDialogType = NORMALDIALOG; 
	}else{
		this->mDialogType = -1;
	}


	//Ԃ̃Zbg
	this->mState = UNVISITED;					//ԂUNVISITEDԂ
	this->mType = DIALOG;						//Θbc[̌^̐ݒ
	this->mId = treeManagement.getIdCount();	//IDԍi[


	//em[hCAvP[VChLg̎擾Ei[
	string *strAppName;
	string *strDocName;
	strAppName = new string();
	strDocName = new string();
	pParentNode->getName(strDocName);
	pParentNode->getAppName(strAppName);
	this->mStrAppName.assign(strAppName->c_str());	
	this->mStrDocName.assign(strDocName->c_str());
	delete strAppName;
	delete strDocName;

	int Ret;
	//_CAOϐ̓o^
	Ret = this->registDiaVar("");
	if( Ret == -1 ){
		//_CAÖo^̎s
		this->mSuccess = 1;
	}

	//CDialogNodeȉ̃c[𐶐
	makeTree();
}

//RXgN^iΘbɓnj
//F
// IXMLDOMNode** pDialogNodeF<dialog>DOMNode
// CDialogTreeNode* pParentNodeF̃m[h̐em[hCDocument
// string strArgF<dialog>ɓn̒li<goto>,<call>̑namelist̑lDj 
CDialogNode::CDialogNode(IXMLDOMNode** pDialogNode, CDocumentNode* pParentNode,string strArg)
{

	CString strLog;

	//m[h̏
	this->mSuccess = 0;
	this->mpXislNode = *pDialogNode;		//<dialog>DOMElement
	this->mpParentNode =  pParentNode;			//Θbc[̐em[hւ̃|C^̃ZbgD

	//Ń_CAOexchangeԂ̋Zbg
	mDistanceFromDialogLength = 0;


	//m[h(_CAO)̎擾
	BSTR bStrId;
	VARIANT vArIdValue;
	char cDialogName[WORD_LENGTH];
	bStrId= SysAllocString(L"@id");
	IXMLDOMNode* pIdAttrNode;

	this->mpXislNode->selectSingleNode(bStrId,&pIdAttrNode);
	pIdAttrNode->get_nodeValue(&vArIdValue);
	VARIANTToAscii(vArIdValue,cDialogName);
	SysFreeString(bStrId);
	VariantClear(&vArIdValue);

	this->mStrName = cDialogName;				 //m[h̃Zbg

	//s[g񐔂̎擾
	BSTR bStrRepeat;
	VARIANT vArRepeatValue;
	char cRepeat[WORD_LENGTH];
	bStrRepeat= SysAllocString(L"@repeat");
	IXMLDOMNode* pRepeatAttrNode;

	this->mpXislNode->selectSingleNode(bStrRepeat,&pRepeatAttrNode);
	pRepeatAttrNode->get_nodeValue(&vArRepeatValue);
	VARIANTToAscii(vArRepeatValue,cRepeat);
	SysFreeString(bStrRepeat);
	VariantClear(&vArRepeatValue);
	
	this->mRepeatCount = atoi(cRepeat);				 //s[g񐔂̃Zbg
	//s[g񐔂̃G[`FbN
	if( this->mRepeatCount < 0 ){
			strLog = "<dialog id=";
			strLog += this->mStrName.c_str();
			strLog += "\">̃s[g񐔂̎w肪sł\r\n";
			g_pLogDlg->setText(strLog);

			this->mSuccess = 1;
	}

	if( this->mRepeatCount == 0 ){
		if( !strcmp(cRepeat,"indefinite") ){
			//s[g񐔖
			this->mRepeatCount = -1;
		}else{

			strLog = "<dialog id=";
			strLog += this->mStrName.c_str();
			strLog += "\">̃s[g񐔂̎w肪sł\r\n";
			g_pLogDlg->setText(strLog);

			this->mSuccess = 1;
		}
	}

	//comb̎擾
	BSTR bStrComb;
	VARIANT vArCombValue;
	char cComb[WORD_LENGTH];
	bStrComb= SysAllocString(L"@comb");
	IXMLDOMNode* pCombAttrNode;

	this->mpXislNode->selectSingleNode(bStrComb,&pCombAttrNode);
	pCombAttrNode->get_nodeValue(&vArCombValue);
	VARIANTToAscii(vArCombValue,cComb);
	SysFreeString(bStrComb);
	VariantClear(&vArCombValue);
	
	if(!strcmp(cComb,"par") ){
		this->mComb = PAR;
	}else if( !strcmp(cComb,"alt") ){
		this->mComb = ALT;
	}else if( !strcmp(cComb,"seq") ){
		this->mComb = SEQ;
	}

	//scope̎擾(_CAǑ^@荞orʁ@)
	BSTR bStrScope;
	VARIANT vArScopeValue;
	char cScope[WORD_LENGTH];
	bStrScope= SysAllocString(L"@scope");
	IXMLDOMNode* pScopeAttrNode;

	this->mpXislNode->selectSingleNode(bStrScope,&pScopeAttrNode);
	pScopeAttrNode->get_nodeValue(&vArScopeValue);
	VARIANTToAscii(vArScopeValue,cScope);
	SysFreeString(bStrScope);
	VariantClear(&vArScopeValue);

	if( !strcmp(cScope,"document") ){
		this->mDialogType = INTERRUPTDIALOG;
	}else if( !strcmp(cScope,"dialog") ){
		this->mDialogType = NORMALDIALOG; 
	}else{
		this->mDialogType = -1;
	}

	//Ԃ̃Zbg
	this->mState = UNVISITED;					//ԂUNVISITEDԂ
	this->mType = DIALOG;						//Θbc[̌^̐ݒ
	this->mId = treeManagement.getIdCount();	//IDԍi[


	//em[hCAvP[VChLg̎擾Ei[
	string *strAppName;
	string *strDocName;
	strAppName = new string();
	strDocName = new string();
	pParentNode->getName(strDocName);
	pParentNode->getAppName(strAppName);
	this->mStrAppName.assign(strAppName->c_str());	
	this->mStrDocName.assign(strDocName->c_str());
	delete strAppName;
	delete strDocName;

	int Ret;
	//_CAOϐ̓o^
	Ret = this->registDiaVar(strArg);
	if( Ret == -1 ){
		this->mSuccess = 1;
	}

	//CDialogTreeNodeȉ̃c[𐶐
	makeTree();
}

//fXgN^
CDialogNode::~CDialogNode()
{
	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];
	char cDiaName[MESSAGE_LENGTH];

	strcpy(cAppName,mStrAppName.c_str());
	strcpy(cDocName,mStrDocName.c_str());
	strcpy(cDiaName,mStrName.c_str());
	//_CAOϐȉ폜悤CΘbc[ǗʂāCϐǗɈ˗
	treeManagement.askVarManagementToDeleteVar(cAppName,cDocName,cDiaName,"","");
}

//@\F
//		̃m[hANeBuԂɂD
//		܂XgCBeginNode΁CCBeginNodeANeBuԂ
//		CBeginNodeȂ΁CCParentsOfExchangeNodeANeBuԂɁC
//		CParentsOfExchangeNodeȂ΁CCEndNodeANeBuԂɂD
//		ǂȂ΁C̃m[ĥ݂ANeBuԂɂ̂
//F
//		 Ȃ
//߂lF
//		 Ȃ
void CDialogNode::beActive(){

	this->mState = ACTIVE;

	//XgH邽߂CDialogTreeNodẽ|C^
	CDialogTreeNode* pTempDialogTreeNode;

	if( mpListHead ){

		//_~[m[h̓ǂݔ΂
		pTempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( pTempDialogTreeNode != NULL ){

			if( pTempDialogTreeNode->getType() == BEGIN ){
				pTempDialogTreeNode->beActive();
				return;	
			}else if( pTempDialogTreeNode->getType() == PARENTSofEXCHANGE ){
			( ( CParentsOfExchangeNode* )pTempDialogTreeNode ) -> beActive();
				return;
			}else if( pTempDialogTreeNode->getType() == END ){
				pTempDialogTreeNode->beActive();
				return;
			}

			pTempDialogTreeNode = ( CDialogTreeNode* )pTempDialogTreeNode->retNextNode();

		}
		//ANeBuɂm[hȂ̂ŁC̃m[hgVISITEDԂɂD
		CDialogTreeNode::beVisited();

	}
	//ANeBuɂm[hȂ̂ŁC̃m[hgVISITEDԂɂD
	CDialogTreeNode::beVisited();

}

//qm[hAŗ^ꂽÃm[h̑ΓIȋ
//ExchangeTAANeBuԂɂ
//0Ԃ
//݂Ȃ-1Ԃ
int CDialogNode::beActiveExchange(int DistanceFromDialog){

	return this->beActiveExchangeFromDialog(DistanceFromDialog);

}


//@\: \bh̃I[o[[h
//  	̏Ԃvisitedɂł邩ǂm߂ĂCvisitedԂɂ
//	    ̓Iɂ́C
//			SĂ̎qvfvisitedԂǂmFD
//@@@
//߂lFint
//			0F
//		   -1Fs
int CDialogNode::beVisited(){

	CDialogTreeNode* pTempDialogTreeNode = NULL;

	//qvf
	if( mpListHead ){

		//擪̃_~[m[h̓ǂݔ΂
		pTempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

		while( pTempDialogTreeNode != NULL ){

			//beginvfvisitedł͂ȂCvisitedԂɂ
			if( pTempDialogTreeNode->getType() == BEGIN ){
				pTempDialogTreeNode->CDialogTreeNode::beVisited();
			}

			//qvfvisitedԂł͂Ȃ
			if( pTempDialogTreeNode->getState() != VISITED ){
				return -1;
			}

			pTempDialogTreeNode = ( CDialogTreeNode* )pTempDialogTreeNode->retNextNode();
		}
		this->mState = VISITED;
		return 0;

	}else{

		this->mState = VISITED;
		return 0;
	}


}

//@\F
//		AvP[VԂ
//F
//		AvP[Vi[string^ւ̃|C^
void CDialogNode::getAppName(string *pStrAppName){

	pStrAppName->assign(this->mStrAppName);

}

//@\F
//		hLgԂ
//F
//		hLgi[string^ւ̃|C^
void CDialogNode::getDocName(string *pStrDocName){

	pStrDocName->assign(this->mStrDocName);

}

//@\F
//		_CAÕ^CvԂi荞݂Cʏ킩j
//߂lF
//		_CAǑ^
int CDialogNode::getDialogType(){

	return this->mDialogType;
}

//@\F
//		_CAȎcomb̒lԂ
//߂lF
//		comb̒l
int CDialogNode::getComb(){

	return this->mComb;
}


//@\F
//		m[h̏𕶎ŕԂ(Θbc[̕\Ɏgp)
//		m[h̏ = CDialogNode( interrupt or normal )Fid = idlCm[hCm[h̏
//F
//		char *cNodeInfoFm[hi[镶z
//߂lF
//		int 0F
int CDialogNode::getNodeInfo(char* cNodeInfo){

	strcpy(cNodeInfo,"CDialogNode(");
	if( this->mDialogType == INTERRUPTDIALOG ){
		strcat(cNodeInfo,"interrupt):");
	}else{
		strcat(cNodeInfo,"normal):");
	}

	//id̑}
	strcat( cNodeInfo," id = ");
	char ch[10];
	itoa(this->mId,ch,10);
	strcat( cNodeInfo, ch);
	strcat( cNodeInfo,",");

	//repeat񐔂̑}
	strcat( cNodeInfo," repeat = ");
	char ch2[10];
	itoa(this->mRepeatCount,ch2,10);
	strcat( cNodeInfo,ch2);
	strcat( cNodeInfo,",");

	//m[h̑}
	strcat(cNodeInfo," name = ");
	strcat(cNodeInfo,this->mStrName.c_str());
	strcat( cNodeInfo,",");

	//m[h̏Ԃ̑}
	strcat(cNodeInfo," state = ");
	switch( this->mState ){

		case UNVISITED: 
			strcat(cNodeInfo,"unvisited");
			break;
		case PROMPTED:
			strcat(cNodeInfo,"prompted");
			break;		
		case ACTIVE:
			strcat(cNodeInfo,"active");
			break;
		case  VISITED:
			strcat(cNodeInfo,"visited");
			break;
		default:
			break;
	}

	return 0;

}

//@\F
//		CDialogNodeȉ̑Θbc[𐶐.
//		XgCBeginNode, CParentsOfExchangeNode, CEndNodeǉD
int CDialogNode::makeTree(){

	IXMLDOMNode* pBeginNode = NULL;
	IXMLDOMNode* pEndNode = NULL;
	BSTR bStrBeginXPath;
	BSTR bStrEndXPath;

	CBeginNode* pTempBeginTreeNode = NULL;
	CParentsOfExchangeNode* pTempParentsOfExchangeNode = NULL;
	CEndNode* pTempEndTreeNode = NULL;

	if( mpListHead == NULL ){
		//_~[m[h̐iCParListNode̐CŏɃ_~[m[h܂Kvj
		mpListHead = new CDialogTreeNode;
		mpListTail = mpListHead;
	}

	bStrBeginXPath = SysAllocString(L"begin");
	mpXislNode->selectSingleNode( bStrBeginXPath, &pBeginNode);
	SysFreeString( bStrBeginXPath );

	if( pBeginNode != NULL ){
		//CBeginNodeIuWFNg̐
		pTempBeginTreeNode = new CBeginNode( &pBeginNode,this );
		//CBeginNodeXg̍Ōɒǉ
		pTempBeginTreeNode->joinList(this->mpListTail);
		// XgŌւ̃|C^ړ
		this->mpListTail = pTempBeginTreeNode;
	}

	//CParentsOfExchangeNode̐
	pTempParentsOfExchangeNode = new CParentsOfExchangeNode( &this->mpXislNode, this, this->mComb);
	if( pTempParentsOfExchangeNode->mSucess == 0 ){
		//CBeginNodeXg̍Ōɒǉ
		pTempParentsOfExchangeNode->joinList(this->mpListTail);
		// XgŌւ̃|C^ړ
		this->mpListTail = pTempParentsOfExchangeNode;
	}else{
		delete pTempParentsOfExchangeNode;
		pTempParentsOfExchangeNode = NULL;
	}

	bStrEndXPath = SysAllocString(L"end");
	mpXislNode->selectSingleNode( bStrEndXPath, &pEndNode);
	SysFreeString( bStrEndXPath );

	if( pEndNode != NULL ){
		//CEndNodeIuWFNg̐
		pTempEndTreeNode = new CEndNode( &pEndNode,this );
		//CBeginNodeXg̍Ōɒǉ
		pTempEndTreeNode->joinList(this->mpListTail);
		// XgŌւ̃|C^ړ
		this->mpListTail = pTempEndTreeNode;
	}


	return 0;
}


//@\F
//		_CAOϐo^(ȂjD
//F
//		string strArg:i[string^
//					@Ȃꍇ͋󕶎n
//߂l:
//		0FI
//		-1:ُI
int CDialogNode::registDiaVar(string strArg){

	CString strLog;

	IXMLDOMNode* pDialogVarNode = NULL;		//<dialog_var>m[hi[
	IXMLDOMNodeList* pVarNodeList = NULL;	//<var>m[hXg
	IXMLDOMNode* pVarNode = NULL;			//<var>m[h
	long lLen;								//<var>m[hXgi[
	int Ret;

	//_CAOϐƂēo^
	Ret = registArgVar(strArg);
	if( Ret == -1 ){
		//@G[
		return -1;
	}


	BSTR bStrDialogVarXPath;      //<dialog_var>vfXPathi[
	//<dialog_var>XPathi[
	bStrDialogVarXPath = SysAllocString(L"dialog_var");

	//<dialog_var>m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrDialogVarXPath,&pDialogVarNode);
	SysFreeString(bStrDialogVarXPath);

	//dialog_var
	if( pDialogVarNode != NULL ){

		//hLgϐ<var>^OQ擾
		pDialogVarNode->get_childNodes(&pVarNodeList);
		pVarNodeList->get_length(&lLen);	
	
		BSTR bStrTagName;							//m[hi[
		BSTR bStrName = SysAllocString(L"name");    //name
		BSTR bStrNameValue;							//name̒l
		BSTR bStrValue = SysAllocString(L"expr");	//expr
		BSTR bStrValueValue;						//expr̒l
		IXMLDOMNamedNodeMap *pVarAttrsNodeMap;		//varvf̑}bv
		IXMLDOMNode* pNameAttrNode;					//namẽm[h
		IXMLDOMNode* pValueAttrNode;				//valuẽm[h
		char cTemp[MESSAGE_LENGTH];
		char cAppName[MESSAGE_LENGTH];
		char cDocName[MESSAGE_LENGTH];
		char cDiaName[MESSAGE_LENGTH];
		char cNameValue[WORD_LENGTH];
		char cValueValue[WORD_LENGTH];

		strcpy(cAppName,this->mStrAppName.c_str());
		strcpy(cDocName,this->mStrDocName.c_str());
		strcpy(cDiaName,this->mStrName.c_str());

		strLog = "***_CAOϐ(";
		strLog += cDiaName;
		strLog += ")̓o^***\r\n";
		g_pLogDlg->setText(strLog);

		//evar^Oɑ΂ď
		for(int i = 0; i < lLen; i++){
			pVarNodeList->get_item(i,&pVarNode);	

			pVarNode->get_baseName(&bStrTagName);
			BSTRToAscii(bStrTagName,cTemp,MESSAGE_LENGTH);
			SysFreeString(bStrTagName);
			if( !strcmp(cTemp,"var") ){

				//varvf̑m[hXg̎擾
				pVarNode->get_attributes(&pVarAttrsNodeMap);

				//namȇl擾
				pVarAttrsNodeMap->getNamedItem(bStrName,&pNameAttrNode);
				pNameAttrNode->get_text(&bStrNameValue);

				BSTRToAscii(bStrNameValue,cNameValue,WORD_LENGTH);
				SysFreeString(bStrNameValue);
			
				pVarAttrsNodeMap->getNamedItem(bStrValue,&pValueAttrNode);
				//valueΑl擾
				if(pValueAttrNode != NULL){
					pValueAttrNode -> get_text(&bStrValueValue);
					BSTRToAscii(bStrValueValue,cValueValue,WORD_LENGTH);
					//
					SysFreeString(bStrValueValue);

				}else{
					cValueValue[0] = '\0';
				}
				//Θbc[ǗʂāCϐǗɃ_CAOϐo^,ϐlo^˗
				Ret = treeManagement.askVarManagementToRegistVar(cAppName,cDocName,cDiaName,"",cNameValue);
				if( Ret != 0 ){
					if( Ret == 1 ){
						strLog = "_CAOϐ:";
						strLog += cNameValue;
						strLog += "d`Ă܂\r\n";
						g_pLogDlg->setText(strLog);
					}else if( Ret == 2 ){
						strLog = "_CAOϐ:";
						strLog += cNameValue;
						strLog += "͕sȕϐł\r\n";
						g_pLogDlg->setText(strLog);
					}
						strLog = "_CAOϐ:";
						strLog += cNameValue;
						strLog += "o^ł܂ł\r\n";
						g_pLogDlg->setText(strLog);
				}else{
					treeManagement.askVarManagemnetToSetVarData(cAppName,cDocName,cDiaName,"",cNameValue,cValueValue);

					strLog = "ϐ:";
					strLog += cNameValue;
					strLog += "=";
					strLog += cValueValue;
					strLog += "œo^\r\n";
					g_pLogDlg->setText(strLog);

				}
				cNameValue[0] = '\0';
				cValueValue[0] = '\0';
				cTemp[0] = '\0';
			}			
	
		}
		g_pLogDlg->setText("\r\n");
				//Q
		SysFreeString(bStrName);
		SysFreeString(bStrValue);
	}

	return 0;
}


//@\F
//		_CAOϐo^(jD
//F
//		ȂD
//߂l:
//	   	 0FI
//		-1FُI
int CDialogNode::registArgVar(string strArg){

	CString strLog;

	int i;
	int length;

	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];
	char cDiaName[MESSAGE_LENGTH];

	strcpy(cAppName,this->mStrAppName.c_str());
	strcpy(cDocName,this->mStrDocName.c_str());
	strcpy(cDiaName,this->mStrName.c_str());

	//<dialog>̈(arg̒ljC_CAOϐƂēo^D
	//̍ہCۂ̕ϐ͒l̏ɓo^C
	//_CAOϐ́C
	BSTR bStrArg;
	VARIANT argValue;
	char cArgValue[MESSAGE_LENGTH];
	string strArgValue;

	//arg̒l̎擾 VARIANATcharstring
	IXMLDOMNode* pArgAttrNode;
	bStrArg= SysAllocString(L"@arg");
	this->mpXislNode->selectSingleNode(bStrArg,&pArgAttrNode);
	SysFreeString(bStrArg);

	//G[`FbN(argw肳ĂȂ̂ɁCw肳Ăꍇ)
	if( pArgAttrNode == NULL ){
		VariantClear(&argValue);
		if( strArg.length() != 0 ){
			if( strArg != "undefined" ){
				strLog = "<dialog id=\"";
				strLog += this->mStrName.c_str();
				strLog += "\">ɂđargw肳Ă܂\r\n";
				g_pLogDlg->setText(strLog);
				return -1;
			}else{
				return 0;
			}
		}else{
			return 0;
		}
	}else{
		//G[`FbNiargw肳Ă̂ɁCw肳ĂȂꍇ
		if( strArg.length() == 0 ){
//			VariantClear(&argValue);	
//			cerr << "<dialog id=\"" << this->mStrName << "\">ɂđargw肳Ă̂"
//				 <<"w肳Ă܂\n";
			return 0;
		}
	}


	pArgAttrNode->get_nodeValue(&argValue);
	VARIANTToAscii(argValue,cArgValue);
	VariantClear(&argValue);
	strArgValue = cArgValue;

	
	//󔒂̏(arg̒l)
	length = strArgValue.length();
	for( i = 0; i < length; i++ ){
		if( strArgValue[i] == ' ' ){
			strArgValue.erase(i,1);
		}
	}
	//󔒂̏(̒lj
	length = strArg.length();
	for( i = 0; i < length; i++ ){
		if( strArg[i] == ' ' ){
			strArg.erase(i,1);
		}
	}

	int count = 0;
	int pos1;
	int pos2;
	string strVarName;
	string strVarValue;
	char cVarName[WORD_LENGTH];
	char cVarValue[WORD_LENGTH];

	while( strArgValue.length() != 0 ){

		pos1 = strArgValue.find(",");				//ŏ","̈ʒuL^
		if( pos1 != -1 ){
			//","܂ł̕ϐCl̎擾
			strVarName = strArgValue.substr(0,pos1);	//̈ʒu܂ł̒̕oϐ
			strArgValue.erase(0,pos1+1);				//","܂ł̏̕

			pos2 = strArg.find(",");					//strArgɊւĂl
			if( pos2 == -1 ){
				strLog = "<dialog id=\"";
				strLog += this->mStrName.c_str();
				strLog += "\">ɂđarg̈Ǝ̐vĂ܂\r\n";
				g_pLogDlg->setText(strLog);

				return -1;
			}
			strVarValue = strArg.substr(0,pos2);		//̈ʒu܂ł̕񒊏oϐ̒l
			strArg.erase(0,pos2+1);

		}else{
			//Ō̕ϐ̎擾
			pos2 = strArg.find(",");
			if( pos2 != -1 ){
				strLog = "<dialog id=\"";
				strLog += this->mStrName.c_str();
				strLog += "\">ɂđarg̈Ǝ̐vĂ܂\r\n";
				g_pLogDlg->setText(strLog);
			}
			strVarName = strArgValue;
			strArgValue.erase(0,strArgValue.length());
			strVarValue = strArg;
			strArg.erase(0,strArg.length());

		}

		//ϐCl̎̃G[
		//if( strVarName.length() == 0 || strVarValue.length() == 0 ){
		//	cerr << "<dialog id=\"" << this->mStrName 
		//		 << "\">ɋ󕶎C邢͎ɋ󕶎gpĂ܂\n";
		//	return -1;
		//}

		strcpy(cVarName,strVarName.c_str());
		int Ret;
		//Θbc[ǗʂāCϐǗɃ_CAOϐo^,ϐlo^˗
		Ret = treeManagement.askVarManagementToRegistVar(cAppName,cDocName,cDiaName,"",cVarName);		
		if( Ret != 0 ){
			
			if( Ret == 1 ){

				strLog = "_CAOϐ:";
				strLog += strVarName.c_str();
				strLog += "d`Ă܂\r\n";
				g_pLogDlg->setText(strLog);
				
			}else if( Ret == 2 ){
			
				strLog = "_CAOϐ:";
				strLog += strVarName.c_str();
				strLog += "͕sȕϐł\r\n";
				g_pLogDlg->setText(strLog);
				
			}
			
				strLog = "_CAOϐ:";
				strLog += strVarName.c_str();
				strLog += "͓o^ł܂ł\r\n";
				g_pLogDlg->setText(strLog);
			
		}else{
			strcpy(cVarValue,strVarValue.c_str());
			treeManagement.askVarManagemnetToSetVarData(cAppName,cDocName,cDiaName,"",cVarName,cVarValue);
			
		}

	}

	if( strArg.length() != 0 ){
		strLog = "<dialog id=\"";
		strLog += this->mStrName.c_str();
		strLog += "\">ɂđargw肳Ă̂Ɏw肳Ă܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;
	}

	return 0;
}

//s[g񐔂Ԃ
int CDialogNode::getRepeatCount(){

	return this->mRepeatCount;
}

//s[g񐔂Zbg
void CDialogNode::setRepeatCount(int count){

	this->mRepeatCount = count;
}

void CDialogNode::writeSource(int documentType){

	CString strTemp;

	IXMLDOMNode *pDialogChildNode;
	IXMLDOMNodeList *pDialogChildNodeList;
	long Length;
	BSTR bstrDialogChildNodeName;
	char cDialogChildNodeName[WORD_LENGTH];

	//<dialog...>̏o
	theApp.getSource(this->mpXislNode,strTemp);
	strTemp.Insert(0,"    ");
	strTemp += "\\line";
	if( this->mState == ACTIVE ){
		theApp.addStringWithJammpingPoint(strTemp,1,documentType);
	}else{
		theApp.addString(strTemp,0,documentType);
	}

	//<dialog>̎qvf̏
	pDialogChildNode = this->mpXislNode;

	pDialogChildNode->get_childNodes(&pDialogChildNodeList);
	pDialogChildNodeList->get_length(&Length);
	for( int i = 0; i < Length; i++){

		pDialogChildNodeList->get_item(i,&pDialogChildNode);
		pDialogChildNode->get_baseName(&bstrDialogChildNodeName);
		BSTRToAscii(bstrDialogChildNodeName,cDialogChildNodeName,WORD_LENGTH);
		SysFreeString(bstrDialogChildNodeName);

		//̂܂܂̃ASY,<exchange>ԂɋLqꂽRg\Ȃ
		//̌ۑɂĂD
		if( !strcmp( cDialogChildNodeName, "exchange" ) ||
			!strcmp( cDialogChildNodeName, "seq_exchange" ) ||
			!strcmp( cDialogChildNodeName, "par_exchange" ) ||
			!strcmp( cDialogChildNodeName, "alt_exchange" ) ||
			!strcmp( cDialogChildNodeName, "begin") ||
			!strcmp( cDialogChildNodeName, "end") ){

			CDialogTreeNode* pTempDialogTreeNode;
			//_~[m[h̓ǂݔ΂
			pTempDialogTreeNode = (CDialogTreeNode*)this->mpListHead->retNextNode();

			while( pTempDialogTreeNode != NULL ){

				if( pTempDialogTreeNode->getType() == BEGIN ){
					//CBeginȂ
					((CBeginNode*)pTempDialogTreeNode)->writeSource(documentType);
				}else if( pTempDialogTreeNode->getType() == PARENTSofEXCHANGE ){
					//CParantesOfExchangeNodeȂ

					( (CParentsOfExchangeNode*)pTempDialogTreeNode )->writeSource(documentType,3);

				}else{
					//CEndȂ
					((CEndNode*)pTempDialogTreeNode)->writeSource(documentType);
				}

				pTempDialogTreeNode = (CDialogTreeNode*)pTempDialogTreeNode->retNextNode();
			}
			break;

		}else{
			//<dialog_var>сC
			//<dialog_var><begin>Ԃ̃Rg̕\
			theApp.writeSource(pDialogChildNode,3,documentType,0);
		}


	}

	strTemp="    </dialog>\\line";
	if( this->mState == ACTIVE ){
		theApp.addString(strTemp,1,documentType);
	}else{
		theApp.addString(strTemp,0,documentType);
	}
}



