//
// SLR(1)\͊vO
// LR(0)W
//
// CanonicalLR0Collection.h / CanonicalLR0Collection.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <assert.h>

#include "CanonicalLR0Collection.h"

using namespace std;



//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//

//
// NX CLR0Item
//



//
// ֐ : CLR0Item::CLR0Item()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0Item::CLR0Item() : m_Production()
{
	m_nMarkerPos = MARKER_END;
	m_nSetNumber = -1;
}


//
// ֐ : CLR0Item::CLR0Item( CProduction &pro, int marker )
// @  \ : RXgN^ilj
//    : pro ---- K
//			marker -- }[J[̈ʒu
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0Item::CLR0Item( CProduction &pro, int setnumber, int marker ) : m_Production( pro )
{
	m_nMarkerPos = marker;
	m_nSetNumber = setnumber;

}


//
// ֐ : CLR0Item::CLR0Item( CLR0Item &item )
// @  \ : Rs[RXgN^
//    : Rs[
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0Item::CLR0Item( CLR0Item &item ) : m_Production( item.GetProduction() )
{
	m_nMarkerPos = item.GetCurrentMarkerPos();
	m_nSetNumber = item.GetSetNumber();
}


//
// ֐ : CLR0Item::~CLR0Item()
// @  \ : fXgN^
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0Item::~CLR0Item()
{
}


//
// ֐ : CProduction &CLR0Item::GetProduction()
// @  \ : K擾
//    : Ȃ
// ߂l : m_Productionւ̎Q
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CProduction &CLR0Item::GetProduction()
{
	return m_Production;
}


//
// ֐ : CProduction *CLR0Item::GetProductionPtr()
// @  \ : K擾
//    : Ȃ
// ߂l : m_Productionւ̃|C^
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G
//
CProduction *CLR0Item::GetProductionPtr()
{
	return &m_Production;
}

//
// ֐ : int CLR0Item::GetCurrentMarkerPos()
// @  \ : ݂̃}[J[ʒuԂ
//    : Ȃ
// ߂l : }[J[̈ʒu
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0Item::GetCurrentMarkerPos()
{
	return m_nMarkerPos;
}

//
// ֐ : int CLR0Item::GetSetNumber()
// @  \ : ĂLR(0)W̔ԍ擾
//    : Ȃ
// ߂l : LR(0)W̔ԍ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0Item::GetSetNumber()
{
	return m_nSetNumber;
}


//
// ֐ : int CLR0Item::ShiftMarker()
// @  \ : }[J[̈ʒuɈړ
//    : Ȃ
// ߂l : ړ̃}[J[̈ʒuBʒuK̖̂ƂMARKER_ENDԂ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//

int CLR0Item::ShiftMarker()
{
	// łɖɂƂ́Ĉ܂ܕԂB
	if ( m_nMarkerPos == MARKER_END ) { return m_nMarkerPos; }

	m_nMarkerPos ++;		// ЂƂEɈړ

	if ( m_nMarkerPos >= m_Production.GetRightSideLength() ) {
		// ړオȂΈʒuMARKER_ENDɂ
		m_nMarkerPos = MARKER_END;
	}

	if ( m_nMarkerPos >= m_Production.GetRightSideLength() ) {

	}

	return m_nMarkerPos;		// ݂̈ʒuԂ
}


//
// ֐ : CLR0Item &CLR0Item::operator = ( CLR0Item &item )
// @  \ : Zq
//    : item ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0Item &CLR0Item::operator =( CLR0Item &item )
{
	if ( &item == this ) { return *this; }

	// Rs[
	m_Production = item.GetProduction();
	m_nMarkerPos = item.GetCurrentMarkerPos();
	m_nSetNumber = item.GetSetNumber();

	return *this;
}

//
// ֐ : bool CLR0Item::operator == ( CLR0Item &item )
// @  \ : ֌WZq
//    : item ---- rΏ
// ߂l : etrueCȊOfalseԂ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
bool CLR0Item::operator == ( CLR0Item &item )
{
	if ( &item == this ) { return true; }

	// ł́CKm_ProductionIuWFNgƃ}[J[̈ʒum_nMarkerPos̒lr
	if ( ( m_Production == item.GetProduction() ) && ( m_nMarkerPos == item.GetCurrentMarkerPos() ) ) {
		// e
		return true;
	}

	// Ȃ
	return false;

}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// NX CLR0ItemList
//

//
// ֐ : CLR0ItemList::CLR0ItemList()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemList::CLR0ItemList()
{
	RemoveAll();
}

//
// ֐ : CLR0ItemList::CLR0ItemList( CLR0ItemList &lst )
// @  \ : Rs[RXgN^
//    : lst ---- Rs[
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemList::CLR0ItemList( CLR0ItemList &lst )
{
	RemoveAll();

	int size = lst.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		CLR0Item &item = lst.GetItem( i );
		AddItem( item );
	}
}

//
// ֐ : CLR0ItemList::~CLR0ItemList()
// @  \ : fXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemList::~CLR0ItemList()
{
	RemoveAll();
}

//
// ֐ : void CLR0ItemList::RemoveAll()
// @  \ : vf폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
void CLR0ItemList::RemoveAll()
{
	int size = m_List.size();

	list < CLR0Item * >::iterator sp = m_List.begin();
	list < CLR0Item * >::iterator ep = m_List.end();

	while ( sp != ep ) {
		delete *sp;
		sp ++;
	}
	
	m_List.clear();
}

//
// ֐ : int CLR0ItemList::GetSize()
// @  \ : Xg̃TCY擾
//    : Ȃ
// ߂l : Xg̃TCYԂ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemList::GetSize()
{
	return m_List.size();
}


//
// ֐ : int CLR0ItemList::AddItem( CProduction &pro, int setnumber, int marker )
// @  \ : XgLR0ǉ
//    : pro ---- ̐K
//			setnumber --- W̔ԍ
//			marker --- }[J[̈ʒuil:MARKER_END)
// ߂l : ǉ̍̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemList::AddItem( CProduction &pro, int setnumber, int marker )
{
	CLR0Item *pNew = new CLR0Item( pro, setnumber, marker );
	assert( pNew != NULL );

	m_List.push_back( pNew );

	return m_List.size();
}

//
// ֐ : int CLR0ItemList::AddItem( CLR0Item &item )
// @  \ : XgLR0ǉ
//    : item --- ǉ鍀
// ߂l : ǉ̍̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemList::AddItem( CLR0Item &item )
{
	CLR0Item *pNew = new CLR0Item( item );
	assert( pNew );

	m_List.push_back( pNew );

	return m_List.size();
}

//
// ֐ : int CLR0ItemList::MergeList( CLR0ItemList &lst )
// @  \ : ʂ̃XgXg̖ɒǉ
//    : lst --- ǉ郊Xg
// ߂l : ǉ̍̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemList::MergeList( CLR0ItemList &lst )
{
	int size = lst.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		// lst̑Svfǉ
		AddItem( lst.GetItem( i ) );		
	}

	return m_List.size();
}


//
// ֐ : int CLR0ItemList::GetItem( int setnumber, CLR0ItemList &lst )
// @  \ : LR0Wɏ鍀擾
//    : setnumber --- 擾W̔ԍ
//			lst ---- 擾i[郊Xg(ój
// ߂l : 擾̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemList::GetItem( int setnumber, CLR0ItemList &lst )
{
	list < CLR0Item * >::iterator sp = m_List.begin();
	list < CLR0Item * >::iterator ep = m_List.end();

	while ( sp != ep ) {
		if ( (*sp)->GetSetNumber() == setnumber ) {
			// `FbN̗vfW̍Ȃ΁Co͂̃Xgɒǉ
			lst.AddItem( *(*sp) );
		}
		sp ++;
	}

	return lst.GetSize();
}


//
// ֐ : CLR0Item &CLR0ItemSet::GetItem( int index )
// @  \ : ̏ꏊɂLR0擾
//    : index --- ʒu
// ߂l : w肵ʒuɂLR0IuWFNgւ̎Q
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0Item &CLR0ItemList::GetItem( int index )
{
	// ʒusȂAT[g
	assert( ( index >= 0 ) && ( index < m_List.size() ) );

	list < CLR0Item * >::iterator sp = m_List.begin();
	list < CLR0Item * >::iterator ep = m_List.end();

	while ( ( index > 0 ) && ( sp != ep ) ) {
		sp ++;
		index --;
	}
	
	if ( sp == ep ) { assert( false ); } // ȂiʁCɂ͂Ȃj

	return *(*sp);	// QƂԂ
}

//
// ֐ : CLR0Item *CLR0ItemList::GetItemPtr( int index )
// @  \ : ̏ꏊɂLR0擾
//    : index --- ʒu
// ߂l : w肵ʒuɂLR0IuWFNgւ̃|C^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 200207/06 Sat. G
//
CLR0Item *CLR0ItemList::GetItemPtr( int index )
{
	// ʒusȂAT[g
	assert( ( index >= 0 ) && ( index < m_List.size() ) );

	list < CLR0Item * >::iterator sp = m_List.begin();
	list < CLR0Item * >::iterator ep = m_List.end();

	while ( ( index > 0 ) && ( sp != ep ) ) {
		sp ++;
		index --;
	}
	
	if ( sp == ep ) { assert( false ); } // ȂiʁCɂ͂Ȃj

	return *sp;
}


//
// ֐ : CLR0ItemList &CLR0ItemList::operator = ( CLR0ItemList &lst )
// @  \ : Zq
//    : lst --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemList &CLR0ItemList::operator = ( CLR0ItemList &lst )
{
	if ( &lst == this ) { return *this; }

	RemoveAll();		// S폜

	MergeList( lst );	// ̃XglstA  

	return *this;
} 

//
// ֐ : bool CLR0ItemList::IsExistItem( CLR0Item &item )
// @  \ : w肵LR0Xgɑ݂邩ǂ𒲂ׂ
//    : item --- 鍀
// ߂l : Xgɑ݂true,ȂfalseԂ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
bool CLR0ItemList::IsExistItem( CLR0Item &item )
{
	list < CLR0Item * >::iterator sp = m_List.begin();
	list < CLR0Item * >::iterator ep = m_List.end();

	while ( sp != ep ) {
		if ( *(*sp) == item ) {
			return true;	// !
		}
		sp ++;
	}

	return false;	// Ȃ
}


//
// NX CLRItemSet
//



//
// ֐ : CLR0ItemSet::CLR0ItemSet()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet::CLR0ItemSet()
{
	m_nSetNumber = 0;
	m_nOperation = UNKNOWN_OPERATION;
	memset( &m_Parameter, 0, sizeof ( m_Parameter ) );
}


//
// ֐ : CLR0ItemSet::CLR0ItemSet( int number, int root )
// @  \ : RXgN^(closureZɂ苁܂ŴƂ)
//    : number ----- Wԍ
//			root ------- closurẽp[^ɂȂ鐶KS'=S̔ԍ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet::CLR0ItemSet( int number, int root )
{
	m_nSetNumber = number;
	m_nOperation = CLOSURE_OPERATION;
	m_Parameter.m_nRootProduction = root;
}

//
// ֐ : CLR0ItemSet::CLR0ItemSet( int number, int original, CSymbol &sym )
// @  \ : RXgN^(gotoZɂ苁܂W)
//    : number ---- Wԍ
//			original -- ̏W̔ԍ
//			sym ------- p[^̓͋L
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet::CLR0ItemSet( int number, int original, CSymbol &sym )
{
	m_nSetNumber = number;
	m_nOperation = GOTO_OPERATION;

	m_Parameter.GotoParam.m_nOriginalSet = original;
	m_Parameter.GotoParam.m_pInputSymbol = new CSymbol( sym );
	
	assert( m_Parameter.GotoParam.m_pInputSymbol != NULL );
}

//
// ֐ : CLR0ItemSet::CLR0ItemSet( CLR0ItemSet &itemset )
// @  \ : Rs[RXgN^
//    : sym --- Rs[
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet::CLR0ItemSet( CLR0ItemSet &itemset )
{
	m_nSetNumber = itemset.GetSetNumber();
	m_nOperation = itemset.GetOperation();

	if ( m_nOperation == CLOSURE_OPERATION ) {
		// closure
		m_Parameter.m_nRootProduction = itemset.GetRootProduction();
	}
	else if ( m_nOperation == GOTO_OPERATION ) {
		// goto
		m_Parameter.GotoParam.m_nOriginalSet = itemset.GetOriginalSet();
		CSymbol sym;
		itemset.GetInputSymbol( sym );
		m_Parameter.GotoParam.m_pInputSymbol = new CSymbol( sym );
	}
	else {
		m_nSetNumber = 0;
		m_nOperation = UNKNOWN_OPERATION;
		memset( &m_Parameter, 0, sizeof ( m_Parameter ) );
	}
}

//
// ֐ : CLR0ItemSet::~CLR0ItemSet()
// @  \ : fXgN^
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet::~CLR0ItemSet()
{
	if ( m_nOperation == GOTO_OPERATION ) {
		delete m_Parameter.GotoParam.m_pInputSymbol;
	}
}

//
// ֐ : int CLR0ItemSet::GetSetNumber()
// @  \ : LR(0)W̔ԍ擾
//    : Ȃ
// ߂l : LR(0)W̔ԍ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0ItemSet::GetSetNumber()
{
	return m_nSetNumber;
}


//
// ֐ : CREATEOPERATION CLR0ItemSet::GetOperation()
// @  \ : W̐ɗpZ̎ނԂ
//    : Ȃ
// ߂l : Z̎ނ\CREATEOPERATION񋓌^̒l
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CREATEOPERATION CLR0ItemSet::GetOperation()
{
	return m_nOperation;
}

//
// ֐ : int CLR0ItemSet::GetRootProduction()
// @  \ : closureZɗpK̔ԍԂ
//    : Ȃ
// ߂l : K̔ԍԂ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0ItemSet::GetRootProduction()
{
	return m_Parameter.m_nRootProduction;
}

//
// ֐ : int CLR0ItemSet::GetOriginalSet()
// @  \ : gotoZɗpWԍԂ
//    : Ȃ
// ߂l : Wԍ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0ItemSet::GetOriginalSet()
{
	return m_Parameter.GotoParam.m_nOriginalSet; 
}

//
// ֐ : int CLR0ItemSet::GetInputSymbol( CSymbol &sym )
// @  \ : gotoZɗpLԂ
//    : sym ---- LIuWFNgւ̎QƁiój
// ߂l : ZgotoŋL̎擾łȂ1CȊO0Ԃ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
int CLR0ItemSet::GetInputSymbol( CSymbol &sym ) 
{
	if ( m_nOperation == GOTO_OPERATION ) {
		// gotoẐƂ̂
		sym = *(m_Parameter.GotoParam.m_pInputSymbol);
		return 1;
	}
	// gotoZȊO
	return 0;
}

//
// ֐ : void CLR0ItemSet::SetClosureInfo( int number, int root )
// @  \ : closureZɂW`
//    : number -- Wԍ
//			root ---- ZɎgK̔ԍ
// ߂l :
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
void CLR0ItemSet::SetClosureInfo( int number, int root )
{
	if ( m_nOperation == GOTO_OPERATION ) {
		// Ƃ肠CgotoZ̏񂪂ꍇ́C̈JĂ
		delete m_Parameter.GotoParam.m_pInputSymbol;
	}

	m_nSetNumber = number;
	m_nOperation = CLOSURE_OPERATION;

	m_Parameter.m_nRootProduction = root;

}

//
// ֐ : void CLR0ItemSet::SetGotoInfo( int number, int original, CSymbol &sym )
// @  \ : gotoZɂW`
//    : number --- Wԍ
//			original -- ̏W
//			sym ----- ͋L
// ߂l : Ȃ
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
void CLR0ItemSet::SetGotoInfo( int number, int original, CSymbol &sym )
{
	if ( m_nOperation != GOTO_OPERATION ) {
		// ύXỎZgotołȂ΁CCSymbol̗̈mۂ
		m_Parameter.GotoParam.m_pInputSymbol = new CSymbol();
		assert ( m_Parameter.GotoParam.m_pInputSymbol != NULL );
	}

	m_nSetNumber = number;
	m_Parameter.GotoParam.m_nOriginalSet = original;
	*(m_Parameter.GotoParam.m_pInputSymbol) = sym;
}

//
// ֐ : CLR0ItemSet &CLR0ItemSet::operator = ( CLR0ItemSet &itemset )
// @  \ : Zq
//    : itemset ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/02 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/02 Fri.
//
CLR0ItemSet &CLR0ItemSet::operator = ( CLR0ItemSet &itemset )
{
	if ( &itemset == this ) { return *this; }

	m_nSetNumber = itemset.GetSetNumber();

	if ( itemset.GetOperation() == CLOSURE_OPERATION ) {
		// closureZ̏W
		if ( m_nOperation == GOTO_OPERATION ) {
			// IuWFNggotoZ̏ŴƂ́CCSymbolJ
			delete m_Parameter.GotoParam.m_pInputSymbol;
		}
		m_nOperation = itemset.GetOperation();
		m_Parameter.m_nRootProduction = itemset.GetRootProduction();
	}
	else if ( itemset.GetOperation() == GOTO_OPERATION ) {
		// gotoZ̏W
		if ( m_nOperation != GOTO_OPERATION ) {
			// IuWFNgclosureZ̏ŴƂ́CCSymbol̗̈mۂ
			m_Parameter.GotoParam.m_pInputSymbol = new CSymbol();
			assert( m_Parameter.GotoParam.m_pInputSymbol != NULL );
		}
		m_nOperation = itemset.GetOperation();
		m_Parameter.GotoParam.m_nOriginalSet = itemset.GetOriginalSet();
		CSymbol sym;
		itemset.GetInputSymbol( sym );
		*(m_Parameter.GotoParam.m_pInputSymbol) = sym;
	}

	return *this;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// CLR0ItemSetList
//

//
// ֐ : CLR0ItemSetList::CLR0ItemSetList()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemSetList::CLR0ItemSetList()
{
	RemoveAll();
}


//
// ֐ : CLR0ItemSetList::CLR0ItemSetList( CLR0ItemSetList &lst )
// @  \ : Rs[RXgN^
//    : lst --- Rs[
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemSetList::CLR0ItemSetList( CLR0ItemSetList &lst )
{
	RemoveAll();

	int size = lst.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		CLR0ItemSet set;
		lst.GetSet( i, set );
		AddSet( set );
	}
}

//
// ֐ : CLR0ItemSet::~CLR0ItemSet()
// @  \ : fXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemSetList::~CLR0ItemSetList()
{
	RemoveAll();
}


//
// ֐ : void CLR0ItemSetList::RemoveAll()
// @  \ : Svf폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
void CLR0ItemSetList::RemoveAll()
{
	list < CLR0ItemSet * >::iterator sp = m_List.begin();
	list < CLR0ItemSet * >::iterator ep = m_List.end();

	while ( sp != ep ) {
		delete *sp;
		sp ++;
	}

	m_List.clear();
}

//
// ֐ : int CLR0ItemSetList::GetSize()
// @  \ : vfԂ
//    : Ȃ
// ߂l : ێĂLR0W̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::GetSize()
{
	return m_List.size();
}

//
// ֐ : int CLR0ItemSetList::AddSet( int number, int root )
// @  \ : LR0WǉiclosureZp)
//    : number --- Wԍ
//			root ----- ZɗpK̔ԍ
// ߂l : ǉ̗vf
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::AddSet( int number, int root )
{
	CLR0ItemSet *pSet = new CLR0ItemSet( number, root );
	assert( pSet );

	m_List.push_back( pSet );

	return m_List.size();
}

//
// ֐ : int CLR0ItemSetList::AddSet( int number, int original, CSymbol &sym )
// @  \ : LR0WǉigotoZpj
//    : number --- Wԍ
//			original -- gotoZɗpW̔ԍ
//			sym ----- Zɗp@L
// ߂l : ǉ̗vf
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::AddSet( int number, int original, CSymbol &sym )
{
	CLR0ItemSet *pSet = new CLR0ItemSet( number, original, sym );
	assert( pSet );

	m_List.push_back( pSet );

	return m_List.size();
}

//
// ֐ : int CLR0ItemSetList::AddSet( CLR0ItemSet &set )
// @  \ : LR0Wǉ
//    : set --- ǉW
// ߂l : ǉ̗vf
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::AddSet( CLR0ItemSet &set )
{
	CLR0ItemSet *pSet = new CLR0ItemSet( set );
	assert( pSet );

	m_List.push_back( pSet );

	return m_List.size();
}

//
// ֐ : int CLR0ItemSetList::MergeList( CLR0ItemSetList &lst )
// @  \ : Xgǉ
//    : lst --- ǉ郊Xg
// ߂l : ǉ̗vf
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::MergeList( CLR0ItemSetList &lst )
{
	int size = lst.GetSize();

	for ( int i = 0; i < size; i ++ ) {
		CLR0ItemSet set;
		lst.GetSet( i, set );
		AddSet( set );
	}

	return m_List.size();
}

//
// ֐ : int CLR0ItemSetList::GetSet( int numindex, CLR0ItemSet &set, bool flag )
// @  \ : L[̈Ӗɏ]āCLR0W擾
//    : numindex ---- vf̈ʒu܂́CWԍ
//			set ---- 擾W̎QƁiój
//			flag --- numindeẍӖtOitrue:vf̈ʒuCfalse:Wԍ)
// ߂l : W̔ԍԂ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CLR0ItemSetList::GetSet( int numindex, CLR0ItemSet &set, bool flag )
{
	list < CLR0ItemSet * >::iterator sp = m_List.begin();
	list < CLR0ItemSet * >::iterator ep = m_List.end();

	if ( flag == true ) {
		// index
		while ( ( numindex > 0 ) && ( sp != ep ) ) {
			sp ++;
			numindex --;
		}
		if ( sp != ep ) {
			set = *(*sp);
			return set.GetSetNumber();	// 
		}
	}
	else {
		// Wԍ
		while ( sp != ep ) { 
			if ( (*sp)->GetSetNumber() == numindex ) {
				set = *(*sp);
				return set.GetSetNumber();	// 
			}
			sp ++;
		}
	}

	return -1;		// 񂩂
}

//
// ֐ : CLR0ItemSetList &CLR0ItemSetList::operator = ( CLR0ItemSetList &lst )
// @  \ : Zq
//    : lst ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemSetList &CLR0ItemSetList::operator = ( CLR0ItemSetList &lst )
{
	if ( &lst == this ) { return *this; }

	RemoveAll();

	MergeList( lst );

	return *this;
}


//
// NX CCLR0Collection
//

//
// ֐ : CCLR0Collection::CCLR0Collection()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CCLR0Collection::CCLR0Collection() : m_Grammar(), m_Collection(), m_SetList()
{

}

//
// ֐ : CCLR0Collection::~CCLR0Collection()
// @  \ : fXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CCLR0Collection::~CCLR0Collection()
{

}

//
// ֐ : void CCLR0Collection::ClearCollection()
// @  \ : Sč폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
void CCLR0Collection::ClearCollection()
{
	// SĂ̏

	// m_Grammar
	m_Grammar = CContextFreeGrammar();

	// m_Collection
	m_Collection.RemoveAll();

	// m_SetList
	m_SetList.RemoveAll();
}

//
// ֐ : CContextFreeGrammar &CCLR0Collection::GetGrammar()
// @  \ : @擾
//    : Ȃ
// ߂l : m_GrammarIuWFNgւ̎Q
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CContextFreeGrammar &CCLR0Collection::GetGrammar()
{
	return m_Grammar;
}


//
// ֐ : CLR0ItemList &CCLR0Collection::GetLR0ItemList()
// @  \ : LR0̃Xg擾
//    : Ȃ
// ߂l : m_CollectionIuWFNgւ̎Q
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemList &CCLR0Collection::GetLR0ItemList()
{
	return m_Collection;
}

//
// ֐ : CLR0ItemList *CCLR0Collection::GetLR0ItemListPtr()
// @  \ : LR0̃Xg擾
//    : Ȃ
// ߂l : m_CollectionIuWFNgւ̃|C^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G
//
CLR0ItemList *CCLR0Collection::GetLR0ItemListPtr()
{
	return &m_Collection;
}

//
// ֐ : CLR0ItemSetList &CCLR0Collection::GetLR0ItemSetList()
// @  \ : LR0W̃Xg擾
//    : Ȃ
// ߂l : m_SetListIuWFNgւ̎Q
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CLR0ItemSetList &CCLR0Collection::GetLR0ItemSetList()
{
	return m_SetList;
}

//
// ֐ : CLR0ItemSetList *CCLR0Collection::GetLR0ItemSetListPtr()
// @  \ : LR0W̃Xg擾
//    : Ȃ
// ߂l : m_SetListIuWFNgւ̃|C^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G
//
CLR0ItemSetList *CCLR0Collection::GetLR0ItemSetListPtr()
{
	return &m_SetList;
}

//
// ֐ : void CCLR0Collection::SetCLR0Collection( CContextFreeGrammar &grammar, CLR0ItemList &item, CLR0ItemSetList &set )
// @  \ : LR0WFollowW̏ǂݍ
//    : grammar --- @
//			item ------ LR0̃Xg
//			set ------- LR0WXg
// ߂l : Ȃ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
void CCLR0Collection::SetCLR0Collection( CContextFreeGrammar &grammar, CLR0ItemList &item, CLR0ItemSetList &set )
{
	m_Grammar = grammar;
	m_Collection = item;
	m_SetList = set;
}


//
// ֐ : CCLR0Collection &CCLR0Collection::operator = ( CCLR0Collection &coll )
// @  \ : Zq
//    : coll --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CCLR0Collection &CCLR0Collection::operator = ( CCLR0Collection &coll )
{
	if ( &coll == this ) { return *this; }

	// Ƃ肠CJ
	ClearCollection();

	SetCLR0Collection( coll.GetGrammar(), coll.GetLR0ItemList(), coll.GetLR0ItemSetList() );
	
	return *this;
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
void CCLR0Collection::Display()
{
	cout << "LR(0) Collection" << endl;
	
	int size = m_SetList.GetSize();

	CLR0ItemList lst;
	CLR0ItemSet set;
	CSymbol sym;
	for ( int i = 0; i < size; i ++ ) {
		m_SetList.GetSet( i, set );
		cout << "I" << set.GetSetNumber() << " : ";
		if ( set.GetOperation() == CLOSURE_OPERATION ) {
			// closure
			cout << "closure" << endl;
		}
		else if ( set.GetOperation() == GOTO_OPERATION ) {
			// goto
			set.GetInputSymbol( sym );
			cout << "goto( " << set.GetOriginalSet() << ", " << sym.GetSymbol() << " )" << endl;
		}
		else {
		}
		
		cout << "   LR(0) items : ";

		cout << " { ";
		m_Collection.GetItem( set.GetSetNumber(), lst );
		for ( int j = 0; j < lst.GetSize() ; j ++ ) {
			CLR0Item lritem = lst.GetItem( j );
			
			if ( lritem.GetSetNumber() != set.GetSetNumber() ) { continue; }
			
			CProduction &pro = lritem.GetProduction();
			cout << "[" << pro.GetLeftSideSymbol() << " = ";
			for ( int k = 0; k < pro.GetRightSideLength(); k ++ ) {
				if ( lritem.GetCurrentMarkerPos() == k ) {
					cout << ".";
				}
				cout << pro.GetRightSideSymbol( k ) << " ";
			}
			if ( lritem.GetCurrentMarkerPos() == MARKER_END ) { cout << "."; }
			cout << "], ";
		}
		cout << "}" << endl;
	}
}

void CCLR0Collection::OutFile( string filename )
{
	ofstream ofs( filename.c_str() );

	ofs << "LR(0) Collection" << endl;
	
	int size = m_SetList.GetSize();

	CLR0ItemList lst;
	CLR0ItemSet set;
	CSymbol sym;
	for ( int i = 0; i < size; i ++ ) {
		m_SetList.GetSet( i, set );
		ofs << "I" << set.GetSetNumber() << " : ";
		if ( set.GetOperation() == CLOSURE_OPERATION ) {
			// closure
			ofs << "closure" << endl;
		}
		else if ( set.GetOperation() == GOTO_OPERATION ) {
			// goto
			set.GetInputSymbol( sym );
			ofs << "goto( " << set.GetOriginalSet() << ", " << sym.GetSymbol() << " )" << endl;
		}
		else {
		}
		
		ofs << "   LR(0) items : ";

		ofs << " { ";
		m_Collection.GetItem( set.GetSetNumber(), lst );
		for ( int j = 0; j < lst.GetSize() ; j ++ ) {
			CLR0Item lritem = lst.GetItem( j );
			
			if ( lritem.GetSetNumber() != set.GetSetNumber() ) { continue; }
			
			CProduction &pro = lritem.GetProduction();
			ofs << "[" << pro.GetLeftSideSymbol() << " = ";
			for ( int k = 0; k < pro.GetRightSideLength(); k ++ ) {
				if ( lritem.GetCurrentMarkerPos() == k ) {
					ofs << ".";
				}
				ofs << pro.GetRightSideSymbol( k ) << " ";
			}
			if ( lritem.GetCurrentMarkerPos() == MARKER_END ) { ofs << "."; }
			ofs << "], ";
		}
		ofs << "}" << endl;
	}
	ofs.close();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// NX CCLR0CollectionCreateor
//

//
// ֐ : CCLR0CollectionCreator::CLR0CollectionCreator()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CCLR0CollectionCreator::CCLR0CollectionCreator()
{
}

//
// ֐ : CCLR0CollectionCreator::~CCLR0CollectionCreator()
// @  \ : fXgN^
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
CCLR0CollectionCreator::~CCLR0CollectionCreator()
{
}

//
// ֐ : int CLR0CollectionCreator::CreateCollection( CContextFreeGrammar &grammar, CCLR0Collection &coll )
// @  \ : LR0W𐶐
//    : grammar ---- g@
//			coll ------- LR0Wiój
// ߂l : LR0W̐Cs畉̒lԂ
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CCLR0CollectionCreator::CreateCollection( CContextFreeGrammar &grammar, CCLR0Collection &coll )
{
	coll.ClearCollection();
	CProductionSet &production = grammar.GetProductionSet();
	CSymbol &startSym = grammar.GetStartSymbol();
	CLR0ItemSetList &setlist = coll.GetLR0ItemSetList();
	CLR0ItemList &itemlist = coll.GetLR0ItemList();

	setlist.RemoveAll();

	CLR0ItemList outitem;

	//////////////////////////////// (1)closure({[S'S]})߂B
	CProductionSet start;
	CProduction pro;
	CLR0ItemList init;

	// S'STB{IɈȂ
	int start_pro = production.GetProduction( startSym.GetSymbol(), start );
	if ( start_pro != 1 ) {
		// S'Sȏ㌩G[
		return -1;
	}

	start.GetProduction( 0, pro );
	init.AddItem( pro, 0, 0 );

	int nresult = Closure( grammar, init, 0, outitem );		// ŏ̏WȂ̂ŏWԍ0
	setlist.AddSet( 0, 0 );		// ꂽẂCI0
	itemlist = outitem;			// closurěʂLR(0)W




	// //////////////////////////// (2)gotoZ

	bool *history;								// `FbNXg
	int setnumber = 1;							// Wԍ
	CLR0ItemList lst, input;					// LR(0)
	CLR0ItemSet  set;

	for ( int i = 0; i < setlist.GetSize(); i ++ ) {

		setlist.GetSet( i, set );						// W擾
		lst.RemoveAll();
		itemlist.GetItem( set.GetSetNumber(), lst );	// WɑΉLR(0)W擾
		if ( lst.GetSize() == 0 ) { continue; }
		
		int index = 0;
		int marker;		// }[J[̈ʒu

		history = new bool[ lst.GetSize() ];
		for ( int j = 0; j < lst.GetSize(); j ++ ) { history[ j ] = false; }	// `FbNXg̏
	
		bool flag = true;
		do 
		{
			CLR0Item lritem = lst.GetItem( index );		// 擾LR(0)
			marker = lritem.GetCurrentMarkerPos();
			if ( ( marker != MARKER_END ) && ( history[ index ] == false ) ) { 
				history[ index ] = true;					// `FbNXgύX		
	
				// }[NK̖ȊO̎
				// 1.܂C̍gotoZɓnLR(0)Winputɒǉ
				input.AddItem( lritem );

				// 2.}[N̒̋L擾
				const char * nextsym = lritem.GetProduction().GetRightSideSymbol( marker );
				
				// 3.LR(0)Wlstł܂gĂȂ}[J[̎nextsymł̂T
				CLR0Item otheritem;
				for ( j = index + 1; j < lst.GetSize(); j ++ ) {
					if ( ! history[ j ] ) {
						// ܂gĂȂ
						otheritem = lst.GetItem( j );
						int othermark = otheritem.GetCurrentMarkerPos();

						if ( othermark != MARKER_END ) {
							// }[J[łȂ
							if ( ! strcmp( otheritem.GetProduction().GetRightSideSymbol( othermark ), nextsym ) ) {
								// }[J[̎̋LnextsymƓȂinputotheritemǉC`FbNXgύX
								input.AddItem( otheritem );
								history[ j ] = true;
							}
						}
						else {
							// }[J[ȂCȍ~͖B
							history[ j ] = true;
						}

					}
				}

				// 4.WinputƓ͋LnextsympgotoZs
				if ( input.GetSize() != 0 ) {
					int ret = Goto( grammar, input, nextsym, setnumber, outitem );
					if ( ret != 0 ) {
						// LR(0)Wcoll.m_CollectionɌʂǉ
						bool addflag = true;
						/*
						for ( j = 0; j < outitem.GetSize(); j ++ ) {
							if ( ! itemlist.IsExistItem( outitem.GetItem( j ) ) ) {
								// ʂLR(0)LR(0)WɂȂΒǉ
								itemlist.AddItem( outitem.GetItem( j ) );
								addflag = true;
							}
						}
						*/
						
						/*
						// gotǒʂ̏WWɊ܂܂ĂȂΒǉB
						for ( int x = 0; x < setlist.GetSize(); x ++ ) {
							CLR0ItemSet  itemset1;
							CLR0ItemList sublist1;
							setlist.GetSet( x, itemset1 );
							itemlist.GetItem( itemset1.GetSetNumber(), sublist1 );
							// ͈ႤHイCH
							if ( sublist1.GetSize() == outitem.GetSize() ) {
								for ( int y = 0; y < outitem.GetSize(); y ++ ) {
									CLR0Item &item2 = outitem.GetItem( y );
									if ( sublist1.IsExistItem( item2 ) == false ) {
										break;
									}

								}
								if ( y == outitem.GetSize() ) {
									// Ō܂Ń`FbNāCWvWWɂƔfꂽꍇC̏WWɒǉȂB
									addflag = false;
									break;
								}
							}
						}
					
						if ( addflag ) {
							// vfȏǉꂽꍇCWWɒǉB
							for ( x = 0; x < outitem.GetSize(); x ++ ) {
								itemlist.AddItem( outitem.GetItem( x ) );
							}

							SYMBOLTYPE st;
							st = grammar.GetNonterminalSymbol().ExistSymbol( nextsym ) ? SYMBOL_NONTERMINAL : SYMBOL_TERMINAL;
							CSymbol sym( nextsym, st );
							setlist.AddSet( setnumber, i, sym );
							setnumber ++;
						}
						*/
						// vfȏǉꂽꍇCWWɒǉB
						for ( int x = 0; x < outitem.GetSize(); x ++ ) {
							itemlist.AddItem( outitem.GetItem( x ) );
						}

						SYMBOLTYPE st;
						st = grammar.GetNonterminalSymbol().ExistSymbol( nextsym ) ? SYMBOL_NONTERMINAL : SYMBOL_TERMINAL;
						CSymbol sym( nextsym, st );
						setlist.AddSet( setnumber, i, sym );
						setnumber ++;


						// ւ̏
						input.RemoveAll();
						outitem.RemoveAll();
					}
				}
			}
			index ++;		// ̗vf

			// `FbNXgS`FbNĂdo`while()̃[v𔲂
			flag = false;
			for ( j = 0; j < lst.GetSize(); j ++ ) {
				if ( history[ j ] == false ) { flag = true; break; }
			}

		}while ( ( flag == true ) && ( index < lst.GetSize() ) );
		delete [] history;

	}

//	coll.Display();

	return itemlist.GetSize();
}


//
// ֐ : int CLR0CollectionCreator::Closure( CContextFreeGrammar &grammar, CLR0ItemList &item, int setnumber, CLR0ItemList &outitem )
// @  \ : closureZs
//    : grammar --- QƂ镶@
//			item ---- closureZɗpLR0Xg(I)
//			setnumber ---- W̔ԍ
//			outitem --- ZʂLR0WLR0Xgiój
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CCLR0CollectionCreator::Closure( CContextFreeGrammar &grammar, CLR0ItemList &item, int setnumber, CLR0ItemList &outitem )
{
	CSymbolTable &nttable = grammar.GetNonterminalSymbol();
	CProductionSet &production = grammar.GetProductionSet();
	
	// o̓Xg̏
	outitem.RemoveAll();

	// (1)ȊSĂ̌́Cclosure(I)Ɋ܂܂
	outitem = item;

	// (2)closure(I)Ɋ܂܂āC}[J[̎I[Lł鍀ɂāc
	int size = item.GetSize();
	CLR0ItemList input, output;
	int outsize;

	for ( int i = 0; i < size; i ++ ) {
		input.RemoveAll();	output.RemoveAll();

		// (2-1)}[J[̎I[Lł鍀T
		CLR0Item &lritem = item.GetItem( i );
		CProduction &proc = lritem.GetProduction();
		int marker = lritem.GetCurrentMarkerPos();
		
		if ( marker != MARKER_END ) {
			const char *nextsym = proc.GetRightSideSymbol( marker );
		
			if ( nttable.ExistSymbol( nextsym ) == true ) {
				// I}[J[̎̋LI[LI
				// (2-3)݂̔I[LӂɂSĂ̐KclosureZs
				CProductionSet sameleft;
				int pro_size = production.GetProduction( nextsym, sameleft );
				for ( int k = 0; k < pro_size; k ++ ) {
					sameleft.GetProduction( k, proc );
					input.AddItem( proc, setnumber, 0 );
					outsize = Closure( grammar, input, setnumber, output );
					for ( int j = 0; j < outsize; j ++ ) {
						if ( !outitem.IsExistItem( output.GetItem( j ) ) ) {
							// (2-4) (2-3)̌ʂ̂C݂̏o͏WɊ܂܂ĂȂo͏Wɒǉ
							outitem.AddItem( output.GetItem( j ) );
						}
					}
				}
			}
		}
	}
	return outitem.GetSize();
}


//
// ֐ : int CCLR0CollectionCreator::Goto( CContextFreeGrammar &grammar, CLR0ItemList &item, const char *sym, int setnumber, CLR0ItemList &outitem )
// @  \ : GOTOZs
//    : grammar ---- QƂ镶@
//			item ------- ZɗpLR(0)W
//			sym -------- ͋L
//			setnumber -- Wԍ
//			outlist ---- ZʂLR(0)W
// ߂l : outlistɒǉꂽLR(0)̐
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//
int CCLR0CollectionCreator::Goto( CContextFreeGrammar &grammar, CLR0ItemList &item, const char *sym, int setnumber, CLR0ItemList &outitem )
{
	outitem.RemoveAll();

	// I[L̏W
	CSymbolTable & nonterm = grammar.GetNonterminalSymbol();

	int size = item.GetSize();
	
	if ( size == 0 ) { return 0; }		// WcB

	for ( int i = 0; i < size; i ++ ) {
		CLR0Item lritem = item.GetItem( i );
		if ( lritem.GetCurrentMarkerPos() != MARKER_END ) {
			// }[J[ȊÖʒuɂƂ
			CProduction proc = lritem.GetProduction();

			if ( ! strcmp( proc.GetRightSideSymbol( lritem.GetCurrentMarkerPos() ), sym ) ) {
				// 1.݂̃}[J[̎ɂLsymƓ΁C}[J[Vtg
				int marker = lritem.ShiftMarker();

				if ( marker != MARKER_END ) {
					// }[J[͈ړłȂ
					const char *nextsym = proc.GetRightSideSymbol( marker );
					if ( nonterm.ExistSymbol( nextsym ) ) {
						// }[J[ɑ̋LI[L̏ꍇ́Cclosure( lritem )߂
						CLR0ItemList input, output;
						input.AddItem( lritem.GetProduction(), setnumber, lritem.GetCurrentMarkerPos() );
						int result = Closure( grammar, input, setnumber, output );
						outitem.MergeList( output );
					}
					else {
						// I[L̂ŁCǉ邾
						outitem.AddItem( lritem.GetProduction(), setnumber, lritem.GetCurrentMarkerPos() );
					}
				}
				else {
					// VtgłłWɒǉ
					outitem.AddItem( lritem.GetProduction(), setnumber, lritem.GetCurrentMarkerPos() );
				}
			}
			
		}
	}

	// 

	return outitem.GetSize();
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/05 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/05 Mon.
//

