// BeginNode.cpp: CBeginNode NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NewIV.h"
#include "common.h"
#include "BeginNode.h"
#include "TreeManagement.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CTreeManagement treeManagement;
extern CNewIVApp theApp;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

//RXgN^
//F
//		IXMLDOMNode** pBeginNodeF<begin>DOMm[h
//		CDialogNode* pParentNodeFΘbc[̐em[h
CBeginNode::CBeginNode(IXMLDOMNode** pBeginNode, CDialogNode* pParentNode)
{
	this->mpXislNode   = *pBeginNode;		//<begin>DOM
	this->mpParentNode =  pParentNode;		//Θbc[̐em[hւ̃|C^̃Zbg

	//Ԃ̃Zbg
	this->mState = UNVISITED;					//ԂUNVISITEDԂ
	this->mType = BEGIN;						//Θbc[̌^̐ݒ
	this->mId = treeManagement.getIdCount();	//IDԍi[


	//em[hCAvP[VChLg,_CAO̎擾Ei[
	string *strAppName;
	string *strDocName;
	string *strDiaName;
	
	strAppName = new string();
	strDocName = new string();
	strDiaName = new string();
	pParentNode->getName(strDiaName);
	pParentNode->getDocName(strDocName);
	pParentNode->getAppName(strAppName);
	this->mStrAppName.assign(strAppName->c_str());	
	this->mStrDocName.assign(strDocName->c_str());
	this->mStrDiaName.assign(strDiaName->c_str());
	delete strAppName;
	delete strDocName;
	delete strDiaName;

	//actionsɁCactiono^˗
	treeManagement.askActionManagementToRegistAction(mStrAppName,mStrDocName,mStrDiaName,mId,pBeginNode);

}

CBeginNode::~CBeginNode()
{
	//GNX`FWϐȉ폜悤CΘbc[ǗʂāCϐǗɈ˗
	char ch[10];
	itoa(this->mId,ch,10);

	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];
	char cDiaName[MESSAGE_LENGTH];

	strcpy(cAppName,mStrAppName.c_str());
	strcpy(cDocName,mStrDocName.c_str());
	strcpy(cDiaName,mStrDiaName.c_str());

	//beginϐ폜˗
	treeManagement.askVarManagementToDeleteVar(cAppName,cDocName,cDiaName,ch,"");

	//actionsɁCANV폜˗
	treeManagement.askActionManagementToDeleteAction(mId);

}

//@\F
//		AvP[VԂ
//F
//		AvP[Vi[string^ւ̃|C^
void CBeginNode::getAppName(string *pStrAppName){

	pStrAppName->assign(this->mStrAppName);

}

//@\F
//		hLgԂ
//F
//		hLgi[string^ւ̃|C^
void CBeginNode::getDocName(string *pStrDocName){

	pStrDocName->assign(this->mStrDocName);

}

//@\F
//		_CAOԂ
//F
//		_CAOi[string^ւ̃|C^
void CBeginNode::getDiaName(string *pStrDiaName){

	pStrDiaName->assign(this->mStrDiaName);

}

//@\F
//		̃m[hvisitedԂɂD
//		܂Cem[hvisitedԂɂłȂm߂D
int CBeginNode::beVisited(){

	//ԂvisitedԂɂD
	this->mState = VISITED;

	//em[hvisitedԂɂłȂm߂D
	(this->mpParentNode)->beVisited();

	return 0;
}

void CBeginNode::writeSource(int documentType)
{

	CString cStrTemp;


	if( this->mState == ACTIVE ){

		bool foundActionNode = false;

		//<begin>̓fo
		cStrTemp = "      <begin>\\line";
		theApp.addString(cStrTemp,1,documentType);

		IXMLDOMNodePtr pXislActionNode = NULL;
		//<begin>̎s̃^Om[hQbg
		treeManagement.askActionManagementToGetActionNode(this->mId,&pXislActionNode);

		IXMLDOMNodeList *pXislNodeList;
		IXMLDOMNodePtr pXislTempNode;
		long length;

		mpXislNode->get_childNodes(&pXislNodeList);
		pXislNodeList->get_length(&length);

		//begin̎qvfɑ΂
		for( int i = 0; i < length; i++ ){
	
			pXislNodeList->get_item( i, &pXislTempNode );
			if( foundActionNode == false )
				foundActionNode  = writeActionSource( pXislTempNode, documentType, 4 ,false);
			else
				writeActionSource( pXislTempNode, documentType, 4 ,true);

		}

		//</begin>̓fo
		cStrTemp = "      </begin>\\line";
		theApp.addString( cStrTemp, 1 , documentType); 

	}else{

		//<begin>̑S\[X̓fo
			
		if( this->mState == VISITED ){
			theApp.writeSource(mpXislNode,3,documentType,2);
		}else{
			theApp.writeSource(mpXislNode,3,documentType,0);
		}

	}

}

//s̃^Om[h
//
bool CBeginNode::writeActionSource(IXMLDOMNode* pActionChildNode, int documentType, int tabNum, bool StateOfNode)
{

	VARIANT_BOOL hasChild;

	IXMLDOMNodePtr ptrActionChildNode;
	IXMLDOMNode* pExecuteXislNode;
	IXMLDOMNodePtr ptrExecuteXislNode;
	bool foundActionNode = false;

	BSTR bstrTemp;
	char* cTemp;
	CString cStrTemp;
	CString cStrTemp2;

	ptrActionChildNode = pActionChildNode;

	CString cStrTab;
	CString cStrTab2;

	//^u
	cStrTab = "";
	for( int i = 0; i < tabNum; i++){
		cStrTab = cStrTab + "  ";
	}
	cStrTab2 = cStrTab + "  ";

	treeManagement.askActionManagementToGetActionNode(this->mId,&pExecuteXislNode);
	ptrExecuteXislNode = pExecuteXislNode;

	//qvf邩̃`FbN
	ptrActionChildNode->hasChildNodes(&hasChild);

	//qvfȂqvfɑ΂ď
	if( hasChild ){

		//^O̎擾
		ptrActionChildNode->get_baseName(&bstrTemp);
		cTemp = new char[WORD_LENGTH];
		BSTRToAscii(bstrTemp,cTemp,WORD_LENGTH);
		SysFreeString(bstrTemp);
		CString cStrTagName = cTemp;
		delete cTemp;

		//Jn^Ȍo
		theApp.getSource(ptrActionChildNode,cStrTemp);
		cStrTemp.Insert(0,cStrTab);
		cStrTemp += "\\line";

		//s̃^Om[hƓȂ
		if( ptrActionChildNode ==  ptrExecuteXislNode ){
			theApp.addStringWithJammpingPoint(cStrTemp,3,documentType);
			foundActionNode = true;
		}else if( StateOfNode ){
			theApp.addString(cStrTemp,0,documentType);
		}else{
			theApp.addString(cStrTemp,2,documentType);
		}

		//qvfɑ΂鏈
		IXMLDOMNode* pActionChildChildNode;

		//<output>ɊւẮAsȂqvfԕɂ̂
		//𕪂
		if( cStrTagName == "output" && ptrActionChildNode == ptrExecuteXislNode ){
	
			ptrActionChildNode->get_firstChild(&pActionChildChildNode);
			theApp.writeSource(pActionChildChildNode,tabNum+2,documentType,1);

		}else{		
			IXMLDOMNodeList* pActionChildChildNodeList;
			long length;
			ptrActionChildNode->get_childNodes(&pActionChildChildNodeList);
			pActionChildChildNodeList->get_length(&length);

			//qvfɑ΂čċAIɌJԂ
			for( i = 0; i < length; i++ ){
				pActionChildChildNodeList->get_item(i,&pActionChildChildNode);
				if( StateOfNode != true && foundActionNode == false ){
					foundActionNode = writeActionSource(pActionChildChildNode,documentType,tabNum+1, false);
				}else{
					writeActionSource(pActionChildChildNode,documentType,tabNum+1, true);
				}
			}
		}

		//I^Ȍo
		cStrTemp = cStrTab;
		cStrTemp += "</";
		cStrTemp += cStrTagName;
		cStrTemp += ">\\line";

		//s̃^Om[hƓȂ
		if( ptrActionChildNode ==  ptrExecuteXislNode ){

			theApp.addString(cStrTemp,3,documentType);

		}else if( StateOfNode ){

			theApp.addString(cStrTemp,0,documentType);

		}else{

			theApp.addString(cStrTemp,2,documentType);

		}

		return foundActionNode;

	}else{	

		//s̃^Om[hƓȂ
		if( ptrActionChildNode ==  ptrExecuteXislNode ){

			theApp.writeSourceWithJamppingPoint(ptrActionChildNode,tabNum,documentType,3);
			foundActionNode = true;

		}else if( StateOfNode ){

			theApp.writeSource(ptrActionChildNode,tabNum,documentType,0);

		}else{

			theApp.writeSource(ptrActionChildNode,tabNum,documentType,2);

		}

		return foundActionNode;

	}

}
