# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from ftg.flowobject import FlowObject


class FlowTable(FlowObject):
    DEFAULT_TYPE = 1

    def __init__(self, table_no, label="", type=DEFAULT_TYPE, metadata={}):
        self.table_no = table_no
        self.label = label
        self.type = type
        self.metadata = metadata
        self.priorities = {}

    def set_priorities(self, priorities):
        self.priorities = priorities

    def add_priorities(self, priorities):
        self.priorities.update(priorities)

    def get_priorities(self):
        return self.priorities

    def get_priority(self, priority_no):
        if priority_no in self.priorities:
            return self.priorities[priority_no]
        else:
            return False

    def get_number_of_priorities(self):
        return len(self.priorities)

    def get_number_of_flow_entries(self):
        number_of_flow_entries = 0
        for priority in self.priorities:
            number_of_flow_entries += priority.get_number_of_flow_entries()
        return number_of_flow_entries

    def get_table_no(self):
        return self.table_no
