#!/usr/bin/env python
# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#
#   ftg.py : It is a tool that ,
#            you can capture and anlyze.
#

__version__ = "0.7"

import sys
import os
import re
from optparse import OptionParser, OptionGroup
from ftg.grapher import Grapher
from ftg.utils.common import CommonUtils
from ftg.formatter.graphviz_tb import GraphvizTBFormatter
from ftg.formatter.csv import CSVFormatter
from ftg.formatter.tsv import TSVFormatter
from ftg.formatter.ovs_add_flow import OVSAddFlowFormatter


if __name__ == "__main__":
    # init program options
    p = OptionParser(version="ver: %s" % __version__)
    p.add_option(
        '-i', '--ovs_dump_file', dest='ovs_dump_file',
        help="specify Open vSwitch dump-flows FILE", metavar="FILE")
    p.add_option(
        '-c', '--csv_dump_file', dest='csv_dump_file',
        help="specify CSV dump FILE", metavar="FILE")
    p.add_option(
        '-t', '--tsv_dump_file', dest='tsv_dump_file',
        help="specify TSV dump FILE", metavar="FILE")
    p.add_option(
        '-f', '--formatter', dest='formatter',
        help="specify formatter (graphviz, csv, tsv, ovsflow)", default="graphviz")
    p.add_option(
        '-b', '--entries_per_block', dest='entries_per_block', type='int',
        help="specify number of entries in priority block", default=10)
    p.add_option(
        '-T', '--tables', dest='output_target_tables',
        help="specify the tables to be output.")
    p.add_option(
        '-v', '--verbose', dest='verbose', action="store_true", default=False,
        help="verbose output")
    p.add_option(
        '-d', '--debug', dest='debug', action="store_true", default=False,
        help="debug output")
    g1 = OptionGroup(p, "Output Flags")
    g1.add_option(
        '--enable_output_resubmit_loop', dest='output_resubmit_loop',
        action="store_true", default=True,
        help="enable the output of the 'resubmit to start' that re-evaluate at the same table")
    g1.add_option(
        '--disable_output_resubmit_loop', dest='output_resubmit_loop',
        action="store_false", default=True,
        help="disable the output of the 'resubmit to start' that re-evaluate at the same table")
    g1.add_option(
        '--enable_output_summary', dest='output_summary',
        action="store_true", default=True,
        help="enable the output of the summary informations")
    g1.add_option(
        '--disable_output_summary', dest='output_summary',
        action="store_false", default=True,
        help="disable the output of the output summary informations")
    p.add_option_group(g1)
    (opts, args) = p.parse_args()

    util = CommonUtils(opts)

    output_target_tables = []
    if  opts.output_target_tables is not None:
        output_target_tables = opts.output_target_tables.split(',')
        
    if  opts.formatter == "graphviz":
        formatter = GraphvizTBFormatter(util)
        formatter.set_output_target_tables(output_target_tables)
        formatter.set_entries_per_block(opts.entries_per_block)
        formatter.set_output_summary(opts.output_summary)
        formatter.set_output_resubmit_loop(opts.output_resubmit_loop)
    elif  opts.formatter == "csv":
        formatter = CSVFormatter(util)
    elif  opts.formatter == "tsv":
        formatter = TSVFormatter(util)
    elif  opts.formatter == "ovsflow":
        formatter = OVSAddFlowFormatter(util)
    else:
        util.error_out("specify valid formatter.")
        sys.exit(1)

    if opts.ovs_dump_file is not None and opts.ovs_dump_file != "":
        grapher = Grapher(util, opts.ovs_dump_file, Grapher.DUMP_FILE_OVS, formatter)
        grapher.run()
    elif opts.csv_dump_file is not None and opts.csv_dump_file != "":
        grapher = Grapher(util, opts.csv_dump_file, Grapher.DUMP_FILE_CSV, formatter)
        grapher.run()
    elif opts.tsv_dump_file is not None and opts.tsv_dump_file != "":
        grapher = Grapher(util, opts.tsv_dump_file, Grapher.DUMP_FILE_TSV, formatter)
        grapher.run()
    else:
        util.error_out("specify flow file with -i or -c or -t option.")
        sys.exit(1)
        

     
